<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBellBookingsUsersTable extends Migration
{
    public function up()
    {
        Schema::create('bell_bookings_users', function (Blueprint $table) {
            $table->id();
            $table->integer('booking_id')
                  ->nullable()
                  ->collation('utf8mb3_unicode_ci');
            $table->integer('user_id')
                ->nullable()
                ->collation('utf8mb3_unicode_ci');
            $table->integer('is_bell');  
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('bell_bookings_users');
    }
}
