<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class StaffSession extends Model
{

    protected $table = 'staff_sessions';

    protected $fillable = [
        'user_id',
        'session_id',
        'status',
    ];

   /**
     * Relationship to the Staff model.
     */
    public function staff()
    {
        return $this->belongsTo(Staff::class, 'user_id', 'id');
    }

    /**
     * Indirect relationship to the User model through Staff.
     */
    public function user()
    {
        return $this->hasOneThrough(
            User::class, // The final related model
            Staff::class, // The intermediate model
            'id', // Foreign key on the Staff table (user_id in staff table)
            'id', // Foreign key on the User table
            'user_id', // Local key on the StaffCard table
            'user_id' // Local key on the Staff table
        );
    }

    /**
     * Relationship to the Card model.
     */
    public function session()
    {
        return $this->belongsTo(SessionPackages::class, 'session_id');
    }

    public function sessionPackage()
    {
        return $this->belongsTo(SessionPackages::class, 'session_id', 'id');
    }

    public function card()
    {
        return $this->hasOneThrough(
            Card::class,
            SessionPackages::class,
            'id',       // Foreign key on SessionPackages table
            'id',       // Foreign key on Card table
            'session_id', // Local key on StaffSession table
            'cart_id'   // Local key on SessionPackages table
        );
    }

    /**
     * Relationship to the Slot model.
     */
    public function slot()
    {
        return $this->hasOneThrough(
            Slot::class,
            SessionPackages::class,
            'id',       // Foreign key on SessionPackages table
            'id',       // Foreign key on Slot table
            'session_id', // Local key on StaffSession table
            'time'      // Local key on SessionPackages table
        );
    }
}
