<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class StaffCard extends Model
{

    protected $table = 'staff_cards';

    protected $fillable = [
        'user_id',
        'card_id',
        'status',
    ];

   /**
     * Relationship to the Staff model.
     */
    public function staff()
    {
        return $this->belongsTo(Staff::class, 'user_id', 'id');
    }

    /**
     * Indirect relationship to the User model through Staff.
     */
    public function user()
    {
        return $this->hasOneThrough(
            User::class, // The final related model
            Staff::class, // The intermediate model
            'id', // Foreign key on the Staff table (user_id in staff table)
            'id', // Foreign key on the User table
            'user_id', // Local key on the StaffCard table
            'user_id' // Local key on the Staff table
        );
    }

    /**
     * Relationship to the Card model.
     */
    public function card()
    {
        return $this->belongsTo(Card::class, 'card_id');
    }

    public function sessionPackages()
    {
        return $this->hasMany(SessionPackages::class, 'cart_id', 'card_id');
    }

}
