<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SessionPackages extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'session_packages';

    /**
     * Get the cart associated with the session.
     */
    public function cart()
    {
        return $this->belongsTo(Card::class, 'cart_id', 'id');
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'offline_id',
        'cart_id',
        'package_id',
        'service_id',
        'date',
        'time',
        'status',
    ];

    /**
     * Get the package associated with the session.
     */
    public function package()
    {
        return $this->belongsTo(Package::class, 'package_id');
    }

    public function slot()
    {
        return $this->belongsTo(Slot::class, 'time');
    }

    /**
     * Get the service associated with the session.
     */
    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }

    public function addedStaff()
    {
        return $this->hasManyThrough(
            Staff::class,
            StaffSession::class,
            'session_id', 
            'id',         
            'id',         
            'user_id'     
        );
    }
    
    public function staffSessions()
    {
        return $this->hasMany(StaffSession::class, 'session_id', 'id');
    }

}
