<?php

namespace App\Jobs;

use App\Card;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class SendExpiredJobNotification implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $expiredCards;

    public function __construct($expiredCards)
    {
        $this->expiredCards = $expiredCards;
    }

    public function handle()
    {
        foreach ($this->expiredCards as $card) {
            
            if($card->status == "Pending" || $card->status == "Accept"){
                $user = User::find($card->user_id);

                if ($user) {
                    $device_tokens = $user->user_device_token;

                    if (!empty($device_tokens) && $device_tokens != '0') {
                        if (strlen($device_tokens) > 70) {
                            $title = "-" . $card->id;
                            $body = "Your booking for {$card->service_name} has expired.";
                            $text = "Your booking for {$card->service_name} is no longer valid due to expiration.";

                            send_single_notification(
                                $device_tokens,
                                [
                                    "title" => $title,
                                    "body" => $body,
                                    "icon" => 'myicon',
                                    "sound" => 'default',
                                    "click_action" => "EcomNotification",
                                ],
                                [
                                    "type" => 'expired_job_notification',
                                    "notificationID" => time(),
                                    "status" => "0",
                                    "imageURL" => "",
                                    "cardId" => (string)$card->id,
                                ]
                            );
                        }
                    }
                }

                if($card->accept_user_id != null){
                    $user = User::find($card->accept_user_id);

                    if ($user) {
                        $device_tokens = $user->user_device_token;

                        if (!empty($device_tokens) && $device_tokens != '0') {
                            if (strlen($device_tokens) > 70) {
                                $title = "-" . $card->id;
                                $body = "Your booking for {$card->service_name} has expired.";
                                $text = "Your booking for {$card->service_name} is no longer valid due to expiration.";

                                send_single_notification(
                                    $device_tokens,
                                    [
                                        "title" => $title,
                                        "body" => $body,
                                        "icon" => 'myicon',
                                        "sound" => 'default',
                                        "click_action" => "EcomNotification",
                                    ],
                                    [
                                        "type" => 'expired_job_notification',
                                        "notificationID" => time(),
                                        "status" => "0",
                                        "imageURL" => "",
                                        "cardId" => (string)$card->id,
                                    ]
                                );
                            }
                        }
                    }

                }
            }

            // Mark the card as notified
            $card->update(['notification_sent' => true]);
        }
    }
}
