<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class AuthApiMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (!auth()->check()) {
            $response = [
                'status' => '0',
                'message' => (object) [],
                'error' => (object) [],
                'data' => (object) [],
            ];
            return response()->json($response, 401);
        }
        return $next($request);
    }
}
