<?php

namespace App\Http\Controllers;

use Auth;
use Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\RewardConfig;
use Detection\MobileDetect;
use App\StaffSession;
use App\WalletPaymentReport;
use App\SessionPackages;
use App\Wallet;
use App\Article;
use App\Order;
use App\Packages;
use App\PrefferedDays;
use Stripe\Checkout\Session;
use App\Transection;
use App\Slot;
use App\Invite;
use App\Category;
use App\Card;
use App\User;
use App\City;
use App\Locality;
use App\RewardUser;
use App\Blog;
use App\Addon;
use App\Slider;
use App\Service;
use App\Address;
use App\Attribute;
use App\DeletedAccount;
use App\Setting;
use App\CardAddon;
use App\HomeSetting;
use App\AttributeValue;
use App\CardAttribute;
use App\ServiceGallery;
use App\ServiceAttributeValue;
use App\ServiceAttributeValueItem;
use App\Coupon;
use App\Question;
use App\Seller;
use App\UserCoupon;
use App\CardCoupon;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\SellerService;
use App\Review;
use App\ChildCategory;
use App\OfflineBooking;
use App\Services\FirebasePushNotificationService;
use Kreait\Firebase\Database;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;

class FrontController extends Controller
{
	protected $firebaseService;

    // Inject FirebasePushNotificationService through the constructor
    public function __construct(FirebasePushNotificationService $firebaseService, Database $database)
    {
        $this->firebaseService = $firebaseService;
        $this->database = $database;
    }

    public function getSessionStaff($sessionId)
    {
        $staffSessions = StaffSession::where('session_id', $sessionId)->with('staff')->get();

        if ($staffSessions->isEmpty()) {
            return response()->json([
                'success' => false,
                'message' => 'No staff assigned to this session.'
            ]);
        }

        $staffList = $staffSessions->map(function ($staffSession) {
            return [
                'name' => trim(optional($staffSession->staff)->first_name . ' ' . optional($staffSession->staff)->last_name),
				'phone' => trim(optional($staffSession->staff)->dial_code . ' ' . optional($staffSession->staff)->phone),
				'status' => $staffSession->status ?? 'unknown'
            ];
        });

        return response()->json([
            'success' => true,
            'staff' => $staffList
        ]);
    }

	public function handle_reward($created_at, $id = 0, $totalAmount = 0)
    {
        // Fetch reward and exchange values from the configuration
        $reward = RewardConfig::where('name', 'reward')->first();
        $exchange = RewardConfig::where('name', 'exchange')->first();

        if (!$reward && !$exchange) {
            return $this->sendResponse([], 'Reward configuration not found!');
        }

        // Get the reward and exchange values
        $rewardPerDollar = $reward->value;  // Points per dollar spent
        // $exchanges = $exchange->value;      // Exchange rate (dollars equivalent for rewards)

        // Calculate reward points and reward amount (AED equivalent of points)
        $rewardPoints = floor($totalAmount * $rewardPerDollar);
        $rewardAmount = floor($totalAmount / $rewardPerDollar);

        // Initialize the final amount after rewards are applied
        $finalAmount = $totalAmount;

        // Calculate remaining reward amount and adjust the final total
        if ($rewardAmount > $totalAmount) {
            // If reward amount exceeds the total, set final amount to zero and calculate remaining reward amount
            $remainingRewardAmount = $rewardAmount - $totalAmount;
            $finalAmount = 0;

            // Calculate the remaining reward points based on the unused reward amount
            $remainingRewardPoints = $remainingRewardAmount * $rewardPerDollar;
        } else {
            // Otherwise, deduct the reward amount from the total and set no remaining rewards
            $finalAmount = $totalAmount - $rewardAmount;
            $remainingRewardAmount = 0;
            $remainingRewardPoints = 0;
        }

        $res = [
            'total_before_rewards' => (string) $totalAmount,
            'reward_amount_used' => (string) ($totalAmount - $finalAmount), 
            'remaining_reward_amount' => (string) $remainingRewardAmount,   
            'remaining_reward_points' => (int) $remainingRewardPoints,      
            'final_amount' => (string) $finalAmount                        
        ];

        // $this->updateUserReward($created_at, $id, ($totalAmount - $finalAmount),($totalAmount - $finalAmount));

        return $res;
    }
	
	public function updateUserReward($created_at, $id, $point, $amount)
    {
        $userId = auth()->user()->id;
    
        // Check if the user exists in the users table
        $userExists = \DB::table('users')->where('id', $userId)->exists();
    
        if (!$userExists) {
            throw new \Exception('User not found in the users table');
        }
    
        // Delete any existing user reward for this user
        // RewardUser::where('user_id', $userId)->delete();
    
        // Create a new reward entry
        // $userReward = RewardUser::create([
        //     'booking_type' => 'Purchase',
        //     'transection_id' => $id,
        //     'date' => $created_at,
        //     'user_id' => $userId,
        //     'reward_config_id' => 1, 
        //     'points' => $point,
        //     'amounts' => $amount
        // ]);
    
        // return $userReward;
    }
    
	public function get_reward_price($totalAmount = 0)
    {
        // Fetch reward and exchange values from the configuration
        $reward = RewardConfig::where('name', 'reward')->first();
        $exchange = RewardConfig::where('name', 'exchange')->first();

        if (!$reward || !$exchange) {
            return [
                'total_before_rewards' => (string) 0,
                'reward_amount_used' => (string) 0, 
                'remaining_reward_amount' => (string) 0,   
                'remaining_reward_points' => (int) 0,      
                'final_amount' => (string) 0                        
            ];
        }

        $rewardPerDollar = $reward->value;  
        $exchanges = $exchange->value;      

        $rewardAmount = floor($totalAmount / $exchanges);
        $rewardPoints = floor($rewardAmount * $rewardPerDollar);

        $finalAmount = $totalAmount;

        if ($rewardAmount > $totalAmount) {
            $remainingRewardAmount = $rewardAmount - $totalAmount;
            $finalAmount = 0;

            // Calculate the remaining reward points based on the unused reward amount
            $remainingRewardPoints = $remainingRewardAmount * $rewardPerDollar;
        } else {
            // Otherwise, deduct the reward amount from the total and set no remaining rewards
            $finalAmount = $rewardAmount;
            $remainingRewardAmount = 0;
            $remainingRewardPoints = 0;
        }
        
        return [
            'total_before_rewards' => (string) $totalAmount,
            'reward_amount_used' => (string) ($totalAmount - $finalAmount), 
            'remaining_reward_amount' => (string) $remainingRewardAmount,   
            'remaining_reward_points' => (int) $remainingRewardPoints,      
            'final_amount' => (string) $finalAmount                        
        ];
    }

	public function index(Request $request)
	{
		$data['home_setting'] = Slider::first();
		// return $data['home_setting'];

		$serviceData = [];
		$services = Category::orderBy('order_column','ASC')->where('parent_id',0)->get();
        foreach ($services as $service) {
            // Get the first ServiceAttributeValueItem record with sub_category relationship
            $serviceAttributeValueItem = ServiceAttributeValueItem::where('category_id', $service->id)
                ->with('service')
                ->first();

              if ($serviceAttributeValueItem && $serviceAttributeValueItem->service) {
                // Add only the service data
                $serviceData[] = $serviceAttributeValueItem->service;
            }
        }
		$data['services'] = $serviceData;
		
		$featured_services = Service::where('status','1')->where('featured','1')->get();
		$featured_services_status = "False";
		if(count($featured_services) && $featured_services){
			foreach($featured_services as $key => $featured){
              	if($featured->featured_banner){
              		$featured_services_status = "True";
              	}
			}
		}
		
		$data['featured_services'] = $featured_services;
		$data['featured_services_status'] = $featured_services_status;
		$data['reviews'] = Review::orderBy('created_at', 'desc')->take(6)->get();

		// ---------------------- Most Booking Service --------------
		$mostBookedServices = [];
		$featuredServices = Service::where('status', 1)->where('featured', 1)->orderBy('id', 'DESC')->get();
		
		foreach ($featuredServices as $service) {
		if(ServiceAttributeValueItem::where('service_id',$service->id)->with('sub_category')->first()->sub_category){
			$mostBookedServices[] = [
				'id' => (string) $service->id,
				'title' => $service->name,
				'slug' => $service->slug,
				'price' => (string) $service->price,
                'image' => asset('uploads/service/'.$service->thumbnail_img),
				// 'image' => asset('uploads/service/featured_banner/'.$service->featured_banner),
				'sub_cate_yes' => 'Yes',
			];
		}else{
			$mostBookedServices[] = [
				'id' => (string) $service->id,
				'title' => $service->name,
				'slug' => $service->slug,
				'price' => $service->price,
                'image' => asset('uploads/service/'.$service->thumbnail_img),
				// 'image' => \URL::to('/').'/uploads/service/featured_banner/'.$service->featured_banner,
				'sub_cate_yes' => 'No',
			];
		}
		}
	
		// Push Most Booked Services data into response
		$data['mostBookedServices'] = $mostBookedServices;

		$categoryIds = [1, 3, 7];

		// Fetch categories
		$categories = Category::whereIn('id', $categoryIds)->get();
		
		// Fetch services with matching parent_id (category) and status = 1
		$servicesByCategory = Service::where('status', 1)
			->whereIn('parent_id', $categoryIds)
			->get();
		
		// Group services under each category with the required structure
		$groupedServices = $categories->map(function ($category) use ($servicesByCategory) {
			// Filter services that belong to the current category (parent_id matches category id)
			$services = $servicesByCategory->filter(function ($service) use ($category) {
				return $service->parent_id === $category->id;
			})->map(function ($service) {
				// Check if service has sub-category relationship
				$serviceAttribute = ServiceAttributeValueItem::where('service_id', $service->id)
					->with('sub_category')
					->first();
		
				$service->sub_cate_yes = $serviceAttribute && $serviceAttribute->sub_category ? 'Yes' : 'No';
				$service->icon = asset('/uploads/service/' . $service->thumbnail_img);
		
				return [
					'id' => (string) $service->id,
					'title' => $service->name,
					'icon' => $service->icon,
					'price' => (string) $service->price,
					'sub_cate_yes' => $service->sub_cate_yes,
				];
			})->values();
		
			return [
				'category_name' => $category->name ?? 'Unknown',
				'services' => $services,
			];
		})->values();
		
		$data['groupedServices'] = $groupedServices;

		$serviceData = [];
		$services = Service::where('status', 1)->get();
		
		foreach ($services as $service) {
			$serviceAttributeValueItem = ServiceAttributeValueItem::where('service_id', $service->id)
				->with('sub_category')
				->first();
		
			$subCateYes = $serviceAttributeValueItem && $serviceAttributeValueItem->sub_category ? 'Yes' : 'No';
		
			$serviceData[] = [
				'id' => (string) $service->id,
				'title' => $service->name,
				'image' => asset('uploads/service/' . $service->thumbnail_img),
				'price' => (string) $service->price,
				'sub_cate_yes' => $subCateYes,
				'slug' => $service->slug,
			];
		}
		
		// Push Service data into response
		$data['services_pickup'] = $serviceData;

		return view('web.home',$data);
	}

	public function ratings($id = null)
	{
		if($id != null) {
			$data['reviews'] = Review::where('service_id', $id)->orderBy('created_at', 'desc')->take(6)->get();
		
		}else{
			$data['reviews'] = Review::orderBy('created_at', 'desc')->take(6)->get();
		
		}
		return view('web.ratings',$data);
	}

	public function search(Request $request)
	{
		$attr_items = AttributeValue::where('value', 'LIKE', "%$request->title%")->get();
		
		$cat = Category::where('name', 'LIKE', "%$request->title%")->orWhere('meta_description', 'LIKE', "%$request->title%")->get();
		$child_cat = ChildCategory::where('name', 'LIKE', "%$request->title%")->get();
		
		$catItemIds = [];
		$childCatItemIds = [];
		$attributeItemIds = [];
		$attributeIds = [];
		$serviceIds = [];
		if($attr_items && count($attr_items)){
			foreach ($attr_items as $key => $attribute) {
				array_push($attributeItemIds, $attribute->id);
			}			
		}

		if($cat && count($cat)){
			foreach ($cat as $key => $attribute) {
				array_push($catItemIds, $attribute->id);
			}			
		}

		if($child_cat && count($child_cat)){
			foreach ($child_cat as $key => $attribute) {
				array_push($childCatItemIds, $attribute->id);
			}			
		}

		// foreach (Attribute::where('name', 'LIKE', "%$request->title%")->get() as $key => $val) {
			
		// 	array_push($attributeIds, $val->id);
		// }
		
		if(count($childCatItemIds) || count($catItemIds)){
			$serv_attr = ServiceAttributeValueItem::whereIn('child_category_id',$childCatItemIds)->orWhereIn('category_id',$catItemIds)->orWhereIn('sub_category_id',$catItemIds)->get();
			
			foreach ($serv_attr as $key => $item) {
				array_push($serviceIds, $item->service_id);
			}
		}

		if(count($attributeItemIds) || count($attributeIds)){
			$serv_attr = ServiceAttributeValue::whereIn('attribute_id',$attributeIds)->orWhereIn('attribute_item_id',$attributeItemIds)->get();
			
			foreach ($serv_attr as $key => $item) {
				array_push($serviceIds, $item->service_id);
			}
		}

		if(count($attributeIds) && count($serviceIds) > 0){

		}

		if($serviceIds && count($serviceIds)){
			$data['services'] = Service::where('status','1')->whereIn('id', $serviceIds)->orWhere('name', 'LIKE', "%$request->title%")->orderBy('position')->get();
		} else {
			$data['services'] = Service::where('status','1')->where('name', 'LIKE', "%$request->title%")->orderBy('position')->get();
		}
		
		return view('web.search',$data);
	}

	public function about_us()
	{
		$data['setting'] = Article::find(1);
		return view('web.about_us',$data);
	}

	public function contact_support()
	{
		return view('web.contact_support');
	}

	public function contact_support_post(Request $request)
	{

		$msg = 'Hello,';
		
		$msg .= ' Name :'.$request->name;
		
		$msg .= ', Email : '.$request->email;
		
		$msg .= ', Address : '.$request->address;
		
		$msg .= ', Phone : '.$request->dial_code.' '.$request->phone;
		
		// $msg .= ', Whatsapp : '.$request->dial_code_whatsapp.' '.$request->whatsapp;
		
		$msg .= ', Comment : '.$request->comment;
		
		
		$array['view']      = 'emails.contact_support';
        $array['subject']   = 'Contact Support';
        $array['data']      = $msg;
        $res = \Mail::to('booknow@urbanmop.com')->send(new \App\Mail\Mail($array));
        return back()->with('success','Your message has been sent successfully!');;
	}
	
	public function service_details_booking($slug = '')
	{
		if (Auth::user()) {
			\Session::put('user_id', Auth::user()->id);
		} else {
			if (!\Session::has('user_id')) {
				\Session::put('user_id', mt_rand(1000000, 9999999));
			}
		}

		$serv = Service::where('slug', $slug)->first();

		if (empty($serv)) {
			return view('errors.404');
		}

		$data['service'] = $serv;
		$id = $serv->id;

		if (Auth::user()) {
			\Session::put('is_login', 'Yes');
		} else {
			\Session::put('is_login', 'No');
		}

		// Clear old cart data
		$card_infos = Card::where('service_id', $id)
			->where('user_id', \Session::get('user_id'))
			->where('is_checkout', 'Processing')
			->where('created_at', '<', date('y-m-d'))
			->get();

		foreach ($card_infos as $card_info) {
			if ($card_info) {
				CardAddon::where('card_id', $card_info->id)->delete();
				CardAttribute::where('card_id', $card_info->id)->delete();
				$card_info->delete();
			}
		}

		// Fetch service and related data
		$data['service_header'] = ServiceGallery::where('service_id', $id)->first();
		$data['card'] = Card::where('user_id', \Session::get('user_id'))
			->where('service_id', $id)
			->where('status', 'Pending')
			->where('payment_collected', 'No')
			->where('work_done', 'No')
			->where('is_checkout', 'Processing')
			->orderBy('id', 'DESC')
			->first();
		$data['maid_slot_id'] = '';
		$data['maid_slot_date']= '';
		if(isset($data['card']->latestSessionPackages)){
		    $data['maid_slot_id'] = $data['card']->latestSessionPackages->first()->time??0;
            $data['maid_slot_date']= $data['card']->latestSessionPackages->first()->date??'';
		}
		$data['addresses'] = Address::where('user_id', \Session::get('user_id'))->where('is_active', 1)->orderBy('id', 'DESC')->get();
		$data['cities'] = City::all();
		$data['localities'] = Locality::all();
		$data['services'] = Service::all();
		$data['packages'] = Packages::where('status', '1')->get()->map(function($package){
		    
            $package->save_amount = ( ($package->amount / $package->total_sessions) * $package->free_sessions); 
            return $package;
		})->sortBy(function ($package) {
			return (int) $package->amount; 
		});

		$reviewData = Review::where('service_id', $id)
			->select(
				DB::raw('ROUND(AVG(rating), 2) as average_rating'), 
				DB::raw('COUNT(id) as total_reviews')           
			)
			->first();

		$averageRating = $reviewData->average_rating ?? '0.00'; 
		$totalReviews = $reviewData->total_reviews ?? 0;       
		$data['total_reviews'] = $totalReviews;
		$data['average_rating'] = $averageRating;
        $data['slots'] = Slot::all();
		$data['data']  = HomeSetting::first();
		return view('web.service_bookings', $data);
	}

	public function saveAddress(Request $request)
	{
		$request->validate([
			'flat_no' => 'required|string',
			'building' => 'required|string',
			'locality' => 'required|string',
			'city_id' => 'required|exists:cities,id',
			'address_type' => 'required|string',
			'address' => 'required|string'
		]);

		$params = [
			'user_id' => Auth::id(),
			'address' => $request->address,
			'address_type' => $request->address_type,
			'flat_no' => $request->flat_no,
			'building' => $request->building,
			'locality' => $request->locality,
			'latitude' => $request->latitude ?? null,
			'longitude' => $request->longitude ?? null,
			'city_id' => $request->city_id,
			'is_active' => "1"
		];

		// Deactivate other addresses for the user
		Address::where('user_id', Auth::id())->update(['is_active' => 0]);

		// Create the new address
		$address = Address::create($params);

		// Load city and locality info for the response
		$address->load('city', 'locality_info');

		return response()->json([
			'success' => true,
			'message' => 'Address added successfully',
			'data' => [
				'id' => $address->id,
				'flat_no' => $address->flat_no,
				'building' => $address->building,
				'city_name' => $address->city->name ?? 'N/A',
				'locality_name' => $address->locality_info->name ?? 'N/A',
				'address_type' => $address->address_type,
				'address' => $address->address,
			]
		]);
	}


	public function edit($id)
	{
		// Fetch the address by ID, or return an error if not found
		$address = Address::find($id);

		if (!$address) {
			return response()->json([
				'success' => false,
				'message' => 'Address not found'
			], 404);
		}

		// Return the address data
		return response()->json([
			'success' => true,
			'data' => $address
		]);
	}

	public function checkout(Request $request)
	{
		$card = Card::with('service')->where(['user_id'=>auth()->user()->id])
		->where('is_checkout', '!=', 'Done')
		->whereNotNull('g_total')  
		// ->whereNotNull('slot_id') 
		->where('g_total', '>', 0) 
		->orderBy('id', 'DESC')
		->get();
		
		if($card){
		    
			
			$cards = [];
			$cards_detail = [];
			$total_amount = 0;
			$coupon_id = 0;
			$coupon_amount = 0;
			$tip_amount = 0;
			$cod_charge = 0;

			foreach ($card as $key => $value) {
				// Initialize card data array
				$card_data = [
					'id'                     => $value->id, 
					'user_id'                => $value->user_id,
					'service_id'             => $value->service_id,
					'service_name'           => $value->service_name, 
					'category_id'            => $value->category_id,
					'slot_id'                => $value->slot_id,
					'slot'                	 => Slot::find($value->slot_id)->name ?? "-",
					'address_id'             => $value->address_id,
					'tran_id'                => normalizeId($value->tran_id),
					'payment_status'         => $value->payment_status,
					'alternative_dial_code'  => $value->alternative_dial_code ?? "",
					'alternative_number'     => $value->alternative_number,
					'note'                   => $value->note,
					'date'                   => $value->date,
					'status'                 => $value->status,
					'accept_user_id'         => $value->accept_user_id,
					'amount'                 => $value->amount, // Add card amount
					'g_total'                => $value->g_total,
					'material_status'        => $value->material_status,
					'material_charge'        => $value->material_charge,
					'is_checkout'            => $value->is_checkout,
					'payment_collected'      => $value->payment_collected,
					'service_completed'      => $value->service_completed,
					'service_completed_date' => $value->service_completed_date,
					'work_done'              => $value->work_done,
					'pending_approval_by_admin' => $value->pending_approval_by_admin,
					'booking_from'           => $value->booking_from,
					'created_at'             => $value->created_at,
					'updated_at'             => $value->updated_at,
					'selected_packages'      => $value->selected_packages,
					'preferred_days'         => $value->preffered_days,
					'sub_total'             => $value->sub_total
				];

				// Card Attributes and Add-ons
				$card_attr = [];
				foreach (CardAttribute::where('card_id', $value->id)->get() as $item) {
					$params = [
						'sub_cate_id'         => (string) $item->sub_cate_id,
						'sub_cate_name'       => Category::find($item->sub_cate_id)->name ?? '',
						'main_sub_cat_id'     => $item->main_sub_cat_id,
						'main_sub_cat_name'   => Category::find($item->main_sub_cat_id)->name ?? '',
						'child_cate_id'       => (string) $item->child_cate_id,
						'child_cate'          => ChildCategory::find($item->child_cate_id)->name ?? '',
						'attribute_id'        => $item->attribute_id,
						'attribute_name'      => $item->attribute_name,
						'attribute_item_id'   => (string) $item->attribute_item_id,
						'attribute_item_name' => $item->attribute_item_name,
						'attribute_qty'       => $item->attribute_qty,
						'attribute_price'     => $item->attribute_price,
						'service_type'        => $item->service_type,
					];

					// Add-ons
					$addons = [];
					foreach (CardAddon::where('card_id', $value->id)->where('card_attribute_id', $item->id)->get() as $cardaddon) {
						$addons[] = [
							'card_id'            => $cardaddon->id,
							'card_attribute_id'  => $cardaddon->id,
							'add_on_id'          => $cardaddon->add_on_id,
							'name'               => $cardaddon->name,
							'value'              => $cardaddon->value,
							'percentage'         => $cardaddon->percentage,
						];
					}
					$params['addon'] = $addons; // Add the addons to the card attribute
					$card_attr[] = $params; // Add the card attribute to the array
				}

				// Include the card attributes inside the card data
				$card_data['card_attribute'] = $card_attr;
				if($value->service_id == 10){
					$session = SessionPackages::where([
						'cart_id' => $value->id, 
					])->first();
					$card_data['session_date'] = $session->date;
					$card_data['session_time'] = $session->time;
				}
				
				$service = Service::find($value->service_id);

				if ($service && !is_null($service->cod_charge)) {
					$cod_charge     += (int) $service->cod_charge;
				} 
				$card_data['cod_charge'] = (string) $service->cod_charge;
				
				// Add card data to the main $cards array
				$cards_detail[] = $card_data;
				$coupon_amount  = (float) $value->coupon_amt;
				$coupon_id = $value->coupon_id;
				$tip_amount     = (int) $value->tip_id;
				// Update total amount
				$total_amount += (float) $value->amount;
			}

			$cards['card'] = $cards_detail;
			
			$cards['sub_total']         = (string) $total_amount;
			$cards['coupon_status']     = (string) "no";
			$cards['tip_status']     = (string) "no";
			if(!empty($coupon_amount) && $coupon_amount != 0){
				$cards['coupon_amount']     = (float) $coupon_amount;
				$cards['coupon_code']     = Coupon::find($coupon_id)->code ?? "";
				$cards['coupon_status']     = "yes";
				// $total_amount -= $coupon_amount;
			}
			$cards['tip_amount'] = (string) $tip_amount;
			$cards['cod_charge'] = (string) $cod_charge;
			$cards['surcharge'] = (string) HomeSetting::first()->cash_surcharge;
			// if ($request->is_tip && $tip_amount > 0) {
			// 	$cards['tip_amount'] = (string) $tip_amount;
			// 	$cards['tip_status'] = "yes";
			// 	// $total_amount += $tip_amount;
			// } else {
			// 	$cards['tip_amount'] = (string) $tip_amount;
			// 	$cards['tip_status'] = "no";
			// }
			
			$cards['user_balance']  = auth()->user()->wallet_balance;
			$rewardData = $this->get_reward_price($total_amount);

			if ($rewardData !== null) {
				$cards["remaining_reward_points"] = (string) $rewardData['remaining_reward_points'];
				$cards["reward_amount"] = (string) $this->get_reward_price($total_amount)['final_amount'];
				// $cards['total']         = (string) ((float) $total_amount - (float) $this->get_reward_price($total_amount)['final_amount']);

				$cards["total"] = (string) ((float)$total_amount); 
			} else {
				$cards["remaining_reward_points"] = '0'; 
				$cards["reward_amount"] = '0'; 
				$cards["total"] = (string) ((float)$total_amount); 
			}
	
		
			return view('web.checkout', [
				'cartItems' => $cards,
			]);
		} else {
			return $this->sendError('Invalid booking id');
		}
	}

	public function process_checkout(Request $request)
	{
		// Validate the incoming request
		$request->validate([
			'tip_amount' => 'nullable|numeric',
			'payment_method' => 'required|string'
		]);
	
		// Retrieve user and any open cart items
		$user = auth()->user();
		$cards = Card::where(['user_id' => $user->id])
			->where('is_checkout', '!=', 'Done')
			->get();
	
		if ($cards->isEmpty()) {
			return response()->json(['success' => false, 'message' => 'Your Cart is empty!']);
		}
	
		$allHaveSlotId = true;
		foreach ($cards as $card) {
			if($card->service_id != 10){
				if (empty($card->slot_id)) {
					$allHaveSlotId = false;
					break;
				}
			}
		}
	
		if (!$allHaveSlotId) {
			return redirect('cart')->with('error','Order is not completed, please fill the order!');
		}
	
		$total = 0;
		$subtotal = 0;
		$couponAmt = 0;
		$card_ids = "";
		foreach ($cards as $card) {
			$card_ids .= $card->id . ',';
			$data = [
				'card_process' => 'Complete',
				'payment_status' => "True",
				'payment_type' => $request->payment_method == 'card' ? "1" : "3",
				'is_checkout' => 'Done'
			];
	
			// Apply tip amount if provided
			if (!empty($request->tip_amount)) {
				$data['tip_id'] = $request->tip_amount;
			}
	
			// Update cart item and calculate total
			$card->update($data);
			$total += $card->amount;
		}
		$card_ids = rtrim($card_ids, ',');

		$input=[
			'customer_id' => auth()->user()->id,
			'vendor_id'=> SellerService::where("service_id",$card->service_id)->first()->seller_id,
			'amount'=>$card->amount,
			'remark'=>"Done",
			'type'=>'Dr',
			'card_ids'=>$card_ids,
		];
		
		$res=Transection::create($input);
	
		// Update user's wallet or process payment record
		$paymentRecord = [
			'user_id' => $user->id,
			'wallet_amount' => $total,
			'amount' => $total,
			'type' => 'debit',
			'pay_type' => 'Booking Service',
			'pay_method' => $request->payment_method,
			'description' => 'Booking Service'
		];
		wallet_history($paymentRecord);
	
		// Prepare final response
		return response()->json([
			'success' => true,
			'message' => 'Checkout completed successfully.',
			'data' => [
				'subtotal' => number_format($subtotal, 2),
				'total' => number_format($total - $couponAmt, 2),
				'tip_amount' => number_format($request->tip_amount ?? 0, 2),
				'tran_id' => $res->id
			]
		]);
	}
	
	public function thankyou($id)
	{
		$res = Transection::find($id);
		$cardIds = explode(',', $res->card_ids);

		$total = 0;
		$subtotal = 0;
		$material_charge = 0;
		$tip = 0;
		$cod_charge = 0;
		$payment_type = 0;
		$surcharge = 0;
		$coupon_discount = 0;
		$addons_total = 0;
		$cards_details = [];
        $grand_total = 0;
		foreach ($cardIds as $cardId) {
			$card = Card::find($cardId);

			if ($card) {
			    $grand_total+=$card->g_total;
			    
				$subtotal += (float) $card->amount;
				$total += (float) $card->amount;
				$material_charge += (float) $card->material_charge;
				$tip += (float) $card->tip_id ?? 0;
				
				$surcharge += (float) $card->cod ?? 0;
				$cod_charge += (float) $card->surcharge ?? 0;

				// Addons
				$addons = $card->card_addon;
				$addons_total += $addons->sum('value');

				// Coupon
				$order = Order::find($card->order_id);
				if ($order) {
					$coupon_discount = $order->coupon_amount;
					$payment_type = $order->payment_type;
				}

				$cards_details[] = [
					'service_name' => $card->service->name ?? 'Service Name',
					'attributes' => CardAttribute::where('card_id', $card->id)->get(),
					'addons' => $addons,
					'coupon' => $coupon_discount,
					'material_charge' => $card->material_charge,
					'tip' => $card->tip_id,
					'amount' => $card->amount,
					'service_price' => $card->service->price ?? 0,
					'service_id' => $card->service->id,
				];
			} else {
				return redirect()->back()->with('error', 'Invalid booking id.');
			}
		}
		if($payment_type == 2){
			//$total = ($total + $material_charge + $tip + $cod_charge + $surcharge + $addons_total) - $coupon_discount;
			$total = ($total  + $tip + $cod_charge + $surcharge + $addons_total) - $coupon_discount;
		}else{
			//$total = ($total + $material_charge + $tip + $cod_charge + $addons_total) - $coupon_discount;
			$total = ($total  + $tip + $cod_charge + $addons_total) - $coupon_discount;
		}
		$total = $grand_total;
		return view('web.thankyou', [
			'material_charge' => $material_charge,
			'sub_total' => $subtotal,
			'total' => $total,
			'cards_details' => $cards_details,
			'tip' => $tip,
			'surcharge' => $surcharge,
			'payment_type' => $payment_type,
			'cod_charge' => $cod_charge,
			'coupon_discount' => $coupon_discount,
			'addons_total' => $addons_total,
		]);
	}

	public function get_selected_price_cod(Request $request)
	{
		$card = Card::where('user_id', auth()->user()->id)
		->where('is_checkout', '!=', 'Done')
		->orderBy('id', 'DESC')
		->get();

		$couponAmount = 0;
		$tipAmount = 0;
		
		if ($card->isEmpty()) {
			return $this->sendResponse([], 'Checkout is empty');
		}


		$cod = (int) 0;
		$total_amount = 0;
        $surcharge = 0;
        $cd_amount = HomeSetting::first()->cash_surcharge; 
        foreach ($card as $key => $value) {
        	$tipAmount = (float) $value->tip_id ?? 0;
        	$couponAmount += (float) $value->coupon_amt;
        	$total_amount += (float) $value->amount;
        	$surcharge += (int) $cd_amount;
        	$cod += (float) Service::find($value->service_id)->cod_charge;
        }
        
		if($request->status == 1){
			$finalAmount = $total_amount + $surcharge + $cod + $tipAmount - $couponAmount;
		} else{
			$finalAmount = $total_amount + $cod + $tipAmount - $couponAmount;
		}
		$cards['after_total'] = (string) ($finalAmount);
		$cards['original_cod'] = (string)($surcharge);
		return $this->sendResponse($cards, 'COD Add');
	}

	public function apply_tip(Request $request)
	{
		$card = Card::where('user_id', auth()->user()->id)
			->where('is_checkout', '!=', 'Done')
			->orderBy('id', 'DESC')
			->get();
	
		if ($card->isEmpty()) {
			return $this->sendResponse([], 'Checkout is empty');
		}
	
		$couponAmount = 0;
	
		$cards = [];
		$total_amount = 0;
		$tip_amount = (float) $request->tip_amount;
	
		$cod = (int) 0;
		
		if($request->payment_method == 'pi4'){
			$surcharge = (int) HomeSetting::first()->cash_surcharge;
		} else{
			$surcharge = 0;
		}
		$total_surcharges = 0;
		foreach ($card as $key => $value) {
			$total_surcharges+=$surcharge;
			$total_amount += (float) $value->amount;
			$couponAmount += (float) $value->coupon_amt;
			$cod += (float) Service::find($value->service_id)->cod_charge;
	
			// Add or update the tip amount
			$value->update([
				'tip_id' => $tip_amount
			]);
		}
	
		$finalAmount = $total_amount + $tip_amount + $cod - $couponAmount + $total_surcharges;
	
		$cards['before_total'] = (string) ($total_amount);
		$cards['after_total'] = (string) ($finalAmount);
		$cards['coupon'] = (string) ($couponAmount);
		$cards['tip'] = (string) ($tip_amount);
	
		return $this->sendResponse($cards, 'Tip Applied');
	}
	
	

	public function applycoupon(Request $request)
	{
		
		$userId = auth()->user()->id;
		if($request->coupon_code == "0"){
			
			$totalAmount = 0;
			$couponAmount = 0;
			$tipAmount = 0;
			$cod = 0;
			$surcharge = 0;

			$cartItems = Card::where('user_id', $userId)
			->where('is_checkout', '!=', 'Done')
			->orderBy('id', 'DESC')
			->get();
		
			if ($cartItems->isEmpty()) {
				return response()->json(['success' => false, 'message' => 'Checkout is empty']);
			}
		
			if($request->payment_method == 'pi4'){
				$surcharge = (int) HomeSetting::first()->cash_surcharge;
			} else{
				$surcharge = 0;
			}
			$total_surcharge = 0;
			foreach ($cartItems as $item) {
				$totalAmount += (float) $item->amount;
				$tipAmount = (float) $item->tip_id ?? 0;
				$cod += (float) Service::find($item->service_id)->cod_charge;
				$total_surcharge+=$surcharge;
				// Add or update the coupon details
				$item->update([
					'coupon_id' => null,
					'coupon_amt' => 0,
				]);
			}
		
			$finalAmount = $totalAmount + $cod + $tipAmount + $total_surcharge;
		
			$response = [
				'coupon' => (string) 0,
				'tip' => (string) ($tipAmount),
				'before_total' => (string) ($totalAmount),
				'after_total' => (string) $finalAmount,
			];
		
			return response()->json(['success' => true, 'message' => 'Coupon Clear Successfully', 'data' => $response]);
		
		}

		$couponCode = $request->coupon_code ?? '';
		$coupon = Coupon::where('code', $couponCode)->where('status', '1')->first();
	
		if (!$coupon) {
			return response()->json(['success' => false, 'message' => 'Coupon does not exist']);
		}
	
		// Check if the coupon is within the valid date range
		$currentDate = date('Y-m-d');
		if ($coupon->start_date > $currentDate || $coupon->end_date < $currentDate) {
			return response()->json(['success' => false, 'message' => 'This coupon is expired']);
		}
	
		$cartItems = Card::where('user_id', $userId)
			->where('is_checkout', '!=', 'Done')
			->orderBy('id', 'DESC')
			->get();
	
		if ($cartItems->isEmpty()) {
			return response()->json(['success' => false, 'message' => 'Checkout is empty']);
		}
	
		$totalAmount = 0;
		
		$tipAmount = 0;
		$couponAmount = 0;
		$cod = 0;
		if($request->payment_method == 'pi4'){
			$surcharge = (int) HomeSetting::first()->cash_surcharge;
		} else{
			$surcharge = 0;
		}
		$total_surcharge = 0;
		foreach ($cartItems as $item) {
			$total_surcharge+=$surcharge;
			$tipAmount = (float) $item->tip_id ?? 0;
			$totalAmount += (float) $item->amount;
			$cod += (float) Service::find($item->service_id)->cod_charge;
			if($coupon->type == "Amt"){
				$couponAmount = (float) $coupon->amount;
			}else{
				//$couponAmount += (float) ( ( $item->amount + $total_surcharge + $cod ) * $coupon->amount / 100);
			}
			// Add or update the coupon details
// 			$item->update([
// 				'coupon_id' => $coupon->id,
// 				'coupon_amt' => $couponAmount,
// 			]);
		}
		
		$cart_total = $total_surcharge + $cod + $totalAmount;
		if($coupon->type != "Amt"){
		    $couponAmount += (float) ( $cart_total * $coupon->amount / 100);
		}
		if($cart_total < $couponAmount){
		    return response()->json(['success' => false, 'message' => 'Cart amount less than coupon amount']);
		}
		$cart_count = $cartItems->count();
		foreach ($cartItems as $item) {
			// Add or update the coupon details
			$item->update([
				'coupon_id' => $coupon->id,
				'coupon_amt' => ($couponAmount/$cart_count),
			]);
		}
	
		$finalAmount = $totalAmount + $tipAmount - $couponAmount + $total_surcharge + $cod;
	
		$response = [
			'coupon' => (string) ($couponAmount),
			'tip' => (string) ($tipAmount),
			'before_total' => (string) ($totalAmount),
			'after_total' => (string) $finalAmount,
		];
	
		return response()->json(['success' => true, 'message' => 'Coupon Applied Successfully', 'data' => $response]);
	}
	
	

	public function cartStore(Request $request)
	{
		$request->validate([
			'service_id' => 'required|integer',
			'item_object' => 'nullable|json',
		]);

		$userId = auth()->user()->id;

		
		$totalAmount = (float) 0;
		$total_count = 1;
		$total_maids = 1;

		// Find the service by ID
		$service = Service::find($request->service_id);
		if(ServiceAttributeValueItem::where('service_id',$service->id)->count() && ServiceAttributeValueItem::where('service_id',$service->id)->with('sub_category')->first()->sub_category)
		{
			$card = Card::where(['service_id'=>$service->id, 'user_id'=>auth()->user()->id])->latest('id')->first();
			if(empty($card)){
			    return response()->json(['error' => true, 'message' => 'Cart total should be greater than 0']);
			}
            $add_res = Address::with(['locality_info','city'])->find($request->address_id);
			$res['sub_total']     		= $card->g_total;
			$res['material_charge']     = $card->material_charge;
			$res["total_amount"]        = $card->amount;
			$res['cart_id']             = (string) $card->id;
			$res['service_name']        = $service->name;
			$res['address_id']          = json_encode($add_res);

			$card->update([
				'category_id'=>$service->parent_id??0,
				'amount' => $card->g_total,
				'material_status' => $request->material_status ?? 'No',
				'is_revisit' => $request->is_revisit ?? '0',
				'service_name' => $service->name,
				'note' => $request->note,
				'is_checkout' => 'Processing',
				'slot_id' => $request->slot_id,
				'address_id' => json_encode($add_res),
				'date' => $request->date,
				'alternative_number' => str_replace($request->dial_code,"",$request->alternative_number ?? ''),
				'alternative_dial_code' => $request->dial_code ?? '',
				'dial_code' => $request->dial_code ?? '',
				'booking_from' => $request->booking_from ?? 'Web',
				'sub_total'=>$card->g_total,
				'tran_id' => 'UM-'.chr(rand(65, 90)).rand(100000, 999999)
			]);
			
			return response()->json(['success' => true, 'message' => 'Successfully Added', 'data' => $res]);
		
		} else {
			// $preferredDaysString = ($request->preffered_days);
			// Initialize base data
			$add_res = Address::with(['locality_info','city'])->find($request->address_id);
			$data = [
				'category_id'=>$service->parent_id??0,
				'user_id' => $userId,
				'service_id' => $service->id,
				'service_name' => $service->name,
				'note' => $request->note,
				'address_id' => json_encode($add_res),
				'material_status' => $request->material_status ?? 'No',
				'material_charge' => 0,
				'selected_packages' => $request->selected_packages ?? "",
				'payment_status' => 'pending',
				'is_checkout' => 'Processing',
				'slot_id' => $request->slot_id ?? null,
				'date' => $request->date ?? null,
				'alternative_number' => str_replace($request->dial_code,"",$request->alternative_number ?? ''),
				'alternative_dial_code' => $request->dial_code ?? '',
				'dial_code' => $request->dial_code ?? "",
				// 'preffered_days' => $preferredDaysString ?? "",
				// 'accept_user_id' => Seller::find(SellerService::where('service_id', $service->id)->first()->seller_id)->user_id,
				'booking_from' => $request->booking_from ?? 'Web',
				'tran_id' => 'UM-'.chr(rand(65, 90)).rand(100000, 999999)
			];

			if($request->service_id == 10){
				$packages = Packages::find($request->selected_packages);
				$data['package_price'] = $packages->amount;
			}
			
			// Calculate material default charge
			$material_default = ($request->material_status == "Apply") ? (float) $service->material_price : 0;
			$material_total = (float) 0;
			$material = (float) 0;

			// Create or update the card
			$card = !empty($request->service_id) 
				? Card::where('service_id', $request->service_id)
				->where(['is_checkout' => 'Processing' , 'user_id'=>auth()->user()->id])->first() 
				: null;

			if ($card) {
				$card->update($data);
				CardAttribute::where('card_id', $card->id)->delete();
			} else {
				
				$card = Card::create($data);

			}

			if($card){
				$material_total = 0;
				$material = 0;
				$total_hours = 0;
				$total_hour = 1;
				$total_count = 1;
				$total_maids = 0;
				$total_maids_material = 0;
				if(isset($request->item_object)){
					$c = 0;
					foreach (json_decode($request->item_object) as $key => $value) {
						$params['card_id']              = $card->id;
						
						$service = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();

						$service_item = ServiceAttributeValueItem::where('id',$service->ser_attr_val_item_id)->first();
						$attribute = Attribute::where('id',$service->attribute_id)->first();
						$attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
						
						$params['sub_cate_id']          = $value->sub_category_id ?? null;
						$params['main_sub_cat_id']      = $value->category_id ?? null;
						$params['child_cate_id']        = $value->child_category_id ?? null;
						$params['attribute_id']         = $attribute->id ?? null;
						$params['attribute_name']       = $attribute->name ?? null;
						$params['attribute_item_id']    = $value->attribute_item_id ?? null;
						$params['attribute_item_name']  = $attribute_item->value ?? null;
						$params['attribute_price']      = ( $service->attribute_price * $value->attribute_qty ) ;
						$params['attribute_qty']        = $value->attribute_qty ?? null;
						$params['service_type']         = '';
						
						$attribute_total = $params['attribute_price'] * $params['attribute_qty'];
						
						if($attribute->name == 'Hours'){
							$totalAmount *= (float) $attribute_total; 
						} else {
							$totalAmount += (float) $attribute_total; 
						}
						
						preg_match('/\d+/', $attribute_item->value, $matches);

						if (count($matches) > 0) {
							$number = (int) $matches[0];
							$total_count *= $number;
						
							$total_maids_material = $number;
							if ($attribute->name == 'Hours') {
								$total_hour *= $number;
							}
						}

						$cardattr = CardAttribute::create($params);
					} 
				}

				if($card->service_id == 10){
					$material_total = $total_maids_material;
				} else {
					$material_total = $material_total;
				}
				//echo $total_count;
				$material = ($request->material_status == "Apply") ? (float) $material_total : 0;
                $total_material_price = 0;
				if (!empty($card->selected_packages)) {
					$selectedPackageIds = explode(',', $card->selected_packages);
				
					$packages = Packages::whereIn('id', $selectedPackageIds)->get();
					$package_price = 0;

					if ($packages->isNotEmpty()) {
						$session = SessionPackages::where([
							'package_id' => $packages[0]->id, 
							'cart_id' => $card->id, 
						])->first();
						$session = SessionPackages::where([
							'package_id' => $packages[0]->id, 
							'cart_id' => $card->id, 
						])->delete();
						//if ($session == null) {

							foreach($request->sessions as $session){
								SessionPackages::create([
									'package_id' => $packages[0]->id,
									'cart_id' => $card->id,
									'service_id' => "10",
									'date' => $session['date'],
									'time' => $session['time'],
									'status' => 'Pending'
								]);
							}
							foreach ($packages as $package) {
								$data["packages"][] = ["name" => $package->name, "price" => (string)$package->amount];
								$package_price += (int)$package->amount;
								$totalAmount = (float) $package->amount * (float) $total_count; 
								$material *= ((int) $package->total_sessions );

								// Total sessions to create
								$totalSessions = (int)$package->total_sessions + (int)$package->free_sessions;
				                $total_material_price = $material_default * $package->total_sessions * $total_count;
							
							}
						//}
					}				
                    $res["package_price"]       = (string) $package_price;
                }
                //echo $totalAmount; exit;
                $sub_total = $totalAmount;
				$res["sub_total"] = (string) $totalAmount;
				$material *= $material_default;
				$g_total = $totalAmount + $total_material_price;
				
				if($g_total < 40){
				    return response()->json(['error' => true, 'message' => 'Min Cart Value Should be greater than 40']);
				}
				
				$card->update([
					'material_charge'   => ($request->material_status == "Apply") ? (string) $total_material_price : '0',
					'amount'            => $g_total,
					'g_total'           => $g_total,
					'sub_total'         => $sub_total
				]);
				
				
				$services = Service::find($request->service_id);
				$res['material_charge']     = $card->material_charge;
				$res["total_amount"]        = (string) $g_total;
				$res['cart_id']             = (string) $card->id;
				$res['service_name']        = $services->name;
				
				return response()->json(['success' => true, 'message' => 'Successfully Added', 'data' => $res]);
			} else {
				return response()->json(['error' => true, 'message' => 'Try Again']);
			}
		}
			
	}

		public function cart(Request $request)
		{
			$card = Card::with('service')->where(['user_id'=>auth()->user()->id])
			->where('is_checkout', '!=', 'Done')
			->whereNotNull('g_total')    
			->where('g_total', '>', 0) 
			->orderBy('id', 'DESC')
			->get();
			
			if($card){
				
				$cards = [];
				$cards_detail = [];
				$total_amount = 0;
				$coupon_amount = 0;
				$tip_amount = 0;

				foreach ($card as $key => $value) {
					$service = Service::find($value->service_id);

    				if ($service && !is_null($service->cod_charge)) {
    				    //surcharge append
    					$value->amount     += (int) $service->cod_charge;
    				}
					// Initialize card data array
					$card_data = [
						'id'                     => $value->id, 
						'user_id'                => $value->user_id,
						'service_id'             => $value->service_id,
						'service_name'           => $value->service_name, 
						'category_id'            => $value->category_id,
						'slot_id'                => $value->slot_id,
						'slot'                	 => Slot::find($value->slot_id)->name ?? "-",
						'address_id'             => $value->address_id,
						'tran_id'                => $value->tran_id,
						'payment_status'         => $value->payment_status,
						'alternative_dial_code'  => $value->alternative_dial_code ?? "",
						'alternative_number'     => $value->alternative_number,
						'note'                   => $value->note,
						'date'                   => $value->date,
						'status'                 => $value->status,
						'accept_user_id'         => $value->accept_user_id,
						'amount'                 => $value->amount, // Add card amount
						'g_total'                => $value->g_total,
						'material_status'        => $value->material_status,
						'material_charge'        => $value->material_charge,
						'is_checkout'            => $value->is_checkout,
						'payment_collected'      => $value->payment_collected,
						'service_completed'      => $value->service_completed,
						'service_completed_date' => $value->service_completed_date,
						'work_done'              => $value->work_done,
						'pending_approval_by_admin' => $value->pending_approval_by_admin,
						'booking_from'           => $value->booking_from,
						'created_at'             => $value->created_at,
						'updated_at'             => $value->updated_at,
						'selected_packages'      => $value->selected_packages,
						'preferred_days'         => $value->preffered_days,
					];

					// Card Attributes and Add-ons
					$card_attr = [];
					foreach (CardAttribute::where('card_id', $value->id)->get() as $item) {
						$params = [
							'sub_cate_id'         => (string) $item->sub_cate_id,
							'sub_cate_name'       => Category::find($item->sub_cate_id)->name ?? '',
							'main_sub_cat_id'     => $item->main_sub_cat_id,
							'main_sub_cat_name'   => Category::find($item->main_sub_cat_id)->name ?? '',
							'child_cate_id'       => (string) $item->child_cate_id,
							'child_cate'          => ChildCategory::find($item->child_cate_id)->name ?? '',
							'attribute_id'        => $item->attribute_id,
							'attribute_name'      => $item->attribute_name,
							'attribute_item_id'   => (string) $item->attribute_item_id,
							'attribute_item_name' => $item->attribute_item_name,
							'attribute_qty'       => $item->attribute_qty,
							'attribute_price'     => $item->attribute_price,
							'service_type'        => $item->service_type,
						];

						// Add-ons
						$addons = [];
						foreach (CardAddon::where('card_id', $value->id)->where('card_attribute_id', $item->id)->get() as $cardaddon) {
							$addons[] = [
								'card_id'            => $cardaddon->id,
								'card_attribute_id'  => $cardaddon->id,
								'add_on_id'          => $cardaddon->add_on_id,
								'name'               => $cardaddon->name,
								'value'              => $cardaddon->value,
								'percentage'         => $cardaddon->percentage,
							];
						}
						$params['addon'] = $addons; // Add the addons to the card attribute
						$card_attr[] = $params; // Add the card attribute to the array
					}

					// Include the card attributes inside the card data
					$card_data['card_attribute'] = $card_attr;
					if($value->service_id == 10){
						$session = SessionPackages::where([
							'cart_id' => $value->id, 
						])->first();
						if($session){
							$card_data['session_date'] = $session->date;
							$card_data['session_time'] = $session->time;
						}
					}

					// Add card data to the main $cards array
					$cards_detail[] = $card_data;
					$coupon_amount  = (int) $value->coupon_amt;
					$tip_amount     = (int) $value->tip_id;
					
					// Update total amount
					$total_amount += (float) ($value->amount ?? 0) > 0 ? $value->amount : $value->g_total;
				}

				$cards['card'] = $cards_detail;

				$cards['sub_total']         = (string) $total_amount;
				$cards['coupon_status']     = (string) "no";
				$cards['tip_status']     = (string) "no";
				// if($request->is_coupon){
				// 	$cards['coupon_amount']     = (string) $coupon_amount;
				// 	$cards['coupon_status']     = "yes";
				// 	$total_amount -= $coupon_amount;
				// }
				// if ($request->is_tip && $tip_amount > 0) {
				// 	$cards['tip_amount'] = (string) $tip_amount;
				// 	$cards['tip_status'] = "yes";
				// 	$total_amount += $tip_amount;
				// } else {
				// 	$cards['tip_amount'] = (string) $tip_amount;
				// 	$cards['tip_status'] = "no";
				// }
				
				$cards['user_balance']  = auth()->user()->wallet_balance;
				$rewardData = $this->get_reward_price($total_amount);

				if ($rewardData !== null) {
				// 	$cards["remaining_reward_points"] = (string) $rewardData['remaining_reward_points'];
					$cards["reward_amount"] = (string) $this->get_reward_price($total_amount)['final_amount'];
				// 	$cards['total']         = (string) ((float) $total_amount - (float) $this->get_reward_price($total_amount)['final_amount']);
				} else {
				// 	$cards["remaining_reward_points"] = '0'; 
				// 	$cards["reward_amount"] = '0'; 
				// 	$cards["total"] = (string) $total_amount; 
				}
		
				$cards["total"] = (string) $total_amount; 
			
				return view('web.cart', [
					'cartItems' => $cards,
				]);
			} else {
				return $this->sendError('Invalid booking id');
			}
		}

		public function removeCartItem($id)
		{
			$cartItem = Card::where('id', $id)->first();
		
			if ($cartItem) {
				CardAttribute::where('card_id',$cartItem->id)->delete();
				$cartItem->delete();
		

				return redirect()->route('cart.list')->with('success', 'Item removed from the cart successfully.');
			} else {
				return redirect()->route('cart.list')->with('error', 'Item not found in the cart.');
			}
		}
		

	public function editCartItem($id)
	{
		$cartItem = Card::with(['service'])->where('id', $id)->first();

		if (!$cartItem) {
			return redirect()->route('cart.list')->with('error', 'Cart item not found');
		}
	
		// Service details
		$service = Service::find($cartItem->service_id);
		if (!$service) {
			return view('errors.404');
		}
		$card_attr = CardAttribute::where('card_id', $cartItem->id)->first();
		// Fetch attributes and other options based on existing selections
		$selectedMaidId = $card_attr->where('attribute_name', 'Maids')->first()->attribute_item_id ?? null;
		$selectedHourId = $card_attr->where('attribute_name', 'Hours')->first()->attribute_item_id ?? null;
		$selectedMaterial = $cartItem->material_status;
		$selectedPackage = $cartItem->package_id;
		$selectedPreferredDays = json_decode($cartItem->preferred_days, true) ?? [];
		$selectedDate = $cartItem->selected_date;
		$selectedSlot = $cartItem->slot_id;
	
		$data = [
			'service_header' => ServiceGallery::where('service_id',$id)->first(),
			'service' => $service,
			'cartItem' => $cartItem,
			'selectedMaidId' => $selectedMaidId,
			'selectedHourId' => $selectedHourId,
			'selectedMaterial' => $selectedMaterial,
			'selectedPackage' => $selectedPackage,
			'selectedPreferredDays' => $selectedPreferredDays,
			'selectedDate' => $selectedDate,
			'selectedSlot' => $selectedSlot,
			'addresses' => Address::where('user_id', \Session::get('user_id'))->orderBy('id', 'DESC')->get(),
			'cities' => City::all(),
			'localities' => Locality::all(),
		];

		return view('web.service_edit_bookings', $data);
	}
		
	public function updateCartItem(Request $request, $id)
	{
		// Validate required fields
		$request->validate([
			'item_object' => 'required|json',
		]);

		$cartItem = Card::findOrFail($id);
		$totalAmount = (float) 0;
	
		// Update base data
		$data = [
			'note' => $request->note,
			'material_status' => $request->material_status ?? 'No',
			'selected_packages' => $request->selected_packages,
			'slot_id' => $request->slot_id,
			'date' => $request->date,
			'alternative_number' => $request->alternative_number ?? "",
			'dial_code' => $request->dial_code ?? "",
		];

		$package_price = 0;
		if($cartItem->service_id == 10){
			$packages = Packages::find($request->selected_packages);
			$package_price = $packages->amount;
		}
		$data['package_price'] = $package_price;

		// Calculate material default charge
		$material_default = ($request->material_status == "Apply") ? (float) $cartItem->service->material_price : 0;
		$material_total = (float) 0;
		$material = (float) 0;
	
		// Update the card item with base data
		$cartItem->update($data);
	
		$card = !empty($request->id) ? Card::findOrFail($request->id) : new Card($data);

		if ($card->exists) {
			$card->update($data);
			CardAttribute::where('card_id', $card->id)->delete();
		} else {
			$card->save();
		}
	
		if(isset($request->item_object)){
			$c = 0;
			foreach (json_decode($request->item_object) as $key => $value) {
				$params['card_id']              = $card->id;
				
				$service = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();

				$service_item = ServiceAttributeValueItem::where('id',$service->ser_attr_val_item_id)->first();
				$attribute = Attribute::where('id',$service->attribute_id)->first();
				$attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
				
				$params['sub_cate_id']          = $value->sub_category_id ?? null;
				$params['main_sub_cat_id']      = $value->category_id ?? null;
				$params['child_cate_id']        = $value->child_category_id ?? null;
				$params['attribute_id']         = $attribute->id ?? null;
				$params['attribute_name']       = $attribute->name ?? null;
				$params['attribute_item_id']    = $value->attribute_item_id ?? null;
				$params['attribute_item_name']  = $attribute_item->value ?? null;
				$params['attribute_price']      = $service->attribute_price ?? null;
				$params['attribute_qty']        = $value->attribute_qty ?? null;
				$params['service_type']         = '';
				
				$attribute_total = $params['attribute_price'] * $params['attribute_qty'];
				
				if($attribute->name == 'Hours'){
					$totalAmount *= (float) $attribute_total; 
				} else {
					$totalAmount += (float) $attribute_total; 
				}
				
				preg_match('/\d+/', $attribute_item->value, $matches);

				if (count($matches) > 0) {
					$number = (int) $matches[0];
					$total_count *= $number;
				
					if ($attribute->name == 'Hours') {
						if ($number > 1) {
							if($material_total > 0){
								$material_total *= ($request->material_status == "Apply" ? $number : 0) 
													* (int) $value->attribute_qty;
							} else {
								$material_total += ($request->material_status == "Apply" ? $number : 0) 
													* (int) $value->attribute_qty;
							}
						} else {
							$c++;
							if((int) $value->attribute_qty > 1){
								$material_total += (float) $material_default * (float) $value->attribute_qty;
							}
						}
					} else {
						if ($number > 1) {
							if($material_total > 0){
								$material_total *= ($request->material_status == "Apply" ? $number : 0) 
													* (int) $value->attribute_qty;
							} else {
								$material_total += ($request->material_status == "Apply" ? $number : 0) 
													* (int) $value->attribute_qty;
							}
						} else {
							$c++;
							if((int) $value->attribute_qty > 1){
								
								$material_total += (float) $material_default * (float) $value->attribute_qty;
							}
						}
					}
				}

				$cardattr = CardAttribute::create($params);
			} 
		}
		
		if($c==2){
			$material_total += $material_default;
		} else {
			$material_total *= $material_default;
		}
		$material = ($request->material_status == "Apply") ? (float) $material_total : 0;
		
		$cardattr = CardAttribute::where(['card_id' => $card->id])->get();
		$res["sub_total"] = (string) $totalAmount;
		$totalAmount += (float) $material;

		$card->update([
			'material_charge'   => ($request->material_status == "Apply") ? (string) $material : '0',
			'amount'            => $totalAmount,
			'g_total'           => $res["sub_total"]
		]);

		// Response data
		$res['material_charge'] = $cartItem->material_charge;
		$res["total_amount"] = (string) ($totalAmount + $material);
		$res['cart_id'] = (string) $cartItem->id;
		$res['service_name'] = $cartItem->service->name;
		
		return response()->json(['success' => true, 'message' => 'Successfully Update', 'data' => $res]);
		
	}
	
	public function update(Request $request, $id)
	{
		$validatedData = $request->validate([
			'flat_no' => 'required|string|max:255',
			'building' => 'required|string|max:255',
			'city_id' => 'required|integer',
			'locality' => 'required|string|max:255',
			'address_type' => 'required|string',
			'address_edit' => 'nullable|string'
		]);
	
		$address = Address::findOrFail($id);
	
		$address->update([
			'flat_no' => $validatedData['flat_no'],
			'building' => $validatedData['building'],
			'city_id' => $validatedData['city_id'],
			'locality' => $validatedData['locality'],
			'address_type' => $validatedData['address_type'],
			'address' => $validatedData['address_edit'] ?? "",
			'latitude'=>$request->edit_latitude,
			'longitude'=>$request->edit_longitude
		]);

		 $address->load('city', 'locality_info');

		 return response()->json([
			 'success' => true,
			 'message' => 'Address updated successfully',
			 'data' => [
				 'id' => $address->id,
				 'flat_no' => $address->flat_no,
				 'building' => $address->building,
				 'city_name' => $address->city->name ?? 'N/A',
				 'locality_name' => $address->locality_info->name ?? 'N/A',
				 'address_type' => $address->address_type,
				 'address' => $address->address,
				 'is_active' => $address->is_active,
			 ]
		 ]);
	
		return response()->json(['success' => true, 'message' => 'Address updated successfully', 'data' => $address]);
	}
	

	public function destroy($id)
	{
		$address = Address::findOrFail($id);
		$address->delete();
		$is_address = Address::where('user_id', auth()->user()->id)->count();
		return array(
			'success' => true,
			'is_address' => $is_address,
			'message' => "Address deleted successfully",
		);
	}

	public function service_details($slug='', $delete='yes')
	{
		if(Auth::user()){
			\Session::put('user_id', Auth::user()->id);
		} else {
			if(!\Session::has('user_id')){
				\Session::put('user_id', mt_rand(1000000, 9999999));
			}
		}
		
		$serv =  Service::where('slug',$slug)->first();
		
		if(empty($serv)){
			return view('errors.404');;
		}

		$data['service'] = $serv;

		$id = $serv->id;

		if(Auth::user()){
			\Session::put('is_login','Yes');
		} else {
			\Session::put('is_login','No');
		}

		$card_infos = Card::where('service_id',$id)->where('user_id',\Session::get('user_id'))->where('is_checkout','Processing')->where('created_at', '<', date('y-m-d'))->get();
		foreach ($card_infos as $key => $card_info) {
			if($card_info){
				CardAddon::where('card_id',$card_info->id)->delete();
				CardAttribute::where('card_id',$card_info->id)->delete();
				$card_info->delete();
			}
		}
		

		$data['service_header'] = ServiceGallery::where('service_id',$id)->first();
		$data['card'] = Card::where('user_id',\Session::get('user_id'))->where('service_id',$id)->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->where('is_checkout','Processing')->orderBy('id', 'DESC')->first();

		$data['address'] = Address::where('user_id',\Session::get('user_id'))->orderBy('id', 'DESC')->first();
		$data['city'] = City::all();
		$data['locality'] = Locality::all();
		$data['services'] = Service::all();

		$reviewData = Review::where('service_id', $id)
			->select(
				DB::raw('ROUND(AVG(rating), 2) as average_rating'), 
				DB::raw('COUNT(id) as total_reviews')           
			)
			->first();

		$averageRating = $reviewData->average_rating ?? '0.00'; 
		$totalReviews = $reviewData->total_reviews ?? 0;       
		$data['total_reviews'] = $totalReviews;
		$data['average_rating'] = $averageRating;

		$data['reviews'] = Review::where('service_id', $id)->whereIn('rating', [4,5])->orderBy('created_at', 'desc')->get();
        
		return view('web.service_details',$data);
	}

	public function get_child_cat_attr_items(Request $request)
	{
		$service = Service::find($request->service_id);
		$attribute_ids = [];
		foreach (ServiceAttributeValueItem::where('service_id',$request->service_id)->where('child_category_id',$request->child_category_id)->get() as $value) {
			array_push($attribute_ids, $value->id);
		}

		$satData = ServiceAttributeValueItem::where('service_id',$request->service_id)->where('id',$request->sub_cat_id)->first();

		$datas=[];
		foreach(ServiceAttributeValue::where('service_id',$request->service_id)->whereIn('ser_attr_val_item_id',$attribute_ids)->get() as $attributeItems){
			if($attributeItems->attributeItem){
				
		        $data['id'] 					= $attributeItems->id;
		        $data['attributename'] 			= $attributeItems->attributeItem?$attributeItems->attributeItem->value:"";
		        $data['attribute_price'] 		= $attributeItems->attribute_price;
		        $data['service_id'] 			= $service->id;
		        $data['category_id'] 			= $service->category_id;
		        $data['child_category_id'] 		= $request->child_category_id;
		        $data['sub_cat_id'] 			= $request->sub_cat_id;
		        $data['main_sub_cat_id'] 		= $satData?$satData->sub_category_id:'';
		        $data['attribute_id'] 			= $attributeItems->attribute_id;
		        $data['attribute_name'] 		= $attributeItems->attribute?$attributeItems->attribute->name:"";
		        $data['attribute_item_id'] 		= $attributeItems->attribute_item_id;
		        $data['attribute_item_name'] 	= $attributeItems->attributeItem?$attributeItems->attributeItem->value:"";
		        array_push($datas, $data);
			}
		}
		return $datas;
	}

	public function sendOTP(Request $request)
	{
		$user=User::where('phone',$request->phone)->first();

        if($user && $user->is_registered==1){ 

            $data['msg'] = 'Number already Exist!';
            return $data;
        } 
        else
        {
            $otp=random_int(1000, 9999);
            User::where('id', $user->id)->update(['otp' => $otp]);
            $data['otp'] = $otp;
            $data['msg'] = 'OTP send successfully';
            return $data;
        }
	}

	public function register(Request $request)
	{
		if(User::where('phone',$request->phone)->where('is_active','1')->where('is_verified','1')->count()>0){
			$data['msg'] = 'This Number is Already Exist.';
			$data['status'] = 'False';
			return $data;
		} else {
			$otp 	= mt_rand(1000, 9999);
    		$phone  = $request->phone;
	        $msg 	= "OTP-".$otp;
	       
			$params['name'] = 'Guest';
	        // $params['email'] = $request->phone.'@gmail.com';
	        $params['phone'] = $request->phone;
	        $params['password'] = $request->phone;
	        $params['otp'] = $otp;
	        $params['registered_by'] = 'Web';
		    $params['is_verified'] = 1;
	        $params['is_active'] = 1;
	        $params['is_registered'] = 1;
	        $params['role'] = 'customer';
	        $params['verify'] = 'False';

	        $success = User::create($params);

	        $array['view'] 		= 'emails.otp';
            $array['subject'] 	= 'Your UrbanMop Signup OTP';
            $array['data'] 		= $otp;
  	        // \Mail::to('')->send(new \App\Mail\Mail($array));

	        $res=send_sms_to_mobile($phone,$msg);
	        $success['status'] = 'True';
	        return $success;
        }
	}

	public function slots_list(Request $request)
    {
      
        $date = $request->input('date');
        $today = date('Y-m-d');
        $currentTime = date('H:i:s');
    
        $twoHoursLater = date('H:i:s', strtotime('+2 hours', strtotime($currentTime)));
    
        // Fetch all slots
        $allSlots = Slot::all();
    
        // Fetch booked slots for the given date
        $bookedSlots = Card::where('date', $date)
                            ->where('status', '!=', 'Canceled')
                            ->where('service_id', $request->service_id)
                            ->pluck('slot_id')->toArray();
    
        $availableSlots = [];
        foreach ($allSlots as $slot) {
            // Convert both times to timestamps for comparison
            $slotStartTime = strtotime($slot->check_in);
            $currentTimeTimestamp = strtotime($currentTime);
            $twoHoursLaterTimestamp = strtotime($twoHoursLater);
    
            // Disable past time slots only if the date is today
            $isPastSlot = false;
            if ($date == $today && $slotStartTime < $twoHoursLaterTimestamp) {
                $isPastSlot = true;
            }
    
            $availableSlots[] = [
                'slot_id' => $slot->id,
                'slot_name' => $slot->name,
                // 'available' => ($isPastSlot) ? false : !in_array($slot->id, $bookedSlots), 
                'available' => ($isPastSlot) ? false : true, 
                'is_past_slot' => $isPastSlot 
            ];
        }
    
        return $this->sendResponse($availableSlots, 'Slot Info');
    }

	public function sendResponse($result, $message)
    {
    	$response = [
            'status' => '1',
            'message' => $message,
            'data'    => $result,
            'errors'    => (object) [],
            'error'    => '',
        ];


        return response()->json($response, 200);
    }

	public function login_with_otp(Request $request)
	{
		$user = User::where('phone',$request->phoneno)
		->where('role','customer')
		->where('is_active','1')->first();
		if($user){
			$otp = $request->otp1.''.$request->otp2.''.$request->otp3.''.$request->otp4;

			if($otp == "1111"){ // $user->otp
				Auth::login($user);
				if(Auth::user()){
					foreach (Card::where('user_id',\Session::get('user_id'))->where('is_checkout','Processing')->get() as $key => $card) {
						$params['user_id'] = Auth::user()->id;
						\Session::put('is_login','Yes');
						$params['is_login'] = 'Yes';
						$card->update($params);
					}
					\Session::put('user_id',Auth::user()->id);
				}
				$res['msg'] = 'Login Successfully.';
				$res['status'] = true;
				if(empty(auth()->user()->email)){
					$res['is_new_user'] =  "1";
				}else{
					$res['is_new_user'] =  "0";
				}
				return $res;
			} else {
				$res['msg'] = 'Invalid OTP.';
				$res['status'] = false;
				return $res;
			}
		 	
		} else {
			
			$res['msg'] = 'Invalid User.';
			$res['status'] = false;
			return $res;
		}
		
	}

	public function wallet_payment_init(Request $request)
    {
        $status = "0";
        $o_data = [];
        $errors = [];
        $message = "Unable to initialize the payment";
    
        $user_id = auth()->user()->id;
        if ($user_id == 0) {
            $message = "Session expired, please login to continue.";
            return response()->json([
                'status' => (string)$status,
                'message' => $message,
                'data' => (object)$o_data,
                'errors' => (object)$errors
            ], 401);
        }
        
        $cart_unique_id = "UMC-".time();

		$card = Card::where(['user_id'=>$user_id])
        ->where('is_checkout', '!=', 'Done')
        ->orderBy('id', 'DESC')
        ->get();
        
        if (!$card->isEmpty()) {
            
            foreach ($card as $key => $value) {
                $past = false;

                if ($value->service_id == 10) {
                    $currentDateTime = now();
                    $sessionPackages = $value->sessionPackages->sortBy('date');
                    
                    if ($sessionPackages->isNotEmpty()) {
                        $serviceDate = Carbon::parse($sessionPackages->first()->date); // Convert to Carbon instance
                        $serviceTime = $sessionPackages->first()->time;
                        
                        // Check if the service date is today
                        if ($serviceDate && $serviceDate->isToday()) {
                            $slot = Slot::find($serviceTime);
                            
                            if ($slot && $slot->check_in) {
                                $slotDateTime = Carbon::createFromFormat('H:i:s', $slot->check_in)
                                    ->setDate($serviceDate->year, $serviceDate->month, $serviceDate->day);
                                
                                // Check if the current time is past the slot time
                                if ($slotDateTime->isPast()) {
                                    $past = true;
                                }
                            }
                        }
                    } else {
						$o_data['checkout_url'] = route('cart.list');
						return response()->json(['status' => "3", 'message' => 'Package Sessions are not updated.', 'errors' => (object)[], 'oData' => (object)$o_data]);
                    }
                } else {
                    $currentDateTime = now();
                    $serviceDate = $value->date ? Carbon::parse($value->date) : null;

                    if ($serviceDate && $serviceDate->isToday()) {
                        $slot = Slot::find($value->slot_id);
                        
                        if ($slot && $slot->check_in) {
                            $slotDateTime = Carbon::createFromFormat('H:i:s', $slot->check_in)
                                ->setDate($serviceDate->year, $serviceDate->month, $serviceDate->day);
                            
                            // Check if the current time is past the slot time
                            if ($slotDateTime->isPast()) {
                                $past = true;
                            }
                        }
                    }
                }

                if ($past) {
					$o_data['checkout_url'] = route('cart.list');
					return response()->json(['status' => "3", 'message' => 'Remove the past date orders.', 'errors' => (object)[], 'oData' => (object)$o_data]);
                }

                
            }

            
        }
    
        $validator = Validator::make($request->all(), [
            'payment_type' => 'required|integer|min:1',
        ]);
    
        if ($validator->fails()) {
            $status = "0";
            $message = "Validation error occurred";
            $errors = $validator->messages();
        } else {
                
            if(!empty($request->coupon_code)){
                $coupon = Coupon::where('code',$request?$request->coupon_code:'')->where('status','1')->first();
            }else{
                $coupon = 0;
            }
           
            $cards = Card::with('service')->where(['user_id'=>auth()->user()->id])
				->where('is_checkout', '!=', 'Done')
				//->whereNotNull('g_total')  
				// ->whereNotNull('slot_id') 
				//->where('g_total', '>', 0) 
				->orderBy('id', 'DESC')
				->get();
    
            $allHaveSlotId = true;
            foreach ($cards as $card) {
				if($card->service_id != 10){
					if (empty($card->slot_id)) {
						$allHaveSlotId = false;
						break;
					}
				}
            }
    
            if (!$allHaveSlotId) {
                $datas['is_draft'] = "yes";
                $datas['step'] = "3";
    
            	return redirect('cart')->with('error','Order is not completed, please fill the order!');
			}
            $grand_total = 0;
            $subtotal = 0;
            $total = 0;
            $coupon_amount = 0;
            $tip_amount = 0;
            $surcharge = 0;
			$card_ids = [];
			$cod = (int) HomeSetting::first()->cash_surcharge;
            if (!$cards->isEmpty()) {
                foreach ($cards as $card) {
                    if ($card) {
                        $card_ids[] = $card->id;
                        $data['payment_mode'] = (string) $request->payment_type ?? "";
                        $data['card_process'] = 'Complete';
                        $data['payment_status'] = "True";
                        $data['payment_type'] = $request->payment_type;
                        $data['booking_from'] = 'Web';
						$coupon_amount += (float)$card->coupon_amt ?? 0;
                        $tip_amount = (float)$card->tip_id;
                        $subtotal += (int)$card->g_total;
						$surcharge = (float) Service::find($card->service_id)->cod_charge;
                        $total += (float)$surcharge;
                        $total += (float)$card->amount;
                        if($request->payment_type == 2){
                            $total+=$cod;
                        }
                        
                        $grand_total+= ( $card->g_total + $surcharge ); 
                        if($request->payment_type == 2){
                            $grand_total+=$cod;
                        }
                    }
                }
                $grand_total+=$tip_amount;
            }
			if (!empty($coupon_amount)) {
				$amount = (float)$total - (float)$coupon_amount;
				$grand_total = $grand_total - $coupon_amount;
			} else {
				$amount = (float)$total;
			}
			$amount += (float)$tip_amount;
			
			$data['amount'] = (string)$amount; 
			
    
			// Wallet
            if ($request->payment_type == 3) {
                $user = User::find($user_id);
                if ($user->wallet_balance < $grand_total) {
                    return response()->json(['status' => "0", 'message' => 'Insufficient wallet balance', 'errors' => (object)[], 'oData' => (object)[]]);
                } else {
                    // Deduct the amount from wallet
                    $user->wallet_balance -= $grand_total;
                    $user->save();
                }

				$card_ids = implode(',', $card_ids);
				$id = Order::create([
					'invoice' => uniqid($user_id . '_'),
					'ref' => "",
					'tip_amount' => $tip_amount,
					'coupon_amount' => $coupon_amount,
					'payment_type' => $request->payment_type,
					'card_ids' => $card_ids,
				]);
				
				$ref = "";

				foreach ($cards as $card) {
					if ($card) {
						$card->update([
							'order_id' => $id->id,
							'payment_type' => $request->payment_type,
							'cart_unique_id'=> $cart_unique_id
						]);
					}
				}
				
				$o_data['payment_ref'] = "";
				$o_data['checkout_url'] = route('payment.update', ['id' => $id->id]);
            }

			// Reward
            if ($request->payment_type == 5) {
                $user = User::find($user_id);
				$reward_amount = RewardUser::where('user_id', $user_id)->sum('amounts');
                if ($reward_amount < $grand_total) {
                    return response()->json(['status' => "0", 'message' => 'Insufficient reward balance', 'errors' => (object)[], 'oData' => (object)[]]);
                } 

				$card_ids = implode(',', $card_ids);
				$id = Order::create([
					'invoice' => uniqid($user_id . '_'),
					'ref' => "",
					'tip_amount' => $tip_amount,
					'coupon_amount' => $coupon_amount,
					'payment_type' => $request->payment_type,
					'card_ids' => $card_ids,
				]);
				
				$ref = "";
				foreach ($cards as $card) {
					if ($card) {
						$card->update([
							'order_id' => $id->id,
							'payment_type' => $request->payment_type,
							'cart_unique_id'=>$cart_unique_id
						]);
					}
				}
				
				$input=[
					'customer_id' => auth()->user()->id,
					'vendor_id'=> SellerService::where("service_id",$cards[0]->service_id)->first()->seller_id ?? 7,
					'amount'=>$grand_total,
					'remark'=>"Done",
					'type'=>'Dr',
					'card_ids'=>$card_ids,
				];
				
				$res=Transection::create($input);

				$userId = auth()->user()->id;
				// Deduct the amount from wallet
				$userReward = RewardUser::create([
					'booking_type' => 'Purchase',
					'transection_id' => $res->id,
					'date' => $res->created_at,
					'user_id' => $userId,
					'reward_config_id' => 1, 
					// 'points' => -calculatePoints($amount),
					'points' => -$grand_total,
					'amounts' => -$grand_total
				]);

				$o_data['payment_ref'] = "";
				$o_data['checkout_url'] = route('payment.update', ['id' => $id->id]);
            }
			
			// Cash
			if($request->payment_type == 2){

				$card_ids = implode(',', $card_ids);
				$id = Order::create([
					'invoice' => uniqid($user_id . '_'),
					'ref' => "",
					'tip_amount' => $tip_amount,
					'coupon_amount' => $coupon_amount,
					'payment_type' => $request->payment_type,
					'card_ids' => $card_ids,
				]);
				$cod = 0;
				foreach ($cards as $card) {
					$cod = (int) HomeSetting::first()->cash_surcharge;
					if ($card) {
						$card->update([
							'cod' => $cod,
							'order_id' => $id->id,
							'payment_type' => $request->payment_type,
							'cart_unique_id'=>$cart_unique_id
						]);
					}
				}
				$o_data['payment_ref'] = "";
				$o_data['checkout_url'] = route('payment.update', ['id' => $id->id]);
			}
    
            if ($grand_total < 0) {
                return response()->json(['status' => "0", 'message' => 'Checkout empty', 'errors' => (object)[], 'oData' => (object)[]]);
            }
    
            $user = User::find($user_id);

			$invoice_id = $user_id . uniqid() . time();

			// Debit/Credit Card
			if($request->payment_type == 1){
				$card_ids = implode(',', $card_ids);
			
				// Update user's wallet or process payment record
				$paymentRecord = [
					'user_id' => $user->id,
					'wallet_amount' => $total,
					'amount' => $total,
					'type' => 'debit',
					'pay_type' => 'Booking Service',
					'pay_method' => $request->payment_method,
					'description' => 'Booking Service'
				];
				// wallet_history($paymentRecord);

				$id = Order::create([
					'invoice' => uniqid($user_id . '_'),
					'ref' => "",
					'tip_amount' => $tip_amount,
					'coupon_amount' => $coupon_amount,
					'payment_type' => $request->payment_type,
					'card_ids' => $card_ids,
				]);

				foreach ($cards as $card) {
					if ($card) {
						$card->update([
							'order_id' => $id->id,
							'payment_type' => $request->payment_type,
							'cart_unique_id'=>$cart_unique_id
						]);
					}
				}

				$input=[
					'customer_id' => auth()->user()->id,
					'vendor_id'=> SellerService::where("service_id",$card->service_id)->first()->seller_id ?? 0,
					'amount'=>$grand_total,
					'remark'=>"Done",
					'type'=>'Dr',
					'card_ids'=>$card_ids,
				];
				
				$res=Transection::create($input);

				// \Stripe\Stripe::setApiKey('sk_test_51KdqxdBjsMxFtgBedbg8geva4BTxE3rcJrjCY2YCYblxn8hcEC2l7mIIPMClBWzyPdOWbNyUKSFjLo7Sl9ZI7Ujf00jVnhJDUA');

				// $checkout_session = \Stripe\Checkout\Session::create([
				// 	'payment_method_types' => ['card'],
				// 	'line_items' => [[
				// 		'price_data' => [
				// 			'currency' => 'AED',
				// 			'product_data' => [
				// 				'name' => 'Service Bookings',
				// 			],
				// 			'unit_amount' => $amount * 100,
				// 		],
				// 		'quantity' => 1,
				// 	]],
				// 	'mode' => 'payment',
				// 	'success_url' => route('payment.update', ['id' => $id->id]),
				// 	'cancel_url' => route('wallet.cancel', ['transaction_id' => $invoice_id]),
				// ]);

				$client = new \GuzzleHttp\Client();

				$storeId = config('app.telr_store_id', env('TELR_STORE_ID'));
				$authKey = config('app.telr_auth_key', env('TELR_AUTH_KEY'));
				$successUrl = route('payment.update', ['id' => $id->id]);
				$cancelUrl = route('wallet.cancel', ['transaction_id' => $invoice_id]);
				$declineUrl = route('wallet.cancel', ['transaction_id' => $invoice_id]);
				$payload = [
					'ivp_method' => 'create',
					'ivp_store' => $storeId,
					'ivp_authkey' => $authKey,
					'ivp_amount' => $grand_total,
					'ivp_currency' => 'AED',
					'ivp_test' => 0, // Set to 0 for live environment
					'ivp_desc' => 'Service Bookings',
					'return_auth' => $successUrl,
					'return_can' => $cancelUrl,
					'return_decl' => $declineUrl,
					'ivp_cart' => $cart_unique_id,
					'bill_fname' => auth()->user()->first_name,
					'bill_sname' => auth()->user()->last_name,
					'bill_email' => auth()->user()->email,
					'bill_country' => auth()->user()->dial_code,
					'bill_phone' => auth()->user()->phone,
				];
				
				$response = $client->post('https://secure.telr.com/gateway/order.json', [
					'form_params' => $payload,
				]);
			
				$responseData = json_decode($response->getBody(), true);

				if (isset($responseData['order']['url'])) {
					$checkoutUrl = $responseData['order']['url'];
					
				}

				// $ref = $checkout_session->id;

				// $o_data['payment_ref'] = $checkout_session->id;
				$o_data['checkout_url'] = $checkoutUrl;
			}
           
			// Tabby
			if($request->payment_type == 4){
				$card_ids = implode(',', $card_ids);
			
				// Update user's wallet or process payment record
				$paymentRecord = [
					'user_id' => $user->id,
					'wallet_amount' => $grand_total,
					'amount' => $grand_total,
					'type' => 'debit',
					'pay_type' => 'Booking Service',
					'pay_method' => $request->payment_method,
					'description' => 'Booking Service'
				];
				// wallet_history($paymentRecord);

				//$card_ids = implode(',', $card_ids);
				$id = Order::create([
					'invoice' => uniqid($user_id . '_'),
					'ref' => "",
					'tip_amount' => $tip_amount,
					'coupon_amount' => $coupon_amount,
					'payment_type' => $request->payment_type,
					'card_ids' => $card_ids,
				]);
				foreach ($cards as $card) {
					if ($card) {
						$card->update([
							'order_id' => $id->id,
							'payment_type' => $request->payment_type,
							'cart_unique_id'=>$cart_unique_id
						]);
					}
				}

				$input=[
					'customer_id' => auth()->user()->id,
					'vendor_id'=> SellerService::where("service_id",$card->service_id)->first()->seller_id,
					'amount'=>$grand_total,
					'remark'=>"Done",
					'type'=>'Dr',
					'card_ids'=>$card_ids,
				];
				
				$res=Transection::create($input);
				
				$params['amount'] 			= $grand_total;
				$params['order_id'] 		= $card->tran_id;
				$params['customer_id'] 		= $card->id;
				$params['customer_name'] 	= $card->user?$card->user->name:'';
				$params['customer_phone'] 	= $card->user?$card->user->phone:'';
				$params['customer_email'] 	= $card->user?$card->user->email:'';
				$params['customer_dob'] 	= $card->user?$card->user->DOB:'';
				$params['items_array'] 		= '';
				$addr = "";
				$params['shipping_city'] = '';
				if($card->address && $card->address->city){
					$city_n = $card->address->city->name;
					$params['shipping_city'] = $city_n;
					$addr .= ", $city_n ";
				}

				if($card->address){
					$addddd = $card->address->address;
					$addr .= $addddd;
				}
				
				$params['shipping_address'] = $addr;
				
				//print_r($params); exit;
				
				$url = $this->pay_by_tabby($params, $id);

				$o_data['payment_ref'] = null;
				$o_data['checkout_url'] = $url;
			}

            $o_data['order_id'] = $id->id;
            $o_data['invoice'] = $invoice_id;
    
            $status = "1";
            $message = "Payment Created Successfully!";
			
        }
    
        return response()->json(['status' => $status, 'message' => $message, 'errors' => (object)$errors, 'oData' => (object)$o_data]);
    }

	public function clear_notifications_firebase() {
		$this->database->getReference('Notifications')->remove();
		$this->database->getReference('ChatMessage')->remove();
		$this->database->getReference('cart')->remove();
		$this->database->getReference('liveLocation')->remove();
		$this->database->getReference('logs')->remove();
	}
	private function generate_telr_payment_link($off_line_booking,$g_total){
	    if(is_numeric($off_line_booking->address_id)){
            $addres = Address::with(['city'])->find($off_line_booking->address_id);
	    }else{
	        $addres = json_decode($off_line_booking->address_id);
	    }
        $user= User::find($off_line_booking->user_id);
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post('https://secure.telr.com/gateway/api_quicklink.json', [
            "QuickLinkRequest" => [
                "storeID" => env('TELR_STORE_ID'),
                "authKey" => env("TELR_AUTH_KEY"),
                "Details" => [
                    "Desc" => "Cash Payment Link Generation",
                    "Cart" => $off_line_booking->tran_id,
                    "Currency" => "AED",
                    "Amount" => $g_total,
                    "FullName" => $user->name??'',
                    "Addr1" => $addres->address??'',
                    "City" => $addres->city->name??'',
                    "Country" => "",
                    "Email" => $user->email??'',
                    "Phone" => $user->dial_code.$user->phone,
                ]
            ]
        ]);
        
        if ($response->successful()) {
            $data = $response->json();
            if (isset($data['QuickLinkResponse']['URL'])) {
                $encodedUrl = $data['QuickLinkResponse']['URL'];
                $decodedUrl = urldecode($encodedUrl);
                
                return $decodedUrl;
            } else {
                return '';
            }
        } else {
            //dd($response->body()); // Show error response
           return '';
        }
    }
    public function card_payment_update($id, $payment_type = 2,REQUEST $request)
    {
        
        $order = Order::find($id);
        $cards = Card::where(['user_id'=>auth()->user()->id])
        ->where('is_checkout', '!=', 'Done')
        ->get();
        $allHaveSlotId = true;
       
        foreach ($cards as $card) {
			if($card->service_id != 10){
				if (empty($card->slot_id)) {
					$allHaveSlotId = false;
					break;
				}
			}
        }
        
        
        if (!$allHaveSlotId) {
            $datas['is_draft'] = "yes";
            $datas['step'] = "3";
        
        	return redirect('cart')->with('error','Order is not completed, please fill the order!');
		}
        
        $all_subtotal = 0;
        $total    = 0;
        $alternative_number    = 0;
        $full_amount = 0;
		$card_ids = [];
        if (!$cards->isEmpty()) {
			
            $count_card = $cards->count();
            $tip_per_card = (float) round($order->tip_amount / $count_card, 2);
            $coupon_per_card = (float) round($order->coupon_amount / $count_card, 2);
            foreach ($cards as $card) {
                if($card){
					$card_ids[] = $card->id;
					$data['tip_id']         =  0;
                    if(!empty($order->tip_amount)){
                        $data['tip_id']         = $tip_per_card;
                    }
                    $data['amount'] = $card->sub_total;
                    $data['card_process']   = 'Complete';
                    $data['payment_status'] = "True";
                    $data['booking_from']   = 'Web';
    
                    $subtotal = $card->g_total;
                    $total += (int) $card->amount;
					$alternative_number = $card->alternative_number;
                    $coupon = Coupon::where('id',$card->coupon_id)->where('status','1')->first();
                    if($coupon){
                        $user_coupon['user_id'] = $card->user_id;
                        $user_coupon['coupon_id'] = $card->coupon_id;
                        UserCoupon::create($user_coupon);
    
                        $crd_coupon['card_id']      = $card->id;
                        $crd_coupon['coupon_id']    = $coupon->id;
                        $crd_coupon['code']         = $coupon->code;
                        $crd_coupon['amount']       = $coupon->amount;
                        $crd_coupon['min_amount']   = $coupon->min_amount;
                        $crd_coupon['max_amount']   = $coupon->max_amount;
                        $crd_coupon['type']         = $coupon->type;
                        $crd_coupon['start_date']   = $coupon->start_date;
                        $crd_coupon['end_date']     = $coupon->end_date;
    
                        if(CardCoupon::where('card_id',$card->card_id)->exists()){
                            CardCoupon::where('card_id',$card->card_id)->update($crd_coupon);
                        } else {
                            CardCoupon::create($crd_coupon);
                        }
    
                        $amount = $order->coupon_amount;
                        
                    } else {
                        $coupon_Amt = '00';
                    }
                    $data['coupon_amt'] = $coupon_per_card;
                    $data['is_checkout'] = 'Done';
                    $service = Service::find($card->service_id);

					if ($service && !is_null($service->cod_charge)) {
						$data['surcharge'] = $service->cod_charge;
					} else {
						$data['surcharge'] = 0;
					}
					if($payment_type == 2){
						
						$setting = HomeSetting::first();
						$codamt  = $setting?$setting->cash_surcharge:'0';
						

						$data['payment_collected'] = 'No';
					}
					//echo $card->sub_total ."+". $data['surcharge'] ."-". $data['coupon_amt']."+". (float)$card->cod_charge."+".$card->material_charge."+".$data['tip_id'];
					$data['g_total'] = $card->sub_total + $data['surcharge'] - $data['coupon_amt'] + (float)$card->cod + $card->material_charge + $data['tip_id'];
					
					$full_amount+=$data['g_total'];
					 //exit;
                    $card->update($data);
                    
                   
                } else {
                    return $this->sendError('Invalid booking id');
                }
            }
            if($payment_type == 2){
                $cart_item = Card::find($card->id);
                //$new_input['payment_link'] = $this->generate_telr_payment_link($cart_item,$full_amount);
                //Card::whereIn('id',$card_ids)->update($new_input);
            }
            // exit;
            $card_ids = implode(',', $card_ids);
			$sellerService = SellerService::where('service_id', $card->service_id)->first();

			if ($sellerService) {
				$sellerId = $sellerService->seller_id;
			} else {
				$sellerId = 0; 
			}

			$input=[
				'customer_id' => auth()->user()->id,
				'vendor_id'=> $sellerId,
				'amount'=>$total,
				'remark'=>"Done",
				'type'=>'Dr',
				'card_ids'=>$card_ids,
			];
			
			$res=Transection::create($input);

			//$new_data['tran_id'] = 'UM-'.mt_rand(1000,99999); //$res->id;
			
			//$card->update($new_data);
			
			$datas = [
				'user_id' => auth()->user()->id,
				'wallet_amount' => $total,
				'amount' => $total,
				'type' => 'debit',
				'pay_type' => 'Booking Service',
				'pay_method' => $order->payment_type == "1" ? "Card" : "Wallet",
				'description' => "Payment Successful",
			];

			if($payment_type == 3){
				if (wallet_history($datas)) {
					// WalletPaymentReport::where(['transaction_id' => $res->id, 'user_id' => $user_id])->update(['payment_status' => 'A']);
					// $status = "1";
					// $message = "Wallet recharged successfully";
				}
			}

			$res['id']       = (string) $res->id;
			
			if($res)
			{
				
				$invite = Invite::where('invite_code', auth()->user()->invite)->first();

				if ($invite && auth()->user()->is_invite) {
				
					$earn_user = User::firstOrCreate(
						['id' => $invite->user_id], 
						['wallet_balance' => "0"]               
					);
					
					$earn_user->wallet_balance = ($earn_user->wallet_balance ?? "0") + "10"; 
					$earn_user->save();
				
					$wallet = Wallet::firstOrCreate(
						['user_id' => $earn_user->id], 
						['balance' => 0]               
					);
					
					$wallet->balance = ($wallet->balance ?? 0) + 10; 
					$wallet->save();
				}
				
				auth()->user()->update([
					// "wallet_balance" => ((float) auth()->user()->wallet_balance - (float) $total),
					"is_invite" => 0
				]);    
				
				$user_wallet = Wallet::firstOrCreate(
					['user_id' => auth()->user()->id], 
					['balance' => 0] 
				);
				
				$user_wallet->balance = ($user_wallet->balance ?? 0);
				$user_wallet->save();
			}

            $res['subtotal']       = (string) $subtotal;
            $res['total']          = (string) $total;
            
            $user = User::find(auth()->user()->id);
            $paymentreport = [
                'transaction_id' => $order->invoice,
                'payment_status' => 'P',
                'user_id' => $user->id,
                'ref_id' => $order->ref,
                'amount' => $total,
                'method_type' => $order->payment_type,
                'created_at' => gmdate('Y-m-d H:i:s'),
            ];

            WalletPaymentReport::insert($paymentreport);
            

			$service = Service::find($card->service_id);
			
			sendWhatsAppMessage("971586400540", "New order received! For ".$card->id." and ".$service->name);

			// sendWhatsAppMessage($alternative_number, "New order received! For ".$card->id." and ".$service->name);

			exec("php ".base_path()."/artisan send-self_booking:push ".$card->id." ".auth()->user()->id." > /dev/null 2>&1 & ");
           

			exec("php ".base_path()."/artisan send_all_selle_booking_notification:init ".$card->id." > /dev/null 2>&1 & ");
			
			
			exec("php ".base_path()."/artisan card_payment_update:mail ".auth()->user()->id." > /dev/null 2>&1 & ");

			return redirect(route('thankyou', $res->id));
        }else {
			return view('errors.404');
        }
        
    }

	

	public function logout()
	{
		Auth::logout();
		\Session::flush();
		return redirect('/');
	}

	public function updated_price(Request $request)
	{
		$service = Service::find($request->service_id);
		$data['is_login']           = \Session::get('is_login');
		$data['user_id']            = \Session::get('user_id');
        $data['service_id']         = $request->service_id;
        $data['service_name']       = $service->name;
        // $data['category_id']        = $request->category_id;
        $data['date']               = date('Y-m-d');
        // $data['tran_id']            = 'UM-'.mt_rand(1000,99999);
        $data['category_id']  		= $service->parent_id;

        if(Card::where('user_id',\Session::get('user_id'))->where('service_id',$request->service_id)->where('status','Pending')->where('is_checkout','Processing')->where('payment_collected','No')->where('work_done','No')->count()>0){
        	
        	$card = Card::where('user_id',\Session::get('user_id'))->where('service_id',$request->service_id)->where('status','Pending')->where('is_checkout','Processing')->where('payment_collected','No')->where('work_done','No')->first();

        	$params['total'] = $card->g_total;
        } 
		return array('params' => $params);
	}

	public function add_card(Request $request)
	{
		$service = Service::find($request->service_id);
		$data['is_login']           = \Session::get('is_login');
		$data['user_id']            = \Session::get('user_id');
        $data['service_id']         = $request->service_id;
        $data['service_name']       = $service->name;
        // $data['category_id']        = $request->category_id;
        $data['date']               = date('Y-m-d');
        // $data['tran_id']            = 'UM-'.mt_rand(1000,99999);
        $data['category_id']  		= $service->parent_id;

        if(Card::where('user_id',\Session::get('user_id'))->where('service_id',$request->service_id)->where('status','Pending')->where('is_checkout','Processing')->where('payment_collected','No')->where('work_done','No')->count()>0){
        	
        	$card = Card::where('user_id',\Session::get('user_id'))->where('service_id',$request->service_id)->where('status','Pending')->where('is_checkout','Processing')->where('payment_collected','No')->where('work_done','No')->first();

        	$dataupdate['g_total']      = $request->attribute_price+$card->g_total;
        	$dataupdate['category_id']  		= $service->parent_id;
        	$gtotal = $request->attribute_price+$card->g_total;
        	$card->update($dataupdate);
        } else {
        	$data['g_total']            = $request->attribute_price;
        	$gtotal = $request->attribute_price;
        	$card = Card::create($data);
        }
        
        if($card){

        	$params['card_id']              = $card->id;
            $params['sub_cate_id']          = $request->sub_cate_id;
            $params['child_cate_id']    	= $request->child_category_id;
            $params['main_sub_cat_id']      = $request->main_sub_cat_id;
            $params['attribute_id']         = $request->attribute_id;
            $params['attribute_name']       = $request->attribute_name;
            $params['attribute_item_id']    = $request->attribute_item_id;
            $params['attribute_item_name']  = AttributeValue::where('id',$request->attribute_item_id)->value('value');
            $params['attribute_price']      = $request->attribute_price;
            $params['attribute_qty']        = '1';

            $qty = '1';
            if(CardAttribute::where('card_id',$card->id)->where('sub_cate_id',$request->sub_cate_id)->where('attribute_item_id',$request->attribute_item_id)->count()>0){
            	$card_atr = CardAttribute::where('card_id',$card->id)->where('sub_cate_id',$request->sub_cate_id)->where('attribute_item_id',$request->attribute_item_id)->first();	    
            	$qty = '1'+$card_atr->attribute_qty;	
            	$paramsupdate['attribute_qty'] 		= $qty;
            	$paramsupdate['attribute_price'] 	= $request->attribute_price*$qty;
            	
            	$card_atr->update($paramsupdate);
            } else {
            	$cardattr = CardAttribute::create($params);
            }
            
        }
        $carddata['service_id'] = $request->service_id;
        $res['qty'] = $qty;
        $res['total_cart'] = Card::where('user_id',\Session::get('user_id'))->where('is_checkout','Processing')->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count();
        $res['gtotal'] = $gtotal;
        return array(

            'res' => $res,
            'modal_view' => view('web.cart_total',$carddata)->render(),
            'modal_view_services' => view('web.cart_details',$carddata)->render(),
			
        );
	}

	public function minus_booking(Request $request)
	{  
		$card = Card::where('user_id',\Session::get('user_id'))->where('service_id',$request->service_id)->where('status','Pending')->where('is_checkout','Processing')->where('payment_collected','No')->where('work_done','No')->first();
		$card_atr = CardAttribute::where('card_id',$card->id)->where('sub_cate_id',$request->sub_cate_id)->where('attribute_item_id',$request->attribute_item_id)->first();	
		
		if($card_atr->attribute_qty>1){
			$paramsupdate['attribute_qty'] 		= $card_atr->attribute_qty-1;
	    	$paramsupdate['attribute_price'] 	= $request->attribute_price;
	    	$qty = $card_atr->attribute_qty-1;
	    	
	    	$card_atr->update($paramsupdate);
		} else {
			$card_atr->delete();
			$qty = '0';
		}           	
    	

    	$g_total = '0';
		foreach (CardAttribute::where('card_id',$card->id)->get() as $key => $value) {
			$g_total += $value->attribute_price;
			// $g_total += $request->attribute_price*$value->attribute_qty;
		}
		$cardinfo['g_total'] 	= $g_total;
		Card::where('id',$card->id)->update($cardinfo);
        
        $carddata['service_id'] = $request->service_id;
        $res['qty'] = $qty;
        $res['gtotal'] = $g_total;
        return array(

            'res' => $res,

            // 'modal_view' => view('web.cart_details',$carddata)->render(),
            'modal_view' => view('web.cart_total',$carddata)->render(),

        );
	}

	public function remove_card_attr(Request $request)
	{

		$cardattr = CardAttribute::find($request->card_atr_id);
		if($cardattr){
			$cardattr->delete();
		}	
		
		$g_total = '0';
		// foreach (CardAttribute::where('card_id',$request->card_id)->get() as $key => $value) {
		// 	$g_total += $value->attribute_price*$value->attribute_qty;
		// }
		
		// if(CardAttribute::where('card_id',$request->card_id)->count()>0){
		// 	$ginfo['g_total'] = $g_total;
		// 	Card::where('id',$request->card_id)->update($ginfo);		
		// } else {
		// 	Card::where('id',$request->card_id)->delete();
		// }
		$res = Card::where('id',$request->card_id)->delete();
        return $res;
		// return back()->with('error','Item Removed.');
	}

	public function get_card_booking(Request $request)
	{
		$carddata['service_id'] = $request?$request->service_id:'';
		$count = Card::where('user_id',\Session::get('user_id'))->where('service_id',$request?$request->service_id:'')->where('is_checkout','Processing')->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->count();

		$res['qty'] = $count;
        return array(

            'res' => $res,

            'modal_view' => view('web.cart_total',$carddata)->render(),
            'modal_view_services' => view('web.cart_details',$carddata)->render(),

        );
	}

	public function removed_card_attr($cardid = '', $id='')
	{
		$cardattr = CardAttribute::find($id);
		$cardattr->delete();
		$g_total = '0';
		foreach (CardAttribute::where('card_id',$cardid)->get() as $key => $value) {
			$g_total += $value->attribute_price*$value->attribute_qty;
		}
		if(CardAttribut::where('card_id',$cardid)->count()>0){
			$card['g_total'] = $g_total;
			Card::where('id',$cardid)->update($card);			
		} else {
			Card::where('id',$cardid)->delete();
		}
		$carddd = Card::where('id',$cardid)->first();
		if($carddd){
			return redirect('card/details/'.$carddd->service_id)->with('error','Item Removed.');
		} else {
			return back()->with('error','Item Removed.');
		}		
	}

	public function removed_booking_attr(Request $request)
	{
		$cardattr = CardAttribute::find($request->card_atr_id);
		$cardattr->delete();
		$g_total = '0';
		foreach (CardAttribute::where('card_id',$request->card_id)->get() as $key => $value) {
			$g_total += $value->attribute_price*$value->attribute_qty;
		}

		if(CardAttribute::where('card_id',$request->card_id)->count()>0){
			$ccrd = Card::where('id',$request->card_id)->first();
			$g_total += $ccrd?$ccrd->tip_id:'0';
			$g_total += $ccrd?$ccrd->cod_charge:'0';
			$ginfo['g_total'] = $g_total;
			$ginfo['coupon_id'] = null;
			$ginfo['coupon_amt'] 	= null;
			Card::where('id',$request->card_id)->update($ginfo);
			CardCoupon::where('card_id',$request->card_id)->delete();			
		} else {
			Card::where('id',$request->card_id)->delete();
			CardCoupon::where('card_id',$request->card_id)->delete();
		}
		
		$card = Card::where('id',$request->card_id)->first();

		$carddata['service_id'] = $card?$card->service_id:'';
		
        return array(
            'g_total' => $g_total,
            'modal_view' => view('web.cart_total',$carddata)->render(),
            'modal_view_services' => view('web.cart_details',$carddata)->render(),
        );
	}

	public function update_profiles(Request $request)
	{
		if(Auth::user()){
            $code = $request->invite_code;
            if(!empty($code)){
				$invite = Invite::where('invite_code', $request->invite_code)->first();
				if(isset($invite->user_id)){
					RewardUser::create([
						'booking_type' => 'Earn',
						'user_id' => $invite->user_id,
						'reward_config_id' => 1,
						'points' => 10,
						'amounts' => 10,
					]);

					RewardUser::create([
						'booking_type' => 'Earn',
						'user_id' => auth()->user()->id,
						'reward_config_id' => 1,
						'points' => 10,
						'amounts' => 10,
					]);
				}  else{
					
					return back()->with('error','Enter correct Referral code.');
				}
			}

			if(Auth::user()->DOB == null){
				$user = User::find(Auth::user()->id);
				$array['view']      = 'emails.customer_created';
                $array['subject']   = 'Welcome to UrbanMop - Your Journey to a Cleaner Home Begins Now!';
                $array['data']      = $user;
                \Mail::to($request->email)->send(new \App\Mail\Mail($array));
			}
			
			$params['name'] 	= $request->name;
			
			if($request->email){
				$params['email']	= $request->email;
			}

			if($request->dial_code){
				$params['dial_code']	= $request->dial_code;
			}

			if($request->phone){
				$params['phone']	= $request->phone;
			}

			if($request->date){
				$params['DOB'] 		= $request->date;
			}
	        
	        if($request->gender){
	        	$params['gender'] 	= $request->gender;
	        }

	        if($request->hasFile('profile')){
                $imageName = $request->name.'-'.time().'.'.$request->profile->extension(); 
                $path = $request->profile->move(public_path('/uploads/user/'), $imageName);
                $params['profile'] = $imageName;
            }

	        User::find(Auth::user()->id)->update($params);
		
			return redirect('/')->with('success','Your Profile Updated.');
		}
		
		return back()->with('error','Please do login first.');
	}

	public function update_profile(Request $request)
	{
		// $this->validate($request,[
        //     'name' => 'required',
        // ]);
     
        $card = Card::where('user_id',Auth::user()?Auth::user()->id:'')->where('service_id',$request->service_id)->where('status','Pending')->where('is_checkout','Processing')->orderBy('id', 'DESC')->first();
        if($card){
        	// $cardparams['card_process'] = 'Complete';
        	$cardparams['booking_from'] = 'Web';
        	$cardparams['address_id'] 	= $request->address_id;
        	$cardparams['amount'] 		= $card->g_total;
        	$card->update($cardparams);
        }
		if(Auth::user()){
			$params['name'] 	= $request->name;
			
			if($request->email){
				$params['email']	= $request->email;
			}

			if($request->date){
				$params['DOB'] 		= $request->date;
			}
	        
	        if($request->gender){
	        	$params['gender'] 	= $request->gender;
	        }

	        $params['verify'] 	= 'True';

	        if($request->hasFile('profile')){
                $imageName = $request->name.'-'.time().'.'.$request->profile->extension(); 
                $path = $request->profile->move(public_path('/uploads/user/'), $imageName);
                $params['profile'] = $imageName;
            }

	        User::where('id',Auth::user()->id)->update($params);

	        if($request->data_from=='my_profile'){
	        	return back()->with('success','Your Profile Updated.');
	        }
	        if($request->address || $request->address_type || $request->flat_no || $request->building){
	        	$this->validate($request,[
		            'address' => 'required',
		            'address_type' => 'required',
		            'flat_no' => 'required',
		        ]);
	        	$address['user_id'] 		= Auth::user()->id;
		        $address['address'] 		= $request->address;
		        $address['address_type'] 	= $request->address_type;
		        $address['flat_no'] 		= $request->flat_no;
		        $address['building'] 		= $request->building;
		        $address['locality'] 		= $request->locality;
		        $address['city_id'] 		= $request->city_id;
		        $address['latitude'] 		= $request->lat;
		        $address['longitude'] 		= $request->long;
		        if($request->address_id){
		        	
		        	Address::where('id',$request->address_id)->update($address);
		        } else {
		        	$address = Address::create($address);
		        	$cardparams['address_id'] 	= $address->id;
        			$card->update($cardparams);
		        }
	        }
	        
	        return redirect('card/details/'.$request->service_id);
		} else {
			return back()->with('error','Login First.');
		}
	}

	public function card_details($id)
	{

		if(Auth::user()){
			// $card_infos = Card::where('service_id',$id)->where('user_id',Auth::user()->id)->where('is_checkout','Processing')->orderBy('id', 'DESC')->get();
			// return $card_infos;
			// foreach ($card_infos as $key => $value) {
			// 	if($key==0){

			// 	} else {
			// 		if($card_info){
			// 			CardAddon::where('card_id',$card_info->id)->delete();
			// 			CardAttribute::where('card_id',$card_info->id)->delete();
			// 			$card_info->delete();
			// 		}
			// 	}				
			// }
			

			if(Card::where('user_id',Auth::user()->id)->where('service_id',$id)->where('status','Pending')->where('payment_collected','No')->where('is_checkout','Processing')->where('work_done','No')->count() && count(Card::where('user_id',Auth::user()->id)->where('service_id',$id)->where('is_checkout','Processing')->where('status','Pending')->with('card_attribute')->where('payment_collected','No')->where('work_done','No')->first()->card_attribute)){
				$data['service'] 		= Service::find($id);
				$data['user'] 			= Auth::user();
				$data['address'] 		= Address::where('user_id',Auth::user()->id)->orderBy('id', 'DESC')->first();
				$data['address_info'] 	= Address::where('user_id',Auth::user()->id)->orderBy('id', 'DESC')->get();
				$data['card'] 			= Card::where('user_id',Auth::user()->id)->where('service_id',$id)->where('status','Pending')->where('is_checkout','Processing')->where('payment_collected','No')->where('work_done','No')->orderBy('id', 'DESC')->first();
				$attr_ids = [];
				$addon_ids = [];
				if(isset($data['card']) && $data['card']){
					foreach ($data['card']->card_attribute as $key => $value) {
						array_push($attr_ids, $value->attribute_item_id);
					}
					foreach ($data['card']->card_addon as $key => $addon) {
						array_push($addon_ids, $addon->add_on_id);
					}					
				}

				$data['addons'] 	= Addon::where('service_id',$id)->whereIn('attribute_item_id',$attr_ids)->get();
				$data['slots'] 		= Slot::all();
				$data['addon_ids'] 	= $addon_ids;
				return view('web.card_info',$data);
			} else {
				return redirect('/')->with('error','Your Card is Empty.');
			}
			
		} else {
			return back()->with('error','Login First.');
		}
	}

	public function revisit(Request $request)
	{
		$validated = $request->validate([
			'date' => 'required|date',
			'slot_id' => 'required|exists:slots,id',
			'old_booking_id' => 'required|exists:cards,id',
		]);

		$originalCard = Card::findOrFail($validated['old_booking_id']);
    

        // if ($originalCard->service_completed_date) {
        //     $originalDate = Carbon::parse($originalCard->service_completed_date);
        //     $currentDate = Carbon::now();
        //     $daysSinceService = $originalDate->diffInDays($currentDate);

        //     // Check if within 90-day revisit window and at least 21 days have passed
        //     if ($daysSinceService >= 21 && $daysSinceService <= 90) {
               
        //     } else {

        //         return back()->with('error', 'Revisit must be booked at least 21 days after service and within 90 days.');
        //     }
        // } else {
		//     return back()->with('error', 'Service not completed yet.');
		// }

        $newCard = new Card();
        $newCard->user_id = $originalCard->user_id;
        $newCard->service_id = $originalCard->service_id;
        $newCard->service_name = $originalCard->service_name;
        $newCard->category_id = $originalCard->category_id;
        $newCard->address_id = $originalCard->address_id;
        $newCard->paymentLinkId = $originalCard->paymentLinkId;
        $newCard->tran_id = $originalCard->tran_id;
        $newCard->paymentTranId = $originalCard->paymentTranId;
        $newCard->payment_moad = $originalCard->payment_moad;
        $newCard->note = $originalCard->note;
        $newCard->alternative_number = $originalCard->alternative_number;
        $newCard->date = $validated['date'];
        $newCard->tip_id = null;
        $newCard->coupon_id = null;
        $newCard->status = $originalCard->status;
        $newCard->accept_user_id = $originalCard->accept_user_id;
        $newCard->accept_user_company_id = $originalCard->accept_user_company_id;
        $newCard->amount = 0;
        $newCard->coupon_amt = $originalCard->coupon_amt;
        $newCard->g_total = 0;
        $newCard->offline_charge = $originalCard->offline_charge;
        $newCard->offline_discount = $originalCard->offline_discount;
        $newCard->before_coupon_amt = $originalCard->before_coupon_amt;
        $newCard->payment_collected = $originalCard->payment_collected;
        $newCard->service_start_datetime = $originalCard->service_start_datetime;
        $newCard->service_complete_approval = $originalCard->service_complete_approval;
        $newCard->service_completed = $originalCard->service_completed;
        $newCard->service_completed_date = $originalCard->service_completed_date;
        $newCard->work_done = $originalCard->work_done;
        $newCard->cod_status = $originalCard->cod_status;
        $newCard->cod_charge = $originalCard->cod_charge;
        $newCard->material_status = $originalCard->material_status;
        $newCard->material_charge = $originalCard->material_charge;
        $newCard->service_type = $originalCard->service_type;
        $newCard->is_login = $originalCard->is_login;
        $newCard->booking_from = $originalCard->booking_from;
        $newCard->cencal_date = $originalCard->cencal_date;
        $newCard->encrypt = $originalCard->encrypt;
        $newCard->pending_approval_by_admin = $originalCard->pending_approval_by_admin;
        $newCard->payment_type = $originalCard->payment_type;
        $newCard->tabby_payment_status = $originalCard->tabby_payment_status;
        $newCard->tabby_payment_response_id = $originalCard->tabby_payment_response_id;
        $newCard->payment_link = $originalCard->payment_link;
        $newCard->selected_packages = $originalCard->selected_packages;
        $newCard->package_price = $originalCard->package_price;
        $newCard->preffered_days = $originalCard->preffered_days;
        $newCard->alternative_dial_code = $originalCard->alternative_dial_code;

        // Set the required changes for the new entry
        $newCard->status = "Accept";
        $newCard->is_checkout = "Done";
        $newCard->slot_id = $validated['slot_id'];
        $newCard->payment_status =  $originalCard->payment_status;
        $newCard->accept_user_id =  $originalCard->accept_user_id;
        $newCard->is_revisit =  0;

        // Save the new card entry
        $newCard->save();   

        
        $oldCard = Card::find($validated['old_booking_id']);
        $oldCard->revisit_id = $newCard->id;
        $oldCard->is_revisit =  1;
        $oldCard->save();   


        $cart = Card::find($newCard->id);
        $service = Service::find($cart->service_id);
        $cardattr = (object) [];
        
        if (CardAttribute::where('card_id', $originalCard->id)->exists()) {
            $data["service_name"] = $service->name;
            foreach (CardAttribute::where('card_id', $originalCard->id)->get() as $value) {
                
                $service = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                $service_item = ServiceAttributeValueItem::where('id',$service->ser_attr_val_item_id)->first();
                $attribute = Attribute::where('id',$service->attribute_id)->first();
                $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                
                $params['sub_cate_id']          = $value->sub_cate_id ?? null;
                $params['main_sub_cat_id']      = $value->main_sub_cat_id ?? null;
                $params['child_cate_id']        = $value->child_cate_id ?? null;
                $params['attribute_id']         = $attribute->id ?? null;
                $params['attribute_name']       = $attribute->name ?? null;
                $params['attribute_item_id']    = $value->attribute_item_id ?? null;
                $params['attribute_item_name']  = $attribute_item->value ?? null;
                $params['attribute_price']      = $service->attribute_price ?? null;
                $params['attribute_qty']        = $value->attribute_qty ?? null;
                $params['service_type']         = '';
                $params['card_id']              = $cart->id;
                
                $cardattr = CardAttribute::create($params);
            } 
            
        }

		return response()->json(['success' => true, 'message' => 'Booking rescheduled successfully.']);
	}

	public function shareApp(){
		$detect = new MobileDetect();

		if ($detect->isAndroidOS()) {
			// Redirect to Google Play Store
			return redirect()->away('https://play.google.com/store/apps/details?id=com.urbanmop');
		} elseif ($detect->isiOS()) {
			// Redirect to Apple App Store
			return redirect()->away('https://apps.apple.com/in/app/urbanmop/id6474144613');
		} else {
			// Optional: Handle for non-mobile devices or unsupported platforms
			return redirect()->away('https://urbanmop.com');
		}
	}
	
	public function reschedule(Request $request)
	{
		$validated = $request->validate([
			'date' => 'required|date',
			'slot_id' => 'required|exists:slots,id',
			'card_id' => 'required|exists:cards,id',
		]);

		$card = Card::where('id', $validated['card_id'])
        ->whereIn('status', ['Pending', 'Accept','Expired','Upcoming'])
        ->first();

        if($card){
            $data['slot_id']   = $request->slot_id;
            $data['date']      = $request->date;
            if(date('Y-m-d',strtotime($request->date)) > date('Y-m-d')){
                    if($card->accept_user_id > 0){
                        $data['status']    = 'Upcoming';
                    }else{
                        $data['status']    = 'Pending';
                    }
                    Log::warning("Website Upcoming: ".$request->slot_id." : ".$request->cart_id);
                }else if(date('Y-m-d',strtotime($request->date)) == date('Y-m-d')){
                    $slot = Slot::find($request->slot_id);
                    if (Carbon::now()->diffInHours($slot->check_in, false) > 2) {
                        if($card->accept_user_id > 0){
                            $data['status']    = 'Upcoming';
                        }else{
                            $data['status']    = 'Pending';
                        }
                        Log::warning("Website Upcoming 2: ".$request->slot_id);
                    }else{
                        if($card->accept_user_id > 0){
                            $data['status']    = 'Accept';
                        }else{
                            $data['status']    = 'Pending';
                        }
                        
                        Log::warning("Website Pending: ".$request->slot_id);
                    }
                    
                }
            $card->update($data);

            if($card->user && $card->user->email){
                $array['view']      = 'emails.change_slot_customer';
                $array['subject']   = 'Slot Changed';
                $array['data']      = $card;
                
                \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
            }

            if($card->vendor && $card->vendor->email){
                $array['view']      = 'emails.change_slot_customer';
                $array['subject']   = 'Slot Changed';
                $array['data']      = $card;
                
                \Mail::to($card->vendor?$card->vendor->email:'')->send(new \App\Mail\Mail($array));
            }

            $adminarray['view']      = 'emails.change_slot_admin';
            $adminarray['subject']   = 'Slot Changed';
            $adminarray['data']      = $card;
           
            // \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));
            
			return response()->json(['success' => true, 'message' => 'Booking rescheduled successfully.']);
	
		}else{
			return response()->json(['success' => false, 'message' => 'Cant schedule the booking.']);
	
		}

	}
	
    public function booking_canceled(Request $request)
    {
        $card = Card::find($request->booking_id);

        if($card && $card->status != 'Canceled'){
			if($card->service_id == 10){
				$session = SessionPackages::where([
					'cart_id' => $card->id, 
				])->first();
				
				$sessionDateTime = Carbon::createFromFormat('Y-m-d H:i:s', $session->date . ' ' . Slot::find($session->time)->check_in);

				$currentDateTime = Carbon::now();

				// Check if the session is within 4 hours from now
				if ($sessionDateTime->isToday() && $sessionDateTime->diffInHours($currentDateTime) <= 4) {
					$data['cancel_charge'] = (float)25;
				}
				
			
	
			} else {
				
				$sessionDateTime = Carbon::createFromFormat('Y-m-d H:i:s', $card->date . ' ' . Slot::find($card->slot_id)->check_in);

				$currentDateTime = Carbon::now();

				// Check if the session is within 4 hours from now
				if ($sessionDateTime->isToday() && $sessionDateTime->diffInHours($currentDateTime) <= 4) {
					$data['cancel_charge'] = (float)25;
				}
			}
			if($card->payment_type == 2){
                $user = User::find($card->user_id);
                $user->wallet_balance -= 25;
                $user->save();
			} else {
                if($card->amount < 25){
                    $user = User::find($card->user_id);
                    $user->wallet_balance -= (float) 25 - (float) $card->amount;
                    $user->save();
                }
            }

            $data['status']  = 'Canceled';

            $card->update($data);



            $array['view']      = 'emails.booking_cancelled';
            $array['subject']   = 'Your Booking Has Been Cancelled';
            $array['data']      = $card;
            \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));

			return response()->json(['success' => true, 'message' => 'Your booking is successfully cancelled!']);
        } else {
			return response()->json(['success' => false, 'message' => 'Booking id not found!']);
        }
    }

	public function reorder(Request $request, $card_id)
	{
		$originalCard = Card::findOrFail($card_id);
    
        $newCard = new Card();
        $newCard->user_id = $originalCard->user_id;
        $newCard->service_id = $originalCard->service_id;
        $newCard->service_name = $originalCard->service_name;
        $newCard->category_id = $originalCard->category_id;
        $newCard->address_id = $originalCard->address_id;
        $newCard->paymentLinkId = $originalCard->paymentLinkId;
        $newCard->paymentTranId = $originalCard->paymentTranId;
        $newCard->payment_moad = $originalCard->payment_moad;
        $newCard->note = $originalCard->note;
        $newCard->alternative_number = $originalCard->alternative_number;
        $newCard->status = $originalCard->status;
        $newCard->amount = $originalCard->amount;
        $newCard->coupon_amt = $originalCard->coupon_amt;
        $newCard->g_total = $originalCard->g_total;
        $newCard->offline_charge = $originalCard->offline_charge;
        $newCard->offline_discount = $originalCard->offline_discount;
        $newCard->before_coupon_amt = $originalCard->before_coupon_amt;
        $newCard->material_status = $originalCard->material_status;
        $newCard->material_charge = $originalCard->material_charge;
        $newCard->service_type = $originalCard->service_type;
        $newCard->is_login = $originalCard->is_login;
        $newCard->booking_from = $originalCard->booking_from;
        $newCard->cencal_date = $originalCard->cencal_date;
        $newCard->pending_approval_by_admin = $originalCard->pending_approval_by_admin;
        $newCard->tabby_payment_status = $originalCard->tabby_payment_status;
        $newCard->tabby_payment_response_id = $originalCard->tabby_payment_response_id;
        $newCard->payment_link = $originalCard->payment_link;
        $newCard->selected_packages = $originalCard->selected_packages;
        $newCard->package_price = $originalCard->package_price;
        $newCard->preffered_days = $originalCard->preffered_days;
        $newCard->alternative_dial_code = $originalCard->alternative_dial_code;

        // Set the required changes for the new entry
        $newCard->status = "Pending";
        $newCard->is_checkout = "Processing";
        $newCard->slot_id = null;
        $newCard->payment_status = "Draft";

        // Save the new card entry
        $newCard->save();   
	
		$cart = Card::find($newCard->id);
	
		$cardAttributes = [];
		if (CardAttribute::where('card_id', $originalCard->id)->exists()) {
			foreach (CardAttribute::where('card_id', $originalCard->id)->get() as $value) {
				$serviceAttrValue = ServiceAttributeValue::where('attribute_item_id', $value->attribute_item_id)->first();
				$serviceAttrValueItem = ServiceAttributeValueItem::find($serviceAttrValue->ser_attr_val_item_id);
				$attribute = Attribute::find($serviceAttrValue->attribute_id);
				$attributeItem = AttributeValue::find($value->attribute_item_id);
	
				$params = [
					'sub_cate_id' => $value->sub_cate_id ?? null,
					'main_sub_cat_id' => $value->main_sub_cat_id ?? null,
					'child_cate_id' => $value->child_cate_id ?? null,
					'attribute_id' => $attribute->id ?? null,
					'attribute_name' => $attribute->name ?? null,
					'attribute_item_id' => $value->attribute_item_id ?? null,
					'attribute_item_name' => $attributeItem->value ?? null,
					'attribute_price' => $serviceAttrValue->attribute_price ?? null,
					'attribute_qty' => $value->attribute_qty ?? null,
					'service_type' => '',
					'card_id' => $cart->id,
				];
	
				$cardAttributes[] = CardAttribute::create($params);
			}
		}
	
		return response()->json([
			'success' => true,
			'message' => 'Card duplicated successfully.',
			'data' => [
				'card' => $cart,
				'card_attributes' => $cardAttributes,
			],
		]);
	}	

	public function card_update(Request $request)
	{
		$crd_info = Card::where('id',$request->card_id)->first();
		
		if($crd_info && $crd_info->is_checkout != 'Done'){

			if($request->slot_id && $request->date){

				if($request->card_id){

					$add_res = Address::find($request->address_id);
					$shippingAddress = [];

					$shippingAddress['user_id'] 	= $add_res->user_id;
					$shippingAddress['city_id'] 	= $add_res->city_id;
					$shippingAddress['city_name'] 	= $add_res->city?$add_res->city->name:'';
					$shippingAddress['address'] 	= $add_res->address;
					$shippingAddress['address_type']= $add_res->address_type;
					$shippingAddress['flat_no'] 	= $add_res->flat_no;
					$shippingAddress['building'] 	= $add_res->building;
					$shippingAddress['locality'] 	= $add_res->locality_info?$add_res->locality_info->name:'';
					$shippingAddress['latitude'] 	= $add_res->latitude;
					$shippingAddress['longitude'] 	= $add_res->longitude;


					$data['address_id'] 		= json_encode($shippingAddress);
					$data['alternative_number'] = $request->alternative_number;
					$data['slot_id'] 			= $request->slot_id;
					$data['payment_moad'] 		= $request->payment_moad;
					if($request->payment_moad=='Card'){
						$data['payment_type'] 		= $request->payment_type;
					}
					$data['date'] 				= $request->date;
					$data['note'] 				= $request->note;
					$data['card_process'] 		= 'Complete';
					$data['payment_status'] 	= $request->payment_moad=='Cash'?'True':'Pending';

					if($request->payment_moad=='Cash'){
						$data['is_checkout'] 		= 'Done';
					} else {
						$data['is_checkout'] 		= 'Processing';
					}
					
					if(Card::where('id',$request->card_id)->where('service_type','Normal')->orderBy('id', 'DESC')->first()){
					
						$total = '0';
						foreach (CardAttribute::where('card_id',$request->card_id)->get() as $key => $crdatr) {
							$ttotal = $crdatr->attribute_price*$crdatr->attribute_qty;
							$total += $ttotal;
						}

						foreach (CardAddon::where('card_id',$request->card_id)->get() as $key => $addon) {
							$attotal = $addon->value;
							$total += $attotal;
						}

						$card = Card::where('id',$request->card_id)->where('service_type','Normal')->orderBy('id', 'DESC')->first();
						

						if($card && $card->coupon_id){
							$coupon = Coupon::where('id',$card?$card->coupon_id:'')->where('status','1')->first();
				              if($coupon){
				              	$user_coupon['user_id'] = $card->user_id;
								$user_coupon['coupon_id'] = $card->coupon_id;
								UserCoupon::create($user_coupon);

								$crd_coupon['card_id'] 		= $request->card_id;
								$crd_coupon['coupon_id'] 	= $coupon->id;
								$crd_coupon['code'] 		= $coupon->code;
								$crd_coupon['amount'] 		= $coupon->amount;
								$crd_coupon['min_amount'] 	= $coupon->min_amount;
								$crd_coupon['max_amount'] 	= $coupon->max_amount;
								$crd_coupon['type'] 		= $coupon->type;
								$crd_coupon['start_date'] 	= $coupon->start_date;
								$crd_coupon['end_date'] 	= $coupon->end_date;

								if(CardCoupon::where('card_id',$request->card_id)->exists()){
									CardCoupon::where('card_id',$request->card_id)->update($crd_coupon);
								} else {
									CardCoupon::create($crd_coupon);
								}	

				                $amount = $coupon->amount;
				                if($coupon->type=='Amt'){
				                  $coupon_Amt = $amount;
				                } else {
				                  $per = ($amount / 100) * $total;

				                  if($per>$coupon->max_amount){
					                $coupon_Amt = $coupon->max_amount;
					              } else {
					                $coupon_Amt = $per;
					              }

				                }
			              	} else {
				                $coupon_Amt = '00';
			              	}
				            $total -= $coupon_Amt;
						}
						$total += $card?$card->tip_id:'0';
						$total += $card?$card->cod_charge:'0';
			            $data['g_total'] = $total;
			            
					} elseif (Card::where('id',$request->card_id)->where('service_type','Maid')->orderBy('id', 'DESC')->first()) {

						$total = '0';
						foreach (CardAttribute::where('card_id',$request->card_id)->get() as $key => $crdatr) {
							$ttotal = $crdatr->attribute_price*$crdatr->attribute_qty;
							$total += $ttotal;
						}

						foreach (CardAddon::where('card_id',$request->card_id)->get() as $key => $addon) {
							$attotal = $addon->value;
							$total += $attotal;
						}

						$card = Card::where('id',$request->card_id)->where('service_type','Maid')->orderBy('id', 'DESC')->first();
						
						
						if($card && $card->material_status){
							$total += $card?$card->material_charge:'0';
						}
						
						if($card && $card->coupon_id){
							$coupon = Coupon::where('id',$card?$card->coupon_id:'')->where('status','1')->first();

				              if($coupon){

				              	$user_coupon['user_id'] = $card->user_id;
								$user_coupon['coupon_id'] = $card->coupon_id;
								UserCoupon::create($user_coupon);

								$crd_coupon['card_id'] 		= $request->card_id;
								$crd_coupon['coupon_id'] 	= $coupon->id;
								$crd_coupon['code'] 		= $coupon->code;
								$crd_coupon['amount'] 		= $coupon->amount;
								$crd_coupon['min_amount'] 	= $coupon->min_amount;
								$crd_coupon['max_amount'] 	= $coupon->max_amount;
								$crd_coupon['type'] 		= $coupon->type;
								$crd_coupon['start_date'] 	= $coupon->start_date;
								$crd_coupon['end_date'] 	= $coupon->end_date;

								if(CardCoupon::where('card_id',$request->card_id)->exists()){
									CardCoupon::where('card_id',$request->card_id)->update($crd_coupon);
								} else {
									CardCoupon::create($crd_coupon);
								}	

				                $amount = $coupon->amount;
				                if($coupon->type=='Amt'){
				                  $coupon_Amt = $amount;
				                } else {
				                  $per = ($amount / 100) * $total;

				                  if($per>$coupon->max_amount){
					                $coupon_Amt = $coupon->max_amount;
					              } else {
					              	
					                if($per>$coupon->max_amount){
						                $coupon_Amt = $coupon->max_amount;
					              	} else {
						                $coupon_Amt = $per;
					              	}

					              }
				                }
			              	} else {
				                $coupon_Amt = '00';
			              	}
				            $total -= $coupon_Amt;
						}
						$total += $card?$card->tip_id:'0';
						$total += $card?$card->cod_charge:'0';
			            $data['g_total'] = $total;

					} else {
					
						return back()->with('error','Some Thing Want Wrong.');
					}

					$data['payment_type'] = $request->payment_type;
					Card::where('id',$request->card_id)->update($data);
					\Session::put('booking_id',$request->card_id);
					
					if($request->payment_moad=='Cash'){		
						return redirect('confirm-order');						
					} else {
						if($request->payment_type=='Tabby'){
							$params['amount'] 			= $total;
							$params['order_id'] 		= $card->tran_id;
							$params['customer_id'] 		= $card->id;
							$params['customer_name'] 	= $card->user?$card->user->name:'';
					    	$params['customer_phone'] 	= $card->user?$card->user->phone:'';
					    	$params['customer_email'] 	= $card->user?$card->user->email:'';
					    	$params['customer_dob'] 	= $card->user?$card->user->DOB:'';
					    	$params['items_array'] 		= '';
					    	$addr = "";
					    	$params['shipping_city'] = '';
					    	if($card->address && $card->address->city){
					    		$city_n = $card->address->city->name;
					    		$params['shipping_city'] = $city_n;
					    		$addr .= ", $city_n ";
					    	}

					    	if($card->address){
					    		$addddd = $card->address->address;
					    		$addr .= $addddd;
					    	}
					    	
							$params['shipping_address'] = $addr;
							
							return $this->pay_by_tabby($params);						
						} else {
							return redirect('payment/'.$request->card_id);
						}
					}
				} else {
					return back()->with('error','Some Thing Want Wrong.');
				}

			} else {
				return back()->with('error','Required Fields Missing.');
			}

		} else {
			return back();
		}
		
		
	}

	function terms_condition()
	{
		$data['setting'] = Article::find(2);
		return view('web.terms_condition',$data);
	}

	function privacy_policies()
	{
		// $data['setting'] = Setting::where('title','privacy-policy')->first();
		$data['setting'] = Article::find(3);
		return view('web.privacy_policies',$data);
	}

	public function add_addon(Request $request)
	{
		if($request->card_id && $request->addon_id){
			if($request->dtfrm=='Add'){
				$addon = Addon::find($request->addon_id);
				$params['card_id'] 				= $request->card_id;
				$params['card_attribute_id'] 	= $addon->attribute_item_id;
				$params['add_on_id'] 			= $addon->id;
				$params['name'] 				= $addon->name;
				$params['value'] 				= $addon->value;
				$params['percentage'] 			= $addon->percentage;
				CardAddon::create($params);

				$card = Card::find($request->card_id);
				$cardparams['g_total'] = $card->g_total+$addon->value;
				$card->update($cardparams);
			} else {
				$cardadd = CardAddon::where('card_id',$request->card_id)->where('add_on_id',$request->addon_id)->first();
				$card = Card::find($request->card_id);
				if($cardadd){
					$cardparams['g_total'] = $card->g_total-$cardadd->value;
					$card->update($cardparams);
					$cardadd->delete();
				}
			}
			
			$carddata['service_id'] = $card?$card->service_id:'';
		
	        return array(
	            'modal_view' => view('web.cart_details',$carddata)->render(),
	        );
		} else {
			return back()->with('error','Some Thing Want Wrong.');
		}
	}

	public function profile()
	{
		if(Auth::check()){
			$data['user'] = Auth::user();
			return view('web.my_profiles',$data);
		} else {
			return back()->with('error','Login First.');
		}
	}

	public function wallet_details(Request $request)
    {
        $status = "1";
        $o_data = [];
        $errors = [];
        $message = "";

        $user_id = auth()->user()->id;
        if ($user_id == 0) {
            $message = "session expired please login to continue";
            return response()->json([
                'status' => (string)$status,
                'message' => $message,
                'data' => (object)$o_data,
                'errors' => (object)$errors
            ], 401);
        }

        // Fetch last transaction details
        $last_history_det = \App\WalletHistory::where(['user_id' => $user_id])
            ->orderBy('id', 'desc')
            ->first();

        $user = User::find($user_id);

        // Fetch all wallet history
        $wallet_history = \App\WalletHistory::where(['user_id' => $user_id])
            ->orderBy('id', 'desc')
            ->get();

        foreach ($wallet_history as $key => $val) {
            $wallet_history[$key]->transaction_id = $val->id . strtotime($val->created_at);
            $wallet_history[$key]->wallet_amount = (string) round($val->wallet_amount, 2);
            $wallet_history[$key]->amount = (string) round($val->amount, 2);

            // Format created_at date correctly for display only
            $wallet_history[$key]->created_at_display = Carbon::parse($val->created_at)
                ->format('d M Y - h:i A');

            $pay_method = '';
            if ($val->pay_method == 1) {
                $pay_method = 'Credit Card';
            } elseif ($val->pay_method == 4) {
                $pay_method = 'Apple Pay';
            }
            $wallet_history[$key]->pay_method = $pay_method;
        }

        if ($last_history_det) {
            // Keep raw timestamp and provide formatted display version
            $last_history_det->created_at_display = Carbon::parse($last_history_det->created_at)
                ->format('d M Y - h:i A');
            $o_data['last_transaction'] = $last_history_det->toArray();
        } else {
            $o_data['last_transaction'] = (object)[];
        }

        $o_data['transaction']['list'] = $wallet_history;

        // Return response with raw and display-formatted dates
        return response()->json([
            'status' => $status,
            'message' => $message,
            'errors' => (object)$errors,
            'oData' => (object)$o_data
        ]);
    }

	public function savedLocations()
	{
		if (Auth::check()) {
			$user = Auth::user();
			$addresses = Address::where('user_id', $user->id)->get();
			$emirates = City::get();

			return view('web.saved_locations', [
				'user' => $user,
				'addresses' => $addresses,
				'emirates' => $emirates,
			]);
		} else {
			return back()->with('error', 'Login First.');
		}
	}

	public function updateAddress(Request $request, $id)
	{
		$address = Address::findOrFail($id);

		$address->update($request->only([
			'plot_off_no',
			'building_name',
			'emirate',
			'locality',
			'address_type',
			'address'
		]));

		return redirect()->route('saved.locations')->with('success', 'Address updated successfully.');
	}


	public function storeAddress(Request $request)
	{
		$request->validate([
			'plot_off_no' => 'required',
			'building_name' => 'required',
			'emirate' => 'required',
			'locality' => 'required',
			'address_type' => 'required',
			'address' => 'required'
		]);
		
		$address = new Address();
		$address->user_id = Auth::id();
		$address->flat_no = $request->plot_off_no;
		$address->building = $request->building_name;
		$address->city_id = $request->emirate;
		$address->locality = $request->locality;
		$address->latitude = $request->latitude;
		$address->longitude = $request->longitude;
		
		$address->address_type = $request->address_type;
		$address->address = $request->address;
		$address->is_active = 0;
		$address->save();

		return redirect()->back()->with('success', 'Address added successfully.');
	}

	public function deleteAddress($id)
	{
		try {
			$address = Address::where('id', $id)->where('user_id', Auth::id())->firstOrFail();
			$address->delete();
	
			return response()->json(['message' => 'Address deleted successfully.'], 200);
		} catch (ModelNotFoundException $e) {
			return response()->json(['error' => 'Address not found or unauthorized action.'], 404);
		} catch (\Exception $e) {
			return response()->json(['error' => 'Failed to delete the address. Please try again later.'], 500);
		}
	}	

	public function editAddresses(Request $request, $id)
	{
		$address = Address::where('id', $id)->where('user_id', Auth::id())->first();

		if ($address) {
			return response()->json([
				'success' => true,
				'address' => [
					'plot_off_no' => $address->flat_no,
					'building_name' => $address->building,
					'emirate_id' => $address->city_id,
					'locality_id' => $address->locality,
					'address_type' => $address->address_type,
					'address'=>$address->address,
					'latitude'=>$address->latitude,
					'longitude'=>$address->longitude
				]
			]);
		} else {
			return response()->json([
				'success' => false,
				'message' => 'Address not found'
			]);
		}
	}

	public function my_rewards()
	{
		if (!auth()->check()) {
			return redirect()->route('login')->with('error', 'Please log in to view your rewards.');
		}
	
		$userId = auth()->user()->id;
	
		// Fetch rewards for authenticated user
		$rewards = RewardUser::where('user_id', $userId)
		->orderBy('id', 'desc')
		->get();

		$lastRewardDate = RewardUser::where('user_id', $userId)
		->latest('date')
		->value('date'); 

		// Calculate total rewards
		$totalAmount = $rewards->sum('amounts');
		$totalPoints = $rewards->sum('points');
		$exist = Invite::where('user_id', $userId)->first();

		if ($exist) {
			$invite = $exist;
		} else {
			$invite = Invite::create([
				'user_id' => $userId,
				'invite_code' => strtoupper(uniqid('INV-'))
			]);
		}
	
		return view('web.my_reward', [
			'rewards' => $rewards,
			'totals' => [
				'total_amount' => $totalAmount,
				'total_points' => $totalPoints,
				'last_date' => \Carbon\Carbon::parse($lastRewardDate)->format('d M Y - h:i A'),
				'invite_code' => $invite ? $invite->invite_code : null,
			],
		]);
	}

	public function delete_account()
	{
		// if (!auth()->check()) {
		// 	return redirect()->route('login')->with('error', 'Please log in to view your rewards.');
		// }
	
		// $userId = auth()->user()->id;
	
		return view('web.delete_account');
	}

	public function deleteAccount(Request $request)
	{
		$name = $request->phone;
		$email = $request->email;
		$phone = $request->phone;
		$dial_code = $request->dial_code;

		DeletedAccount::create([
			'dial_code' => $dial_code,
			'phone' => $phone,
			'email' => $email,
			'name' => $name,
			'user_id' => null,
			'comment' => $request->comments,
		]);
	
		// $user->delete();
	
		return redirect()->route('delete.account.get')->with('success', 'Your account deletion request submitted.');
	}
	

	public function my_wallet()
	{
		if (Auth::check()) {
			$user = Auth::user();
			$user_id = $user->id;
	
			// Initialize response data
			$o_data = [];
	
			// Fetch last transaction details
			$last_history_det = \App\WalletHistory::where('user_id', $user_id)
				->orderBy('id', 'desc')
				->first();
	
			// Fetch all wallet history
			$wallet_history = \App\WalletHistory::where('user_id', $user_id)
				->orderBy('id', 'desc')
				->get();
			$total = auth()->user()->wallet_balance;
			foreach ($wallet_history as $key => $val) {
				$wallet_history[$key]->transaction_id = $val->id . strtotime($val->created_at);
				$wallet_history[$key]->wallet_amount = (string) round($val->wallet_amount, 2);
				$wallet_history[$key]->amount = (string) round($val->amount, 2);
				$wallet_history[$key]->created_at_display = \Carbon\Carbon::parse($val->created_at)->format('d M Y - h:i A');
				// $total += (float) round($val->amount, 2);
				$pay_method = '';
				if ($val->pay_method == 1) {
					$pay_method = 'Credit Card';
				} elseif ($val->pay_method == 4) {
					$pay_method = 'Apple Pay';
				}
				$wallet_history[$key]->pay_method = $pay_method;
			}
	
			if ($last_history_det) {
				$last_history_det->created_at_display = \Carbon\Carbon::parse($last_history_det->created_at)->format('d M Y - h:i A');
				$o_data['last_transaction'] = $last_history_det->toArray();
			} else {
				$o_data['last_transaction'] = (object)[];
			}
	
			$o_data['transaction']['list'] = $wallet_history;

			return view('web.my_wallet', [
				'user' => $user,
				'walletData' => $o_data,
				'total' => $total,
			]);
		} else {
			return back()->with('error', 'Login First.');
		}
	}	

	public function bookingDetail(Request $request, $id)
	{
		$value = Card::with(['service','staffCards','staffCards.staff','vendor'])->find($id);
		$order_count = Card::where('order_id',$value->order_id)->count();
			
		if ($value != null) {
			$cards = [];
			$cards_detail = [];
			$total_amount = 0;
			$coupon_amount = 0;
			$tip_amount = 0;
			$assigned_staff = $value->staffCards;
			$vendor = $value->vendor;
			$g_total = $value->g_total;

			// Initialize card data array
			$card_data = [
				'id'                     => $value->id, 
				'user_id'                => $value->user_id,
				'service_id'             => $value->service_id,
				'service_name'           => $value->service_name, 
				'category_id'            => $value->category_id,
				'slot_id'                => $value->slot_id,
				'slot'                	 => Slot::find($value->slot_id)->name ?? "-",
				'address_id'             => $value->address_id,
				'tran_id'                => normalizeId($value->tran_id),
				'payment_status'         => $value->payment_status,
				'alternative_dial_code'  => $value->alternative_dial_code ?? "",
				'alternative_number'     => $value->alternative_number,
				'note'                   => $value->note,
				'date'                   => $value->date,
				'status'                 => $value->status,
				'accept_user_id'         => $value->accept_user_id,
				'amount'                 => $value->amount, // Add card amount
				'g_total'                => $value->g_total,
				'material_status'        => $value->material_status,
				'material_charge'        => $value->material_charge,
				'is_checkout'            => $value->is_checkout,
				'payment_collected'      => $value->payment_collected,
				'service_completed'      => $value->service_completed,
				'service_completed_date' => $value->service_completed_date,
				'work_done'              => $value->work_done,
				'pending_approval_by_admin' => $value->pending_approval_by_admin,
				'booking_from'           => $value->booking_from,
				'created_at'             => $value->created_at,
				'updated_at'             => $value->updated_at,
				'selected_packages'      => $value->selected_packages,
				'package_price'      => $value->package_price,
				'preferred_days'         => $value->preffered_days,
				'surcharge'				=>$value->surcharge,
				'order_id'                   => $value->order_id,
			];

			

			// Card Attributes and Add-ons
			$card_attr = [];
			foreach (CardAttribute::where('card_id', $value->id)->get() as $item) {
				$params = [
					'sub_cate_id'         => (string) $item->sub_cate_id,
					'sub_cate_name'       => Category::find($item->sub_cate_id)->name ?? '',
					'main_sub_cat_id'     => $item->main_sub_cat_id,
					'main_sub_cat_name'   => Category::find($item->main_sub_cat_id)->name ?? '',
					'child_cate_id'       => (string) $item->child_cate_id,
					'child_cate'          => ChildCategory::find($item->child_cate_id)->name ?? '',
					'attribute_id'        => $item->attribute_id,
					'attribute_name'      => $item->attribute_name,
					'attribute_item_id'   => (string) $item->attribute_item_id,
					'attribute_item_name' => $item->attribute_item_name,
					'attribute_qty'       => $item->attribute_qty,
					'attribute_price'     => $item->attribute_price,
					'service_type'        => $item->service_type,
				];

				$card_attr[] = $params; 
			}

			// Include the card attributes inside the card data
			$card_data['card_attribute'] = $card_attr;

			// Add card data to the main $cards array
			$cards_detail = $card_data;
			$coupon_amount  = (float) $value->coupon_amt;
			$tip_amount     = (float) $value->tip_id;
			
			// Update total amount
			$total_amount += (float) $value->amount;

			$cards['card'] = $cards_detail;
			$cards['surcharge']=$value->surcharge;
			$cards['cod_charge']=$value->cod;
			$cards['order_id']=$value->order_id;
			$cards['coupon_id']=$value->coupon_id;
			$cards['sub_total']         = (string) $total_amount;
			$cards['coupon_status']     = (string) "no";
			$cards['tip_status']     = (string) "no";
			
			if($value->material_status == "Apply"){
				$cards['material_charge']     = $value->material_charge;
			}
			

			if($request->is_coupon){
				$cards['coupon_amount']     = (string) $coupon_amount;
				$cards['coupon_status']     = "yes";
				$total_amount -= $coupon_amount;
			}
			if ($request->is_tip && $tip_amount > 0) {
				$cards['tip_amount'] = (string) $tip_amount;
				$cards['tip_status'] = "yes";
				$total_amount += $tip_amount;
			} else {
				$cards['tip_amount'] = (string) $tip_amount;
				$cards['tip_status'] = "no";
			}
			
			$cards['user_balance']  = auth()->user()->wallet_balance;
			$rewardData = $this->get_reward_price($total_amount);
			$single_service = Service::find($value->service_id);
			$cards['service_id']     = $value->service_id;
			$cards['service_name']     =  $value->service_name;
			$cards['service_price']     =  $single_service->price;
			$cards['status']     =  $value->status;
			$cards['amount']     =  $value->amount;
			$cards['date']     =  $value->date;
			$cards['slot_id']     =  $value->slot_id;
			$cards['id']     =  $value->id;
			$cards['tran_id']     =  normalizeId($value->tran_id);
			$cards['slot']     = Slot::find($value->slot_id)->name ?? "-";

			$address = Address::find($value->address_id);
			$cards['flat_no']     = $address->flat_no ?? "-";
			$cards['building']     = $address->building ?? "-";
			$cards['city_name']     = $address->city->name ?? "-";
			$cards['locality_name']     = $address->locality_info->name ?? "-";
			$cards['address_type']     = $address->address_type ?? "-";
			$cards['revisit_id']     = $value->revisit_id ?? null;
			
			
			$cards['user_email']     = User::find($value->user_id)->email ?? "-";
			$cards['user_name']     = User::find($value->user_id)->name ?? "-";
			$cards['user_dial_code']     = User::find($value->user_id)->dial_code ?? "-";
			$cards['user_phone']     = User::find($value->user_id)->phone ?? "-";
			$cards['service_completed_date']     = $value->service_completed_date;

			if ($rewardData !== null) {
				$cards["remaining_reward_points"] = (string) $rewardData['remaining_reward_points'];
				// $cards["reward_amount"] = (string) $this->get_reward_price($total_amount)['final_amount'];
				// $cards['total']         = (string) ((float) $total_amount - (float) $this->get_reward_price($total_amount)['final_amount']);
				
				$cards["total"] = (string) $total_amount; 
				$cards["subtotal"] = (string) $total_amount; 
			} else {
				$cards["remaining_reward_points"] = '0'; 
				$cards["reward_amount"] = '0'; 
				$cards["total"] = (string) $total_amount; 
				$cards["subtotal"] = (string) $total_amount; 
			}
		
			$sessions = SessionPackages::with('package')->where('cart_id', $value->id)->get();
			$completed_session = SessionPackages::with('package')
			->where(['cart_id' => $value->id, 'status' => 'Completed'])->count();
			
			$free_sessions = 0;
			$per_week = 0;
			$total_sessions = 0;
			$is_package = 0;
			
			if($value->service_id == 10){
				$session = SessionPackages::where([
					'cart_id' => $value->id, 
				])->first();
				$cards['session_date'] = $session->date??'';
				$cards['session_time'] = $session->time??'';
			}

			foreach ($sessions as $session) {
				if ($session->package) { 
					$is_package = 1;
					$total_sessions = $session->package->total_sessions;
					$free_sessions = $session->package->free_sessions;
					$per_week = $session->package->per_week;
				}
			}
			$cards['session_history'] = [
				'total_session' => $total_sessions,
				'free_session' => $free_sessions,
				'per_week' => $per_week,
				'sessions' => $sessions,
				'completed_session' => (string) $completed_session+1,
			];
			
			$cards["time"] = ($value->slot_id) ? Slot::find($value->slot_id)->name : "";

			$res = Transection::find($value->tran_id);
			

			$total = 0;
			$subtotal = 0;
			$material_charge = 0;
			$tip = 0;
			$cod_charge = 0;
			$surcharge = 0;
			$coupon_discount = 0;
			$addons_total = 0;
			$payment_type = "";
			$cards_details = [];
		
			if (!empty($res->card_ids)) {
				$cardIds = explode(',', $res->card_ids);
				foreach ($cardIds as $cardId) {
					$card = Card::find($cardId);

					if ($card) {
					    
						$subtotal += (float) $card->amount;
						$total += (float) $card->amount;
						$material_charge += (float) $card->material_charge;
						$tip += (float) $card->tip_id ?? 0;
						$surcharge += (float) $card->surcharge;
						$cod_charge += (float) $card->cod;

						// Addons
						$addons = $card->card_addon;
						$addons_total += $addons->sum('value');

						// Coupon
						$order = Order::find($card->order_id);
						if ($order) {
							$coupon_discount = $order->coupon_amount;
							$payment_type = $order->payment_type;
						}

						$cards_details[] = [
							'service_name' => $card->service->name ?? 'Service Name',
							'attributes' => CardAttribute::where('card_id', $card->id)->get(),
							'addons' => $addons,
							'coupon' => $coupon_discount,
							'material_charge' => $card->material_charge,
							'tip' => $card->tip_id,
							'amount' => $card->amount,
							'service_price' => $card->service->price ?? 0,
						];
					} else {
						return redirect()->back()->with('error', 'Invalid booking id.');
					}
				}
			}
			// $total = ($total + $material_charge + $surcharge + $cod_charge + $tip + $addons_total) - $coupon_discount;

			return view('web.booking_detail', [
				'cartItem' => $cards,
				'material_charge' => $material_charge,
				'subtotal' => $subtotal,
				'payment_type' => $payment_type,
				'total' => $total,
				'g_total'=>$g_total,
				'cards_details' => $cards_details,
				'tip' => $tip,
				'cod_charge' => $cod_charge,
				'surcharge' => $surcharge,
				'coupon_discount' => $coupon_discount,
				'addons_total' => $addons_total,
				'order_count'=>$order_count,
				'coupon_amount'=>$coupon_amount??0,
				'assigned_staff'=>$assigned_staff,
				'vendor'=>$vendor
			]);
		} else {
			return $this->sendError('Invalid booking id');
		}
	}

	public function myOrders(Request $request)
	{
		$card = Card::with('service')->where(['user_id'=>auth()->user()->id])
		->where('is_checkout', 'Done')
		->orderBy('id', 'DESC')
		->paginate(10);
		
		if($card){
			
			$cards = [];
			$cards_detail = [];
			$total_amount = 0;
			$coupon_amount = 0;
			$tip_amount = 0;

			foreach ($card as $key => $value) {
				// Initialize card data array
				$card_data = [
					'id'                     => $value->id, 
					'user_id'                => $value->user_id,
					'service_id'             => $value->service_id,
					'service_name'           => $value->service_name, 
					'category_id'            => $value->category_id,
					'slot_id'                => $value->slot_id,
					'slot'                	 => Slot::find($value->slot_id)->name ?? "-",
					'address_id'             => $value->address_id,
					'tran_id'                => normalizeId($value->tran_id),
					'payment_status'         => $value->payment_status,
					'alternative_dial_code'  => $value->alternative_dial_code ?? "",
					'alternative_number'     => $value->alternative_number,
					'note'                   => $value->note,
					'date'                   => $value->date,
					'order_id'                   => $value->order_id,
					'status'                 => $value->status,
					'accept_user_id'         => $value->accept_user_id,
					'amount'                 => $value->amount, // Add card amount
					'g_total'                => $value->g_total,
					'material_status'        => $value->material_status,
					'material_charge'        => $value->material_charge,
					'is_checkout'            => $value->is_checkout,
					'payment_collected'      => $value->payment_collected,
					'service_completed'      => $value->service_completed,
					'service_completed_date' => $value->service_completed_date,
					'work_done'              => $value->work_done,
					'pending_approval_by_admin' => $value->pending_approval_by_admin,
					'booking_from'           => $value->booking_from,
					'created_at'             => $value->created_at,
					'updated_at'             => $value->updated_at,
					'selected_packages'      => $value->selected_packages,
					'preferred_days'         => $value->preffered_days,
					'surcharge'				=>$value->surcharge,
					'cod_charge'				=>$value->cod,
					'coupon_id'				=>$value->coupon_id,
					'coupon_amt'            => $value->coupon_amt,
					'tip_id'                => $value->tip_id
				];

	
				if($value->service_id == 10){
					$session = SessionPackages::where([
						'cart_id' => $value->id, 
					])->first();
					$card_data['session_date'] = $session->date??'';
					$card_data['session_time'] = $session->time??'';
				}

				// Card Attributes and Add-ons
				$card_attr = [];
				foreach (CardAttribute::where('card_id', $value->id)->get() as $item) {
					$params = [
						'sub_cate_id'         => (string) $item->sub_cate_id,
						'sub_cate_name'       => Category::find($item->sub_cate_id)->name ?? '',
						'main_sub_cat_id'     => $item->main_sub_cat_id,
						'main_sub_cat_name'   => Category::find($item->main_sub_cat_id)->name ?? '',
						'child_cate_id'       => (string) $item->child_cate_id,
						'child_cate'          => ChildCategory::find($item->child_cate_id)->name ?? '',
						'attribute_id'        => $item->attribute_id,
						'attribute_name'      => $item->attribute_name,
						'attribute_item_id'   => (string) $item->attribute_item_id,
						'attribute_item_name' => $item->attribute_item_name,
						'attribute_qty'       => $item->attribute_qty,
						'attribute_price'     => $item->attribute_price,
						'service_type'        => $item->service_type,
					];

					// Add-ons
					$addons = [];
					foreach (CardAddon::where('card_id', $value->id)->where('card_attribute_id', $item->id)->get() as $cardaddon) {
						$addons[] = [
							'card_id'            => $cardaddon->id,
							'card_attribute_id'  => $cardaddon->id,
							'add_on_id'          => $cardaddon->add_on_id,
							'name'               => $cardaddon->name,
							'value'              => $cardaddon->value,
							'percentage'         => $cardaddon->percentage,
						];
					}
					$params['addon'] = $addons; // Add the addons to the card attribute
					$card_attr[] = $params; // Add the card attribute to the array
				}

				// Include the card attributes inside the card data
				$card_data['card_attribute'] = $card_attr;

				// Add card data to the main $cards array
				$cards_detail[] = $card_data;
				$coupon_amount  = (int) $value->coupon_amt;
				$tip_amount     = (int) $value->tip_id;
				
				// Update total amount
				$total_amount += (float) $value->amount;
			}

			$cards['card'] = $cards_detail;

			$cards['sub_total']         = (string) $total_amount;
			$cards['coupon_status']     = (string) "no";
			$cards['tip_status']     = (string) "no";
			if($request->is_coupon){
				$cards['coupon_amount']     = (string) $coupon_amount;
				$cards['coupon_status']     = "yes";
				$total_amount -= $coupon_amount;
			}
			if ($request->is_tip && $tip_amount > 0) {
				$cards['tip_amount'] = (string) $tip_amount;
				$cards['tip_status'] = "yes";
				$total_amount += $tip_amount;
			} else {
				$cards['tip_amount'] = (string) $tip_amount;
				$cards['tip_status'] = "no";
			}
			
			$cards['user_balance']  = auth()->user()->wallet_balance;
			$rewardData = $this->get_reward_price($total_amount);

			if ($rewardData !== null) {
				$cards["remaining_reward_points"] = (string) $rewardData['remaining_reward_points'];
				$cards["reward_amount"] = (string) $this->get_reward_price($total_amount)['final_amount'];
				$cards['total']         = (string) ((float) $total_amount - (float) $this->get_reward_price($total_amount)['final_amount']);
			} else {
				$cards["remaining_reward_points"] = '0'; 
				$cards["reward_amount"] = '0'; 
				$cards["total"] = (string) $total_amount; 
			}
		
			return view('web.my_booking', [
				'cartItems' => $cards,
				'card'=>$card
			]);
		} else {
			return $this->sendError('Invalid booking id');
		}
	}

	public function myorders_old()
	{
		if(Auth::check()){
			$data['cards'] = Card::where('user_id',Auth::user()->id)->where('card_process','Complete')->orderBy('id', 'DESC')->get();

			$data['slot'] = Slot::get();
			return view('web.orders',$data);
		} else {
			return back()->with('error','Login First.');
		}
	}

	public function draftbookings()
	{
		if(Auth::check()){
			$data['cards'] = Card::where('user_id',Auth::user()->id)->where('payment_status','Draft')->orderBy('id', 'DESC')->get();

			return view('web.draftbookings',$data);
		} else {
			return back()->with('error','Login First.');
		}
	}

	public function confirm_order(Request $request)
	{
		error_reporting(E_ALL);
ini_set('display_errors', '1');
		$card = Card::where('id',\Session::get('booking_id'))->where('payment_status','True')->where('is_checkout','Done')->first();
		//print_r($card->toArray());
		if($card){

			if($card->user && $card->user->email){
				$array['view']      = 'emails.invoice';
		        $array['subject']   = 'Your Booking Invoice';
		        $array['data']      = $card;
		        try{
		        	\Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
				}catch(\Exception $e){
					print_r($e->getMessage());
						// Get error here
				}
			}

	        $adminarray['view']      = 'emails.invoice';
	        $adminarray['subject']   = 'You Have New Service Booking';
	        $adminarray['data']      = $card;
	       try{
	        \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));
			}catch(\Exception $e){
					//print_r($e->getMessage());
						// Get error here
				}
//echo "here"; exit;
	        $tran_id = normalizeId($card->tran_id);
	        $message = "Congratulation! You have successfully booked service with UrbanMop. \nYour booking ID is $tran_id \nView booking on UrbanMop \nhttps://www.urbanmop.com \nFor any assistance contact UrbanMop helpline at 052 618 8291 \ 058 581 4007 or send email at booking@urbanmop.com";
			$msg = urlencode($message);
			if($card->user && $card->user->phone){

				$mobile = $card->user->phone;
				$res=send_sms_to_mobile($mobile,$msg);

			}

			$ser_users = get_seller_info_by_service($card?$card->service_id:'');
	        if($ser_users){
	        	foreach ($ser_users as $key => $value) {
		            if(isset($value->device_token)){
		            	
		                $token 	= $value->device_token;

		                $service = $card->service?$card->service->name:'No Service';
		                           
		                $title  = 'New Booking Arrived';
		                $body   = "Heads up! A new booking just came in Urbanmop Partner App for '.$service.' Don't miss out on this chance to earn extra money.";
		                $text   = "Heads up! A new booking just came in Urbanmop Partner App for '.$service.' Don't miss out on this chance to earn extra money.";

		                $data = send_notification($token, $title, $body, $text);
		            }
		        }
	        }			

			$dataReturn['card'] = $card;

			$dataReturn['is_checkout'] = 'Done';
			
			return view('web.confirm_order',$dataReturn);
		} else {
			return back()->with('error','Some Thing Want Wrong.');
		}

		
	}

	public function apply_coupon(Request $request)
	{
		if($request->coupon_code == 0){
			
			$data['msg'] 	= 'Coupon Cleared';
			$data['status'] = 'True';
			return $data;
		}
		$coupon = Coupon::where('code',$request->coupon_code)->where('status','1')->first();

		$coupon_use = UserCoupon::where('user_id',Auth::user()->id)->where('coupon_id',$coupon->id)->count();
		if($coupon){
			$card = Card::find($request->card_id);
			if($coupon->id==$card->coupon_id){
				$data['msg'] 	= 'This Coupon Already Applied';
				$data['status'] = 'False';
			} else {
				if($coupon_use < $coupon->user_used){
					if($coupon->start_date<=date('Y-m-d') && $coupon->end_date>=date('Y-m-d') ){
						if($card->coupon_id){
							$total = $card->amount;
						} else {
							$total = $card->g_total;
						}
		              	$old_amt = $total;

		              	$total -= $card->tip_id;
		              	
		              	$total -= $card->cod_charge;

		              	if($total > $coupon->min_amount){
		              		if($coupon){
		              			
				                $amount = $coupon->amount;
				                if($coupon->type=='Amt'){
				                  $coupon_Amt = $amount;
				                } else {
				                  	$per = ($amount / 100) * $total;

				                  	if($per>$coupon->max_amount){
				                  		$coupon_Amt = $coupon->max_amount;
				                  	} else {
				                  		$coupon_Amt = price_format($per);
				                  	}

				                }
			              	} else {
				                $coupon_Amt = '00';
			              	}
			              	$params['before_coupon_amt'] = $old_amt;
			              	$old_amt -= $coupon_Amt;
			              	$params['coupon_amt'] 	= $coupon_Amt;
			              	$params['g_total'] 		= $old_amt;
							$params['coupon_id'] 	= $coupon->id;
							$card->update($params);

							$crd_coupon['card_id'] 		= $request->card_id;
							$crd_coupon['coupon_id'] 	= $coupon->id;
							$crd_coupon['code'] 		= $coupon->code;
							$crd_coupon['amount'] 		= $coupon->amount;
							$crd_coupon['min_amount'] 	= $coupon->min_amount;
							$crd_coupon['max_amount'] 	= $coupon->max_amount;
							$crd_coupon['type'] 		= $coupon->type;
							$crd_coupon['start_date'] 	= $coupon->start_date;
							$crd_coupon['end_date'] 	= $coupon->end_date;

							if(CardCoupon::where('card_id',$request->card_id)->exists()){
								CardCoupon::where('card_id',$request->card_id)->update($crd_coupon);
							} else {
								CardCoupon::create($crd_coupon);
							}							

							$data['card_amt'] 	= $card->g_total;
							$data['amt'] 	= $coupon_Amt;
							$data['msg'] 	= 'Coupon Apply Successfully';
							$data['status'] = 'True';
							$data['service_id'] = $card->service_id;
		              	} else {
		              		$data['msg'] 	= "This coupon's minimum amount is less than your total";
							$data['status'] = 'False';
		              	}
					} else {
						$data['msg'] 	= 'Coupon Expired';
						$data['status'] = 'False';
					}
				} else {
					$data['msg'] 	= 'Coupon Usage Limit Exceeded';
					$data['status'] = 'False';
				}
			}
			
		} else {
			$data['msg'] 	= 'Invalid Coupon';
			$data['status'] = 'False';
		}
		return $data;
	}

	public function remove_coupon(Request $request)
	{
		$card = Card::find($request->card_id);

		if($card){
			$params['g_total'] 		= $card->before_coupon_amt;
			$params['coupon_id'] 	= null;
			$params['coupon_amt'] 	= null;
			$card->update($params);

			CardCoupon::where('card_id',$request->card_id)->delete();

			$data['msg'] 	= 'Coupon Remove Successfully';
			$data['status'] = 'True';
			$data['service_id'] = $card->service_id;
		} else {
			$data['msg'] 	= 'Data Not Found!';
			$data['status'] = 'False';
		}
		return $data;
	}

	public function pay_tip(Request $request)
	{
		$card = Card::find($request->card_id);
		if($card->tip_id && isset($card->tip_id)){
			$params['tip_id'] 	= $request->tip;
			$gottal = $card->g_total-$card->tip_id;
			$params['g_total'] 	= $gottal+$request->tip;
			$params['amount'] 	= $gottal+$request->tip;

		} else {
			$params['tip_id'] 	= $request->tip;
			$params['g_total'] 	= $card->g_total+$request->tip;
			$params['amount'] 	= $card->g_total+$request->tip;
		}
		
		$card->update($params);
		$carddata['service_id'] = $card?$card->service_id:'';
		
        return array(
            'modal_view' => view('web.cart_details',$carddata)->render(),
        );
	}

	public function cod_charge(Request $request)
	{
		$setting = HomeSetting::first();
		$codamt  = $setting?$setting->cash_surcharge:'0';

		$card = Card::find($request->card_id);
		
		$params['payment_moad'] = $request->moad;
		if($request->moad=='Cash'){
			$params['cod_charge'] 	= $codamt;
			$params['g_total'] 	= $codamt+$card->g_total;
			$params['amount'] 	= $codamt+$card->g_total;
		} else {
			$params['cod_charge'] 	= '0';
			$params['g_total'] 	= $card->g_total-$card->cod_charge;
			$params['amount'] 	= $card->g_total-$card->cod_charge;
		}
		$card->update($params);
		$carddata['service_id'] = $card?$card->service_id:'';
		
        return array(
            'modal_view' => view('web.cart_details',$carddata)->render(),
        );
	}

	public function myaddress()
	{
		if(Auth::check()){
			$data['address'] 	= Address::where('user_id',Auth::user()->id)->orderBy('id', 'DESC')->get();
			$data['city'] 		= City::all();
			$data['locality'] 	= Locality::get();
			return view('web.address',$data);
		} else {
			return back()->with('error','Login First.');
		}
	}

	public function get_locality(Request $request)
	{
		$locality = Locality::where('city_id',$request->city_id)->orderBy('name','asc')->get();
        
        $data['locality'] = $locality;
        return array(
            'modal_view' => view('web.locality',$data)->render(),
        );
	}

	public function editaddress($id)
	{
		$data['address'] = Address::find($id);
		$data['city'] = City::all();
		$data['locality'] = Locality::get();
		return view('web.edit_address',$data);
	}

	public function update_locations($address_id = '')
	{
		$user = auth()->user();
		$user_addresses = Address::where('user_id', $user->id)->get();
	
		foreach ($user_addresses as $address) {
			$address->update(['is_active' => 0]);
		}
	
		$address = Address::with(['city', 'locality_info'])->find($address_id); // Eager load city and locality
	
		if ($address) {
			$address->update(['is_active' => 1]);
	
			return response()->json([
				'success' => 1,
				'message' => 'Address updated successfully',
				'data' => [
					'id' => $address->id,
					'address_type' => $address->address_type,
					'flat_no' => $address->flat_no,
					'building' => $address->building,
					'city_name' => $address->city->name ?? 'N/A',
					'is_active' => $address->is_active,
					'locality_name' => $address->locality_info->name ?? 'N/A',
				]
			], 200);
		} else {
			return response()->json([
				'success' => 0,
				'error' => 'Address not found'
			], 404);
		}
	}
	
	public function wallet_init(Request $request)
	{
		$status = "0";
		$o_data = [];
		$errors = [];
		$message = "Failed to recharge the wallet";
		
		$user_id = auth()->user()->id;
		if (!$user_id) {
			$message = "Session expired, please login to continue.";
			return response()->json([
				'status' => $status,
				'message' => $message,
				'data' => (object)$o_data,
				'errors' => (object)$errors
			], 401);
		}
	
		$validator = Validator::make($request->all(), [
			'amount' => 'required|numeric|min:1',
			'payment_type' => 'required|integer|min:1',
		]);
	
		if ($validator->fails()) {
			$status = "0";
			$message = "Validation error occurred";
			$errors = $validator->messages();
		} else {
			$user = User::find($user_id);
	
			// \Stripe\Stripe::setApiKey('sk_test_51KdqxdBjsMxFtgBedbg8geva4BTxE3rcJrjCY2YCYblxn8hcEC2l7mIIPMClBWzyPdOWbNyUKSFjLo7Sl9ZI7Ujf00jVnhJDUA');
	
			$user = auth()->user();
			$amount = $request->amount;
			$invoiceId = uniqid();

	
			// $session = \Stripe\Checkout\Session::create([
			// 	'payment_method_types' => ['card'],
			// 	'line_items' => [[
			// 		'price_data' => [
			// 			'currency' => 'aed',
			// 			'product_data' => [
			// 				'name' => 'Wallet Recharge',
			// 			],
			// 			'unit_amount' => $request->amount * 100,
			// 		],
			// 		'quantity' => 1,
			// 	]],
			// 	'mode' => 'payment',
			// 	'success_url' => route('wallet.success', ['invoice_id' => $invoice_id]),
			// 	'cancel_url' => route('wallet.cancel'),
			// ]);

			$client = new \GuzzleHttp\Client();

			$storeId = config('app.telr_store_id', env('TELR_STORE_ID'));
			$authKey = config('app.telr_auth_key', env('TELR_AUTH_KEY'));
			if($storeId == null){
				$storeId = 31478;
				$authKey = "38mH@T7FfN^NJzmk";
			}
			$successUrl = route('wallet.success', ['invoice_id' => $invoiceId]);
			$cancelUrl = route('wallet.cancel', ['transaction_id' => $invoiceId]);
			$declineUrl = route('wallet.cancel', ['transaction_id' => $invoiceId]);
		
			// Prepare the payload
			$payload = [
				'ivp_method' => 'create',
				'ivp_store' => $storeId,
				'ivp_authkey' => $authKey,
				'ivp_amount' => $amount,
				'ivp_currency' => 'AED',
				'ivp_test' => 0, 
				'ivp_desc' => 'Wallet Recharge',
				'return_auth' => $successUrl,
				'return_can' => $cancelUrl,
				'return_decl' => $declineUrl,
				'ivp_cart' => $invoiceId,
				'bill_fname' => $user->first_name,
				'bill_sname' => $user->last_name,
				'bill_email' => $user->email,
				'bill_country' => $user->country_code,
				'bill_phone' => $user->phone,
			];
	
			// Send the request to Telr
			$response = $client->post('https://secure.telr.com/gateway/order.json', [
				'form_params' => $payload,
			]);
	
			$responseData = json_decode($response->getBody(), true);

			if (isset($responseData['order']['url'])) {
				$paymentreport = [
					'transaction_id' => $invoiceId,
					'payment_status' => 'P',
					'user_id' => $user->id,
					'ref_id' => $responseData['order']['ref'],
					'amount' => $request->amount,
					'method_type' => $request->payment_type,
					'created_at' => gmdate('Y-m-d H:i:s'),
				];
		
				$checkoutUrl = $responseData['order']['url'];
				WalletPaymentReport::insert($paymentreport);
				$o_data['payment_ref'] = $responseData['order']['ref'];
				$o_data['invoice_id'] = $invoiceId;
				$o_data['checkout_url'] = $checkoutUrl;
				$message = "Wallet Recharge (via App)";
				$status = "1";
			}
		}
	
		return response()->json([
			'status' => $status,
			'message' => $message,
			'errors' => (object)$errors,
			'oData' => (object)$o_data
		]);
	}
	

	public function wallet_recharge($invoice_id)
	{
		$status = "0";
		$message = "Failed to recharge the wallet";
		$errors = [];
		$o_data = [];
	
		$user_id = auth()->user()->id;
	
		if (!$user_id) {
			$message = "Session expired, please login to continue.";
			return redirect()->route('login')->with('error', $message);
		}
	
		$payment = WalletPaymentReport::where([
			'transaction_id' => $invoice_id,
			'user_id' => $user_id,
			'payment_status' => 'P',
		])->first();
	
		if ($payment) {
			try {
				// \Stripe\Stripe::setApiKey('sk_test_51KdqxdBjsMxFtgBedbg8geva4BTxE3rcJrjCY2YCYblxn8hcEC2l7mIIPMClBWzyPdOWbNyUKSFjLo7Sl9ZI7Ujf00jVnhJDUA');
	
				// $session = \Stripe\Checkout\Session::retrieve($payment->ref_id);

				$client = new \GuzzleHttp\Client();

				// Telr API endpoint to check payment status
				$response = $client->post('https://secure.telr.com/gateway/order.json', [
					'form_params' => [
						'ivp_method' => 'check',
						'ivp_store' => config('app.telr_store_id', env('TELR_STORE_ID')),
						'ivp_authkey' => config('app.telr_auth_key', env('TELR_AUTH_KEY')),
						'order_ref' => $payment->ref_id,
					],
				]);
		
				$responseData = json_decode($response->getBody(), true);
	
				// if ($session->payment_status === 'paid') {
				if (isset($responseData['order']['status']['code']) && $responseData['order']['status']['code'] == 3) { // Status code 3 indicates payment success
           
					$user = User::find($user_id);
					$user->wallet_balance += $payment->amount;
					if ($user->save()) {
                        $data = [
                            'user_id' => $user_id,
                            'wallet_amount' => $payment->amount,
                            'amount' => $payment->amount,
                            'pay_type' => 'RECHARGED',
                            'type' => 'debit',
                            'pay_method' => $payment->method_type,
                            'description' => 'Wallet Top up ',
                        ];

                        if (wallet_history($data)) {
							$payment->update(['payment_status' => 'A']);
							$status = "1";
                            $message = "Wallet recharged successfully";
                        }
                    }
	

					$status = "1";
					$message = "Wallet recharged successfully";
	
					return redirect()->route('my-wallet')->with('success', $message);
				} else {
					$message = "Payment not completed yet.";
				}
			} catch (\Exception $e) {
				$message = $e->getMessage();
			}
		} else {
			$message = "No pending payment found.";
		}
	
		return redirect()->route('my-wallet')->with('error', $message);
	}
	
	public function update_location(Request $request)
	{
		$data = [];

		$user_addresses = Address::where('user_id', auth()->user()->id)->get();

		foreach ($user_addresses as $addresses) {
			$addresses->update(['is_active' => 0]);
		}
		
		$address = Address::find($address_id);            
	 
		if ($address) {
			$address->update(['is_active'=>1]);
		
			return redirect()->back()->with('success', 'Address updated successfully.');
		} else {
			return redirect()->back()->with('error', 'Failed to update address. Please try again.');
		}
	}

	public function update_address(Request $request)
	{
		// Prepare the data for updating the address
		$addressData = [
			'address_type' => $request->address_type_edit,
			'flat_no' => $request->plot_off_no,
			'building' => $request->building_name,
			'locality' => $request->locality,
			'city_id' => $request->emirate,
			'address'=>$request->address_edit,
			'latitude'=>$request->latitude,
			'longitude'=>$request->longitude
		];
       $res = Address::where('id', $request->id)->update($addressData);
		// Update the address
		// Redirect back with a success or error message
		if ($res) {
			return redirect()->back()->with('success', 'Address updated successfully.');
		} else {
			return redirect()->back()->with('error', 'Failed to update address. Please try again.');
		}
	}

	public function removeaddress($id='')
	{
		Address::where('id',$id)->delete();
		return back()->with('success','Delete Successfully.');
	}

	public function store_address(Request $request)
	{
		$address['user_id'] 		= Auth::user()->id;
        $address['address'] 		= $request->address;
        $address['address_type'] 	= $request->address_type;
        $address['flat_no'] 		= $request->flat_no;
        $address['building'] 		= $request->building;
        $address['locality'] 		= $request->locality;
        $address['city_id'] 		= $request->city_id;

        $res = Address::create($address);
        if($res){
        	return back()->with('success','Create Successfully.');
        } else {
        	return back()->with('error','Try Again.');
        }        
	}

	public function update_slot(Request $request)
	{
		$params['slot_id'] 	= $request->slot_id;
		$params['date'] 	= $request->date;
		Card::where('id',$request->card_id)->update($params);

		$card = Card::find($request->card_id);

		if($card->user && $card->user->email){
			$array['view']      = 'emails.change_slot_customer';
	        $array['subject']   = 'Slot Changed';
	        $array['data']      = $card;
	        
	        \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
	    }

	    if($card->vendor && $card->vendor->email){
			$array['view']      = 'emails.change_slot_customer';
	        $array['subject']   = 'Slot Changed';
	        $array['data']      = $card;
	        
	        \Mail::to($card->vendor?$card->vendor->email:'')->send(new \App\Mail\Mail($array));
	    }

		$adminarray['view']      = 'emails.change_slot_admin';
        $adminarray['subject']   = 'Slot Changed';
        $adminarray['data']      = $card;
       
        \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));

		return back()->with('success','Slot Update Successfully.');
	}

	public function subAttribute(Request $request)
	{
		if(\Session::has('user_id')){
			$data['user_id']            = \Session::get('user_id');
	        $data['service_id']         = $request->service_id;
	        $ser_info = Service::find($request->service_id);
	        $data['service_name']       = $ser_info->name;
	        $data['category_id']        = $request->category_id;
	        $data['date']               = date('Y-m-d');
	        // $data['tran_id']            = 'UM-'.mt_rand(1000,99999);
	        $data['service_type']       = 'Maid';
	        $data['material_status']	= 'Not';
	        $data['material_charge']	= '';

	        $valItems = ServiceAttributeValue::find($request->item_id);
	        if(Card::where('user_id',\Session::get('user_id'))->where('service_id',$request->service_id)->where('service_type','Maid')->where('status','Pending')->where('payment_collected','No')->where('is_checkout','Processing')->where('work_done','No')->count()>0){
	        	$card = Card::where('user_id',\Session::get('user_id'))->where('is_checkout','Processing')->where('service_id',$request->service_id)->where('service_type','Maid')->where('status','Pending')->where('payment_collected','No')->where('work_done','No')->first();
	        	$dataupdate['g_total']      = $valItems->attribute_price;
	        	$gtotal 					= $valItems->attribute_price+$card->g_total;
	        	$card->update($dataupdate);
	        } else {
	        	$data['g_total']  	= $valItems->attribute_price;
	        	$gtotal 			= $valItems->attribute_price;
	        	$card = Card::create($data);
	        }
	        
	        if($card){
	        	
	        	$params['card_id']              = $card->id;
	            $params['attribute_id']         = $valItems->attribute_item_id;
	            $params['attribute_name']       = $valItems->attributeItem?$valItems->attributeItem->value:'';
	            $params['attribute_item_id']    = $request->attribute_item_id;
	            $params['attribute_item_name']  = '';
	            $params['attribute_price']      = $valItems->attribute_price;
	            $params['attribute_qty']        = '1';
	            $params['service_type']        	= 'Maid';

	            $qty = '1';

	            if(CardAttribute::where('card_id',$card->id)->count()>0){
	            	$cardattr = CardAttribute::where('card_id',$card->id)->first();	            	
	            	$cardattr->update($params);
	            } else {
	            	$cardattr = CardAttribute::create($params);
	            }
	            
	        }
	        $response['service'] = Service::find($request->service_id);
	        $response['serviceItem'] = ServiceAttributeValueItem::where('service_id',$request->service_id)->where('id', '!=' , $request->ser_attr_item_id)->first();
			$response['ser_attr_item_id'] = $request->ser_attr_item_id;
			$response['card_id'] = $card->id;
			$response['card_attribute_id'] = $cardattr->id;
	       return array(
	            'modal_view' => view('web.sub_attribute',$response)->render(),
	        );
	    } else {
	    	return back()->with('error','Login First.');
	    }		
	}

	public function updateSubAttribute(Request $request)
	{
		$card 			= Card::find($request->card_id);
		$card_atr 		= CardAttribute::where('id',$request->card_attribute_id)->first();
		$service_atr 	= ServiceAttributeValue::find($request->attribute_detail_id);
		$ftotal 		= $card_atr->attribute_price*$service_atr->attribute_price;

		$card_info['material_status']	= 'Not';
        $card_info['material_charge']	= null;
		$card_info['g_total'] = $ftotal;
		$card->update($card_info);

		// $card_atr_info['attribute_price'] 		= $ftotal;
		$card_atr_info['attribute_qty'] 		= $service_atr->attribute_price;
		$card_atr_info['attribute_item_id'] 	= $service_atr->attributeItem?$service_atr->attributeItem->id:'';
		$card_atr_info['attribute_item_name'] 	= $service_atr->attributeItem?$service_atr->attributeItem->value:'';
		$card_atr->update($card_atr_info);

		$service = Service::find($card?$card->service_id:'');
		if($service){
			$peramt = ($service->material_price * $ftotal) / '100';
		} else {
			$peramt = '00';
		}
		
		$response['card_id'] = $card?$card->id:'';
		return array(
			'peramt' => $peramt,
            'modal_view' => view('web.sub_attribute_card',$response)->render(),
        );
	}

	public function update_material_charge(Request $request)
	{
		$card = Card::find($request->card_id);
		$params['material_status'] = $request->status;
		if($request->status=='Not'){
			$params['material_charge'] = '0';
			$params['g_total'] = $card->g_total-$card->material_charge;
			$card->update($params);
		} else {
			$params['material_charge'] = $request->material_amt;
			$params['g_total'] = $request->material_amt+$card->g_total;
			if($card->material_status=='Not'){
				$card->update($params);
			}
		}
	
		
		$response['card_id'] = $request?$request->card_id:'';
		return array(
			'peramt' => $request->material_amt,
            'modal_view' => view('web.sub_attribute_card',$response)->render(),
        );
	}

	public function get_selected_price(Request $request)
    {
    
        $data = [];
        $totalAmount = 0;
        $apply = $request->apply;
        $service = Service::find($request->service_id);
        $material_default = ($request->material_status == "Apply") ? (float) $service->material_price : 0;
        $material_total = 0;
        $material = 0;
        $total_hours = 0;
        $total_hour = 1;
        $total_count = 1;
        $total_maids = 0;
        $total_maids_material = 1;
		$singlePrice = $service->price ?? 0;
		$c = 0;
        if(isset($request->item_object)){
            $data["service_name"] = $service->name;
            $c = 0;
            foreach (json_decode($request->item_object) as $key => $value) {
                if(empty($value->sub_category_id)){
                    $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                    $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                    $attribute = Attribute::where('id',$services->attribute_id)->first();
                    $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                    
                    $params['attribute_price']      = $services->attribute_price ?? null;
                    $params['attribute_qty']        = $value->attribute_qty ?? null;
                    $params['service_type']         = '';
                    
                    $data["attribute"][] = [
                        "category"=>Category::find($service_item->category_id)->name,
                        "name"=>$attribute_item->value,
                        "price"=>(string) $services->attribute_price,
                    ];
                    $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                    
                    if($attribute->name == 'Hours'){
                        $totalAmount *= (int) $attribute_total; 
						$total_hours *= (int) $attribute_total; 
                    } else {
						$total_maids += $attribute_total; 
                        $totalAmount += $attribute_total; 
                    }
                    
                    preg_match('/\d+/', $attribute_item->value, $matches);

                    if (count($matches) > 0) {
                        $number = (int) $matches[0];
                        $total_count *= $number;
                    
						$total_maids_material *= $number;
                        if ($attribute->name == 'Hours') {
							$total_hour *= $number;
                        }
                    }

                } else {
                    if(empty($value->child_category_id)){
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$request->service_id,
                            'category_id'=>$value->category_id,
                            'sub_category_id'=>$value->sub_category_id
                        ])->first();
                    } else{
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$request->service_id,
                            'category_id'=>$value->category_id,
                            'sub_category_id'=>$value->sub_category_id,
                            'child_category_id'=>$value->child_category_id,
                        ])->first();
                    }
                    if(!empty($service_item)){
                        $services = ServiceAttributeValue::where([
                            'ser_attr_val_item_id'=>$service_item->id,
                            'attribute_item_id'=>$value->attribute_item_id,
                        ])->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
    
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name,
                            "sub_category"=>Category::find($service_item->sub_category_id)->name,
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price];
                    
                        
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
						if($attribute->name == 'Hours'){
							
							$totalAmount *= (int) $attribute_total; 
							$total_hours *= (int) $attribute_total; 
						} else {
							
							$total_maids += (int) $total_maids; 
							$totalAmount += $attribute_total; 
						}

                        preg_match('/\d+/', $attribute_item->value, $matches);

                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
							$total_count *= $number;
                        
							$total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
								$total_hour *= $number;
                            }
                        }
                        
                    } 
                    $params['service_type']         = '';
                }
            } 
            
        }     
        if($service->id == 10){
			    $material_total = $total_maids_material;
		} 
		if(auth()->user()){
		    
    		$card_info = Card::where('user_id', auth()->user()->id)
    			->where('service_id', $request->service_id)
    			->where('status', 'Pending')
    			->where('payment_collected', 'No')
    			->where('work_done', 'No')
    			->where('is_checkout', 'Processing')
    			->orderBy('id', 'DESC')
    			->first();
		}else{
		    
    		$card_info = Card::where('service_id', $request->service_id)
    			->where('status', 'Pending')
    			->where('payment_collected', 'No')
    			->where('work_done', 'No')
    			->where('is_checkout', 'Processing')
    			->orderBy('id', 'DESC')
    			->first();
		}

		
			$material = ($request->material_status == "Apply") ? (float) $material_total : 0;
        
        $data["total_hours"] = (string) $total_hour;
        $data["total_maids"] = (string) $total_maids;
        $maids_hour_count = $total_count;
        $data['maids_hour_count'] = (string)$maids_hour_count;
		$package_amount = 0;
		if($request->service_id == "10"){
            
            if(isset($request->package_id) ){    
                $totalAmount = 0;            
                $selectedPackageIds = explode(',', $request->package_id);

                $packages = Packages::whereIn('id', $selectedPackageIds)->get();

                foreach ($packages as $package) {
					$material *= ((int) $package->total_sessions);
                    $data["packages"][] = [
                        "name"=>$package->name, 
                        "base_amount"=>(string) ((int) $package->amount * (int) $total_count),
                        "price"=>(string) ((int) $package->amount * (int) $total_count + ($material * $material_default)),
                        "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count + ($material * $material_default))
                    ]; 
					$package_amount = $package->amount* (int) $total_count;
					$data["package_free_sessions"] = $package->free_sessions;
					$data["package_per_week_sessions"] = $package->per_week;
					$data["package_total_sessions"] = (int) $package->total_sessions;
					// $data["package_total_sessions_sub_total"] = $package->amount * ((int) $package->total_sessions + (int) $package->free_sessions);
					$data["package_total_sessions_sub_total"] = ((float) $package->amount * (int) $total_count) + ($material * $material_default);
					// $data["package_free_sessions_sub_total"] = $package->amount * (int) $package->free_sessions;
					$data["package_free_sessions_sub_total"] = (float) $package->save_amount * (float) $total_maids_material;
                    // $totalAmount = (int) $package->amount * ((int) $package->total_sessions); 
                    $totalAmount = (float) ($package->amount*(float) $total_count); 
                }
            }

        }

        $data["sub_total"] = (string) ((int) $total_maids * $total_hour);
		$material *= $material_default;
        $totalAmount += $material;

        $data["material_default"] = (string) $material_default;
        $data["material"] = (string) $material;
        $data["package_amount"] = (string) $package_amount;
        $data["total_amount"] = (string) $totalAmount;
        $data["single_price"] = (string) $singlePrice;
        
        if($request->material_status == "Apply"){
             $data['packages'] = Packages::where(['service_id' => 10, 'status' => '1'])
            ->get()
            ->map(function ($package) use ($maids_hour_count,  $material_default) {
                
                $package->amount =  ( $package->amount * $maids_hour_count ) + ($material_default * $maids_hour_count * $package->total_sessions ); 
                $package->save_amount = ( ($package->amount / $package->total_sessions) * $package->free_sessions); 
                
                return $package;
            })
            ->sortBy(function ($package) {
                return (int) $package->amount;
            })
            ->values();
            
        } else {
            
             $data['packages'] = Packages::where(['service_id' => 10, 'status' => '1'])
            ->get()
            ->map(function ($package) use ($maids_hour_count) {
                $package->amount = (int) $package->amount * (int) $maids_hour_count; 
                $package->save_amount = ( ($package->amount / $package->total_sessions) * $package->free_sessions); 
                return $package;
            })
            ->sortBy(function ($package) {
                return (int) $package->amount;
            })
            ->values();
        }
        
        $package_view = view('web.inc_package_list',['packages'=>$data['packages'],'card_info'=>$card_info,'selected_package_id'=>$request->package_id??0])->render();
  
		return array(
			'data' => $data,
			'package_view'=>$package_view
		);
    }


	public function getLocation(Request $request)
	{
		$apiKey = 'AIzaSyBvGq8LjejiKHaI5lPEUZVYbwOYSwhZMEs';

		// Retrieve the search query from the form submission
		$location = $_POST['req'];

		// Prepare the URL for the Places Autocomplete API request
		$url = 'https://maps.googleapis.com/maps/api/place/autocomplete/json?input=' . urlencode($location) . '&key=' . $apiKey;

		// Make the API request using cURL
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($curl);
		curl_close($curl);

		// Decode the JSON response
		$data = json_decode($response, true);
		return $data;

	}

	public function store_question(Request $request)
	{
		$data['mobile_no'] = $request->mobileno;
        Question::create($data);
        return back()->with('success','Your Question Successfully Submit.');
	}

	public function payment($booking_id)
	{
		$card = Card::find($booking_id);
		\Session::put('booking_id',$booking_id);
		if($card){
			$amount = $card->g_total;
			$booking_id = $card->tran_id;
			$return_url = \URL::to('/paymentsuccess');
			$failure_return_url = \URL::to('/paymentfailure');
			$service = $card->service?$card->service->name:'NA';
			
			$client = new \GuzzleHttp\Client();

			$response = $client->request(
				'POST', 
				'https://business.mamopay.com/manage_api/v1/links', 
				[
			  		'body' => '{
			  			"name":"UrbanMop",
			  			"description":"'.$service.'",
			  			"capacity":1,
			  			"active":true,
			  			"return_url":"'.$return_url.'",
			  			"failure_return_url": "'.$failure_return_url.'",
			  			"processing_fee_percentage":0,
			  			"amount":"'.$amount.'",
			  			"amount_currency":"AED",
			  			"is_widget":false,
			  			"enable_tabby":false,
			  			"enable_message":false,
			  			"enable_tips":false,
			  			"enable_customer_details":false,
			  			"enable_quantity":false,
			  			"enable_qr_code":false,
			  			"send_customer_receipt":false,
						"external_id":"'.$booking_id.'"}',
				  	'headers' => [
					    'Authorization' => 'Bearer sk-3b63062a-a66c-40af-b877-7eda10ce1d32',
					    'accept' => 'application/json',
					    'content-type' => 'application/json',
				  	],
			]);

			$data = $response->getBody();
			$fdata = json_decode($data, true);
			
			return redirect($fdata['payment_url']);
		} else {
			return back()->with('error','Try Again.');
		}
		
	}

	public function paymentsuccess(Request $request)
	{
		$crd_info = Card::where('id',\Session::get('booking_id'))->first();
		if($crd_info && $crd_info->is_checkout != 'Done'){

			if($request->status=='captured'){
	
				$data['paymentTranId'] 	= $request->transactionId;
				$data['paymentLinkId'] 	= $request->paymentLinkId;
				$data['payment_status'] = 'True';
				$data['is_checkout'] 	= 'Done';

				Card::where('id',\Session::get('booking_id'))->update($data);
				$card = Card::where('id',\Session::get('booking_id'))->first();

				if($card->user && $card->user->email){
					$array['view']      = 'emails.invoice';
			        $array['subject']   = 'Your Booking Invoice';
			        $array['data']      = $card;
			        
			        \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
			    }

				$adminarray['view']      = 'emails.invoice';
		        $adminarray['subject']   = 'You Have New Service Booking';
		        $adminarray['data']      = $card;
		       
		        \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));

		        $tran_id = normalizeId($card->tran_id);
		        $message = "Congratulation! You have successfully booked service with UrbanMop. \nYour booking ID is $tran_id \nView booking on UrbanMop \nhttps://www.urbanmop.com \nFor any assistance contact UrbanMop helpline at 052 618 8291 \ 058 581 4007 or send email at booking@urbanmop.com";
				$msg = urlencode($message);
				if($card->user && $card->user->phone){

					$mobile = $card->user->phone;
					$res=send_sms_to_mobile($mobile,$msg);

				}

				$home_set = HomeSetting::first();
				if($home_set && $home_set->admin_mobile){

					$admin_m_n = $home_set->admin_mobile;
					send_sms_to_mobile($admin_m_n,$msg);	

				}
				

				return redirect('confirm-order');
			} else {
				return back()->with('error','Payment Field Try Again.');
			}

		} else {
			return redirect('/');
		}
		
	}

	public function paymentfailure(Request $request)
	{
		$card = Card::where('id',\Session::get('booking_id'))->first();

		if($card){

			$data['paymentTranId'] 	= $request->transactionId;
			$data['paymentLinkId'] 	= $request->paymentLinkId;
			$data['payment_status'] = 'False';
			$data['is_checkout'] 	= 'Done';

			$card->update($data);

			if($card->user && $card->user->email){
				$array['view']      = 'emails.booking_faild_customer';
		        $array['subject']   = 'Your Booking Failed';
		        $array['data']      = $card;
		        
		        \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
		    }

			$adminarray['view']      = 'emails.booking_faild_admin';
	        $adminarray['subject']   = 'Booking Failed';
	        $adminarray['data']      = $card;
	       
	        \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));

			return redirect('failed');

		} else {

			return redirect('/')->with('error','Payment Field Try Again.');
		}
	}

	public function failed()
	{
		$data['card'] = Card::where('id',\Session::get('booking_id'))->first();
		if($data['card']){
			return view('web.failed',$data);
		} else {
			return redirect('/');
		}
		
	}

	public function blogs()
	{
		$data['blogs'] = Blog::where('status','1')->orderBy('id','DESC')->paginate(15);

		return view('web.blog',$data);
	}

	public function blog_details($id)
	{
		$data['blog'] = Blog::where('slug',$id)->first();

		if($data['blog']){
			return view('web.blog_details',$data);
		} else {
			return back();
		}
		
	}

	public function become_vendor()
	{
		$data['city'] = City::all();
		$data['services'] = Service::all();
		return view('web.vendor_form',$data);
	}

	public function store_vendor(Request $request)
	{
        

        if($request->is_registered=='Yes'){

        	$this->validate($request,[
	            'person_name' 	=> 'required|string|max:200',
	            'store_name' 	=> 'required|string|max:200',
	            'mobile_no' 	=> 'required',
	            'vat_no' 		=> 'required',
	            'email' 		=> 'required|email|unique:users,email',
	            'business_license' 		=> 'required',
	        ]);

        } else {
        	$this->validate($request,[
	            'person_name' 	=> 'required|string|max:200',
	            'store_name' 	=> 'required|string|max:200',
	            'mobile_no' 	=> 'required',
	            'email' 		=> 'required|email|unique:users,email',
	            'business_license' 		=> 'required',
	        ]);
        }

        $params['role']             = 'vendor';
        $params['name']             = $request->person_name;
        $params['email']            = $request->email;
        $params['dial_code']            = '971';
        $params['phone']            = $request->mobile_no;
        $params['city']            	= $request->city_id;
        $params['verify']           = 'True';
        $params['is_registered']    = 'Web';
        $params['is_active']        = 0;
        $params['is_registered']    = 1;
        $params['is_verified']      = 0;

        $user = User::create($params);

        if($user){
        	$seller['user_id']          = $user->id;
	        $seller['company_name']     = $request->store_name;
	        $seller['landline_no']      = $request->landline_number;
			$seller['dial_code']            = '971';
	        $seller['city']             = $request->city_id;
	        $seller['address']          = $request->address;
	        $seller['bank_name']        = $request->bank_name;
	        $seller['ac_holder_name']   = $request->ac_holder_name;
	        $seller['ac_number']        = $request->ac_number;
	        // $seller['contact_ac_no']    = $request->mobile_no;
	        $seller['status']           = '1';
	        $seller['is_registered']    = $request->is_registered;
	        $seller['vat_no']           = $request->vat_no;

	        if($request->hasFile('business_license')){
	            $imageName = time().'.'.$request->business_license->extension(); 
	            $path = $request->business_license->move(public_path('/uploads/vendor_document/'), $imageName);
	            $seller['licence_file'] = $imageName;
	        }
	        
	        if(Seller::where('user_id',$user->id)->count()>0){
	            Seller::where('user_id',$user->id)->update($seller);
	            $seller_info = Seller::where('user_id',$user->id)->first();
	        } else {
	           $seller_info = Seller::create($seller);
	        }
	        $serviceIds = [];
	        if($request->service_id){
	            foreach ($request->service_id as $key => $value) {
	                $sellerservice['seller_id'] = $seller_info->id;
	                $sellerservice['service_id'] = $value;
	                // if(!SellerService::where('seller_id',$seller_info->id)->where('service_id',$value)->count()>0){
	                    SellerService::create($sellerservice);
	                    $ssss = Service::find($value);
	                    array_push($serviceIds, $ssss?$ssss->name:'');
	                // }	                
	            }
	        }

	        $address['user_id'] 		= $user->id;
	        $address['address'] 		= $request->address;
	        $address['address_type'] 	= $request->address_type;
	        $address['flat_no'] 		= $request->flat_no;
	        $address['building'] 		= $request->building;
	        $address['locality'] 		= $request->locality;
	        $address['city_id'] 		= $request->city_id;

	        Address::create($address);

	        if ($seller_info) {
	        	if($request->email){
					$array['view']      = 'emails.vendor_created';
			        $array['subject']   = 'New Vendor Created';
			        $array['data']      = $seller_info;
			        
			        \Mail::to($request->email)->send(new \App\Mail\Mail($array));
			    }

				$adminarray['view']      = 'emails.vendor_created_admin';
		        $adminarray['subject']   = 'New Vendor Created';
		        $adminarray['data']      = $seller_info;
		       
		        \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));
	        }

	        return back()->with('success','Vendor create successfully.');	        
        } else {
        	return back()->with('error','Try Again.');
        }
        return back()->with('error','Try Again.');
	}

	public function get_live_address(Request $request)
	{
		$apiKey = 'AIzaSyBHrKkhwSDWrr45yqGAt2GjgF0adHLAkTU';

		$location = $request->location;

		$url = 'https://maps.googleapis.com/maps/api/place/autocomplete/json?input=' . urlencode($location) . '&key=' . $apiKey;

		// Make the API request using cURL
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($curl);
		curl_close($curl);

		// Decode the JSON response
		$data = json_decode($response, true);
		
		// Check if the response contains predictions
		$html = '';
		if ($data['status'] === 'OK') {
		    $predictions = $data['predictions'];

		    // Loop through the predictions and retrieve the place names
		    foreach ($predictions as $prediction) {
		        $placeName = $prediction['description'];
		        $html .= '<option value="' . $placeName . '">' . $placeName . '</option>';
		    }
		} else {
		     $html = '<option value="">No Data Found</option>';
		}
		$datas['res'] = $html;

		return $datas;
	}

	public function get_lat_long(Request $request)
	{
		$apiKey = 'AIzaSyBHrKkhwSDWrr45yqGAt2GjgF0adHLAkTU';

		$location = $request->location;

		$url = "https://maps.googleapis.com/maps/api/geocode/json?address=" . urlencode($location) . "&key=" . $apiKey;

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($ch);
		curl_close($ch);

		$data = json_decode($response, true);

		if ($data['status'] === 'OK') {
		    $res['latitude'] = $data['results'][0]['geometry']['location']['lat'];
		    $res['longitude'] = $data['results'][0]['geometry']['location']['lng'];
		    $res['status'] = '1';
		} else {
		    $res['status'] = '0';
		}
		return $res;
	}


    public function checkmobileno(Request $request)
    { 
    	if(User::where('phone',$request->phone)->where(['dial_code'=>'971'])->get()->count()>0){
	       	$data['status'] = "True";
    	} else {
    		$otp 	= mt_rand(1000, 9999);
    		$phone  = $request->phone;
	       
			$params['name'] = 'Guest';
	        $params['phone'] = $request->phone;
	        $params['password'] = $request->phone;
	        $params['registered_by'] = 'Web';
		    $params['is_verified'] = 1;
	        $params['is_active'] = 1;
	        $params['is_registered'] = 1;
	        $params['role'] = 'customer';
	        $params['verify'] = 'False';

	        $success = User::create($params);

    		$data['status'] = "True";

    	}
      
        return $data;
    }

	public function list()
	{
		$addresses = Address::with(['city', 'locality_info']) // Assuming these are the relationships
			->where('user_id', auth()->id())
			->orderBy('id', 'DESC')
			->get();

		// Add city_name and locality_name to each address in the response
		$addresses->transform(function ($address) {
			return [
				'id' => $address->id,
				'address' => $address->address,
				'address_type' => $address->address_type,
				'flat_no' => $address->flat_no,
				'building' => $address->building,
				'latitude' => $address->latitude,
				'is_active'=>$address->is_active,
				'longitude' => $address->longitude,
				'city_name' => $address->city->name ?? 'N/A', // Include city name
				'locality_name' => $address->locality_info->name ?? 'N/A', // Include locality name
			];
		});

		return response()->json($addresses);
	}


	public function send_sms(Request $request)
    {
    	// try {
		// 	$booking = Card::find(1);
		
		// 	// Check if booking exists
		// 	if (!$booking) {
		// 		throw new \Exception('Booking not found.');
		// 	}
		
		// 	$array['view']    = 'emails.booking_completed';
		// 	$array['subject'] = 'Rating on Booking';
		// 	$array['data']    = $booking;
		
		// 	// Validate email address
		// 	$email = 'arshadiqbal.d@gmail.com';
		// 	if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		// 		throw new \Exception('Invalid email address.');
		// 	}
		
		// 	\Mail::to($email)->send(new \App\Mail\Mail($array));
		
		// 	// Success response
		// 	return response()->json(['message' => 'Email sent successfully.'], 200);
		// } catch (\Exception $e) {
		// 	// Log the exception and return an error response
		// 	\Log::error('Failed to send email: ' . $e->getMessage());
		
		// 	return response()->json([
		// 		'message' => 'Failed to send email.',
		// 		'error' => $e->getMessage(),
		// 	], 500);
		// }
		

    	if(User::where('phone',$request->phone)->count()>0){
    		$otp 	= 1111; //mt_rand(1000, 9999);
    		$phone  = $request->phone;
	        // $msg 	= "OTP-".$otp;
	        // $msg = preg_replace('/[^A-Za-z0-9\-]/', '', $msg); // Remove spaces and special characters
  			$User['otp'] = $otp;
  	        User::where('phone',$request->phone)->update($User);

  	        $array['view'] 		= 'emails.otp';
            $array['subject'] 	= 'Your UrbanMop Login OTP';
            $array['data'] 		= $otp;
  	        // \Mail::to('user@gmail.com')->send(new \App\Mail\Mail($array));

	    	$message = "Your UrbanMop account LOGIN verification code is $otp \nDo not share this code with anyone for account safety.";
			$msg = urlencode($message);

	        $res=send_sms_to_mobile($phone,$msg);
	       	$data['status'] = "True";
	        
    	} else {
    		$data['status'] = 'false';
    		$data['msg'] = 'Your Mobile Number Does Not Exist.';
    	}
      
        return $data;
    }

    public function get_slot(Request $request)
    {
    	$slot = Slot::get();

    	$nowtime = date("H:i");
		
		$date = date('H:i', strtotime($nowtime . ' + 2 Hours'));

    	$html = '<option value="">Select Slot</option>';
        
        if($request->from=='current'){
        	foreach ($slot as $key => $row) {
	    		if($row->check_in > $date){
		    		$html .= '<option value="' . $row->id . '">' . $row->name . '</option>';
		    	}
	    	}
        } else {
        	foreach ($slot as $key => $row) {
		    	$html .= '<option value="' . $row->id . '">' . $row->name . '</option>';
	    	}
        }
    	
        echo $html;
    }

    // Tabby Work

    public function test_tabby()
    {
    	$params['order_id'] 		= '000001';
    	$params['customer'] 		= '000001'; // booking row id
    	$params['amount'] 			= '2000';
    	$params['customer_name'] 	= '';
    	$params['customer_phone'] 	= '';
    	$params['customer_email'] 	= '';
    	$params['customer_dob'] 	= '';
    	$params['items_array'] 		= '';

    	return $this->pay_by_tabby($params);
    }


    public function pay_by_tabby($request, $id)
    {
		$successUrl = route('payment.update', ['id' => $id]);
		$cancelUrl = route('checkout', ['transaction_id' => $request["order_id"]]);
	
		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://api.tabby.ai/registration/v1/sessions',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS =>'{
		  "lang": "en",
		  "merchant_code": "UMUAE",
		  "merchant_urls": {
		    "success": "'.$successUrl.'",
		    "cancel": "'.$cancelUrl.'",
		    "failure": "'.$cancelUrl.'"
		  },
		  "buyer": {
		    "phone": "'.$request["customer_phone"].'", 
            "email": "'.$request["customer_email"].'",
            "name": "'.$request["customer_name"].'",
		    "dob": "2019-08-24"
		  },
		  "buyer_history": {
		    "registered_since": "2019-08-24T14:15:22Z",
		    "loyalty_level": 0,
		    "wishlist_count": 0,
		    "is_social_networks_connected": true,
		    "is_phone_number_verified": true,
		    "is_email_verified": true
		  }
		}',
		  CURLOPT_HTTPHEADER => array(
		    'Authorization: Bearer sk_a8d65278-c694-419c-8bb0-17cbbf38a455',
		    'Content-Type: application/json',
		    'Cookie: _cfuvid=gDYieiE1Ewcg2iyAIcyDxeVxCdKPKEm7BQbfFz9ql3g-1703145517954-0-604800000'
		  ),
		));

		curl_exec($curl);

		curl_close($curl);
		


		$curl = curl_init();
		// return $request;
		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://api.tabby.ai/api/v2/checkout',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS =>'{
			    "payment": {
			        "amount": "'.$request["amount"].'", 
			        "currency": "AED", 
			        "description": "string",
			        "buyer": {
			            "phone": "'.$request["customer_phone"].'", 
			            "email": "'.$request["customer_email"].'",
			            "name": "'.$request["customer_name"].'",
			            "dob": "2019-08-24" 
			        },
			        "buyer_history": {
			            "registered_since": "2019-08-24T14:15:22Z", 
			            "loyalty_level": 0,
			            "wishlist_count": 0, 
			            "is_social_networks_connected": true,
			            "is_phone_number_verified": true, 
			            "is_email_verified": true 
			        },
			        "order": {
			            "tax_amount": "0.00",
			            "shipping_amount": "0.00",
			            "discount_amount": "0.00",
			            "updated_at": "2019-08-24T14:15:22Z",
			            "reference_id": "'.$request["order_id"].'",
			            "items": [
			                {
			                    "title": "string", 
			                    "description": "string", 
			                    "quantity": 1, 
			                    "unit_price": "'.$request["amount"].'", 
			                    "discount_amount": "0.00",
			                    "reference_id": "string",
			                    "image_url": "http://example.com",
			                    "product_url": "http://example.com",
			                    "gender": "Male",
			                    "category": "string",  
			                    "color": "string",
			                    "product_material": "string",
			                    "size_type": "string",
			                    "size": "string",
			                    "brand": "string"
			                }
			            ]
			        },
			        "order_history": [
			            {
			                "purchased_at": "2019-08-24T14:15:22Z", 
			                "amount": "'.$request["amount"].'", 
			                "payment_method": "card", 
			                "status": "new",
			                "buyer": { 
			                    "phone": "'.$request["customer_phone"].'", 
					            "email": "'.$request["customer_email"].'",
					            "name": "'.$request["customer_name"].'", 
			                    "dob": "2019-08-24" 
			                },
			                "shipping_address": {
			                    "city": "'.$request["shipping_city"].'",
			                    "address": "'.$request["shipping_address"].'",
			                    "zip": "string" 
			                },
			                "items": [
			                    {
			                        "title": "string",
			                        "description": "string",
			                        "quantity": 1,
			                        "unit_price": "'.$request["amount"].'", 
			                        "discount_amount": "0.00",
			                        "reference_id": "string",
			                        "image_url": "http://example.com",
			                        "product_url": "http://example.com",
			                        "ordered": 0,
			                        "captured": 0,
			                        "shipped": 0,
			                        "refunded": 0,
			                        "gender": "Male",
			                        "category": "string",
			                        "color": "string",
			                        "product_material": "string",
			                        "size_type": "string",
			                        "size": "string",
			                        "brand": "string"
			                    }
			                ]
			            }
			        ],
			        "shipping_address": {
			            "city": "'.$request["shipping_city"].'", 
			            "address": "'.$request["shipping_address"].'",
			            "zip": "00000" 
			        },
			        "meta": {
			            "order_id": "'.$request["order_id"].'", 
			            "customer": "00002" 
			        },
			        "attachment": {
			            "body": "{\\"flight_reservation_details\\": {\\"pnr\\": \\"TR9088999\\",\\"itinerary\\": [...],\\"insurance\\": [...],\\"passengers\\": [...],\\"affiliate_name\\": \\"some affiliate\\"}}",
			            "content_type": "application/vnd.tabby.v1+json"
			        }
			    },
			    "lang": "en", 
			    "merchant_code": "UMUAE", 
			    "merchant_urls": {
					"success": "'.$successUrl.'",
					"cancel": "'.$cancelUrl.'",
					"failure": "'.$cancelUrl.'"
			    }
			}',
			  CURLOPT_HTTPHEADER => array(
			    'Authorization: Bearer sk_a8d65278-c694-419c-8bb0-17cbbf38a455',
			    'Content-Type: application/json'
			  ),
			));

			$response = curl_exec($curl);

		curl_close($curl);

		$respo = json_decode($response, true);
		// return $respo;
		if($respo && isset($respo['configuration']) && isset($respo['configuration']['available_products']) && isset($respo['configuration']['available_products']['installments'])){
			return $respo['configuration']['available_products']['installments'][0]['web_url'];
		} else {
			return back()->with('error','Required Fields is Empty. Try Again.');
		}
		
		// echo "<pre>";
		// print_r($respo['configuration']['available_products']['installments'][0]['web_url']);

    }

    public function tabby_response(Request $request)
    {
    	$params['payment_id'] = $request->payment_id;
    	return $this->check_tabby_status($params); 	
    }

	public function wallet_cancel(){
		return redirect('checkout')->with('error','Payment declined.');
	}

    public function tabby_cancel(Request $request)
    {
    	$params['payment_id'] = $request->payment_id;
    	return $this->check_tabby_status($params);  
    }

    public function tabby_failure(Request $request)
    {
    	$params['payment_id'] = $request->payment_id;
    	return $this->check_tabby_status($params);  
    }

    public function check_tabby_status($request)
    {
    	$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://api.tabby.ai/api/v1/payments/'.$request['payment_id'],
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => array(
		    'Authorization: Bearer sk_a8d65278-c694-419c-8bb0-17cbbf38a455'
		  ),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$respo = json_decode($response, true);
		// echo "<pre>"; print_r($respo);die();
		if($respo && $respo['status'] != 'error'){
			// -------------- Capture Payment

			$curl = curl_init();

			curl_setopt_array($curl, array(
			  CURLOPT_URL => 'https://api.tabby.ai/api/v1/payments/'.$request['payment_id'].'/captures',
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'POST',
			  CURLOPT_POSTFIELDS =>'{
			  "amount": "'.$respo["amount"].'",
			  "reference_id": "string",
			  "tax_amount": "0.00",
			  "shipping_amount": "0.00",
			  "discount_amount": "0.00",
			  "created_at": "string",
			  "items": [
			    {
			      "title": "string",
			      "description": "string",
			      "quantity": 1,
			      "unit_price": "0.00",
			      "discount_amount": "0.00",
			      "reference_id": "string",
			      "image_url": "http://example.com",
			      "product_url": "http://example.com",
			      "gender": "Male",
			      "category": "string",
			      "color": "string",
			      "product_material": "string",
			      "size_type": "string",
			      "size": "string",
			      "brand": "string"
			    }
			  ]
			}',
			  CURLOPT_HTTPHEADER => array(
			    'Content-Type: application/json',
			    'Authorization: Bearer sk_a8d65278-c694-419c-8bb0-17cbbf38a455'
			  ),
			));

			$catp = curl_exec($curl);
			$catp = json_decode($catp, true);
			curl_close($curl);

			// -------------- End Capture
			// echo "<pre>"; print_r($catp);die();
			$card = Card::where('tran_id',$respo['meta']['order_id'])->first();
			if($card){
				
				$orderID = $respo['meta']['order_id'];
				$pstatus = $respo['status'];

				$params['tabby_payment_status'] = $pstatus;
				$params['tabby_payment_response_id'] = $request['payment_id'];
				$params['is_checkout'] = 'Done';

				if($pstatus == 'CREATED'){
					$params['payment_status'] = 'False';
					$params['tabby_payment_response_id'] = $request['payment_id'];
					$res = Card::where('id',$card->id)->update($params);

				    if($card->user && $card->user->email){
						$array['view']      = 'emails.booking_faild_customer';
				        $array['subject']   = 'Your Booking Failed';
				        $array['data']      = Card::where('id',$card->id)->first();
				        
				        \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
				    }

					$adminarray['view']      = 'emails.booking_faild_admin';
			        $adminarray['subject']   = 'Booking Failed';
			        $adminarray['data']      = Card::where('id',$card->id)->first();
			       
			        \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));

			        $tran_id = normalizeId($card->tran_id);
			        
			        $message = "Your payment created. \nFor any assistance contact UrbanMop helpline at 052 618 8291 \ 058 581 4007 or send email at booking@urbanmop.com";
					$msg = urlencode($message);
					if($card->user && $card->user->phone){

						$mobile = $card->user->phone;
						$res=send_sms_to_mobile($mobile,$msg);

					}

					return redirect('/')->with('error','Your payment is created. Contact UrbanMop Support.');
					
				} elseif ($pstatus == 'AUTHORIZED'){

					$params['payment_status'] = 'True';
					$params['tabby_payment_response_id'] = $request['payment_id'];
					$res = Card::where('id',$card->id)->update($params);

					if($res) {

						$adminarray['view']      = 'emails.invoice';
				        $adminarray['subject']   = 'You Have New Service Booking';
				        $adminarray['data']      = Card::where('id',$card->id)->first();
				       
				        // \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));

				        if($card->user && $card->user->email){
							$array['view']      = 'emails.invoice';
					        $array['subject']   = 'Your Booking Invoice';
					        $array['data']      = $card;
					        
					        // \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
					    }

				        $tran_id = normalizeId($card->tran_id);
				        $message = "Congratulation! You have successfully booked service with UrbanMop. \nYour booking ID is $tran_id \nView booking on UrbanMop \nhttps://www.urbanmop.com \nFor any assistance contact UrbanMop helpline at 052 618 8291 \ 058 581 4007 or send email at booking@urbanmop.com";
				        
						// $msg = urlencode($message);
						// if($card->user && $card->user->phone){

						// 	$mobile = $card->user->phone;
						// 	$res=send_sms_to_mobile($mobile,$msg);

						// }
						
						\Session::put('booking_id',$card->id);

						return redirect('confirm-order');
					} else {
						
						return redirect('/')->with('error','Something went wrong. Contact UrbanMop Support.');
					}
				} else {
					$params['payment_status'] = 'False';
					$params['tabby_payment_response_id'] = $request['payment_id'];
					$res = Card::where('id',$card->id)->update($params);

					if($card->user && $card->user->email){
						$array['view']      = 'emails.booking_faild_customer';
				        $array['subject']   = 'Your Booking Failed';
				        $array['data']      = $card;
				        
				        \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
				    }

					$adminarray['view']      = 'emails.booking_faild_admin';
			        $adminarray['subject']   = 'Booking Failed';
			        $adminarray['data']      = $card;
			       
			        \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));

					return redirect('/')->with('error','Your payment is created. Contact UrbanMop Support.');
				}

			} else {
				return redirect('/')->with('error','Something went wrong. Contact UrbanMop Support.');
			}
			
		} else {
			return redirect('/')->with('error','Your payment failed. Contact UrbanMop Support.');	
		}
		
    }

    public function cronjob_tabby_status(Request $request)
    {	
    	$bookings = Card::where('payment_status','False')->where('tabby_payment_status','CREATED')->whereDate('created_at', Carbon::today()->subDays(1))->get();

    	foreach ($bookings as $key => $card) {
    		
    		$curl = curl_init();

			curl_setopt_array($curl, array(
			  CURLOPT_URL => 'https://api.tabby.ai/api/v1/payments/'.$card->tabby_payment_response_id,
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			  CURLOPT_HTTPHEADER => array(
			    'Authorization: Bearer sk_a8d65278-c694-419c-8bb0-17cbbf38a455'
			  ),
			));

			$response = curl_exec($curl);

			curl_close($curl);
			$respo = json_decode($response, true);

			if($respo && $respo['status']);
			{
				$pstatus = $respo['status'];
				if($pstatus == 'AUTHORIZED')
				{

					$params['payment_status'] = 'True';
					$params['tabby_payment_status'] = $pstatus;

					$res = Card::where('id',$card->id)->update($params);

					if($res) 
					{

						$adminarray['view']      = 'emails.invoice';
				        $adminarray['subject']   = 'You Have New Service Booking';
				        $adminarray['data']      = Card::where('id',$card->id)->first();
				       
				        // \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));

				        if($card->user && $card->user->email){
							$array['view']      = 'emails.invoice';
					        $array['subject']   = 'Your Booking Invoice';
					        $array['data']      = $card;
					        
					        // \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
					    }

				        $tran_id = normalizeId($card->tran_id);
				        $message = "Congratulation! You have successfully booked service with UrbanMop. \nYour booking ID is $tran_id \nView booking on UrbanMop \nhttps://www.urbanmop.com \nFor any assistance contact UrbanMop helpline at 052 618 8291 \ 058 581 4007 or send email at booking@urbanmop.com";
				        
						$msg = urlencode($message);
						if($card->user && $card->user->phone){

							$mobile = $card->user->phone;
							// $res=send_sms_to_mobile($mobile,$msg);

						}
					}
				}
    		}   		

    		print_r($card->id); echo " | "; print_r($card->tabby_payment_response_id); echo " | "; print_r($respo['status']);
    	}

    	$cron['datetime'] = date('Y-m-d H:i:s');

		\DB::table('cron_jobs')->insert($cron);
	}

    
    public function checkmail($id)
    {
    	$data['data'] = Card::find($id);

    	return view('emails.invoice',$data);
    }

    function booking_review($id)
	{
		$card = Card::where('encrypt',$id)->first();
	
		if($card){

			$review = Review::where('booking_id',$card->id)->first();
			if($review){
				return redirect('/')->with('error','Review already submitted');
			} else {
				$data['booking'] = $card;
				return view('web.review_form',$data);
			}
		} else {
			return redirect('/')->with('error','Try Again.');
		}
		
	}

	function store_review(Request $request)
	{
		$params['booking_id'] = $request->booking_id;
		$params['service_id'] = $request->service_id;
		$params['vendor_id'] = $request->vendor_id;
		$params['customer_id'] = $request->customer_id;
		$params['rating'] = $request->rating;
		$params['opinion'] = $request->opinion;

		$res = Review::create($params);

		if($res){
			return redirect('/')->with('success','Review submit successfully');
		} else {
			return back()->with('error','Try Again.');
		}
	}

	public function submitReview(Request $request)
	{
		$validated = $request->validate([
			'cart_id' => 'required|exists:cards,id',
			'service_id' => 'required|exists:services,id',
			'review' => 'required|string',
			'rating' => 'required|string|min:1|max:5',
		]);

		Review::create([
			'vendor_id' => 1,
			'customer_id' => auth()->user()->id,
			'booking_id' => $validated['cart_id'],
			'service_id' => $validated['service_id'],
			'opinion' => $validated['review'],
			'rating' => $validated['rating'],
		]);

		return response()->json(['success' => true, 'message' => 'Review submitted successfully.']);
	}
	 
	public function telr_webhook(REQUEST $request){
	    $data = $request->all(); 

        // Convert data to JSON
        $jsonData = json_encode($data, JSON_PRETTY_PRINT);
    
        // Define the file path
        $filePath = 'webhooks/telr_webhook_' . date('Y-m-d_H-i-s') . '.json';
    
        // Store the file using Laravel Storage (storage/app/webhooks/)
        Storage::disk('local')->put($filePath, $jsonData);
        
        if($request->tran_type == "sale"){
            if($request->tran_status =='A' || $request->tran_status == "H"){
                $booking = OfflineBooking::where(['tran_id'=>$request->tran_cartid])->get();
                if($booking->count() > 0){
                    $item = OfflineBooking::find($booking->first()->id);
                    $item->payment_collected = "Yes";
                    $item->payment_moad = "Card";
                    $item->paymentLinkId = $request->tran_ref;
                    $item->save();
                }
                
                $booking = Card::where(['tran_id'=>$request->tran_cartid])->get();
                if($booking->count() > 0){
                    $item = Card::find($booking->first()->id);
                    $item->payment_collected = "Yes";
                    $item->payment_type = 1;
                    $item->paymentLinkId = $request->tran_ref;
                    $item->save();
                }
                Card::where(['cart_unique_id'=>$request->tran_cartid])->update(['payment_collected'=>"Yes","paymentLinkId"=>$request->tran_ref]);
            }
        }
    
        return response()->json(['message' => 'Webhook received and saved successfully']);
	}

}



