<?php

namespace App\Http\Controllers;

use Auth;
use App\Article;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class CMSController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->search){
            $cms = Article::orderBy('id','DESC')->where('name', 'like', '%'.$request->search.'%')->paginate(10);
        } else {
            $cms = Article::orderBy('id','DESC')->get();
        }
        
        return view('cms.index',compact('cms','request'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cms.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name' => 'required',
            'details' => 'required',
        ]);

        $data['title_en']       = $request->name;
        $data['desc_en']        = $request->details;
        $data['meta_title']        = $request->meta_title;
        $data['meta_keyword']        = $request->meta_keyword;
        $data['meta_description']        = $request->meta_description;
        Article::create($data);
        return redirect('cms')->with('success','CMS created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\CMS  $cms
     * @return \Illuminate\Http\Response
     */
    public function show(CMS $cms)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\CMS  $cms
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id=decrypt($id);
        $cms = Article::find($id);
        return view('cms.edit',compact('cms'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\CMS  $cms
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name' => 'required',
            'details' => 'required',
        ]);
        
        $data['title_en']       = $request->name;
        $data['desc_en']        = $request->details;
        $data['status']         = $request->status;
        $data['meta_title']        = $request->meta_title;
        $data['meta_keyword']        = $request->meta_keyword;
        $data['meta_description']        = $request->meta_description;
        Article::whereId($id)->update($data);
        
        return redirect('cms')->with('success','CMS updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\CMS  $cms
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $id=decrypt($id);
        Article::whereId($id)->delete();
        
        return redirect()->back()->with('error','CMS deleted successfully.');
    }
}
