<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\API\BaseController as BaseController;
use Illuminate\Http\Request;
use App\Slot;
use App\PrefferedDays;
use App\Card;

class SlotController extends BaseController
{
    public function index(Request $request)
    {
        $date = $request->input('date');
        $today = date('Y-m-d');
        $currentTime = date('H:i:s');
        
        $twoHoursLater = date('H:i:s', strtotime('+2 hours', strtotime($currentTime)));
        
        // Fetch all slots
        $allSlots = Slot::all();
        
        // Fetch booked slots for the given date
        $bookedSlots = Card::where('date', $date)
                            ->where('status', '!=', 'Canceled')
                            ->where('service_id', $request->service_id)
                            ->pluck('slot_id')->toArray();
        
        $availableSlots = [];
        foreach ($allSlots as $slot) {
            // Convert slot check-in time and current time to timestamps for comparison
            $slotStartTime = strtotime($slot->check_in);
            $currentTimeTimestamp = strtotime($currentTime);
            $twoHoursLaterTimestamp = strtotime($twoHoursLater);
        
            // Determine if the slot is a past slot
            $isPastSlot = false;
            if ($date < $today) {
                // If the date is in the past, mark all slots as past
                $isPastSlot = true;
            } elseif ($date == $today && $slotStartTime < $twoHoursLaterTimestamp) {
                // If the date is today and the slot time is earlier than the current time
                $isPastSlot = true;
            }
        
            // Disable the slot if it is a past slot or if it is already booked
            $isAvailable = !$isPastSlot ; // && !in_array($slot->id, $bookedSlots)
        
            $availableSlots[] = [
                'slot_id' => $slot->id,
                'slot_name' => $slot->name,
                'available' => $isAvailable, // Only true if not a past slot and not booked
                'is_past_slot' => $isPastSlot // Explicit flag for past slot
            ];
        }
        
        return $this->sendResponse($availableSlots, 'Slot Info');
        
    }

    public function preffered_days()
    {
        $data = PrefferedDays::all();
        return $this->sendResponse($data, 'Days List');
    }
}
