<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\API\BaseController as BaseController;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Order;
use App\BellBookingUser;
use Illuminate\Http\Request;
use App\WalletPaymentReport;
use App\StaffSession;
use App\StaffCard;
use App\Staff;
use App\VendorCardStatus;
use App\Invite;
use App\SessionPackages;
use App\PrefferedDays;
use App\Wallet;
use App\User;
use App\Card;
use App\Category;
use App\ChildCategory;
use App\Service;
use App\CardAttribute;
use App\CardAddon;
use App\Coupon;
use App\Seller;
use App\SellerService;
use App\HomeSetting;
use App\PayOutBalance;
use App\Payment;
use App\UserCoupon;
use App\CardCoupon;
use App\Address;
use App\Review;
use App\Packages;
use App\Slot;
use App\Transection;
use App\RewardConfig;
use App\RewardUser;
use App\ServiceAttributeValue;
use App\ServiceAttributeValueItem;
use App\Attribute;
use App\AttributeValue;
use App\MailJobs;
use App\Services\FirebasePushNotificationService;
use Kreait\Firebase\Database;
use Kreait\Firebase\Factory;
use Illuminate\Support\Facades\Http;

class CardController extends BaseController
{
    
    protected $firebaseService;
    protected $database;

    // Inject FirebasePushNotificationService through the constructor
    public function __construct(FirebasePushNotificationService $firebaseService, Database $database)
    {
        $this->firebaseService = $firebaseService;
        $this->database = $database;
    }

    function arrived_session($session_id)
    {
        // Find the session by ID
        $session = SessionPackages::find($session_id);
    
        if ($session) {
            // Update the session status to "Complete"
            $session->status = 'Mark as Arrived';
        
            // Save the updated session
            $session->save();
        }
    
    
        // Return the updated session as a response
        return $this->sendResponse($session, 'Session status updated to Complete');
    }

    function complete_session($session_id)
    {
        // Find the session by ID
        $session = SessionPackages::find($session_id);
    
        if ($session) {
            // Update the session status to "Complete"
            $session->status = 'Completed';
        
            // Save the updated session
            $session->save();
        }
    
    
        // Return the updated session as a response
        return $this->sendResponse($session, 'Session status updated to Complete');
    }
    
    function get_session_history($card_id)
    {
        $cart = Card::find($card_id);
        $data['preffered_days'] = $cart->preffered_days;
        
        $selectedPackageIds = explode(',', $cart->selected_packages);
        $data['package_id'] = $selectedPackageIds[0];
        $data["time"] = ($cart->slot_id) ? Slot::find($cart->slot_id)->name : "";
        $sessions = SessionPackages::with('package')->where('cart_id', $card_id)->get();
        $completed_session = SessionPackages::with('package')
        ->where(['cart_id' => $card_id, 'status' => 'Completed'])->count();
        $free_sessions = 0;
        $per_week = 0;
        $total_sessions = 0;
        $is_package = 0;
        // Loop through sessions to access related package data
        foreach ($sessions as $session) {
            if ($session->package) { 
                $is_package = 1;
                $total_sessions = $session->package->total_sessions;
                $free_sessions = $session->package->free_sessions;
                $per_week = $session->package->per_week;
            }
        }
        $data['session_history'] = (object) [
            'total_sessions' => $total_sessions,
            'free_sessions' => $free_sessions,
            'per_week' => $per_week,
            'sessions' => $sessions,
            'completed_session' => (string) $completed_session,
        ];
        $packages = Packages::find($selectedPackageIds)
                    ->toArray();
        $data['package'] = $packages[0];

        

        $check = StaffCard::where('card_id', $card_id)->with(['user', 'card']);

        if ($check->exists()) {
            $data['added_staff'] = $check->get()->map(function ($staffCard) {
        
                return [
                    'status' => $staffCard->card->status ?? null,
                    'id' => $staffCard->user_id ?? null,
                    'first_name' => $staffCard->staff->first_name ?? null,
                    'last_name' => $staffCard->staff->last_name ?? null,
                    'phone' => $staffCard->staff->phone ?? null,
                    'dial_code' => $staffCard->staff->dial_code ?? null,
                ];
            })->toArray();
        } else {
            $data['added_staff'] = [];
        }

        // Return the data as response
        return $this->sendResponse($data, 'Get Data');
    }    

    public function get_selected_price_by_card(Request $request)
    {
        if($request->cart_id){

            $data = [];
            $totalAmount = 0;
            $cart = Card::find($request->cart_id);
            $service = Service::find($cart->service_id);
            $material_default = ($cart->material_status == "Apply") ? (float) $service->material_price : 0;
            $material_total = 0;
            $material = 0;
            $is_maid = 0;
            $total_count = 1;
            $total_maids_material = 0;
            if (CardAttribute::where('card_id', $cart->id)->exists()) {
                $data["service_name"] = $service->name;
                $c = 0;
                foreach (CardAttribute::where('card_id', $cart->id)->get() as $value) {
                    if(!isset($value->sub_cate_id)){
                        $is_maid = 1;
                        $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                        $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
                        $params['service_type']         = '';
                        
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name ?? "",
                            "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (int) $attribute_total; 
                        } else {
                            
                            $totalAmount += $attribute_total; 
                        }
                        
                        preg_match('/\d+/', $attribute_item->value, $matches);
        
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                        
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
        
                    } else {
                        if(empty($value->child_category_id)){
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$cart->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id
                            ])->first();
                        } else{
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$cart->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id,
                                'child_category_id'=>$value->child_cate_id,
                            ])->first();
                        }
                        if(!empty($service_item)){
                            $services = ServiceAttributeValue::where([
                                'attribute_item_id'=>$value->attribute_item_id,
                            ])->first();

                            $attribute = Attribute::where('id',$services->attribute_id)->first();
                            $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                            
                            $params['attribute_price']      = $services->attribute_price ?? null;
                            $params['attribute_qty']        = $value->attribute_qty ?? null;
        
                            $data["attribute"][] = [
                                "category"=>Category::find($service_item->category_id)->name,
                                "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                "name"=>$attribute_item->value ?? "",
                                "price"=>(string) $services->attribute_price,
                                "qty"=>(string) $value->attribute_qty];
                        
                            
                            $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                            
                            if($attribute->name == 'Hours'){
                                $totalAmount *= (float) $attribute_total; 
                            } else {
                                
                                $totalAmount += (float) $attribute_total; 
                            }
    
                            preg_match('/\d+/', $attribute_item->value, $matches);
    
                            if (count($matches) > 0) {
                                $number = (int) $matches[0];
                                $total_count *= $number;
                            
                                $total_maids_material *= $number;
                                if ($attribute->name == 'Hours') {
                                } else {
                                }
                            }
                            
                        } 
                        $params['service_type']         = '';
                    }
                } 
                
            }
            if($service->id == 10){
                $material_total = $total_maids_material;
            } else {
                $material_total = $material_total;
            }
            $material = ($cart->material_status == "Apply") ? (float) $material_total : "0";
        
            $data["sub_total"] = (string) $cart->g_total;
            $data["cart"] = $cart;
            
            $data["material_status"] = (string) $cart->material_status;
            $data["date"] = $cart->date ?? "";
            $data['preffered_days'] = $cart->preffered_days;

            $totalAmount = (int) $cart->amount;
            $data["time"] = ($cart->slot_id) ? Slot::find($cart->slot_id)->name : "";
            if($cart->service_id == "10"){
            
                if(isset($cart->selected_packages) ){    
                    $totalAmount = 0;            
                    $selectedPackageIds = explode(',', $cart->selected_packages);
    
                    $packages = Packages::whereIn('id', $selectedPackageIds)->get();
    
                    foreach ($packages as $package) {
                        $data["packages"][] = [
                            "name"=>$package->name, 
                            "base_amount"=>(string) $package->amount,
                            "price"=>(string) ((int) $package->amount * (int) $total_count),
                            "save_amount"=>(string) (  ( ( $package->amount * (int) $total_count ) / $package->total_sessions ) * (int) $package->free_sessions )
                        ]; 
                        $totalAmount = ((int) $package->amount * (int) $total_count) -(float)$value->coupon_amt; 
                   
                        $material *= ((int) $package->total_sessions );
                
                    }
                   
                    $check = StaffCard::where('card_id', $cart->id)->with(['user', 'card']);

                    if ($check->exists()) {
                        $data['added_staff'] = $check->get()->map(function ($staffCard) {
                    
                            return [
                                'status' => $staffCard->card->status ?? null,
                                'id' => $staffCard->user_id ?? null,
                                'first_name' => $staffCard->staff->first_name ?? null,
                                'last_name' => $staffCard->staff->last_name ?? null,
                                'phone' => $staffCard->staff->phone ?? null,
                                'dial_code' => $staffCard->staff->dial_code ?? null,
                            ];
                        })->toArray();
                    } else {
                        $data['added_staff'] = [];
                    }
                }
    
            }
            
            $material *= $material_default;
            $totalAmount += (float) $material;
            $data["material"] = (string) $material;
            $data["material_default"] = (string) $material_default;
            $data["total_amount"] = (string) $totalAmount;
            // arshad
            $data["user"] = auth()->user();
            $data["address"] = optional(Address::where(['user_id' => auth()->user()->id])->first())->address ?? "";
            $data["address_object"] = (object) optional(Address::where(['user_id' => auth()->user()->id])->first())->toArray() ?? [];

            return $this->sendResponse($data, 'Updated Price!');
        } else {
            return $this->sendResponse((object) [], 'Missing Fields Required!');
        }
    }

    public function get_selected_price(Request $request)
    {
    
        $data = [];
        $totalAmount = 0;
        $service = Service::find($request->service_id);
        $material_default = ($request->material_status == "Apply") ? (float) $service->material_price : 0;
        $material_total = 0;
        $total_maids_material = 0;
        $material = 0;
        $is_maid = 0;
        $total_count = 1;
        if(isset($request->item_object)){
            $data["service_name"] = $service->name;
            $c = 0;
            foreach (json_decode($request->item_object) as $key => $value) {
                if(!isset($value->sub_category_id)){
                    $is_maid = 1;
                    $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                    $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                    $attribute = Attribute::where('id',$services->attribute_id)->first();
                    $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                    
                    $params['attribute_price']      = $services->attribute_price ?? null;
                    $params['attribute_qty']        = $value->attribute_qty ?? null;
                    $params['service_type']         = '';
                    
                    $data["attribute"][] = [
                        "category"=>Category::find($service_item->category_id)->name,
                        "name"=>$attribute_item->value,
                        "price"=>(string) $services->attribute_price,
                    ];
                    $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                    
                    if($attribute->name == 'Hours'){
                        $totalAmount *= (float) $attribute_total; 
                    } else {
                        
                        $totalAmount += (float) $attribute_total; 
                    }
                    
                    preg_match('/\d+/', $attribute_item->value, $matches);

                    if (count($matches) > 0) {
                        $number = (int) $matches[0];
                        $total_count *= $number;
                    
						$total_maids_material *= $number;
                        if ($attribute->name == 'Hours') {
                        } else {
                        }
                    }

                } else {
                    if(empty($value->child_category_id)){
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$request->service_id,
                            'category_id'=>$value->category_id,
                            'sub_category_id'=>$value->sub_category_id
                        ])->first();
                    } else{
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$request->service_id,
                            'category_id'=>$value->category_id,
                            'sub_category_id'=>$value->sub_category_id,
                            'child_category_id'=>$value->child_category_id,
                        ])->first();
                    }
                    if(!empty($service_item)){
                        $services = ServiceAttributeValue::where([
                            'ser_attr_val_item_id'=>$service_item->id,
                            'attribute_item_id'=>$value->attribute_item_id,
                        ])->first();
                        
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
    
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name,
                            "sub_category"=>Category::find($service_item->sub_category_id)->name,
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                    
                        
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (float) $attribute_total; 
                        } else {
                            
                            $totalAmount += (float) $attribute_total; 
                        }

                        preg_match('/\d+/', $attribute_item->value, $matches);

                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                        
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }

                        // $material_total += ($request->material_status == "Apply" ? (float) $material_default : 0) 
                        // * (float) $value->attribute_qty;
                        
                    } 
                    $params['service_type']         = '';
                }
            } 
            
        }     
        if($service->id == 10){
			$material_total = $total_maids_material;
		} else {
			$material_total = $material_total;
		}
        $material = ($request->material_status == "Apply") ? (float) $material_total : 0;

         if($request->service_id == "10"){
            // dd($total_count);
            if(isset($request->selected_packages) ){    
                $totalAmount = 0;            
                $selectedPackageIds = explode(',', $request->selected_packages);

                $packages = Packages::whereIn('id', $selectedPackageIds)->get();

                foreach ($packages as $package) {
                    $material = $total_count;
                    $data["packages"][] = [
                        "name"=>$package->name, 
                        "base_amount"=>(string) $package->amount,
                        "price"=>(string) ((int) $package->amount * (int) $total_count),
                        //"save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                        "save_amount"=>(string) (  ( ( $package->amount * (int) $total_count ) / $package->total_sessions ) * (int) $package->free_sessions )
                    ]; 
                    
                    $totalAmount = (float) $package->amount * (float) $total_count; 

                    $material *= ((int) $package->total_sessions );
                
                }
                
            }

        }
        
        $data["sub_total"] = (string) $totalAmount;
		$material *= $material_default;
        $totalAmount += $material;
        $data["material"] = (string) $material;
        $data["total_amount"] = (string) $totalAmount;

        return $this->sendResponse($data, 'Updated Price!');
    }


    public function get_price(Request $request)
    {
        if($request->cart_id){

            $data = [];
            $totalAmount = 0;
            $cart = Card::find($request->cart_id);
            $service = Service::find($cart->service_id);
            $material_default = ($request->material_status == "Apply") ? (float) $service->material_price : 0;
           
            $material_total = ($cart->material_status == "Apply") ? (int) $cart->material_charge : 0;
            $material = 0;
            if (CardAttribute::where('card_id', $cart->id)->exists()) {
                $data["service_name"] = $service->name;
                foreach (CardAttribute::where('card_id', $cart->id)->get() as $value) {
                    
                    $service = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                    $service_item = ServiceAttributeValueItem::where('id',$service->ser_attr_val_item_id)->first();
                    $attribute = Attribute::where('id',$service->attribute_id)->first();
                    $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                    
                    $params['attribute_price']      = $service->attribute_price ?? null;
                    $params['attribute_qty']        = $value->attribute_qty ?? null;
                    $params['service_type']         = '';
                    
                    $data["attribute"][] = ["name"=>$attribute_item->value,"price"=>$service->attribute_price];
                    $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                    
                    if($attribute->name == 'Hours'){
                        $totalAmount *= (float) $attribute_total; 
                    } else {
                        
                        $totalAmount += (float) $attribute_total; 
                    }

                    preg_match('/\d+/', $attribute_item->value, $matches);
                    
                    $material += ($request->material_status == "Apply") ? (int) $material_total : 0;
                    $material *= (int) $value->attribute_qty;

                    $cardattr = CardAttribute::create($params);
                } 
                
            }
            $data["sub_total"] = (string) $totalAmount;
            $material *= $material_default;
            $totalAmount += $material;
            
            $data["material"] = (string) $material;
            $data["date"] = $cart->date ?? "";
            $data["time"] = ($cart->slot_id) ? Slot::find($cart->slot_id)->name : "";
            $data["total_amount"] = $totalAmount;

            return $this->sendResponse($data, 'Updated Price!');
        } else {
            return $this->sendResponse([], 'Missing Fields Required!');
        }
    }

    public function get_reward_price($totalAmount = 0)
    {
        // Fetch reward and exchange values from the configuration
        $reward = RewardConfig::where('name', 'reward')->first();
        $exchange = RewardConfig::where('name', 'exchange')->first();

        if (!$reward || !$exchange) {
            return [
                'total_before_rewards' => (string) 0,
                'reward_amount_used' => (string) 0, 
                'remaining_reward_amount' => (string) 0,   
                'remaining_reward_points' => (int) 0,      
                'final_amount' => (string) 0                        
            ];
        }

        $rewardPerDollar = $reward->value;  
        $exchanges = $exchange->value;      

        $rewardAmount = floor($totalAmount / $exchanges);
        $rewardPoints = floor($rewardAmount * $rewardPerDollar);

        $finalAmount = $totalAmount;

        if ($rewardAmount > $totalAmount) {
            $remainingRewardAmount = $rewardAmount - $totalAmount;
            $finalAmount = 0;

            // Calculate the remaining reward points based on the unused reward amount
            $remainingRewardPoints = $remainingRewardAmount * $rewardPerDollar;
        } else {
            // Otherwise, deduct the reward amount from the total and set no remaining rewards
            $finalAmount = $rewardAmount;
            $remainingRewardAmount = 0;
            $remainingRewardPoints = 0;
        }
        
        return [
            'total_before_rewards' => (string) $totalAmount,
            'reward_amount_used' => (string) ($totalAmount - $finalAmount), 
            'remaining_reward_amount' => (string) $remainingRewardAmount,   
            'remaining_reward_points' => (int) $remainingRewardPoints,      
            'final_amount' => (string) $finalAmount                        
        ];
    }


    public function handle_reward($created_at, $id = 0, $totalAmount = 0)
    {
        // Fetch reward and exchange values from the configuration
        $reward = RewardConfig::where('name', 'reward')->first();
        $exchange = RewardConfig::where('name', 'exchange')->first();

        if (!$reward && !$exchange) {
            return $this->sendResponse([], 'Reward configuration not found!');
        }

        // Get the reward and exchange values
        $rewardPerDollar = $reward->value;  // Points per dollar spent
        // $exchanges = $exchange->value;      // Exchange rate (dollars equivalent for rewards)

        // Calculate reward points and reward amount (AED equivalent of points)
        $rewardPoints = floor($totalAmount * $rewardPerDollar);
        $rewardAmount = floor($totalAmount / $rewardPerDollar);

        // Initialize the final amount after rewards are applied
        $finalAmount = $totalAmount;

        // Calculate remaining reward amount and adjust the final total
        if ($rewardAmount > $totalAmount) {
            // If reward amount exceeds the total, set final amount to zero and calculate remaining reward amount
            $remainingRewardAmount = $rewardAmount - $totalAmount;
            $finalAmount = 0;

            // Calculate the remaining reward points based on the unused reward amount
            $remainingRewardPoints = $remainingRewardAmount * $rewardPerDollar;
        } else {
            // Otherwise, deduct the reward amount from the total and set no remaining rewards
            $finalAmount = $totalAmount - $rewardAmount;
            $remainingRewardAmount = 0;
            $remainingRewardPoints = 0;
        }

        $res = [
            'total_before_rewards' => (string) $totalAmount,
            'reward_amount_used' => (string) ($totalAmount - $finalAmount), 
            'remaining_reward_amount' => (string) $remainingRewardAmount,   
            'remaining_reward_points' => (int) $remainingRewardPoints,      
            'final_amount' => (string) $finalAmount                        
        ];

        // $this->updateUserReward($created_at, $id, ($totalAmount - $finalAmount),($totalAmount));

        return $res;
    }

    public function reorder(Request $request)
    {
        $validated = $request->validate([
            'card_id' => 'required|exists:cards,id',
        ]);
    
        $originalCard = Card::findOrFail($validated['card_id']);
    
        $newCard = new Card();
        $newCard->user_id = $originalCard->user_id;
        $newCard->service_id = $originalCard->service_id;
        $newCard->service_name = $originalCard->service_name;
        $newCard->category_id = $originalCard->category_id;
        $newCard->address_id = $originalCard->address_id;
        $newCard->paymentLinkId = $originalCard->paymentLinkId;
        $newCard->paymentTranId = $originalCard->paymentTranId;
        $newCard->payment_moad = $originalCard->payment_moad;
        $newCard->note = $originalCard->note;
        $newCard->alternative_number = $originalCard->alternative_number;
        $newCard->tip_id = $originalCard->tip_id;
        $newCard->coupon_id = $originalCard->coupon_id;
        $newCard->status = $originalCard->status;
        $newCard->amount = $originalCard->amount;
        $newCard->coupon_amt = $originalCard->coupon_amt;
        $newCard->g_total = $originalCard->g_total;
        $newCard->offline_charge = $originalCard->offline_charge;
        $newCard->offline_discount = $originalCard->offline_discount;
        $newCard->before_coupon_amt = $originalCard->before_coupon_amt;
        $newCard->payment_collected = $originalCard->payment_collected;
        $newCard->service_start_datetime = $originalCard->service_start_datetime;
        $newCard->service_complete_approval = $originalCard->service_complete_approval;
        $newCard->service_completed = $originalCard->service_completed;
        $newCard->service_completed_date = $originalCard->service_completed_date;
        $newCard->work_done = $originalCard->work_done;
        $newCard->cod_status = $originalCard->cod_status;
        $newCard->cod_charge = $originalCard->cod_charge;
        $newCard->material_status = $originalCard->material_status;
        $newCard->material_charge = $originalCard->material_charge;
        $newCard->service_type = $originalCard->service_type;
        $newCard->is_login = $originalCard->is_login;
        $newCard->booking_from = $originalCard->booking_from;
        $newCard->cencal_date = $originalCard->cencal_date;
        $newCard->encrypt = $originalCard->encrypt;
        $newCard->pending_approval_by_admin = $originalCard->pending_approval_by_admin;
        $newCard->payment_type = $originalCard->payment_type;
        $newCard->tabby_payment_status = $originalCard->tabby_payment_status;
        $newCard->tabby_payment_response_id = $originalCard->tabby_payment_response_id;
        $newCard->payment_link = $originalCard->payment_link;
        $newCard->selected_packages = $originalCard->selected_packages;
        $newCard->preffered_days = $originalCard->preffered_days;
        $newCard->alternative_dial_code = $originalCard->alternative_dial_code;
        if($originalCard->service_id == 13){
            $newCard->is_revisit = 1;
            $newCard->revisit_id = $originalCard->id;
        }
        // Set the required changes for the new entry
        $newCard->status = "Pending";
        $newCard->is_checkout = "Processing";
        $newCard->slot_id = null;
        $newCard->payment_status = "pending";

        // Save the new card entry
        $newCard->save();   

        $cart = Card::find($newCard->id);
        $service = Service::find($cart->service_id);
        $cardattr = (object) [];
        
        if (CardAttribute::where('card_id', $originalCard->id)->exists()) {
            $data["service_name"] = $service->name;
            foreach (CardAttribute::where('card_id', $originalCard->id)->get() as $value) {
                
                $service = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                $service_item = ServiceAttributeValueItem::where('id',$service->ser_attr_val_item_id)->first();
                $attribute = Attribute::where('id',$service->attribute_id)->first();
                $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                
                $params['sub_cate_id']          = $value->sub_cate_id ?? null;
                $params['main_sub_cat_id']      = $value->main_sub_cat_id ?? null;
                $params['child_cate_id']        = $value->child_cate_id ?? null;
                $params['attribute_id']         = $attribute->id ?? null;
                $params['attribute_name']       = $attribute->name ?? null;
                $params['attribute_item_id']    = $value->attribute_item_id ?? null;
                $params['attribute_item_name']  = $attribute_item->value ?? null;
                $params['attribute_price']      = $service->attribute_price ?? null;
                $params['attribute_qty']        = $value->attribute_qty ?? null;
                $params['service_type']         = '';
                $params['card_id']              = $cart->id;
                
                $cardattr = CardAttribute::create($params);
            } 
            
        }
    
        return response()->json([
            'success' => "1",
            'message' => 'Card duplicated successfully.',
            'data' => [
                "card" => $cart,
                "card_attribute" => $cardattr
            ],
        ]);
    }
    
    public function revisit(Request $request){
        $validated = $request->validate([
            'old_booking_id' => 'required|exists:cards,id',
            'date' => 'required',
            'slot' => 'required',
        ]);
    
        $originalCard = Card::findOrFail($validated['old_booking_id']);
    

        // if ($originalCard->service_completed_date) {
        //     $originalDate = Carbon::parse($originalCard->service_completed_date);
        //     $currentDate = Carbon::now();
        //     $daysSinceService = $originalDate->diffInDays($currentDate);

        //     // Check if within 90-day revisit window and at least 21 days have passed
        //     if ($daysSinceService >= 21 && $daysSinceService <= 90) {
               
        //     } else {
        //         return back()->with('error', 'Revisit must be booked at least 21 days after service and within 90 days.');
        //     }
        // } else {
		//     return back()->with('error', 'Service not completed yet.');
		// }


        $newCard = new Card();
        $newCard->user_id = (string) $originalCard->user_id;
        $newCard->service_id = (string) $originalCard->service_id;
        $newCard->service_name = $originalCard->service_name;
        $newCard->category_id = $originalCard->category_id;
        $newCard->address_id = $originalCard->address_id;
        $newCard->paymentLinkId = $originalCard->paymentLinkId; 
        $newCard->tran_id = $originalCard->tran_id;
        $newCard->paymentTranId = $originalCard->paymentTranId;
        $newCard->payment_moad = $originalCard->payment_moad;
        $newCard->note = $originalCard->note;
        $newCard->alternative_number = $originalCard->alternative_number;
        $newCard->date = $validated['date'];
        $newCard->tip_id = null;
        $newCard->coupon_id = null;
        $newCard->status = $originalCard->status;
        $newCard->accept_user_id = $originalCard->accept_user_id;
        $newCard->accept_user_company_id = $originalCard->accept_user_company_id;
        $newCard->amount = 0;
        $newCard->coupon_amt = $originalCard->coupon_amt;
        $newCard->g_total = 0;
        $newCard->offline_charge = $originalCard->offline_charge;
        $newCard->offline_discount = $originalCard->offline_discount;
        $newCard->before_coupon_amt = $originalCard->before_coupon_amt;
        $newCard->payment_collected = $originalCard->payment_collected;
        $newCard->service_start_datetime = $originalCard->service_start_datetime;
        $newCard->service_complete_approval = $originalCard->service_complete_approval;
        $newCard->service_completed = $originalCard->service_completed;
        $newCard->service_completed_date = $originalCard->service_completed_date;
        $newCard->work_done = $originalCard->work_done;
        $newCard->cod_status = $originalCard->cod_status;
        $newCard->cod_charge = $originalCard->cod_charge;
        $newCard->material_status = $originalCard->material_status;
        $newCard->material_charge = $originalCard->material_charge;
        $newCard->service_type = $originalCard->service_type;
        $newCard->is_login = $originalCard->is_login;
        $newCard->booking_from = $originalCard->booking_from;
        $newCard->cencal_date = $originalCard->cencal_date;
        $newCard->encrypt = $originalCard->encrypt;
        $newCard->pending_approval_by_admin = $originalCard->pending_approval_by_admin;
        $newCard->payment_type = $originalCard->payment_type;
        $newCard->tabby_payment_status = $originalCard->tabby_payment_status;
        $newCard->tabby_payment_response_id = $originalCard->tabby_payment_response_id;
        $newCard->payment_link = $originalCard->payment_link;
        $newCard->selected_packages = $originalCard->selected_packages;
        $newCard->preffered_days = $originalCard->preffered_days;
        $newCard->alternative_dial_code = $originalCard->alternative_dial_code;
        
        $slot = Slot::find($originalCard->slot_id);
        $currentTime = Carbon::now('Asia/Dubai');
        $cardDate = Carbon::createFromFormat('Y-m-d', $validated['date'], 'Asia/Dubai');
        
        // Ensure the slot exists and contains the check-in time
        if ($slot) {
            $checkInTime = Carbon::createFromFormat('H:i:s', $slot->check_in, 'Asia/Dubai');
        
            if ($cardDate->isPast() && !$cardDate->isToday()) {
                // The date is in the past and not today
                $newCard->status = "Expired";
            } elseif ($cardDate->isToday()) {
                // The date is today; check the time difference
                if ($currentTime->diffInHours($checkInTime, false) > 2) {
                    $newCard->status = "Upcoming";
                } else {
                    $newCard->status = "Accept";
                }
            } else {
                // The date is in the future
                $newCard->status = "Upcoming";
            }
        } else {
            // Handle the case where the slot doesn't exist
            $newCard->status = "Pending"; // Or set a default fallback status
        }
        

        $newCard->is_checkout = "Done";
        $newCard->slot_id = $validated['slot'];
        $newCard->payment_status =  $originalCard->payment_status;
        $newCard->accept_user_id =  $originalCard->accept_user_id;
        $newCard->is_revisit =  0;

        // Save the new card entry
        $newCard->save();   

        
        $oldCard = Card::find($validated['old_booking_id']);
        $oldCard->revisit_id = $newCard->id;
        $oldCard->is_revisit =  1;
        $oldCard->save();   

        $data = [];
        $cart = Card::find($newCard->id);
        $data['id'] = (int) $cart->id; 
        $data['user_id'] = (int) $cart->user_id;
        $data['service_id'] = (int)$cart->service_id;
        $data['service_name'] = $cart->service_name;
        $data['category_id'] = $cart->category_id;
        $data['slot_id'] = $cart->slot_id;
        $data['address_id'] = $cart->address_id;
        $data['tran_id'] = normalizeId($cart->tran_id) ?? "";
        $data['payment_status'] = $cart->payment_status ?? "";
        $data['note'] = $cart->note ?? "";
        $data['status'] = $cart->status ?? "";
        $data['payment_collected'] = $cart->payment_collected ?? "";
        $data['service_complete_approval'] = $cart->service_complete_approval ?? "";
        $data['service_completed'] = $cart->service_completed ?? "";
        $data['material_status'] = $cart->material_status ?? "";

        $service = Service::find($cart->service_id);
        $cardattr = (object) [];
        
        if (CardAttribute::where('card_id', $originalCard->id)->exists()) {
            $data["service_name"] = $service->name;
            foreach (CardAttribute::where('card_id', $originalCard->id)->get() as $value) {
                
                $service = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                $service_item = ServiceAttributeValueItem::where('id',$service->ser_attr_val_item_id)->first();
                $attribute = Attribute::where('id',$service->attribute_id)->first();
                $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                
                $params['sub_cate_id']          = $value->sub_cate_id ?? null;
                $params['main_sub_cat_id']      = $value->main_sub_cat_id ?? null;
                $params['child_cate_id']        = $value->child_cate_id ?? null;
                $params['attribute_id']         = $attribute->id ?? null;
                $params['attribute_name']       = $attribute->name ?? null;
                $params['attribute_item_id']    = $value->attribute_item_id ?? null;
                $params['attribute_item_name']  = $attribute_item->value ?? null;
                $params['attribute_price']      = $service->attribute_price ?? null;
                $params['attribute_qty']        = $value->attribute_qty ?? null;
                $params['service_type']         = '';
                $params['card_id']              = $cart->id;
                
                $cardattr = CardAttribute::create($params);
            } 
            
        }
        
        return response()->json([
            'success' => "1",
            'message' => 'Revisit Successful',
            'data' => [
                "card" => $data,
                "card_attribute" => $cardattr
            ],
        ]);
    }

    public function store(Request $request)
    {
        $cart_message = 'Card updated successfully.';
        if($request->service_id && $request->item_object ){
            $totalAmount = 0;
            $total_count = 1;
            $total_maids_material = 1;
            $service = Service::find($request->service_id);
            $data['user_id']            = auth()->user()->id;
            $data['service_id']         = (string) $service->id;
            $data['service_name']       = $service->name;
            $data['category_id']        = $request->category_id;         
            $data['note']               = $request->note;
            $data['material_status']    = ($request->material_status)?$request->material_status:"No";
            $data['selected_packages']  = $request->selected_packages;
            $data['service_type']       = '';
            $data['payment_status']     = 'pending';
            $data['status']        = 'Pending';
            $data['is_checkout']        = 'Start';
            // $data['accept_user_id']     = Seller::find(SellerService::where('service_id',$service->id)->first()->seller_id)->user_id;
            $data['booking_from']       = ($request->booking_from != '')?$request->booking_from:'App';
            
            $material_default = ($request->material_status == "Apply") ? (float) $service->material_price : 0;
            $material_total = (float) 0;
            $material = (float) 0;
            if (!empty($request->card_id)) {
                $card = Card::findOrFail($request->card_id); 
                $card->update($data);

                if (isset($card) && $card->id) {
                    CardAttribute::where('card_id', $card->id)->delete();
                }
            } else {
                $data['tran_id'] = 'UM-'.chr(rand(65, 90)).rand(100000, 999999); //'UM-'.time();
                $card = Card::create($data);
            }
            
            $total_maids = 0;
            if($card){

                $material_default = ($request->material_status == "Apply") ? (float) $service->material_price : 0;
                $material_total = 0;
                $material = 1;
                $is_maid = 0;
                if(isset($request->item_object)){
                    $data["service_name"] = $service->name;
                    $c = 0;
                    foreach (json_decode($request->item_object) as $key => $value) {
                        if(!isset($value->sub_category_id)){
                            
                            $is_maid = 1;
                            $service = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                            $service_item = ServiceAttributeValueItem::where('id',$service->ser_attr_val_item_id)->first();
                            $attribute = Attribute::where('id',$service->attribute_id)->first();
                            $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();

                            $params['sub_cate_id']          = $value->sub_category_id ?? null;
                            $params['main_sub_cat_id']      = $value->category_id ?? null;
                            $params['child_cate_id']        = $value->child_category_id ?? null;
                            $params['attribute_id']         = $attribute->id ?? null;
                            $params['attribute_name']       = $attribute->name ?? null;
                            $params['attribute_item_id']    = $value->attribute_item_id ?? null;
                            $params['attribute_item_name']  = $attribute_item->value ?? null;
                            $params['attribute_price']      = ( $service->attribute_price * $value->attribute_qty ) ;
                            $params['unit_price']      = ( $service->attribute_price??0 ) ;
                            $params['attribute_qty']        = $value->attribute_qty ?? null;
                            $params['service_type']         = '';
                            $params['card_id']              = $card->id;
                            
                            $data["attribute"][] = [
                                "category"=>Category::find($service_item->category_id)->name,
                                "name"=>$attribute_item->value,
                                "price"=>(string) $service->attribute_price,
                            ];
                            $attribute_total = $params['unit_price'] * $params['attribute_qty'];
                            
                            if($attribute->name == 'Hours'){
                                $totalAmount *= (float) $attribute_total; 
                            } else {
                                
                                $totalAmount += (float) $attribute_total; 
                            }
                            
                            preg_match('/\d+/', $attribute_item->value, $matches);

                            if (count($matches) > 0) {
                                $number = (int) $matches[0];
                                $total_count *= $number;
                            
                                $total_maids_material *= $number;
                                if ($attribute->name == 'Hours') {
                                } else {
                                    $total_maids *= $number;
                                }
                            }

                            $cardattr = CardAttribute::create($params);
                        } else {
                            if(empty($value->child_category_id)){
                                $service_item = ServiceAttributeValueItem::where([
                                    'service_id'=>$request->service_id,
                                    'category_id'=>$value->category_id,
                                    'sub_category_id'=>$value->sub_category_id
                                ])->first();
                            } else{
                                $service_item = ServiceAttributeValueItem::where([
                                    'service_id'=>$request->service_id,
                                    'category_id'=>$value->category_id,
                                    'sub_category_id'=>$value->sub_category_id,
                                    'child_category_id'=>$value->child_category_id,
                                ])->first();
                            }
                            if(!empty($service_item)){
                                $service = ServiceAttributeValue::where([
                                    'ser_attr_val_item_id'=>$service_item->id,
                                    'attribute_item_id'=>$value->attribute_item_id,
                                ])->first();
                                
                                $service_item = ServiceAttributeValueItem::where('id',$service->ser_attr_val_item_id)->first();
                                $attribute = Attribute::where('id',$service->attribute_id)->first();
                                $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                                
                                $params['sub_cate_id']          = $value->sub_category_id ?? null;
                                $params['main_sub_cat_id']      = $value->category_id ?? null;
                                $params['child_cate_id']        = $value->child_category_id ?? null;
                                $params['attribute_id']         = $attribute->id ?? null;
                                $params['attribute_name']       = $attribute->name ?? null;
                                $params['attribute_item_id']    = $value->attribute_item_id ?? null;
                                $params['attribute_item_name']  = $attribute_item->value ?? null;
                                $params['attribute_price']      = ( $service->attribute_price * $value->attribute_qty ) ;
                                $params['unit_price']      = ( $service->attribute_price ??0 ) ;
                                $params['attribute_qty']        = $value->attribute_qty ?? null;
                                $params['service_type']         = '';
                                $params['card_id']              = $card->id;

                                $data["attribute"][] = [
                                    "category"=>Category::find($service_item->category_id)->name,
                                    "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                    "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                    "name"=>$attribute_item->value ?? "",
                                    "price"=>(string) $service->attribute_price,
                                    "qty"=>(string) $value->attribute_qty];
                            
                                
                                $attribute_total = $params['unit_price'] * $params['attribute_qty'];
                                
                                if($attribute->name == 'Hours'){
                                    $totalAmount *= (float) $attribute_total; 
                                } else {
                                    
                                    $totalAmount += (float) $attribute_total; 
                                }

                                preg_match('/\d+/', $attribute_item->value, $matches);

                                if (count($matches) > 0) {
                                    $number = (int) $matches[0];
                                    $total_count *= $number;
                                
                                    //$total_maids_material *= $number;
                                    if ($attribute->name == 'Hours') {
                                    } else {
                                        $total_maids *= $number;
                                    }
                                }

                                $material_total += ($request->material_status == "Apply" ? (float) $material_default : 0) 
                                * (float) $value->attribute_qty;
                                
                                $cardattr = CardAttribute::create($params);
                            } 
                            $params['service_type']         = '';
                        }
                    } 
                    
                }   
                if($service->id == 10){
                    $material_total = $total_maids_material;
                } else {
                    $material_total = $material_total;
                }
                $material = ($request->material_status == "Apply") ? (float) $total_count : "0";
                // $material = $total_count;
                
                $cardattr = CardAttribute::where(['card_id' => $card->id])->get();

                if($request->service_id == "10"){
                    if(isset($request->selected_packages)){   
                        
                        if (SessionPackages::where('cart_id', $card->id)->exists()) {
                            SessionPackages::where('cart_id', $card->id)->delete();
                        }

                        $selectedPackageIds = explode(',', $request->selected_packages);

                        $packages = Packages::whereIn('id', $selectedPackageIds)->get();

                        foreach ($packages as $package) {
                            $data["packages"][] = [
                                "name"=>$package->name, 
                                "base_amount"=>(string) $package->amount,
                                "price"=>(string) ((int) $package->amount * (int) $total_count),
                                "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                            ]; 
                            $totalAmount = (float) $package->amount * (float) $total_count; 
                            $material *= ((int) $package->total_sessions);
                
                        }
                    }
                }

                $package_price = 0;
                if($request->service_id == 10){
                    $packages = Packages::find($request->selected_packages);
                    $package_price = $packages->amount;
                }

                $sub_total = $totalAmount;
                $res["sub_total"] = (string) $totalAmount;
                $mt = $material;
                $material *= $material_default;
                $totalAmount += (float) $mt;
                $res["material_default"] = (string) $material_default;
                $res["material"] = (string) $material;
                $card->update([
                    'material_charge'   => ($request->material_status == "Apply") ? (string) $material : '0',
                    'amount'            => $totalAmount,
                    'g_total'           => $res["sub_total"],
                    'package_price'     => $package_price,
                    'sub_total'         => $sub_total
                ]);

                $services = Service::find($request->service_id);
                $res['material_charge']     = $card->material_charge;
                $res["total_amount"]        = (string) $totalAmount;
                $res['cart_id']             = (string) $card->id;
                $res['service_name']        = $services->name;
                
                return $this->sendResponse($res, 'Item Added');
            } else {
                return $this->sendResponse([], 'Try Again');
            }
            
        } elseif($request->cart_id && $request->alternative_number && $request->dial_code && $request->address_id ) {
            
            $add_res = Address::find($request->address_id);
            $shippingAddress = [];

            if($request->address_id){
                if($add_res){
                    $shippingAddress['user_id']     = $add_res->user_id;
                    $shippingAddress['city_id']     = $add_res->city_id;
                    $shippingAddress['city_name']   = $add_res->city?$add_res->city->name:'';
                    $shippingAddress['address']     = $add_res->address;
                    $shippingAddress['address_type']= $add_res->address_type;
                    $shippingAddress['flat_no']     = $add_res->flat_no;
                    $shippingAddress['building']    = $add_res->building;
                    $shippingAddress['locality']    = $add_res->locality_info?$add_res->locality_info->name:'';
                    $shippingAddress['latitude']    = $add_res->latitude;
                    $shippingAddress['longitude']   = $add_res->longitude;

                    $data['address_id']         = $request->address_id;
                } else {
                    return $this->sendError('Address detials not found.');
                }
            } else {
                return $this->sendError('Address detials not found.');
            }

            $data = [
                'alternative_number' => $request->alternative_number,
                'alternative_dial_code' => $request->dial_code,
                'address_id' => json_encode($add_res),
            ];

            $card = Card::find($request->cart_id);

            if($card) {
                $card->update($data);
                
                $cardattr = CardAttribute::where(['card_id' => $card->id])->get();

                $services = Service::find($card->service_id);
                $res['sub_total']           = (string) $card->g_total;
                
                // if(!empty($card->selected_packages)){                
                //     $selectedPackageIds = explode(',', $card->selected_packages);
    
                //     $packages = Packages::whereIn('id', $selectedPackageIds)->get();
                //     $package_price = 0;
                //     foreach ($packages as $package) {
                //         $data["packages"][] = ["name"=>$package->name, "price"=>(string)$package->amount]; 
                //         $package_price += (int) $package->amount; 
                //     }
                //     $res["package_price"]       = (string) $package_price;
                // }

                $res['material_charge']     = $card->material_charge;
                $res['amount_total']        = (string) $card->amount;
                $res['cart_id']             = (string) $card->id;
                $res['service_name']        = $services->name;
                // $res['attributes']          = $cardattr;
                return $this->sendResponse($res, 'Card updated successfully.');
            } else {
                return response()->json(['error' => 'Card not found.'], 404);
            }

        } elseif($request->cart_id && ($request->slot_id || $request->sessions)) {
            $totalAmount = 0;

            $card = Card::find($request->cart_id);

            if($card) {

                if($card->service_id != 10 && !empty($request->slot_id)){
                    if($card->service_id == 13){
                        $data = [
                            'slot_id' => $request->slot_id,
                            'date' => $request->date,
                            'is_revisit' => $request->is_revisit,
                        ];
                        if($request->is_revisit){
                            // $booking        = Card::find($request->booking_id); 
                            // $accept_user_id = $booking->accept_user_id;
                            
                            // StaffCard::create(['card_id' => $card->id, 'user_id' => $accept_user_id, 'status'=>'Accept']);
                            $cart_message = 'Card updated for revisit successfully.';
                        }
                    } else{ 
                        
                        $data = [
                            'slot_id' => $request->slot_id,
                            'date' => $request->date,
                        ];
                    }
                    $card->update($data);
                }
                
                $cardattr = CardAttribute::where(['card_id' => $card->id])->get();

                $services = Service::find($card->service_id);
                $res['sub_total']           = (string) $card->g_total;
                
                if (!empty($card->selected_packages)) {
					$selectedPackageIds = explode(',', $card->selected_packages);
				
					$packages = Packages::whereIn('id', $selectedPackageIds)->get();
					$package_price = 0;
				
					if ($packages->isNotEmpty()) {
                        
						$session = SessionPackages::where([
							'cart_id' => $card->id, 
						])->delete();

						$session = SessionPackages::where([
							'cart_id' => $card->id, 
						])->first();
                        
						// $session = SessionPackages::where([
						// 	'package_id' => $packages[0]->id, 
						// 	'cart_id' => $card->id, 
						// ])->first();
				
						if ($session == null) {
                            
							foreach($request->sessions as $session){
								SessionPackages::create([
									'package_id' => $packages[0]->id,
									'cart_id' => $card->id,
									'service_id' => "10",
									'date' => $session['date'],
									'time' => $session['time'],
									'status' => 'Pending'
								]);
							}
							foreach ($packages as $package) {
								$data["packages"][] = ["name" => $package->name, "price" => (string)$package->amount];
								$package_price += (int)$package->amount;
								$totalAmount = (int) $package->amount * ((int) $package->total_sessions); 

								$totalSessions = (int)$package->total_sessions + (int)$package->free_sessions;
							}
						} else{
                            // Update existing sessions
                            foreach ($request->sessions as $sessionData) {
                                $existingSession = SessionPackages::where([
                                    'package_id' => $packages[0]->id,
                                    'cart_id' => $card->id,
                                ])->first();

                                if ($existingSession) {
                                    // Update session if it exists
                                    $existingSession->update([
                                        'date' => $sessionData['date'],
                                        'time' => $sessionData['time'], 
                                    ]);
                                } else {
                                    // Create a new session if no existing session matches
                                    SessionPackages::create([
                                        'package_id' => $packages[0]->id,
                                        'cart_id' => $card->id,
                                        'service_id' => "10",
                                        'date' => $sessionData['date'],
                                        'time' => $sessionData['time'],
                                        'status' => 'Pending'
                                    ]);
                                }
                            }
                        }
					}				
                    $res["package_price"]       = (string) $package_price;
                }

                $res['material_charge']     = $card->material_charge;
                $res['amount_total']        = (string) $totalAmount;
                $res['cart_id']             = (string) $card->id;
                $res['service_name']        = $services->name;
                return $this->sendResponse($res, $cart_message);
            } else {
                return response()->json(['error' => 'Card not found.'], 404);
            }

        } else {
            return $this->sendError('Required field is empty');
        }
    }


    public function get_card(Request $request)
    {
        if($request->user_id){
            $card = Card::where('user_id',$request->user_id)->where('status', '!=' , 'Canceled')->orderBy('id', 'DESC')->get();
            $cards = [];
            $allHaveSlotId = true;

            foreach ($card as $item) {
                if($item->service_id != 10){
                    if (empty($item->slot_id)) {
                        $allHaveSlotId = false;
                        break;
                    }
                } else{
                    if ($item->sessionPackages->isNotEmpty() && !empty($item->sessionPackages[0]->date)) {
                        $allHaveSlotId = true;
                    } else {
                        $allHaveSlotId = false;
                    }
                }
            }
            
            if (!$allHaveSlotId) {
                $datas['is_draft'] = "yes";
                $datas['step'] = "3";
            
                return $this->sendResponse($datas, 'Order is not completed, please fill the order!');
            } else {
                $card_data['is_draft'] = "no";
                $card_data['step'] = "0";
            }

            foreach ($card as $key => $value) {

                $service = Service::find($value->service_id);

                if(ServiceAttributeValueItem::where('service_id',$value->id)->with('sub_category')->first()->sub_category){
                    $data['sub_cate_yes'] = 'Yes';
                } else {
                    $data['sub_cate_yes'] = 'No';
                }

                $user = User::find($value->user_id);
                $category = Category::find($value->category_id);

                $data['booking_id']     = $value->id;
                $data['tran_id']        = normalizeId($value->tran_id);
                $data['paymentTranId']  = $value->paymentTranId;
                $data['user_id']        = $value->user_id;
                $data['user_name']      = $user?$user->name:'';
                $data['user_email']     = $user?$user->email:'';
                $data['user_mobile']    = $user?$user->phone:'';
                //$data['user_mobile']    = '000000000';
                $data['user_dial_code']    = $user ? $user->dial_code : '971';
                $data['service_id']     = $value->service_id;
                $data['staus']          = $value->status;
                $data['service']        = $service->name;
                $data['image']          = asset('/uploads/service/'.$service->thumbnail_img);
                $data['category_id']    = $value->category_id;
                $data['category']       = $category?$category->name:'';
                $data['slot_id']        = $value->slot_id;
                $data['slot']           = $value->slot?$value->slot->name:'';

                if(is_numeric($value->address_id)){

                    $data['address_id']     = $value->address_id;

                    $building = $value->address?$value->address->building:'';
                    $flat_no = $value->address?$value->address->flat_no:'';
                    $address = $value->address?$value->address->address:'';

                    $latitude = $value->address?$value->address->latitude:'';
                    $longitude = $value->address?$value->address->longitude:'';
                    $data['address']        = $building.', '. $flat_no.', '.$address;

                    if($value->address && $value->address->city){
                        $city = $value->address->city->name;
                    } else {
                        $city = "";
                    }

                    $data['city']           = $city;

                    if($value->address && $value->address->locality_info){
                        $locality = $value->address->locality_info->name;
                    } else {
                        $locality = "";
                    }
                    $data['locality']       = $locality;
                    
                    $data['latitude']       = $latitude;
                    $data['longitude']      = $longitude;

                } else {

                    $add_info = json_decode($value->address_id);

                    $data['address_id']     = '';


                    $building = $add_info?$add_info->building:'';
                    $flat_no = $add_info?$add_info->flat_no:'';
                    $address = $add_info?$add_info->address:'';

                    $latitude = $add_info?$add_info->latitude:'';
                    $longitude = $add_info?$add_info->longitude:'';
                    $data['address']        = $building.', '. $flat_no.', '.$address;

                    if($add_info && $add_info->city_name){
                        $city = $add_info->city_name;
                    } else {
                        $city = "";
                    }

                    $data['city']           = $city;

                    if($add_info && $add_info->locality){
                        $locality = $add_info->locality;
                    } else {
                        $locality = "";
                    }
                    $data['locality']       = $locality;
                    
                    $data['latitude']       = $latitude;
                    $data['longitude']      = $longitude;

                }


                $data['payment_moad']   = $value->payment_moad;
                $data['payment_status'] = $value->payment_status;
                $data['note']           = $value->note;
                $data['material_charge']= (string) $value->material_charge;
                $data['material_status']= ($value->material_status)?$value->material_status:"No";
                $data['service_type']   = $value->service_type;
                $data['alternative_number'] = $value->alternative_number;
                $data['date']           = $value->date;
                $data['tip']            = $value->tip_id;
                $data['coupon_id']      = $value->coupon_id;
                $data['is_checkout']    = $value->is_checkout;
                
                $card_attr = [];
                $sub_total = '00';
                $subtotal = '00';
                $total = '00';
                foreach (CardAttribute::where('card_id',$value->id)->get() as $key => $item) {

                    $sub_cat = Category::find($value->sub_cate_id);
                    $child_cat = ChildCategory::find($value->child_cate_id);

                    $params['sub_cate_id']          = $item->sub_cate_id;
                    $params['sub_cate_name']        = $sub_cat?$sub_cat->name:'';
                    $params['main_sub_cat_id']      = $item->main_sub_cat_id;
                    $params['main_sub_cat_name']    = $item->main_sub_cat?$item->main_sub_cat->name:'';
                    $params['child_cate_id']        = $item->child_cate_id;
                    $params['child_cate']           = $item->child_cate?$item->child_cate->name:'';
                    $params['attribute_id']         = $item->attribute_id;
                    $params['attribute_name']       = $item->attribute_name;
                    $params['attribute_item_id']    = $item->attribute_item_id;
                    $params['attribute_item_name']  = $item->attribute_item_name;
                    $params['attribute_qty']        = $item->attribute_qty;
                    $params['attribute_price']      = $item->attribute_price;
                    $params['service_type']         = $item->service_type;
                    $addons = [];

                    foreach (CardAddon::where('card_id',$value->id)->where('card_attribute_id',$item->id)->get() as $key => $cardaddon) {
                        $addon['card_id']               = $cardaddon->id;
                        $addon['card_attribute_id']     = $cardaddon->id;
                        $addon['add_on_id']             = $cardaddon->add_on_id;
                        $addon['name']                  = $cardaddon->name;
                        $addon['value']                 = $cardaddon->value;
                        $addon['percentage']            = $cardaddon->percentage;
                        array_push($addons,$addon);
                    }
                    $params['addon']      = $addons;
                    array_push($card_attr,$params);
                }

                $data['coupon']         = $value->coupon?$value->coupon->code:'';
                $data['coupon_amt']     = (string) $value->coupon_amt;
                $data['total']       = (string) $value->amount;
                $data['g_total']       = (string) $value->amount;
                $data['subtotal']          = (string) $value->g_total;
                $data['card_attribute'] = $card_attr;
               
                array_push($cards, $data);
            }
            // return $this->sendResponse($cards, 'Card Response');
        } else {
            return $this->sendError('Required field is empty');
        }
    }


    public function get_perticular_card(Request $request)
    {
        if($request->booking_id){
            $card = Card::where('id',$request->booking_id)->get();
            $cards = [];

            foreach ($card as $key => $value) {

                $service = Service::find($value->service_id);
                $user = User::find($value->user_id);
                $category = Category::find($value->category_id);

                $data['booking_id']     = $value->id;
                $data['tran_id']        = normalizeId($value->tran_id);
                $data['paymentTranId']  = $value->paymentTranId;
                $data['user_id']        = $value->user_id;
                $data['user_name']      = $user?$user->name:'';
                $data['user_email']     = $user?$user->email:'';
                $data['user_mobile']    = $user?$user->phone:'';
                $data['user_dial_code']    = $user ? $user->dial_code : '971';
                $data['service_id']     = $value->service_id;
                $data['service']        = $service->name;
                $data['category_id']    = $value->category_id;
                $data['category']       = $category?$category->name:'';
                $data['slot_id']        = $value->slot_id;
                $data['slot']           = $value->slot?$value->slot->name:'';
                $data['address_id']     = $value->address_id;
                $building = $value->address?$value->address->building:'';
                $flat_no = $value->address?$value->address->flat_no:'';
                $address = $value->address?$value->address->address:'';
                $data['address']        = $building.', '. $flat_no.', '.$address;
                $data['payment_moad']   = $value->payment_moad;
                $data['payment_status'] = $value->payment_status;
                $data['note']           = $value->note;
                $data['material_charge']= (string) $value->material_charge;
                $data['material_status']= $value->material_status;
                $data['service_type']   = $value->service_type;
                $data['alternative_number'] = $value->alternative_number;
                $data['date']           = $value->date;
                $data['tip']            = $value->tip_id;
                $data['coupon_id']      = $value->coupon_id;
                $data['is_checkout']    = $value->is_checkout;
                
                $card_attr = [];
                $sub_total = '00';
                $subtotal = '00';
                $total = '00';
                foreach (CardAttribute::where('card_id',$value->id)->get() as $key => $item) {

                    $sub_cat = Category::find($value->sub_cate_id);
                    $child_cat = ChildCategory::find($value->child_cate_id);

                    $params['sub_cate_id']          = $item->sub_cate_id;
                    $params['sub_cate_name']        = $sub_cat?$sub_cat->name:'';
                    $params['main_sub_cat_id']      = $item->main_sub_cat_id;
                    $params['main_sub_cat_name']    = $item->main_sub_cat?$item->main_sub_cat->name:'';
                    $params['child_cate_id']        = $item->child_cate_id;
                    $params['child_cate']           = $item->child_cate?$item->child_cate->name:'';
                    $params['attribute_id']         = $item->attribute_id;
                    $params['attribute_name']       = $item->attribute_name;
                    $params['attribute_item_id']    = $item->attribute_item_id;
                    $params['attribute_item_name']  = $item->attribute_item_name;
                    $params['attribute_qty']        = $item->attribute_qty;
                    $params['attribute_price']      = $item->attribute_price;
                    $params['service_type']         = $item->service_type;
                    $addons = [];

                    foreach (CardAddon::where('card_id',$value->id)->where('card_attribute_id',$item->id)->get() as $key => $cardaddon) {
                        $addon['card_id']               = $cardaddon->id;
                        $addon['card_attribute_id']     = $cardaddon->id;
                        $addon['add_on_id']             = $cardaddon->add_on_id;
                        $addon['name']                  = $cardaddon->name;
                        $addon['value']                 = $cardaddon->value;
                        $addon['percentage']            = $cardaddon->percentage;
                        array_push($addons,$addon);
                    }
                    $params['addon']      = $addons;
                    array_push($card_attr,$params);
                }

                $data['coupon']         = $value->coupon?$value->coupon->code:'';
                $data['coupon_amt']     = $value->coupon_amt;
                $data['total']       = $value->amount;
                $data['subtotal']          = $value->g_total;
                $data['card_attribute'] = $card_attr;

                array_push($cards, $data);
            }
            // return $this->sendResponse($cards, 'Card Response');
        } else {
            return $this->sendError('Required field is empty');
        }
    }

    public function card_transection_id_update(Request $request, $card_id='')
    {
        $card = Card::find($card_id);

        if($card){

            $data['tran_id']  = $request->tran_id;

            $card->update($data);

            return $this->sendResponse([], 'Card Updated');

        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function card_checkout_go(Request $request)
    {
        $card = Card::where(['user_id'=>auth()->user()->id])
        ->where('is_checkout', '!=', 'Done')
        ->orderBy('id', 'DESC')
        ->get();
        
        if (!$card->isEmpty()) {
            
            foreach ($card as $key => $value) {
                $past = false;

                if ($value->service_id == 10) {
                    $currentDateTime = now();
                    $sessionPackages = $value->sessionPackages->sortBy('date');
                    
                    if ($sessionPackages->isNotEmpty()) {
                        $serviceDate = Carbon::parse($sessionPackages->first()->date); // Convert to Carbon instance
                        $serviceTime = $sessionPackages->first()->time;
                        
                        // Check if the service date is today
                        if ($serviceDate && $serviceDate->isToday()) {
                            $slot = Slot::find($serviceTime);
                            
                            if ($slot && $slot->check_in) {
                                $slotDateTime = Carbon::createFromFormat('H:i:s', $slot->check_in)
                                    ->setDate($serviceDate->year, $serviceDate->month, $serviceDate->day);
                                
                                // Check if the current time is past the slot time
                                if ($slotDateTime->isPast()) {
                                    $past = true;
                                }
                            }
                        }
                    } else {
                        
                        return $this->sendError('Package Sessions are not updated.', 'step 3');
                    }
                } else {
                    $currentDateTime = now();
                    $serviceDate = $value->date ? Carbon::parse($value->date) : null;

                    if ($serviceDate && $serviceDate->isToday()) {
                        $slot = Slot::find($value->slot_id);
                        
                        if ($slot && $slot->check_in) {
                            $slotDateTime = Carbon::createFromFormat('H:i:s', $slot->check_in)
                                ->setDate($serviceDate->year, $serviceDate->month, $serviceDate->day);
                            
                            // Check if the current time is past the slot time
                            if ($slotDateTime->isPast()) {
                                $past = true;
                            }
                        }
                    }
                }

                if ($past) {
                    return $this->sendError('Remove the past date orders.', 'step 3');
                }

                
                if(empty($value->address_id)){
                    return $this->sendError('Your cart information is missing!', 'step 2');
                } 
                
                if($value->service_id != 10){
                    if(empty($value->slot_id)){
                        return $this->sendError('Your cart information is missing!', 'step 3');
                    }
                }
            }

            return $this->sendResponse($card, 'Cards Data');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function apply_coupon_calculation($code,$request)
    {
         $coupon = Coupon::where('code',$code)->where('status','1')->first();
         if(!empty($coupon)){
             if($coupon->start_date <= date('Y-m-d') && $coupon->end_date >= date('Y-m-d')){
 
                 $card = Card::where(['user_id'=>auth()->user()->id])
                 ->where('is_checkout', '!=', 'Done')
                 ->orderBy('id', 'DESC')
                 ->get();
                 
                 if($card){
                     
                     $cards = [];
                     $total_amount = 0;
                     $coupon_amount = 0;
                     $single_coupon_amount = 0;
                     $count_card = $card->count();
                     
                     foreach ($card as $key => $value) {
                             $surcharge = (float) Service::find($value->service_id)->cod_charge;
                             $cod = (int) HomeSetting::first()->cash_surcharge;
                             $card[$key]->surcharge = $surcharge;
                             if($request->payment_type == 2){
                                $card[$key]->cod_charge= $cod;
                            }else{
                                $card[$key]->cod_charge= 0;
                                $cod=0;
                            }
                             $total_amount += (float) $value->sub_total + $value->material_charge + $surcharge + $cod;
                             $coupon_amount += (float) $coupon->amount;
                                if($coupon->type == "Amt"){
                                    $single_coupon_amount += (float) round($coupon->amount / $count_card, 2);//$coupon->amount;
                                }else{
                                    $single_coupon_amount += (float) round( ( ($value->amount * $coupon_amount / 100) / $count_card ), 2);
                                }
 
                             $params['coupon_id']    = $coupon->id;
                             $params['coupon_amt']   = (float) round($coupon->amount / $count_card, 2);//$coupon->amount;
                             
                            //  $value->update($params);
                     }
                     if($coupon->type != "Amt"){
                        $single_coupon_amount = ($total_amount * $coupon->amount / 100);
                     }
         
                     $cards['before_total']     = (string) $total_amount;
                     $cards['single_coupon_amount']     = (float) $single_coupon_amount;
                     $cards['after_total']     = (string) ((int) $total_amount - (int) $coupon_amount);
 
                 } else {
                     return ['message'=>'Checkout is empty'];
                 }
                 return ['message'=>'Coupon Applied', 'data' => $cards];
             } else {
                 return ['message'=>'This Coupon is expired'];
             }
         } else {
             return ['message'=>'Coupon is not exist'];
         }
    }

    public function card_checkout_data(Request $request)
    {
        $cart_unique_id = "UMC-".rand(100000, 999999);
        Card::where(['user_id'=>auth()->user()->id])
             ->where('is_checkout', '!=', 'Done')
             ->update(['cart_unique_id'=>$cart_unique_id]);
             
        $card = Card::with('sessionPackages.slot')
        ->where(['user_id'=>auth()->user()->id])
        ->where('is_checkout', '!=', 'Done')
        ->orderBy('id', 'DESC')
        ->get();
        
        if($card){
            
            $cards = [];
            $cards_detail = [];
            $total_amount = 0;

            $cards['coupon_status']     = (string) "no";
            $cards['tip_status']     = (string) "no";
            $coupon_amount = 0;
            if(!empty($request->coupon_code)){
                $coupon = $this->apply_coupon_calculation($request->coupon_code,$request);
                if($coupon["message"] == "Coupon Applied"){
                    $cards['coupon_status']     = (string) "yes";
                    $cards['coupon_message']     = $coupon["message"];
                    $coupon_amount              = $coupon["data"]["single_coupon_amount"];

                } else { 
                    $cards['coupon_message']     = $coupon["message"];
                }
            }

            $tip_amount = 0;
            if(!empty($request->tip_amount)){
                $tip_amount = $request->tip_amount;
                $cards['tip_status']     = (string) "yes";
            }
            $total_count = 1;
            $card_id = 0;
            $cod = 0;
            $surcharge = 0;
            $total_amount = 0;
            $cart_sub_total = 0;

            foreach ($card as $key => $item) {
                $totalAmount = 0;
                // if($item->service_id != 10){
                //     if(empty($item->date)){
                //         return $this->sendError('Date is Missing');
                //     }
                //     if(empty($item->slot_id)){
                //         return $this->sendError('Time is Missing');
                //     }
                // }
            
                $surcharge = (float) Service::find($item->service_id)->cod_charge;
                $cod = (int) HomeSetting::first()->cash_surcharge;

                $card_data = [
                    'id'                     => $item->id,
                    'user_id'                => $item->user_id,
                    'service_id'             => $item->service_id,
                    'service_name'           => $item->service_name, 
                    'amount'           => $item->amount, 
                    'category_id'            => $item->category_id,
                    'slot_id'                => $item->slot_id,
                    'address_id'             => $item->address_id,
                    'tran_id'                => normalizeId($item->tran_id),
                    'payment_status'         => $item->payment_status,
                    'alternative_dial_code'  => $item->alternative_dial_code ?? "",
                    'alternative_number'     => $item->alternative_number,
                    'note'                   => $item->note,
                    'date'                   => $item->date,
                    'status'                 => $item->status,
                    'accept_user_id'         => $item->accept_user_id,
                    'material_status'        => $item->material_status,
                    'material_charge'        => $item->material_charge,
                    'is_checkout'            => $item->is_checkout,
                    'payment_collected'      => $item->payment_collected,
                    'service_completed'      => $item->service_completed,
                    'service_completed_date' => $item->service_completed_date,
                    'work_done'              => $item->work_done,
                    'pending_approval_by_admin' => $item->pending_approval_by_admin,
                    'booking_from'           => $item->booking_from,
                    'created_at'             => $item->created_at,
                    'updated_at'             => $item->updated_at,
                    'selected_packages'      => $item->selected_packages,
                    'preferred_days'         => $item->preffered_days,
                    'full_addrss'            =>  (object)($item->address??[]),
                    'cart_unique_id'         => (string)$cart_unique_id
                ];
                if($request->payment_type == 2){
                    $card_data['cod_charge'] = $cod;
                }
                $card_data['surcharge'] = $surcharge;
                $items = Service::find($item->service_id);
                $material_default = ($item->material_status == "Apply") ? (float) $items->material_price : 0;
            
                // Card Attributes and Add-ons
                $card_attr = [];
                $c = 0;
                $material_total = 0;
                $total_count = 1;
                $material = 0;
                $total_maids_material = 1;
                foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                    if(!isset($value->sub_cate_id)){
                        $is_maid = 1;
                        $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                        $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
                        $params['service_type']         = '';
                        
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name ?? "",
                            "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (int) $attribute_total; 
                        } else {
                            
                            $totalAmount += $attribute_total; 
                        }
                        
                        preg_match('/\d+/', $attribute_item->value, $matches);
                
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                            
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                
                    } else {
                        if(empty($value->child_category_id)){
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id
                            ])->first();
                        } else{
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id,
                                'child_category_id'=>$value->child_cate_id,
                            ])->first();
                        }
                        if(!empty($service_item)){
                            $services = ServiceAttributeValue::where([
                                // 'ser_attr_val_item_id'=>$service_item->id,
                                'attribute_item_id'=>$value->attribute_item_id,
                            ])->first();
                            $attribute = Attribute::where('id',$services->attribute_id)->first();
                            $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                            
                            $params['attribute_price']      = $services->attribute_price ?? null;
                            $params['attribute_qty']        = $value->attribute_qty ?? null;
                
                            $data["attribute"][] = [
                                "category"=>Category::find($service_item->category_id)->name,
                                "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                "name"=>$attribute_item->value ?? "",
                                "price"=>(string) $value->attribute_price,
                                "qty"=>(string) $value->attribute_qty];
                        
                            
                            $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                            
                            if($attribute->name == 'Hours'){
                                $totalAmount *= (float) $attribute_total; 
                            } else {
                                
                                $totalAmount += (float) $attribute_total; 
                            }
                
                            preg_match('/\d+/', $attribute_item->value, $matches);
                
                            if (count($matches) > 0) {
                                $number = (int) $matches[0];
                                $total_count *= $number;
                            
                                $total_maids_material *= $number;
                                if ($attribute->name == 'Hours') {
                                } else {
                                }
                            }
                            
                        } 
                        $params['service_type']         = '';
                    } 
                    $sub_cat = Category::find($value->sub_cate_id);
                    $child_cat = ChildCategory::find($value->child_cate_id);

                    $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                    $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                    $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                    $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                    $paramss['child_cate_id']        = (string) $value->child_cate_id;
                    $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                    $paramss['attribute_id']         = (string) $value->attribute_id;
                    $paramss['attribute_name']       = $value->attribute_name;
                    $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                    $paramss['attribute_item_name']  = $value->attribute_item_name;
                    $paramss['attribute_qty']        = (string) $value->attribute_qty;
                    $paramss['attribute_price']      = (string) $value->attribute_price;
                    $paramss['service_type']         = $value->service_type;
                    $paramss['unit_price']         = (string)$value->unit_price??0;
                
                    array_push($card_attr,$paramss);
                }

                $card_data['card_attribute'] = $card_attr;

                if($item->service_id == 10){
                    $material_total = $total_maids_material;
                } else {
                    $material_total = $material_total;
                }
                // $material = ($item->material_status == "Apply") ? (float) $material_total : "0";
                    $material = $total_count;
        
                $totalAmount = ((float)$item->amount);
                if($item->service_id == 10){
                    
                    if ($item->sessionPackages->isNotEmpty()) {
                        $card_data["sessions"] = $item->sessionPackages
                            ->sortBy('date')
                            ->map(function ($session) {
                                return [
                                    'id' => (string) $session->id,
                                    'cart_id' => $session->cart_id,
                                    'package_id' => $session->package_id,
                                    'slot' => $session->slot,
                                    'service_id' => $session->service_id,
                                    'date' => $session->date,
                                    'time' => $session->time,
                                    'status' => $session->status,
                                ];
                            })
                            ->values() 
                            ->toArray(); 
                    } else {
                        $card_data["sessions"] = [];
                    }
                    

                    if(isset($item->selected_packages) ){        
                        $selectedPackageIds = explode(',', $item->selected_packages);
                
                        $packages = Packages::whereIn('id', $selectedPackageIds)->get();
                
                        foreach ($packages as $package) {
                            
                            $card_data['is_package'] = "1";
                            $card_data["packages"][] = [
                                "name"=>$package->name, 
                                "base_amount"=>(string) $package->amount,
                                "price"=>(string) ((int) $package->amount * (int) $total_count),
                                "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                            ]; 
                            $totalAmount = ((int) $package->amount * (int) $total_count)-(float)$value->coupon_amt; 
                            $material *= ((int) $package->total_sessions) ;
                
                        }
                    } else {
                
                        $card_data['is_package'] = "0";
                        $card_data['packages'] = [];
                    }
                
                } else {
                
                    $card_data['is_package'] = "0";
                    $card_data['packages'] = [];
                }

                $card_data['coupon']         = $item->coupon?$item->coupon->code:'';
                $card_data['subtotal']       = $item->g_total ?? "";
                $card_data['coupon_amt']     = $item->coupon_amt ?? "";
                $material *= $material_default;
                // $totalAmount += $material;
                $totalAmount += $surcharge;
                
                if($request->payment_type == 2){
                    $totalAmount += $cod;
                }

                $card_data['material_charge'] = (string) $material;
                $card_data['material'] = (string) $material;
                
                if($item->material_status == 'Apply'){
                    $totalAmount += $material;
                }
                $card_data['g_total'] = (string) $totalAmount;
                $card_data['total'] = (string) $totalAmount;
                $card_data['subtotal'] = (string) $totalAmount;
                $cart_sub_total+=$totalAmount;
                $total_amount += $totalAmount;
                $cards_detail[] = $card_data;
                $card_id = $item->id;
                $data['card_attribute'] = $card_attr;
            }

            $cards['card'] = $cards_detail;
            if($total_amount < $coupon_amount){
                return $this->sendError('Cart amount less than coupon amount');
            }

            if($coupon_amount > 0){
                $cards['coupon_amount']     = (string) round($coupon_amount,1);
                $cards['coupon_status']     = "yes";
                if($total_amount > $coupon_amount){
                    $total_amount -= (float) $coupon_amount;
                }else{
                    $cards['coupon_amount']     = (string) round($total_amount,1);
                    $total_amount=0;
                }
                
            }
            if ($tip_amount > 0) {
                $cards['tip_amount'] = (string) $tip_amount;
                $cards['tip_status'] = "yes";
                $total_amount += $tip_amount;
            } else {
                $cards['tip_amount'] = (string) $tip_amount;
                $cards['tip_status'] = "no";
            }
            
            $cards['user_balance']  = auth()->user()->wallet_balance;
            $rewardData = $this->get_reward_price($total_amount);

            $cards['sub_total']         = (string) $cart_sub_total;
            if ($rewardData !== null) {
                $cards["remaining_reward_points"] = (string) $rewardData['remaining_reward_points'];
                $cards["reward_amount"] = (string) $this->get_reward_price($total_amount)['final_amount'];
                // $cards['total']         = (string) ((float) $total_amount - (float) $this->get_reward_price($total_amount)['final_amount']);
                // $cards['g_total']         = (string) ((float) $total_amount - (float) $this->get_reward_price($total_amount)['final_amount']);
                
                $cards["total"] = (string) $total_amount; 
                $cards["g_total"] = (string) $total_amount; 
            } else {
                $cards["remaining_reward_points"] = '0'; 
                $cards["reward_amount"] = '0'; 
                $cards["total"] = (string) $total_amount; 
                $cards["g_total"] = (string) $total_amount; 
            }
    
    
            return $this->sendResponse($cards, 'Cards Data');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function send_email_notification($card){
        $array['view']      = 'emails.invoice';
        $array['subject']   = 'Your Booking Invoice';
        $array['data']      = $card;
        if($card->user && $card->user->email){
            $res = \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
        }                

        $adminarray['view']      = 'emails.invoice';
        $adminarray['subject']   = 'You Have New Service Booking';
        $adminarray['data']      = $card;
    
        \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));
        // $admins = User::where('role', 'admin')->get();

        // foreach ($admins as $admin) {
        //     Mail::to($admin->email)->send(new \App\Mail\Mail($adminarray));
        // }

        $ser_users = get_seller_info_by_service($card?$card->service_id:'');
        if($ser_users){
            foreach ($ser_users as $key => $val) {
                if(isset($val->device_token)){
                    
                    $token  = $val->device_token;
                            
                    $service = $card->service?$card->service->name:'No Service';
                        
                    $title  = 'New Booking Arrived';
                    $body   = "Heads up! A new booking just came in Urbanmop Partner App for '.$service.' Don't miss out on this chance to earn extra money.";
                    $text   = "Heads up! A new booking just came in Urbanmop Partner App for '.$service.' Don't miss out on this chance to earn extra money.";

                    send_notification($token, $title, $body, $text);
                }
            }
        }   
    }
    private function generate_telr_payment_link($off_line_booking,$g_total){
	    if(is_numeric($off_line_booking->address_id)){
            $addres = Address::with(['city'])->find($off_line_booking->address_id);
	    }else{
	        $addres = json_decode($off_line_booking->address_id);
	    }
        $user= User::find($off_line_booking->user_id);
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post('https://secure.telr.com/gateway/api_quicklink.json', [
            "QuickLinkRequest" => [
                "storeID" => env('TELR_STORE_ID'),
                "authKey" => env("TELR_AUTH_KEY"),
                "Details" => [
                    "Desc" => "Cash Payment Link Generation",
                    "Cart" => $off_line_booking->tran_id,
                    "Currency" => "AED",
                    "Amount" => $g_total,
                    "FullName" => $user->name??'',
                    "Addr1" => $addres->address??'',
                    "City" => $addres->city->name??'',
                    "Country" => "",
                    "Email" => $user->email??'',
                    "Phone" => $user->dial_code.$user->phone,
                ]
            ]
        ]);
        
        if ($response->successful()) {
            $data = $response->json();
            if (isset($data['QuickLinkResponse']['URL'])) {
                $encodedUrl = $data['QuickLinkResponse']['URL'];
                $decodedUrl = urldecode($encodedUrl);
                
                return $decodedUrl;
            } else {
                return '';
            }
        } else {
            //dd($response->body()); // Show error response
           return '';
        }
    }

    public function card_payment_update(Request $request)
    {
        $order = Order::find($request->order_id);
        $order->ref = $request->transaction_ref;
        $order->save();
        $cards = Card::where(['user_id'=>auth()->user()->id])
        ->where('is_checkout', '!=', 'Done')
        ->get()
        ->map(function ($card) {
            $card->amount = (string) $card->amount; 
            return $card;
        });
        $allHaveSlotId = true;

        foreach ($cards as $card) {
            if($card->service_id != 10){
                if (empty($card->slot_id)) {
                    $allHaveSlotId = false;
                    break;
                }
            }
        }
        
        if (!$allHaveSlotId) {
            $datas['is_draft'] = "yes";
            $datas['step'] = "3";
        
            return $this->sendResponse($datas, 'Order is not completed, please fill the order!');
        }
        
        $all_subtotal = 0;
        $total    = 0;
        $card_ids=[];
        if (!$cards->isEmpty()) {
            $cod = 0;
            $count_card = $cards->count();
            $tip_per_card = (float) round($order->tip_amount / $count_card, 2);
            $coupon_per_card = (float) round($order->coupon_amount / $count_card, 2);
            $order_total = 0;
            foreach ($cards as $card) {
                if($card){
                    $card_ids[] = $card->id;
                    $data['tip_id'] = 0;
                    if(!empty($order->tip_amount)){
                        $data['tip_id']         = $tip_per_card;
                    }
                    $data['amount'] = $card->sub_total;
                    $data['card_process']   = 'Complete';
                    $data['payment_status'] = "True";
                    $data['payment_type']   = $order->payment_type;
                    //$data['booking_from']   = $request->booking_from?$request->booking_from:'App';
    
                    $cod += (float) Service::find($card->service_id)->cod_charge;
                    $subtotal = (float)$card->g_total+(float)$cod;
                    $total += (float)$card->amount+(float)$cod;
                    

                    $coupon = Coupon::where('id',$request->coupon_id)->where('status','1')->first();
                    if($coupon){
                        $user_coupon['user_id'] = $card->user_id;
                        $user_coupon['coupon_id'] = $card->coupon_id;
                        UserCoupon::create($user_coupon);
    
                        $crd_coupon['card_id']      = $card->id;
                        $crd_coupon['coupon_id']    = $coupon->id;
                        $crd_coupon['code']         = $coupon->code;
                        $crd_coupon['amount']       = $coupon->amount;
                        $crd_coupon['min_amount']   = $coupon->min_amount;
                        $crd_coupon['max_amount']   = $coupon->max_amount;
                        $crd_coupon['type']         = $coupon->type;
                        $crd_coupon['start_date']   = $coupon->start_date;
                        $crd_coupon['end_date']     = $coupon->end_date;
    
                        if(CardCoupon::where('card_id',$request->card_id)->exists()){
                            CardCoupon::where('card_id',$request->card_id)->update($crd_coupon);
                        } else {
                            CardCoupon::create($crd_coupon);
                        }
    
                        $amount = $order->coupon_amount;
                        if($coupon->type=='Amt'){
                            $total = $subtotal - $amount;
                            $coupon_Amt = $amount;
                        } else {
                            $per = ($amount / 100) * $subtotal;
                            $total = $subtotal - $per;
                            if($per>$coupon->max_amount){
                                $coupon_Amt = $coupon->max_amount;
                            } else {
                                $coupon_Amt = $per;
                            }
                        }
                    } else {
                        $coupon_Amt = '00';
                    }
                    //$data['coupon_amt'] = $coupon_per_card;
                    $service = Service::find($card->service_id);

                    if ($service && !is_null($service->cod_charge)) {
                        $data['surcharge'] = $service->cod_charge;
                    } else {
                        $data['surcharge'] = 0;
                    }
                    
                    if($order->payment_type == 2){
                        $data['cod']= $card->cod;
                    }else{
                        $data['cod']= 0;
                    }
                    
                    $data['is_checkout'] = 'Done';
                    $data['g_total'] = $card->sub_total + $data['surcharge'] - $card->coupon_amt + (float)$data['cod'] + $card->material_charge + $data['tip_id'];
                    $data['paymentLinkId'] = $request->transaction_ref;
                    $card->update($data);

                    $input=[
                        'customer_id' => auth()->user()->id,
                        'vendor_id'=> SellerService::where("service_id",$card->service_id)->first()->seller_id,
                        'amount'=>(string) ((float)$card->amount+(float)$cod),
                        'remark'=>"Done",
                        'type'=>'Dr'
                    ];
                    
                    $res=Transection::create($input);

                    // $new_data['tran_id'] = 'UM-'.uniqid().time();//$res->id;
                    
                    // $card->update($new_data);

                    // $datas = [
                    //     'user_id' => $card->user_id,
                    //     'wallet_amount' => auth()->user()->wallet_balance,
                    //     'amount' => (string)$card->amount+(float)$cod,
                    //     'pay_type' => 'Booking Service',
                    //     'type' => 'debit',
                    //     'pay_method' => $order->payment_type,
                    //     'description' => "Payment Successful",
                    // ];
                    // if($order->payment_type == 3){
                    //     if (wallet_history($datas)) {
                    //         // WalletPaymentReport::where(['transaction_id' => $res->id, 'user_id' => $user_id])->update(['payment_status' => 'A']);
                    //         // $status = "1";
                    //         // $message = "Wallet recharged successfully";
                    //     } 
                    // } 
                    if($order->payment_type == 5){ 
                        $rewarUser = RewardUser::create([
                            'booking_type' => 'Purchase',
                            'transection_id' => $res->id,
                            'date' => Carbon::today()->toDateString(),
                            'user_id' => auth()->user()->id,
                            'reward_config_id' => 1, 
                            // 'points' => -calculatePoints($total),
                            'points' => -$total,
                            'amounts' => -$total
                        ]);
                    }

                    // $this->send_email_notification($card);
                    // $order_total+=((float) ($card->amount + $card->surcharge ) - 
                    // (float) ($card->coupon_amt ?? 0) + 
                    // (float) ($card->tip_id ?? 0));
                    $order_total+=$card->g_total;
                     if($order->payment_type == "2"){
                         //$order_total+=$card->cod;
                     }
                    if($res)
                    {
                        
                        $invite = Invite::where('invite_code', auth()->user()->invite)->first();

                        if ($invite && auth()->user()->is_invite) {
                        
                            $earn_user = User::firstOrCreate(
                                ['id' => $invite->user_id], 
                                ['wallet_balance' => "0"]               
                            );
                            
                            $earn_user->wallet_balance = ($earn_user->wallet_balance ?? "0") + "10"; 
                            $earn_user->save();
                        
                            $wallet = Wallet::firstOrCreate(
                                ['user_id' => $earn_user->id], 
                                ['balance' => 0]               
                            );
                            
                            $wallet->balance = ($wallet->balance ?? 0) + 10; 
                            $wallet->save();
                        }

                        $order = Order::find($card->order_id); 

                        $amount_total = (string)
                        (round((float) ($card->amount ?? 0) - 
                              (float) ($order->coupon_amount ?? 0) + 
                              (float) ($order->tip_amount ?? 0), 2));

                        if($order->payment_type == "3"){
                            // auth()->user()->update([
                            //     "wallet_balance" => round((float) auth()->user()->wallet_balance - $total, 2),
                            //     "is_invite" => 0
                            // ]);   
                        }
                        
                        $user_wallet = Wallet::firstOrCreate(
                            ['user_id' => auth()->user()->id], 
                            ['balance' => 0] 
                        );
                        
                        // $user_wallet->balance = (round((float) auth()->user()->wallet_balance - $total, 2) ?? 0);
                        // $user_wallet->save();
                    }
                    


                } else {
                    return $this->sendError('Invalid booking id');
                }
            }
            
            if($order->payment_type == 2){
                $cart_item = Card::find($card->id);
                $new_input['payment_link'] = $this->generate_telr_payment_link($cart_item,$order_total);
                Card::whereIn('id',$card_ids)->update($new_input);
            }
    
            $res['subtotal']       = (string) $subtotal;
            $res['total']          = (string) $total;

            $datas = [
                        'user_id' => auth()->user()->id,
                        'wallet_amount' => auth()->user()->wallet_balance,
                        'amount' => (string)$order_total,
                        'pay_type' => 'Service Booking',
                        'type' => 'debit',
                        'pay_method' => $order->payment_type,
                        'description' => "Payment Successful",
                    ];
                    if($order->payment_type == 3){
                        if (wallet_history($datas)) {
                            $user = User::find(auth()->user()->id);
                            $user->wallet_balance -= $order_total;
                            $user->save();
                        } 
                    }
            
            $user = User::find(auth()->user()->id);
            $paymentreport = [
                'transaction_id' => $order->invoice,
                'payment_status' => 'P',
                'user_id' => $user->id,
                'ref_id' => $order->ref,
                'amount' => $total,
                'method_type' => $order->payment_type,
                'created_at' => gmdate('Y-m-d H:i:s'),
            ];

            WalletPaymentReport::insert($paymentreport);
            
            if($total > HomeSetting::select("min_cart_value")->first()->min_cart_value){

               $res['reward'] = $this->handle_reward($res->created_at, $res->id, $total);

            }
            exec("php ".base_path()."/artisan send-self_booking:push ".$card->id." ".auth()->user()->id." > /dev/null 2>&1 & ");
            // $seller = User::find($user_id);
            // $user = User::find(auth()->user()->id);

            // if ($user) {
            //     $device_tokens = $user->user_device_token;
            //     $firebase_user_key = $user->firebase_user_key;
            
            //     if (!empty($device_tokens) && $device_tokens != '0') {
            //         if (strlen($device_tokens) > 70) {
            //             // Logic when token length exceeds 70
            //             $title  = "#" . $card->id;
            //             $body   = "You have succesfully place the booking";
            //             $text   = "A new booking just came in for {$card->service_name} via Urbanmop Partner App. Take action quickly!";

            //             if (!empty($firebase_user_key)) {
            //                 $user_firebase_key = $firebase_user_key; 
            //                 $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
            //                     "title" => $title,
            //                     "description" => $body,
            //                     "notificationType" => 'card_payment_update',
            //                     "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
            //                     "cardId" => (string)$card->id,
            //                     "status" => "1",
            //                     "url" => "",
            //                     "imageURL" => '',
            //                     "read" => "0",
            //                     "seen" => "0",
            //                 ];
            //                 $this->database->getReference()->update($notification_data);

            //                 send_single_notification(
            //                     $device_tokens,
            //                     [
            //                         "title" => $title,
            //                         "body" => $body,
            //                         "icon" => 'myicon',
            //                         "sound" => 'default',
            //                         "click_action" => "EcomNotification",
            //                     ],
            //                     [
            //                         "type" => 'card_payment_update',
            //                         "notificationID" => time(),
            //                         "status" => "1",
            //                         "imageURL" => "",
            //                         "cardId" => (string)$card->id,
            //                     ]
            //                 );
            //             }
            //         }
            //     }

            // }
            exec("php ".base_path()."/artisan send_all_selle_booking_notification:init ".$card->id." > /dev/null 2>&1 & ");
            // $seller_id = SellerService::where('service_id', $card->service_id)->first()->seller_id;
            // $user_id = Seller::find($seller_id)->user_id;
            // $users = User::where(['role' => 'vendor'])->get();
            // foreach($users as $user){
            //     $seller = Seller::where('user_id',$user->id)->first();
            //     $device_tokens = $user->user_device_token;
            //     $firebase_user_key = $user->firebase_user_key;
            //     if (!empty($seller) && SellerService::where(['service_id' => $card->service_id, 'seller_id' => $seller->id])->exists()) {
                
            //         if (!empty($device_tokens) && $device_tokens != '0') {
            //             if (strlen($device_tokens) > 70) {
            //                 // Logic when token length exceeds 70
            //                 $title  = "#" . $card->id;
            //                 $body   = "Heads up! You have a new booking on Urbanmop Partner App for {$card->service_name}. Don't miss out on extra earnings!";
            //                 $text   = "A new booking just came in for {$card->service_name} via Urbanmop Partner App. Take action quickly!";

            //                 if (!empty($firebase_user_key)) {
            //                     $user_firebase_key = $firebase_user_key; 
                                    
            //                     $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
            //                         "title" => $title,
            //                         "description" => $body,
            //                         "notificationType" => 'card_payment_update',
            //                         "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
            //                         "cardId" => (string)$card->id,
            //                         "status" => "1",
            //                         "url" => "",
            //                         "imageURL" => '',
            //                         "read" => "0",
            //                         "seen" => "0",
            //                     ];
            //                     $this->database->getReference()->update($notification_data);

            //                     send_single_notification(
            //                         $device_tokens,
            //                         [
            //                             "title" => $title,
            //                             "body" => $body,
            //                             "icon" => 'myicon',
            //                             "sound" => 'default',
            //                             "click_action" => "EcomNotification",
            //                         ],
            //                         [
            //                             "type" => 'card_payment_update',
            //                             "notificationID" => time(),
            //                             "status" => "1",
            //                             "imageURL" => "",
            //                             "cardId" => (string)$card->id,
            //                         ]
            //                     );
            //                 }
            //             }
            //         }
            //     }
            // }

            if(!empty(auth()->user()->email)){
                $array['view']      = 'emails.booking_completed';
                $array['subject']   = 'Your Order Booked Successfully!';
                $array['data']      = $cards;
                $array['user']      = auth()->user();
                exec("php ".base_path()."/artisan card_payment_update:mail ".auth()->user()->id." > /dev/null 2>&1 & ");
                //\Mail::to(auth()->user()->email)->send(new \App\Mail\Mail($array));

                // $mail_entry = new MailJobs();
                // $mail_entry->to_email = auth()->user()->email??'';
                // $mail_entry->subject = 'Your Order Booked Successfully!';
                // $mail_entry->json_array = json_encode($array);
                // $mail_entry->created_at = gmdate('Y-m-d H:i:s');
                // $mail_entry->updated_at = gmdate('Y-m-d H:i:s');
                // $mail_entry->save();
                // exec("php ".base_path()."/artisan mailinit:job ".$mail_entry->id." > /dev/null 2>&1 & ");
            }

            return $this->sendResponse($res, 'Checkout Successfully!');
        }else {
            return $this->sendError('Your Cart is empty!');
        }
        
    }

    public function updateUserReward($created_at, $id, $point, $amount)
    {
        $userId = auth()->user()->id;
    
        // Check if the user exists in the users table
        $userExists = \DB::table('users')->where('id', $userId)->exists();
    
        if (!$userExists) {
            throw new \Exception('User not found in the users table');
        }
    
        // Delete any existing user reward for this user
        // RewardUser::where('user_id', $userId)->delete();
        $rewardConfig = RewardConfig::where('name', 'reward')->first();
    
        // Create a new reward entry
        // $userReward = RewardUser::create([
        //     'booking_type' => 'Purchase',
        //     'transection_id' => $id,
        //     'date' => $created_at,
        //     'user_id' => $userId,
        //     'reward_config_id' => 1, 
        //     'points' => -($amount / (int)$rewardConfig->value),
        //     'amounts' => -$amount
        // ]);
    
        return $userReward;
    }
    
    public function all_bookings(Request $request)
    {
        return $request;
    }

    public function get_expired_accept_session(Request $request)
    {
        // Fetch all sessions with status 'Accept'
        $sessions = SessionPackages::where('status', 'Accept')->get();

        foreach ($sessions as $session) {
            $sessionDate = Carbon::parse($session->date);

            // Check if the session is expired
            $slot = Slot::find($session->time);
            if ($slot && (
                $sessionDate->isPast() || 
                ($sessionDate->isToday() && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in)))
            )) {
                // Update the current session status to 'Expired'
                $session->update(['status' => 'Expired']);
                Log::info("Session ID {$session->id} marked as Expired.");

                // Find the next session for the same card
                $nextSessions = SessionPackages::where('cart_id', $session->cart_id)
                ->whereIn('status',['Pending','Upcoming'])
                ->where(function ($dateQuery) {
                    $dateQuery->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Allow today's sessions
                    ->whereHas('slot', function ($timeQuery) {
                        $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                    });
                })
                ->get();

                // Loop through each session and check if it starts within 2 hours from now
                foreach ($nextSessions as $nextSession) {
                    $nextSlot = Slot::find($nextSession->time);
                    if ($nextSlot) {
                        $nextSessionTime = Carbon::createFromFormat('Y-m-d H:i:s', $nextSession->date . ' ' . $nextSlot->check_in);

                        if (Carbon::now()->diffInHours($nextSessionTime, false) <= 2) {
                            // Update the session status to 'Accept'
                            $nextSession->update(['status' => 'Accept']);
                            Log::info("Session ID {$nextSession->id} marked as Accept.");
                        }
                    }
                }
            }
        }

        return $this->sendResponse([], 'Expred Accept Session Updated.');
    }  

    public function get_expired_booking(Request $request)
    {
        $limit = $request->get('limit', 10);
        $page = $request->get('page', 1); 
        $date = $request->date; 
        $user = User::find(auth()->user()->id);
        if($user->wallet_balance < 0 || $user->wallet_balance == '0'){
            $wallet = '0';
        } else {
            $wallet = $user->wallet_balance;
        }
        $sellerId = Seller::where('user_id', $user->id)->value('id'); // Get seller ID directly
        $serviceIds = SellerService::where('seller_id', $sellerId)->pluck('service_id')->toArray();
    
        $card = Card::with('slot')
        ->whereIn('service_id', $serviceIds)
        ->where('is_checkout', 'Done')
        ->whereDoesntHave('vendorCardStatuses', function ($query) {
            $query->where('vendor_id', auth()->id())
                ->where('status', 'Cancelled');
        })
        ->where(function ($query) {
            // For services other than service_id = 10
            $query->where(function ($subQuery) {
                $subQuery
                    ->where('service_id', '!=', 10)
                    ->where(function ($innerQuery) {
                        $innerQuery->where(DB::raw('DATE(date)'), '<', Carbon::today()->toDateString()) // Past dates
                        ->orWhere(function ($dateQuery) {
                            $dateQuery->where('status','Pending')->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Today's sessions with past times
                                ->whereHas('slot', function ($timeQuery) {
                                    $timeQuery->whereRaw("TIME(check_in) < ?", [Carbon::now()->format('H:i:s')]);
                                });
                        });
                    });
            })->orWhere(function ($query) {
                // For service_id = 10, use sessionPackages for date and slot
                $query->where('service_id', 10)
                    ->whereHas('sessionPackages', function ($subQuery) {
                        $subQuery->where(DB::raw('DATE(date)'), '<', Carbon::today()->toDateString()) // Past dates
                        ->orWhere(function ($dateQuery) {
                            $dateQuery->where('status','Pending')->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Today's sessions with past times
                                ->whereHas('slot', function ($timeQuery) {
                                    $timeQuery->whereRaw("TIME(check_in) < ?", [Carbon::now()->format('H:i:s')]);
                                });
                        });
                    });
            });
            
        })
        ->orderBy('id', 'DESC')
        ->paginate($limit, ['*'], 'page', $page);

    
        // Initialize the response array
        $cards = [];

        // Check if there are results in the query
        if ($card->count()) {
            foreach ($card as $item) {
                $service = Service::find($item->service_id);

                $check = StaffCard::where('card_id', $item->id)->with(['user', 'card']);

                $matchedSession = $item->sessionPackages->first(function ($session) use ($date) {
                    if (empty($date)) {
                        return true; 
                    }

                    // Check if the date is 'upcoming'
                    if ($date === 'upcoming') {
                        return Carbon::parse($session->date)->gte(Carbon::tomorrow());
                    }
                
                    // For specific date matching
                    return $session->date == $date;
                });
                
                $data['matched_session_id'] = $matchedSession ? (string) $matchedSession->id : null;
                
                if ($check->exists()) {
                    $data['added_staff'] = $check->get()->map(function ($staffCard) {

                        return [
                            'status' => $staffCard->card->status ?? null,
                            'id' => $staffCard->user_id ?? null,
                            'first_name' => $staffCard->staff->first_name ?? null,
                            'last_name' => $staffCard->staff->last_name ?? null,
                            'phone' => $staffCard->staff->phone ?? null,
                            'dial_code' => $staffCard->staff->dial_code ?? null,
                        ];
                    })->toArray();
                    $data['payment_type'] = $item->payment_type;
                } else {
                    $data['added_staff'] = [];
                    $data['payment_type'] = $item->payment_type;
                }

                $user = User::find($item->user_id);
                $category = Category::find($item->category_id);

                $data['booking_id']     = (string) $item->id;
                $data['tran_id']        = (string) normalizeId($item->tran_id);
                $data['user_id']        = (string) $item->user_id;
                $data['user_name']      = $user ? $user->name : '';
                $data['user_email']     = $user ? $user->email : '';
                $data['user_mobile']    = $user ? $user->phone : '';
                //$data['user_mobile']    = '000000000';
                $data['user_dial_code']    = $user ? $user->dial_code : '971';
                $data['service_id']     = (string) $item->service_id;
                $data['service']        = $service->name;
                $data['image']          = asset('/uploads/service/' . $service->thumbnail_img);
                $data['category_id']    = (string) $item->category_id;
                $data['category']       = $category ? $category->name : '';
                $data['slot_id']        = $item->slot_id;
                $data['slot']           = $item->slot ? $item->slot->name : '';
                $data['offline_charge'] = $item->offline_charge;
                $data['offline_discount'] = $item->offline_discount;
                // if (!is_null($item->date) && Carbon::parse($item->date)->isPast()) {
                //     $data['status'] = 'Expired';
                // } else {
                //     $data['status'] = $item->status;
                // }          
                $data['status'] = $item->status;      
                // Address Logic
                if (is_numeric($item->address_id)) {
                    $data['address_id'] = $item->address_id;
                    $building = $item->address ? $item->address->building : '';
                    $flat_no = $item->address ? $item->address->flat_no : '';
                    $address = $item->address ? $item->address->address : '';
                    $data['address'] = $building . ', ' . $flat_no . ', ' . $address;
                    $data['city'] = $item->address && $item->address->city ? $item->address->city->name : '';
                    $data['locality'] = $item->address && $item->address->locality_info ? $item->address->locality_info->name : '';
                    $data['latitude'] = $item->address ? $item->address->latitude : '';
                    $data['longitude'] = $item->address ? $item->address->longitude : '';
                } else {
                    // For custom address in JSON
                    $add_info = json_decode($item->address_id);
                    $data['address_id'] = '';
                    $building = $add_info ? $add_info->building : '';
                    $flat_no = $add_info ? $add_info->flat_no : '';
                    $address = $add_info ? $add_info->address : '';
                    $data['address'] = $building . ', ' . $flat_no . ', ' . $address;
                    $data['city'] = $add_info && isset($add_info->city_name) ? $add_info->city_name : '';
                    $data['locality'] = $add_info && $add_info->locality ? $add_info->locality : '';
                    $data['latitude'] = $add_info ? $add_info->latitude : '';
                    $data['longitude'] = $add_info ? $add_info->longitude : '';
                }

                $data['payment_moad']   = $item->payment_moad;
                $data['payment_status'] = $item->payment_status;
                $data['note']           = $item->note;
                $data['material_charge']= (string) $item->material_charge;
                $data['material_status']= $item->material_status;
                $data['service_type']   = $item->service_type;
                $data['alternative_dial_code']  = $item->alternative_dial_code;
                $data['alternative_number'] = $item->alternative_number;
                $data['date']           = $item->date;
                $data['tip']            = (string) $item->tip_id;
                $data['coupon_id']      = $item->coupon_id;
                $data['is_checkout']    = $item->is_checkout;

                // Card Attributes and Add-ons
                $card_attr = [];
                $c = 0;
                $material_total = 0;
                $material = 0;
                $total_count = 1;
                $totalAmount = 1;
                $surcharge = 0;
                $total_maids_material = 0;

                foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                    if(!isset($value->sub_cate_id)){
                        $is_maid = 1;
                        $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                        $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
                        $params['service_type']         = '';
                        
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name ?? "",
                            "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (int) $attribute_total; 
                        } else {
                            
                            $totalAmount += $attribute_total; 
                        }
                        
                        preg_match('/\d+/', $attribute_item->value, $matches);
                
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                            
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                
                    } else {
                        if(empty($value->child_category_id)){
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id
                            ])->first();
                        } else{
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id,
                                'child_category_id'=>$value->child_cate_id,
                            ])->first();
                        }
                        if(!empty($service_item)){
                            $services = ServiceAttributeValue::where([
                                // 'ser_attr_val_item_id'=>$service_item->id,
                                'attribute_item_id'=>$value->attribute_item_id,
                            ])->first();
                            $attribute = Attribute::where('id',$services->attribute_id)->first();
                            $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                            
                            $params['attribute_price']      = $services->attribute_price ?? null;
                            $params['attribute_qty']        = $value->attribute_qty ?? null;
                
                            $data["attribute"][] = [
                                "category"=>Category::find($service_item->category_id)->name,
                                "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                "name"=>$attribute_item->value ?? "",
                                "price"=>(string) $services->attribute_price,
                                "qty"=>(string) $value->attribute_qty];
                        
                            
                            $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                            
                            if($attribute->name == 'Hours'){
                                $totalAmount *= (float) $attribute_total; 
                            } else {
                                
                                $totalAmount += (float) $attribute_total; 
                            }
                
                            preg_match('/\d+/', $attribute_item->value, $matches);
                
                            if (count($matches) > 0) {
                                $number = (int) $matches[0];
                                $total_count *= $number;
                            
                                $total_maids_material *= $number;
                                if ($attribute->name == 'Hours') {
                                } else {
                                }
                            }
                            
                        } 
                        $params['service_type']         = '';
                    } 
                    $sub_cat = Category::find($value->sub_cate_id);
                    $child_cat = ChildCategory::find($value->child_cate_id);

                    $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                    $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                    $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                    $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                    $paramss['child_cate_id']        = (string) $value->child_cate_id;
                    $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                    $paramss['attribute_id']         = (string) $value->attribute_id;
                    $paramss['attribute_name']       = $value->attribute_name;
                    $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                    $paramss['attribute_item_name']  = $value->attribute_item_name;
                    $paramss['attribute_qty']        = (string) $value->attribute_qty;
                    $paramss['attribute_price']      = (string) $value->attribute_price;
                    $paramss['service_type']         = $value->service_type;
                    $paramss['unit_price']         = $value->unit_price??0;
                
                    array_push($card_attr,$paramss);
                }

                if($item->service_id == 10){  
                    if ($item->sessionPackages->isNotEmpty()) {
                        $data["sessions"] = $item->sessionPackages
                            ->sortBy('date')
                            ->map(function ($session) {
                                $status = $session->status;

                                // if (!is_null($session->date)) {
                                //     $sessionDate = Carbon::parse($session->date);
                    
                                //     if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                                //         // If the session date is in the past and not today, mark as Expired
                                //         $status = 'Expired';
                                //     } elseif ($sessionDate->isToday()) {
                                //         // If the session date is today, check the session time
                                //         $slot = Slot::find($session->slot_id);
                                //         if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                                //             $status = 'Expired Time';
                                //         }
                                //     } else {
                                //         $status = $session->status;
                                //     } 
                                // }
                               
                                return [
                                    'id' => $session->id,
                                    'cart_id' => $session->cart_id,
                                    'package_id' => $session->package_id,
                                    'slot' => $session->slot,
                                    'service_id' => $session->service_id,
                                    'date' => $session->date,
                                    'time' => $session->time,
                                    'status' => $session->status,
                                ];
                            })
                            ->values() 
                            ->toArray(); 
                             
                            $allSessionsExpired = collect($data["sessions"])->every(function ($session) {
                                if (!is_null($session['date'])) {
                                    $sessionDate = Carbon::parse($session['date']);
                                    if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                                        // If the date is in the past and not today, the session is expired
                                        return true;
                                    } elseif ($sessionDate->isToday() && isset($session['slot']['check_in'])) {
                                        // If the date is today, check the session time
                                        return Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $session['slot']['check_in']));
                                    }
                                }
                                return false;
                            });

                            // Check if all sessions have the same status
                            $allSameStatus = collect($data["sessions"])->pluck('status')->unique()->count() == 1;
                            $sameStatus = $allSameStatus ? $data["sessions"][0]['status'] : null;

                            if($sameStatus == 'Canceled'){
                                if ($allSameStatus && $sameStatus) {
                                    $data['status'] = $sameStatus;
                                } else {
                                    $data['status'] = $item->status;
                                }   
                            } else {
                                if ($allSameStatus && $sameStatus) {
                                    $data['status'] = $sameStatus;
                                } else {
                                    $data['status'] = $item->status;
                                }  
                            }           

                    } else {
                        $data["sessions"] = [];
                    }
                    
                    if(isset($item->selected_packages) ){
                        $totalAmount = 0;            
                        $selectedPackageIds = explode(',', $item->selected_packages);
        
                        $packages = Packages::whereIn('id', $selectedPackageIds)->get();
        
                        foreach ($packages as $package) {
                            
                            $data['is_package'] = "1";
                            $data["packages"][] = [
                                "name"=>$package->name, 
                                "base_amount"=>(string) $package->amount,
                                "price"=>(string) ((int) $package->amount * (int) $total_count),
                                "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                            ]; 
                            
                            $totalAmount = ((int) $package->amount * (int) $total_count) -(float)$value->coupon_amt; 
                            $material *= ((int) $package->total_sessions + (int) $package->free_sessions);
                
                        }
                    } else {
                    
                        $data['session_history'] = (object) [];
                        $data['is_package'] = "0";
                        $data['packages'] = [];

                        // if (!is_null($item->date)) {
                        //     $itemDate = Carbon::parse($item->date);
    
                        //     if ($itemDate->isPast() && !$itemDate->isToday()) {
                        //         // If the session date is in the past and not today, mark as Expired
                        //         $data['status'] = 'Expired';
                        //     } elseif ($itemDate->isToday()) {
                        //         // If the session date is today, check the session time
                        //         $slot = Slot::find($item->slot_id);
                        //         if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                        //             $data['status'] = 'Expired';
                        //         }
                        //     } else {
                        //         $data['status'] = $item->status;
                        //     } 
                        // }
                        
                    }
    
                    $sessions = SessionPackages::with('package')->where('cart_id', $item->id)->get();
                    $free_sessions = 0;
                    $per_week = 0;
                    $total_sessions = 0;
                    // Loop through sessions to access related package data
                    foreach ($sessions as $session) {
                        if ($session->package) { 
                            $total_sessions = $session->package->total_sessions;
                            $free_sessions = $session->package->free_sessions;
                            $per_week = $session->package->per_week;
                        }
                    }
                    $data['session_history'] = (object) [
                        'total_sessions' => $total_sessions,
                        'free_sessions' => $free_sessions,
                        'per_week' => $per_week,
                    ];
                } else {
                    
                    $data['is_package'] = "0";
                    $data['packages'] = [];
                }

                $data['coupon']         = $item->coupon ? $item->coupon->code : '';
                $data['coupon_amt']     = $item->coupon_amt;
                $data['subtotal']       = $item->g_total;
                $order = Order::find($item->order_id); 

                $cod = (int) $item->cod;
    
                $surcharge = (float) $item->surcharge;

                if($item->payment_type == 2){
                    $data['total'] = (string)
                        ((float) ($item->amount + $surcharge + $cod ?? 0) - 
                        (float) ($order->coupon_amount ?? 0) + 
                        (float) ($order->tip_amount ?? 0));

                }else{
                        
                    $data['total'] = (string)
                    ((float) ($item->amount + $surcharge ?? 0) - 
                    (float) ($order->coupon_amount ?? 0) + 
                    (float) ($order->tip_amount ?? 0));
                }

                
                $data['card_attribute'] = $card_attr;
                $isMuted = BellBookingUser::where(['user_id' => auth()->user()->id, 'booking_id' => $item->id])->value('is_bell');
                $data['is_bell'] = $isMuted ? (string) $isMuted : "0";

                $cards[] = $data;
                
                $data['packages'] = [];
            }
            $cards['total_booking'] = $card->count();
            // Return response with pagination info
            return $this->sendResponse($cards, 'Expired Bookings');
        } else {
            return $this->sendResponse([], 'No data found.');
        }
    }

    public function get_all_booking(Request $request)
    {
        $limit = $request->get('limit', 10);
        $page = $request->get('page', 1); 
        $date = $request->date; 
        $user = User::find(auth()->user()->id);
        if($user->wallet_balance < 0 || $user->wallet_balance == '0'){
            $wallet = '0';
        } else {
            $wallet = $user->wallet_balance;
        }
        $sellerId = Seller::where('user_id', $user->id)->value('id'); // Get seller ID directly
        $serviceIds = SellerService::where('seller_id', $sellerId)->pluck('service_id')->toArray();
        
        $s_list = SellerService::whereIn('service_id',$serviceIds)->get()->toArray();
        
        if(!empty($date)){

            $card = Card::with(['sessionPackages.slot'])
            ->where(function($q){
                $q->where('accept_user_id', null)->orwhere('accept_user_id', 0);
            })
            ->whereIn('service_id', $serviceIds)
            ->where(function ($query) use ($date) {
                if ($date === 'upcoming') {
                    $query->where(function ($subQuery) {
                        $subQuery->where('service_id', '!=', 10)
                            ->where('date', '>', Carbon::tomorrow());
                    })
                    ->orWhere(function ($subQuery) {
                        $subQuery->where('service_id', 10)
                            ->whereHas('sessionPackages', function ($innerQuery) {
                                $innerQuery
                                ->whereIn('status', ['Pending','Upcoming'])->where('date', '>', Carbon::tomorrow());
                            });
                    });
                } else if(!empty($date)) {
                    $query->where(function ($subQuery) use ($date) {
                        $subQuery
                        ->whereIn('status', ['Pending','Upcoming'])->where('service_id', '!=', 10)
                            ->where('date', $date);
                    })
                    ->orWhere(function ($subQuery) use ($date) {
                        $subQuery->where('service_id', 10)
                            ->whereHas('sessionPackages', function ($innerQuery) use ($date) {
                                $innerQuery
                                ->whereIn('status', ['Pending','Upcoming'])
                                ->where('date', $date);
                            });
                    });
                } else {
                    // For services other than service_id = 10
                    $query->where(function ($subQuery) {
                        $subQuery
                            ->where('service_id', '!=', 10)
                            ->whereIn('status', ['Pending','Upcoming'])
                            ->where(function ($innerQuery) {
                                $innerQuery->where('date', '>', Carbon::today()) // Allow only future dates
                                    ->orWhere(function ($dateQuery) {
                                        $dateQuery
                                        ->whereIn('status', ['Pending','Upcoming'])->where('date', '=', Carbon::today()) // Allow today's cards with future times
                                            ->whereHas('slot', function ($timeQuery) {
                                                $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                            });
                                    });
                            });
                    })
                    ->orWhere(function ($query) {
                        // For service_id = 10, use sessionPackages for date and slot
                        $query->where('service_id', 10)
                        ->where('status', '!=','Accept')
                            ->whereHas('sessionPackages', function ($subQuery) {
                                $subQuery
                                ->whereIn('status', ['Pending','Upcoming'])
                                ->where(DB::raw('DATE(date)'), '>', Carbon::today()->toDateString()) // Allow future dates only
                                    ->orWhere(function ($dateQuery) {
                                        $dateQuery
                                        ->whereIn('status', ['Pending','Upcoming'])
                                        ->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Allow today's sessions
                                            ->whereHas('slot', function ($timeQuery) {
                                                $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                            });
                                    });
                            });
                    });
                    
                }
            })
            ->where('is_checkout', 'Done')
            // ->whereDoesntHave('vendorCardStatuses', function ($query) {
            //     $query->where('vendor_id', auth()->id())
            //         ->where('status', 'Cancelled');
            // })
            ->orderBy('id', 'DESC')
            ->paginate($limit, ['*'], 'page', $page);
        
        } else{
            
            $card = Card::with('slot')
            ->whereIn('service_id', $serviceIds)
            ->where(function($q){
                $q->where('accept_user_id', null)->orwhere('accept_user_id', 0);
            })
            ->where('is_checkout', 'Done')
            // ->whereDoesntHave('vendorCardStatuses', function ($query) {
            //     $query->where('vendor_id', auth()->id())
            //         ->where('status', 'Cancelled');
            // })
            ->where(function ($query) {
                // For services other than service_id = 10
                $query->where(function ($subQuery) {
                    $subQuery
                        ->where('service_id', '!=', 10)
                        ->whereIn('status', ['Pending','Upcoming'])
                        ->where(function ($innerQuery) {
                            $innerQuery->where('date', '>', Carbon::today()) // Allow only future dates
                                ->orWhere(function ($dateQuery) {
                                    $dateQuery->where('date', '=', Carbon::today()) // Allow today's cards with future times
                                        ->whereHas('slot', function ($timeQuery) {
                                            $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                        });
                                });
                        });
                })
                ->orWhere(function ($query) {
                    // For service_id = 10, use sessionPackages for date and slot
                    $query->where('service_id', 10)
                    ->where('status', '!=','Accept')
                        ->whereHas('sessionPackages', function ($subQuery) {
                            $subQuery
                            ->whereIn('status', ['Pending','Upcoming']);
                            //commented on 28-02-25
                            // ->where(DB::raw('DATE(date)'), '>', Carbon::today()->toDateString()) // Allow future dates only
                            // ->orWhere(function ($dateQuery) {
                            //     $dateQuery
                            //     ->whereIn('status', ['Pending','Upcoming'])
                            //     ->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Allow today's sessions
                            //     ->whereHas('slot', function ($timeQuery) {
                            //         $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                            //     });
                            // });
                        });
                });
            })
            ->orderBy('id', 'DESC')
            ->paginate($limit, ['*'], 'page', $page);
        
        }

        // Initialize the response array
        $cards = [];

        // Check if there are results in the query
        if ($card->count()) {
            foreach ($card as $item) {
                $service = Service::find($item->service_id);

                $check = StaffCard::where('card_id', $item->id)->with(['user', 'card']);

                $matchedSession = $item->sessionPackages->first(function ($session) use ($date) {
                    if (empty($date)) {
                        return true; 
                    }

                    // Check if the date is 'upcoming'
                    if ($date === 'upcoming') {
                        return Carbon::parse($session->date)->gte(Carbon::tomorrow());
                    }
                
                    // For specific date matching
                    return $session->date == $date;
                });
                
                $data['matched_session_id'] = $matchedSession ? (string) $matchedSession->id : null;
                
                if ($check->exists()) {
                    $data['added_staff'] = $check->get()->map(function ($staffCard) {

                        return [
                            'status' => $staffCard->card->status ?? null,
                            'id' => $staffCard->user_id ?? null,
                            'first_name' => $staffCard->staff->first_name ?? null,
                            'last_name' => $staffCard->staff->last_name ?? null,
                            'phone' => $staffCard->staff->phone ?? null,
                            'dial_code' => $staffCard->staff->dial_code ?? null,
                        ];
                    })->toArray();
                    $data['payment_type'] = $item->payment_type;
                } else {
                    $data['added_staff'] = [];
                    $data['payment_type'] = $item->payment_type;
                }

                $user = User::find($item->user_id);
                $category = Category::find($item->category_id);

                $data['booking_id']     = (string) $item->id;
                $data['tran_id']        = (string) normalizeId($item->tran_id);
                $data['user_id']        = (string) $item->user_id;
                $data['user_name']      = $user ? $user->name : '';
                $data['user_email']     = $user ? $user->email : '';
                $data['user_mobile']    = $user ? $user->phone : '';
                //$data['user_mobile']    = '000000000';
                $data['user_dial_code']    = $user ? $user->dial_code : '971';
                $data['service_id']     = (string) $item->service_id;
                $data['service']        = $service->name;
                $data['image']          = asset('/uploads/service/' . $service->thumbnail_img);
                $data['category_id']    = (string) $item->category_id;
                $data['category']       = $category ? $category->name : '';
                $data['slot_id']        = $item->slot_id;
                $data['slot']           = $item->slot ? $item->slot->name : '';
                $data['offline_charge'] = $item->offline_charge;
                $data['offline_discount'] = $item->offline_discount;
                // if (!is_null($item->date) && Carbon::parse($item->date)->isPast()) {
                //     $data['status'] = 'Expired';
                // } else {
                //     $data['status'] = $item->status;
                // }          
                $data['status'] = $item->status;      
                // Address Logic
                if (is_numeric($item->address_id)) {
                    $data['address_id'] = $item->address_id;
                    $building = $item->address ? $item->address->building : '';
                    $flat_no = $item->address ? $item->address->flat_no : '';
                    $address = $item->address ? $item->address->address : '';
                    $data['address'] = $building . ', ' . $flat_no . ', ' . $address;
                    $data['city'] = $item->address && $item->address->city ? $item->address->city->name : '';
                    $data['locality'] = $item->address && $item->address->locality_info ? $item->address->locality_info->name : '';
                    $data['latitude'] = $item->address ? $item->address->latitude : '';
                    $data['longitude'] = $item->address ? $item->address->longitude : '';
                } else {
                    // For custom address in JSON
                    $add_info = json_decode($item->address_id);
                    $data['address_id'] = '';
                    $building = $add_info ? $add_info->building : '';
                    $flat_no = $add_info ? $add_info->flat_no : '';
                    $address = $add_info ? $add_info->address : '';
                    $data['address'] = $building . ', ' . $flat_no . ', ' . $address;
                    $data['city'] = $add_info && isset($add_info->city_name) ? $add_info->city_name : '';
                    $data['locality'] = $add_info && $add_info->locality ? $add_info->locality : '';
                    $data['latitude'] = $add_info ? $add_info->latitude : '';
                    $data['longitude'] = $add_info ? $add_info->longitude : '';
                }

                $data['payment_moad']   = $item->payment_moad;
                $data['payment_status'] = $item->payment_status;
                $data['note']           = $item->note;
                $data['material_charge']= (string) $item->material_charge;
                $data['material_status']= $item->material_status;
                $data['service_type']   = $item->service_type;
                $data['alternative_dial_code']  = $item->alternative_dial_code;
                $data['alternative_number'] = $item->alternative_number;
                //$data['alternative_number'] = "0000000000";
                $data['date']           = $item->date;
                $data['tip']            = (string) $item->tip_id;
                $data['coupon_id']      = (string) $item->coupon_id;
                $data['is_checkout']    = $item->is_checkout;

                // Card Attributes and Add-ons
                $card_attr = [];
                $c = 0;
                $material_total = 0;
                $material = 0;
                $total_count = 1;
                $totalAmount = 1;
                $surcharge = 0;
                $total_maids_material = 0;

                foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                    if(!isset($value->sub_cate_id)){
                        $is_maid = 1;
                        $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                        $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
                        $params['service_type']         = '';
                        
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name ?? "",
                            "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (int) $attribute_total; 
                        } else {
                            
                            $totalAmount += $attribute_total; 
                        }
                        
                        preg_match('/\d+/', $attribute_item->value, $matches);
                
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                            
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                
                    } else {
                        if(empty($value->child_category_id)){
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id
                            ])->first();
                        } else{
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id,
                                'child_category_id'=>$value->child_cate_id,
                            ])->first();
                        }
                        if(!empty($service_item)){
                            $services = ServiceAttributeValue::where([
                                // 'ser_attr_val_item_id'=>$service_item->id,
                                'attribute_item_id'=>$value->attribute_item_id,
                            ])->first();
                            $attribute = Attribute::where('id',$services->attribute_id)->first();
                            $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                            
                            $params['attribute_price']      = $services->attribute_price ?? null;
                            $params['attribute_qty']        = $value->attribute_qty ?? null;
                
                            $data["attribute"][] = [
                                "category"=>Category::find($service_item->category_id)->name,
                                "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                "name"=>$attribute_item->value ?? "",
                                "price"=>(string) $services->attribute_price,
                                "qty"=>(string) $value->attribute_qty];
                        
                            
                            $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                            
                            if($attribute->name == 'Hours'){
                                $totalAmount *= (float) $attribute_total; 
                            } else {
                                
                                $totalAmount += (float) $attribute_total; 
                            }
                
                            preg_match('/\d+/', $attribute_item->value, $matches);
                
                            if (count($matches) > 0) {
                                $number = (int) $matches[0];
                                $total_count *= $number;
                            
                                $total_maids_material *= $number;
                                if ($attribute->name == 'Hours') {
                                } else {
                                }
                            }
                            
                        } 
                        $params['service_type']         = '';
                    } 
                    $sub_cat = Category::find($value->sub_cate_id);
                    $child_cat = ChildCategory::find($value->child_cate_id);

                    $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                    $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                    $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                    $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                    $paramss['child_cate_id']        = (string) $value->child_cate_id;
                    $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                    $paramss['attribute_id']         = (string) $value->attribute_id;
                    $paramss['attribute_name']       = $value->attribute_name;
                    $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                    $paramss['attribute_item_name']  = $value->attribute_item_name;
                    $paramss['attribute_qty']        = (string) $value->attribute_qty;
                    $paramss['attribute_price']      = (string) $value->attribute_price;
                    $paramss['service_type']         = $value->service_type;
                
                    array_push($card_attr,$paramss);
                }

                if($item->service_id == 10){  
                    if ($item->sessionPackages->isNotEmpty()) {
                        $data["sessions"] = $item->sessionPackages
                            ->sortBy('date')
                            ->map(function ($session) {
                                $status = $session->status;

                                // if (!is_null($session->date)) {
                                //     $sessionDate = Carbon::parse($session->date);
                    
                                //     if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                                //         // If the session date is in the past and not today, mark as Expired
                                //         $status = 'Expired';
                                //     } elseif ($sessionDate->isToday()) {
                                //         // If the session date is today, check the session time
                                //         $slot = Slot::find($session->slot_id);
                                //         if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                                //             $status = 'Expired Time';
                                //         }
                                //     } else {
                                //         $status = $session->status;
                                //     } 
                                // }
                               
                                return [
                                    'id' => $session->id,
                                    'cart_id' => $session->cart_id,
                                    'package_id' => $session->package_id,
                                    'slot' => $session->slot,
                                    'service_id' => $session->service_id,
                                    'date' => $session->date,
                                    'time' => $session->time,
                                    'status' => $session->status,
                                ];
                            })
                            ->values() 
                            ->toArray(); 
                             
                            $allSessionsExpired = collect($data["sessions"])->every(function ($session) {
                                if (!is_null($session['date'])) {
                                    $sessionDate = Carbon::parse($session['date']);
                                    if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                                        // If the date is in the past and not today, the session is expired
                                        return true;
                                    } elseif ($sessionDate->isToday() && isset($session['slot']['check_in'])) {
                                        // If the date is today, check the session time
                                        return Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $session['slot']['check_in']));
                                    }
                                }
                                return false;
                            });

                            // Check if all sessions have the same status
                            $allSameStatus = collect($data["sessions"])->pluck('status')->unique()->count() == 1;
                            $sameStatus = $allSameStatus ? $data["sessions"][0]['status'] : null;

                            if($sameStatus == 'Canceled'){
                                if ($allSameStatus && $sameStatus) {
                                    $data['status'] = $sameStatus;
                                } else {
                                    $data['status'] = $item->status;
                                }   
                            } else {
                                if ($allSameStatus && $sameStatus) {
                                    $data['status'] = $sameStatus;
                                } else {
                                    $data['status'] = $item->status;
                                }  
                            }           

                    } else {
                        $data["sessions"] = [];
                    }
                    
                    if(isset($item->selected_packages) ){
                        $totalAmount = 0;            
                        $selectedPackageIds = explode(',', $item->selected_packages);
        
                        $packages = Packages::whereIn('id', $selectedPackageIds)->get();
        
                        foreach ($packages as $package) {
                            
                            $data['is_package'] = "1";
                            $data["packages"][] = [
                                "name"=>$package->name, 
                                "base_amount"=>(string) $package->amount,
                                "price"=>(string) ((int) $package->amount * (int) $total_count),
                                "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                            ]; 
                            
                            $totalAmount = ((int) $package->amount * (int) $total_count) -(float)$value->coupon_amt; 
                            $material *= ((int) $package->total_sessions + (int) $package->free_sessions);
                
                        }
                    } else {
                    
                        $data['session_history'] = (object) [];
                        $data['is_package'] = "0";
                        $data['packages'] = [];

                        // if (!is_null($item->date)) {
                        //     $itemDate = Carbon::parse($item->date);
    
                        //     if ($itemDate->isPast() && !$itemDate->isToday()) {
                        //         // If the session date is in the past and not today, mark as Expired
                        //         $data['status'] = 'Expired';
                        //     } elseif ($itemDate->isToday()) {
                        //         // If the session date is today, check the session time
                        //         $slot = Slot::find($item->slot_id);
                        //         if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                        //             $data['status'] = 'Expired';
                        //         }
                        //     } else {
                        //         $data['status'] = $item->status;
                        //     } 
                        // }
                        
                    }
    
                    $sessions = SessionPackages::with('package')->where('cart_id', $item->id)->get();
                    $free_sessions = 0;
                    $per_week = 0;
                    $total_sessions = 0;
                    // Loop through sessions to access related package data
                    foreach ($sessions as $session) {
                        if ($session->package) { 
                            $total_sessions = $session->package->total_sessions;
                            $free_sessions = $session->package->free_sessions;
                            $per_week = $session->package->per_week;
                        }
                    }
                    $data['session_history'] = (object) [
                        'total_sessions' => $total_sessions,
                        'free_sessions' => $free_sessions,
                        'per_week' => $per_week,
                    ];
                } else {
                    
                    $data['is_package'] = "0";
                    $data['packages'] = [];
                }

                $data['coupon']         = $item->coupon ? $item->coupon->code : '';
                $data['coupon_amt']     = $item->coupon_amt;
                $data['subtotal']       = $item->g_total;
                $order = Order::find($item->order_id); 

                $cod = (int) $item->cod;

                $surcharge = (float) $item->surcharge;
                if($item->payment_type == 2){
                    $data['total'] = (string)
                        ((float) ($item->amount + $surcharge + $cod ?? 0) - 
                        (float) ($item->coupon_amt ?? 0) + 
                        (float) ($item->tip_id ?? 0));

                }else{
                        
                    $data['total'] = (string)
                    ((float) ($item->amount + $surcharge ?? 0) - 
                    (float) ($item->coupon_amt ?? 0) + 
                    (float) ($item->tip_id ?? 0));
                }

                $data['total'] = $item->g_total;
                $data['card_attribute'] = $card_attr;
                $isMuted = BellBookingUser::where(['user_id' => auth()->user()->id, 'booking_id' => $item->id])->value('is_bell');
                $data['is_bell'] = $isMuted ? (string) $isMuted : "0";

                $cards[] = $data;
                
                $data['packages'] = [];
            }

            // Return response with pagination info
            return $this->sendResponse($cards, 'All Bookings');
        } else {
            return $this->sendResponse([], 'No data found.');
        }
    }

    public function get_all_booking_mute(Request $request)
    {
        $limit = $request->get('limit', 20);
        $page = $request->get('page', 1); 

        $user = User::find(auth()->user()->id);
        // Check wallet balance condition
        if($user->wallet_balance < 0 || $user->wallet_balance == '0'){
            $wallet = '0';
        } else {
            $wallet = $user->wallet_balance;
        }

        $sellerId = Seller::where('user_id', $user->id)->value('id'); // Get seller ID directly
        $serviceIds = SellerService::where('seller_id', $sellerId)->pluck('service_id')->toArray();

        // Query based on wallet balance condition
        if($wallet == '0'){
            $card = Card::whereIn('service_id', $serviceIds)
                        ->where('status', 'Pending')
                        ->where('payment_status', 'True')
                        ->where('is_checkout', 'Done')
                        ->orderBy('id', 'DESC')
                        ->paginate($limit, ['*'], 'page', $page); 
        } else {
            $card = Card::whereIn('service_id', $serviceIds)
                        ->where('status', 'Pending')
                        ->where('payment_status', 'True')
                        ->where('is_checkout', 'Done')
                        ->orderBy('id', 'DESC')
                        ->paginate($limit, ['*'], 'page', $page); 
        }

        // Initialize the response array
        $cards = [];

        // Check if there are results in the query
        if ($card->count()) {
            foreach ($card as $value) {
                $service = Service::find($value->service_id);
                $user = User::find($value->user_id);
                $category = Category::find($value->category_id);

                $data['booking_id']     = (string) $value->id;
                $data['tran_id']        = (string) normalizeId($value->tran_id);
                $data['user_id']        = (string) $value->user_id;
                $data['user_name']      = $user ? $user->name : '';
                $data['user_email']     = $user ? $user->email : '';
                $data['user_mobile']    = $user ? $user->phone : '';
                //$data['user_mobile']    = '000000000';
                $data['user_dial_code']    = $user ? $user->dial_code : '971';
                $data['service_id']     = (string) $value->service_id;
                $data['service']        = $service->name;
                $data['image']          = asset('/uploads/service/' . $service->thumbnail_img);
                $data['category_id']    = (string) $value->category_id;
                $data['category']       = $category ? $category->name : '';
                $data['slot_id']        = $value->slot_id;
                $data['slot']           = $value->slot ? $value->slot->name : '';
                $data['offline_charge'] = $value->offline_charge;
                $data['offline_discount'] = $value->offline_discount;
                $data['status'] = $value->status;

                $isMuted = BellBookingUser::where(['user_id' => auth()->user()->id, 'booking_id' => $value->id])->value('is_bell');
                $data['is_bell'] = $isMuted ? (string) $isMuted : "0";
                $data['ring'] = $isMuted ? "0" : (string) $isMuted;

                $cards[] = $data;
                
                $data['packages'] = [];
            }

            // Return response with pagination info
            return $this->sendResponse($cards, 'All Bookings');
        } else {
            return $this->sendResponse([], 'No data found.');
        }
    }

    public function get_latest_booking(Request $request)
    {
        $card = Card::where('status','Pending')->where('payment_status' , 'Done')->where('is_checkout' , 'Done')->orderBy('id', 'DESC')->paginate(5);
        $cards = [];

        foreach ($card as $key => $value) {

            $service = Service::find($value->service_id);
            $user = User::find($value->user_id);
            $category = Category::find($value->category_id);

                $data['booking_id']     = (string) $value->id;
                $data['tran_id']        = (string) normalizeId($value->tran_id) ?? "";
                $data['user_id']        = $value->user_id;
                $data['user_name']      = $user?$user->name:'';
                $data['service_id']     = $value->service_id;
                $data['service']        = $service->name;
                $data['category_id']    = $value->category_id;
                $data['category']       = $category?$category->name:'';
                $data['slot_id']        = $value->slot_id;
                $data['slot']           = $value->slot?$value->slot->name:'';


                if(is_numeric($value->address_id)){

                    $data['address_id']     = $value->address_id;

                    $building = $value->address?$value->address->building:'';
                    $flat_no = $value->address?$value->address->flat_no:'';
                    $address = $value->address?$value->address->address:'';

                    $latitude = $value->address?$value->address->latitude:'';
                    $longitude = $value->address?$value->address->longitude:'';
                    $data['address']        = $building.', '. $flat_no.', '.$address;

                    if($value->address && $value->address->city){
                        $city = $value->address->city->name;
                    } else {
                        $city = "";
                    }

                    $data['city']           = $city;

                    if($value->address && $value->address->locality_info){
                        $locality = $value->address->locality_info->name;
                    } else {
                        $locality = "";
                    }
                    $data['locality']       = $locality;
                    
                    $data['latitude']       = $latitude;
                    $data['longitude']      = $longitude;

                } else {

                    $add_info = json_decode($value->address_id);

                    $data['address_id']     = '';


                    $building = $add_info?$add_info->building:'';
                    $flat_no = $add_info?$add_info->flat_no:'';
                    $address = $add_info?$add_info->address:'';

                    $latitude = $add_info?$add_info->latitude:'';
                    $longitude = $add_info?$add_info->longitude:'';
                    $data['address']        = $building.', '. $flat_no.', '.$address;

                    if($add_info && $add_info->city_name){
                        $city = $add_info->city_name;
                    } else {
                        $city = "";
                    }

                    $data['city']           = $city;

                    if($add_info && $add_info->locality){
                        $locality = $add_info->locality;
                    } else {
                        $locality = "";
                    }
                    $data['locality']       = $locality;
                    
                    $data['latitude']       = $latitude;
                    $data['longitude']      = $longitude;

                }


                $data['payment_moad']   = $value->payment_moad;
                $data['payment_status'] = $value->payment_status;
                $data['note']           = $value->note;
                $data['material_price'] = $value->material_price;
                $data['material_status']= $value->material_status;
                $data['alternative_dial_code']  = $value->alternative_dial_code;
                $data['alternative_number'] = $value->alternative_number;
                $data['date']           = $value->date;
                $data['tip']            = (string) $value->tip_id;
                $data['coupon_id']      = (string) $value->coupon_id;
                $data['coupon']         = $value->coupon?$value->coupon->code:'';
                $data['coupon_amt']     = $value->coupon_amt;
                $data['total']       = $value->amount;
                $data['subtotal']          = $value->g_total;

            $card_attr = [];

            foreach (CardAttribute::where('card_id',$value->id)->get() as $key => $item) {

                $sub_cat = Category::find($value->sub_cate_id);
                $child_cat = ChildCategory::find($value->child_cate_id);

                $params['sub_cate_id']          = $item->sub_cate_id;
                $params['sub_cate_name']        = $sub_cat?$sub_cat->name:'';
                $params['child_cate_id']        = $item->child_cate_id;
                $params['child_cate']           = $child_cat?$child_cat->name:'';
                $params['attribute_id']         = $item->attribute_id;
                $params['attribute_name']       = $item->attribute_name;
                $params['attribute_item_id']    = $item->attribute_item_id;
                $params['attribute_item_name']  = $item->attribute_item_name;
                $params['attribute_qty']        = $item->attribute_qty;
                $params['attribute_price']      = $item->attribute_price;

                array_push($card_attr,$params);
            }
            $data['card_attribute'] = $card_attr;
            array_push($cards, $data);
        }
        return $this->sendResponse($cards, 'Latest Bookings');
    }

    public function get_my_booking(Request $request)
    {
        $user_id = auth()->user()->id;
        
        // Default values for pagination
        $page = $request->input('page', 1);
        $limit = $request->input('limit', 10);
        $offset = ($page - 1) * $limit;

        // Fetch the cards with pagination
        $cardsQuery = Card::where(['user_id' => $user_id, 'is_checkout' => 'Done'])
                        ->offset($offset)
                        ->limit($limit)
                        ->orderBy('id', 'DESC')
                        ->get();
        
        $cards = [];

        foreach ($cardsQuery as $key => $item) {
            $totalAmount = 0;
            $total_count = 1;
            $surcharge = 0;
            $service = Service::find($item->service_id);
            $user = User::find($item->user_id);
            $provider = User::find($item->accept_user_id);
            $provider_address   = Address::where('user_id', $item->accept_user_id)->first();
            $user_address       = Address::where('user_id', $user->id)->first();

            $data['parent_cart_id'] = (string) optional(Card::where('revisit_id', $item->id)->first())->id ?? "";                ;

            $data['user_latitude'] = (string) ($user_address->latitude ?? '');
            $data['user_longitude'] = (string) ($user_address->longitude ?? '');
            $data['provider'] = (object) $provider;
            $data['provider_latitude'] = (string) ($provider_address->latitude ?? '');
            $data['provider_longitude'] = (string) ($provider_address->longitude ?? '');
            $data['is_reviewed'] = Review::where([
                'customer_id' => auth()->user()->id, 
                'booking_id' => $item->id
            ])->exists() ? '1' : '0';
            
            $matchedSession = $item->sessionPackages->first(function ($sessionPackage) {
                $status = $sessionPackage->status;
            
                // Exclude sessions with a status of 'Canceled'
                if ($status != 'Canceled') {
                    // if (!is_null($sessionPackage->date)) {
                    //     $sessionDate = Carbon::parse($sessionPackage->date);
            
                    //     if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                    //         // If the session date is in the past and not today, mark as Expired
                    //         return false;
                    //     } elseif ($sessionDate->isToday()) {
                    //         // If the session date is today, check the session time
                    //         $slot = Slot::find($sessionPackage->time);
                    //         if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                    //             // Mark as expired if current time is past the session time
                    //             return false;
                    //         }
                    //     }
                    // }
                    return true; // Session is valid
                }
                return false; // Session is not valid
            });
            
            $data['active_current_session'] = $matchedSession
            ? (string) $matchedSession->id
            : ($item->sessionPackages->isNotEmpty() ? $item->sessionPackages->first()->id : null);

            $category = Category::find($item->category_id);

            $data['id']             = (string) $item->id;
            // if(isset($item->tabby_payment_response_id)){
            //     $data['tran_id']    = $item->tabby_payment_response_id;
            // } elseif (isset($item->paymentTranId)) {
            //     $data['tran_id']    = $item->paymentTranId;
            // } else {
            //     $input = [
            //         'customer_id' => $item->user_id,
            //         'vendor_id' => Seller::where("user_id", $item->accept_user_id)->first()->seller_id ?? null
            //     ];
                
            //     $transection = Transection::where($input)->first();
            //     $data['tran_id'] = $transection ? normalizeId($transection->id) : normalizeId($item->tran_id);                
            // }
            $data['tran_id']    = $item->tran_id;
            
            $data['user_id']        = (string) $item->user_id;
            $data['user_name']      = $user ? $user->name : '';
            $data['user_email']     = $user ? $user->email : '';
            $data['user_mobile']    = $user ? $user->phone : '';
            //$data['user_mobile']    = '000000000';
            $data['user_dial_code']    = $user ? $user->dial_code : '971';
            $data['service_id']     = (string) $item->service_id;
            $data['accept_user_id'] = $item->accept_user_id;
            $data['service']        = $service->name;
            $data['image']          = asset('/uploads/service/'.$service->thumbnail_img);
            $data['category_id']    = $item->category_id;
            $data['category']       = $category ? $category->name : '';
            $data['slot_id']        = $item->slot_id;
            $data['slot']           = Slot::find($item->slot_id)->name ?? '';
            $data['offline_charge'] = $item->offline_charge;
            $data['offline_discount'] = $item->offline_discount;
            
            // Other details (same as before)
            $data['payment_moad']   = $item->payment_moad;
            $data['payment_status'] = $item->payment_status;
            $data['note']           = $item->note;
            $data['material_charge']= (string) $item->material_charge;
            $data['material_status']= $item->material_status;
            $data['service_type']   = $item->service_type;
            $data['alternative_dial_code']  = $item->alternative_dial_code;
            $data['alternative_number'] = $item->alternative_number;
            $data['date']           = $item->date;
            $data['tip']            = (string) $item->tip_id;
            $data['coupon_id']      = (string) $item->coupon_id;
            $data['is_checkout']    = $item->is_checkout;
            $data['status']         = $item->status;
            $data['sub_total']       = (string) $item->g_total;
            if($item->service_id == 13){
                $data['revisit']       = Card::find($item->revisit_id);
                $data['is_revisit']       = $item->is_revisit;
            }
            $order = Order::find($item->order_id); 
          
            $cod = (int) $item->cod;

            $surcharge = (float) $item->surcharge;
            $parent_cart_id = (string) optional(\App\Card::where('revisit_id', $item->id)->first())->id ?? "";
            if(!empty($parent_cart_id)){

                $data['amount_total'] = "0";
            }else {
                if($item->material_status == 'Apply'){
                     if($item->payment_type == 2){
                        $data['amount_total'] = (string)
                            ((float) ($item->g_total + $item->material_charge + $surcharge + $cod ?? 0) - 
                            (float) ($item->coupon_amt ?? 0) + 
                            (float) ($item->tip_id ?? 0));
            
                    }else{
                            
                        $data['amount_total'] = (string)
                        ((float) ($item->g_total + $item->material_charge + $surcharge ?? 0) - 
                        (float) ($item->coupon_amt ?? 0) + 
                        (float) ($item->tip_id ?? 0));
                    }
                }else{
                    //  if($item->payment_type == 2){
                    //     $data['amount_total'] = (string)
                    //         ((float) ($item->g_total + $surcharge + $cod ?? 0) - 
                    //         (float) ($item->coupon_amt ?? 0) + 
                    //         (float) ($item->material_charge ?? 0) + 
                    //         (float) ($item->tip_id ?? 0));
            
                    // }else{
                            
                    //     $data['amount_total'] = (string)
                    //     ((float) ($item->g_total + $surcharge ?? 0) - 
                    //     (float) ($item->coupon_amt ?? 0) + 
                    //     (float) ($item->tip_id ?? 0));
                    // }
                    if($item->payment_type == 2){
                        $data['amount_total'] = (string)
                            ((float) ($item->amount + $surcharge + $cod ?? 0) - 
                            (float) ($order->coupon_amount ?? 0) + 
                            (float) ($order->tip_amount ?? 0) - ($item->offline_discount??0));
    
                    }else{
                            
                        $data['amount_total'] = (string)
                        ((float) ($item->amount + $surcharge ?? 0) - 
                        (float) ($order->coupon_amount ?? 0) + 
                        (float) ($order->tip_amount ?? 0) - ($item->offline_discount??0) );
                    }
                    
                }
               
            }
            $data['amount_total'] = (string)$item->g_total;
            
                $data['pending_approval_by_admin'] = $item->pending_approval_by_admin;

            // Card attributes logic (same as before)
            $card_attr = [];
            $c = 0;
            $material_total = 0;
            $total_maids_material = 0;
            $material_default = ($item->material_status == "Apply") ? (float) $item->material_price : 0;
            $data["attribute"] = [];
            foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                if(!isset($value->sub_cate_id)){
                    $is_maid = 1;
                    $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                    $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                    $attribute = Attribute::where('id',$services->attribute_id)->first();
                    $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                    
                    $params['attribute_price']      = $services->attribute_price ?? null;
                    $params['attribute_qty']        = $value->attribute_qty ?? null;
                    $params['service_type']         = '';
                    
                    $data["attribute"][] = [
                        "category"=>Category::find($service_item->category_id)->name ?? "",
                        "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                        "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                        "name"=>$attribute_item->value ?? "",
                        "price"=>(string) $services->attribute_price,
                        "qty"=>(string) $value->attribute_qty];
                    $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                    
                    if($attribute->name == 'Hours'){
                        $totalAmount *= (int) $attribute_total; 
                    } else {
                        
                        $totalAmount += $attribute_total; 
                    }
                    
                    preg_match('/\d+/', $attribute_item->value, $matches);
            
                    if (count($matches) > 0) {
                        $number = (int) $matches[0];
                        $total_count *= $number;
                        
                        if ($attribute->name == 'Hours') {
                        } else {
                        $total_maids_material *= $number;
                        }
                    }
            
                } else {
                    if(empty($value->child_category_id)){
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$item->service_id,
                            'category_id'=>$value->main_sub_cat_id,
                            'sub_category_id'=>$value->sub_cate_id
                        ])->first();
                    } else{
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$item->service_id,
                            'category_id'=>$value->main_sub_cat_id,
                            'sub_category_id'=>$value->sub_cate_id,
                            'child_category_id'=>$value->child_cate_id,
                        ])->first();
                    }
                    if(!empty($service_item)){
                        $services = ServiceAttributeValue::where([
                            // 'ser_attr_val_item_id'=>$service_item->id,
                            'attribute_item_id'=>$value->attribute_item_id,
                        ])->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
            
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name,
                            "sub_category"=>Category::find($service_item->sub_category_id)->name,
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                    
                        
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (float) $attribute_total; 
                        } else {
                            
                            $totalAmount += (float) $attribute_total; 
                        }
            
                        preg_match('/\d+/', $attribute_item->value, $matches);
            
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                        
                            if ($attribute->name == 'Hours') {
                            } else {
                        $total_maids_material *= $number;
                            }
                        }
                        
                    } 
                    $params['service_type']         = '';
                } 
                $sub_cat = Category::find($value->sub_cate_id);
                $child_cat = ChildCategory::find($value->child_cate_id);

                $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                $paramss['child_cate_id']        = (string) $value->child_cate_id;
                $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                $paramss['attribute_id']         = (string) $value->attribute_id;
                $paramss['attribute_name']       = $value->attribute_name;
                $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                $paramss['attribute_item_name']  = $value->attribute_item_name;
                $paramss['attribute_qty']        = (string) $value->attribute_qty;
                $paramss['attribute_price']      = (string) $value->attribute_price;
                $paramss['service_type']         = $value->service_type;
                $paramss['unit_price']         = $value->unit_price??0;
                array_push($card_attr,$paramss);
            }

            $data['card_attribute'] = $card_attr;
            
            if($item->service_id == 10){
                $material_total = $total_maids_material;
            } else {
                $material_total = $material_total;
            }
            $material = ($item->material_status == "Apply") ? (float) $material_total : "0";

            if($item->service_id == 10){  

                if(isset($item->selected_packages) ){
                    $totalAmount = 0;            
                    $selectedPackageIds = explode(',', $item->selected_packages);
    
                    $package = Packages::whereIn('id', $selectedPackageIds)->first();
 
                    $data['is_package'] = "1";
                    $data["packages"] = [[
                        "name"=>$package->name, 
                        "base_amount"=>(string) $package->amount,
                        "price"=>(string) ((int) $package->amount * (int) $total_count),
                        "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                    ]]; 
                    
                    $totalAmount = ((int) $package->amount) -(float)$value->coupon_amt; 
                    $material *= ((int) $package->total_sessions + (int) $package->free_sessions);
            
                } else {
                
                    $data['is_package'] = "0";
                    $data['packages'] = [];
                }

                $free_sessions = 0;
                $per_week = 0;
                $total_sessions = 0;
                $is_package = 0;
                
                $completed_session = SessionPackages::with('package')
                ->where(['cart_id' => $item->id, 'status' => 'Completed'])
                ->count();

                $datas['status']         = $item->status;
                $sessions = SessionPackages::with(['package', 'slot'])
                ->where('cart_id', $item->id)
                ->orderBy('date')
                ->get()
                ->map(function ($sessionPackage) {
                    // Fetch staff details with the status from staff_sessions
                    $addedStaff = \DB::table('staff_sessions')
                    ->join('staff', 'staff.id', '=', 'staff_sessions.user_id')
                    ->where('staff_sessions.session_id', $sessionPackage->id)
                    ->select(
                        'staff.id',
                        'staff.user_id',
                        'staff.first_name',
                        'staff.last_name',
                        'staff.phone',
                        'staff.dial_code',
                        'staff_sessions.status as staff_session_status'
                    )
                    ->get();

                    $status = $sessionPackage->status;

                    // if($status != 'canceled'){
                    //     if (!is_null($sessionPackage->date)) {
                    //         $sessionDate = Carbon::parse($sessionPackage->date);

                    //         if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                    //             // If the session date is in the past and not today, mark as Expired
                    //             $status = 'Expired';
                    //         } elseif ($sessionDate->isToday()) {
                    //             // If the session date is today, check the session time
                    //             $slot = Slot::find($sessionPackage->time);
                    //             if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                    //                 $status = 'Expired';
                    //             }
                    //         } else {
                    //             $status = $sessionPackage->status;
                    //         } 
                    //     }
                    // }

                    return [
                        'session_id' => (string) $sessionPackage->id,
                        'package_id' => $sessionPackage->package_id,
                        'package' => convert_all_elements_to_string($sessionPackage->package->toArray()),
                        'slot' => $sessionPackage->slot,
                        'date' => $sessionPackage->date,
                        'status' => $status,
                        'added_staff' => $addedStaff,
                    ];
                });

                $allSessionsExpired = collect($sessions)->every(function ($session) {
                    
                    if($session['status'] != 'canceled'){
                        if (!is_null($session['date'])) {
                            $sessionDate = Carbon::parse($session['date']);
                            if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                                // If the date is in the past and not today, the session is expired
                                return true;
                            } elseif ($sessionDate->isToday() && isset($session['slot']['check_in'])) {
                                // If the date is today, check the session time
                                return Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $session['slot']['check_in']));
                            }
                        }
                    }

                    return false; // If any session is not expired
                });

                // Update the main status if all sessions are expired
                // if ($allSessionsExpired) {
                //     $data['status'] = 'Expired';
                // } else {
                //     $data['status'] = $item->status; // Retain the original status if not all are expired
                // }
                $data['status'] = $item->status;

                foreach ($sessions as $session) {
                    // Check if package exists
                    if ($session['package']) {
                        $total_sessions = $session['package']['total_sessions'] ?? 0;
                        $free_sessions = $session['package']['free_sessions'] ?? 0;
                        $per_week = $session['package']['per_week'] ?? 0;
                    }
                }
            
                $data['session_history'] = (object) [
                    'total_sessions' => $total_sessions,
                    'free_sessions' => $free_sessions,
                    'per_week' => $per_week,
                    'sessions' => $sessions,
                    'completed_session' => (string) $completed_session,
                ];


            } else {
                $data['session_history'] = (object) [];
                $data['is_package'] = "0";
                $data['packages'] = [];

                // if($item->status == 'Accept' || $item->status == 'Pending'){
                //     if (!is_null($item->date)) {
                //         $itemDate = Carbon::parse($item->date);

                //         if ($itemDate->isPast() && !$itemDate->isToday()) {
                //             // If the session date is in the past and not today, mark as Expired
                //             $data['status'] = 'Expired';
                //         } elseif ($itemDate->isToday()) {
                //             // If the session date is today, check the session time
                //             $slot = Slot::find($item->slot_id);
                //             if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                //                 $data['status'] = 'Expired';
                //             }
                //         } else {
                //             $data['status'] = $item->status;
                //         } 
                //     }
                // } else {
                //     $data['status'] = $item->status;
                // }
                $data['status'] = $item->status;

            }
            
            array_push($cards, $data);
        }

        // Get the total count for pagination
        $totalCount = Card::where(['user_id' => $user_id,
        'is_checkout' => 'Done'])->count();

        // Prepare pagination info
        $pagination = [
            'total' => (string) $totalCount,
            'per_page' => $limit,
            'current_page' => $page,
            'last_page' => (string) ceil($totalCount / $limit)
        ];

        return $this->sendResponse(['cards' => $cards, 'pagination' => $pagination], 'My Jobs');
    }

    public function get_home(Request $request)
    {
        $limit = $request->get('limit', 10); 
        $page = $request->get('page', 1); 
        $service_ids = [];
        $seller = Seller::where('user_id', auth()->user()->id)->first();
        if($seller){
            $service_ids = SellerService::where('seller_id', $seller->id)->pluck('service_id');
        } 

        $card = Card::with('slot')
        ->whereIn('service_id', $service_ids)
        ->where(function($q){
            $q->where('accept_user_id', null)->orwhere('accept_user_id', 0);
        })
        ->where('is_checkout', 'Done')
        // ->whereDoesntHave('vendorCardStatuses', function ($query) {
        //     $query->where('vendor_id', auth()->id())
        //         ->where('status', 'Cancelled');
        // })
        ->where(function ($query) {
            // For services other than service_id = 10
            $query->where(function ($subQuery) {
                $subQuery
                    ->where('service_id', '!=', 10)
                    ->whereIn('status', ['Pending','Upcoming'])
                    ->where(function ($innerQuery) {
                        $innerQuery->where('date', '>', Carbon::today()) // Allow only future dates
                            ->orWhere(function ($dateQuery) {
                                $dateQuery
                                ->whereIn('status', ['Pending','Upcoming'])->where('date', '=', Carbon::today()) // Allow today's cards with future times
                                    ->whereHas('slot', function ($timeQuery) {
                                        $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                    });
                            });
                    });
            })
            ->orWhere(function ($query) {
                // For service_id = 10, use sessionPackages for date and slot
                $query->where('service_id', 10)
                ->where('status', '!=','Accept')
                    ->whereHas('sessionPackages', function ($subQuery) {
                        $subQuery
                        ->whereIn('status', ['Pending','Upcoming'])
                        ->where(DB::raw('DATE(date)'), '>', Carbon::today()->toDateString()) // Allow future dates only
                        ->orWhere(function ($dateQuery) {
                            $dateQuery
                            ->whereIn('status', ['Pending','Upcoming']);
                            // ->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Allow today's sessions
                            // ->whereHas('slot', function ($timeQuery) {
                            //     $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                            // });
                        });
                    });
            });
        })
        ->orderBy('id', 'DESC')
        ->paginate($limit, ['*'], 'page', $page);

        $cards = [];

        $total_new_booking =   Card::with('slot')
        ->whereIn('service_id', $service_ids)
        ->where('is_checkout', 'Done')
        ->whereDoesntHave('vendorCardStatuses', function ($query) {
            $query->where('vendor_id', auth()->id())
                ->where('status', 'Cancelled');
        })
        ->where(function ($query) {
            // For services other than service_id = 10
            $query->where(function ($subQuery) {
                $subQuery
                    ->where('service_id', '!=', 10)
                    ->whereIn('status', ['Pending','Upcoming'])
                    ->where(function ($innerQuery) {
                        $innerQuery->where('date', '>', Carbon::today()) // Allow only future dates
                            ->orWhere(function ($dateQuery) {
                                $dateQuery->where('date', '=', Carbon::today()) // Allow today's cards with future times
                                    ->whereHas('slot', function ($timeQuery) {
                                        $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                    });
                            });
                    });
            })
            ->orWhere(function ($query) {
                // For service_id = 10, use sessionPackages for date and slot
                $query->where('service_id', 10)
                ->where('status', '!=','Accept')
                    ->whereHas('sessionPackages', function ($subQuery) {
                        $subQuery
                        ->whereIn('status', ['Pending','Upcoming']);
                        // ->where(DB::raw('DATE(date)'), '>', Carbon::today()->toDateString()) // Allow future dates only
                        // ->orWhere(function ($dateQuery) {
                        //     $dateQuery
                        //     ->whereIn('status', ['Pending','Upcoming'])
                        //     ->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Allow today's sessions
                        //     ->whereHas('slot', function ($timeQuery) {
                        //         $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                        //     });
                        // });
                    });
            });
        })
        ->orderBy('id', 'DESC')
        ->count();

        foreach ($card as $item) {
            $service = Service::find($item->service_id);

            $data = [];  // Initialize $data to avoid leftovers from previous iterations
            $check = StaffCard::where('card_id', $item->id)->with(['user', 'card']);

            $matchedSession = collect($item->sessionPackages)->first(function ($session) {
                $sessionDate = Carbon::parse($session['date']);
            
                // Check if the session date is today or in the future
                if ($sessionDate->isToday()) {
                    // If the session date is today, check the session time
                    $slot = Slot::find($session['time']); // Adjust for session's slot time
                    if ($slot && Carbon::now()->lt(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                        return true; // Valid session for today with a future time
                    }
                } elseif ($sessionDate->isFuture()) {
                    return true; // Valid session for a future date
                }
            
                return false; // Session is not valid
            });
            
            $data['matched_session_id'] = $matchedSession ? (string) $matchedSession['id'] : null;
                
            if ($check->exists()) {
                $data['added_staff'] = $check->get()->map(function ($staffCard) {
            
                    return [
                        'status' => $staffCard->card->status ?? null,
                        'id' => $staffCard->user_id ?? null,
                        'first_name' => $staffCard->staff->first_name ?? null,
                        'last_name' => $staffCard->staff->last_name ?? null,
                        'phone' => $staffCard->staff->phone ?? null,
                        'dial_code' => $staffCard->staff->dial_code ?? null,
                    ];
                })->toArray();
                $data['payment_type'] = $item->payment_type;
            } else {
                $data['added_staff'] = [];
                $data['payment_type'] = $item->payment_type;
            }

            $user = User::find($item->user_id);
            $category = Category::find($item->category_id);
    
            $data['booking_id']     = (string) $item->id;
            $data['tran_id']        = (string) normalizeId($item->tran_id) ?? '';
            $data['user_id']        = (string) $item->user_id;
            $data['user_name']      = $user ? $user->name : '';
            $data['user_email']     = $user ? $user->email : '';
            $data['user_dial_code']    = $user ? $user->dial_code : '971';
            $data['user_mobile']    = $user ? $user->phone : '';
            //$data['user_mobile']    = '000000000';
            $data['service_id']     = (string) $item->service_id;
            $data['accept_user_id'] = (string) $item->accept_user_id;
            $data['service']        = $service ? $service->name : '';
            $data['image']          = asset('/uploads/service/' . ($service->thumbnail_img ?? ''));
            $data['category_id']    = (string) $item->category_id;
            $data['category']       = $category ? $category->name : '';
            $data['slot_id']        = $item->slot_id;
            $data['slot']           = $item->slot ? $item->slot->name : '';
            $data['offline_charge'] = $item->offline_charge;
            $data['offline_discount'] = $item->offline_discount;
    
            // Address handling
            if (is_numeric($item->address_id)) {
                $data['address_id']     = $item->address_id;
                $building = $item->address ? $item->address->building : '';
                $flat_no = $item->address ? $item->address->flat_no : '';
                $address = $item->address ? $item->address->address : '';
                $data['address']        = "$building, $flat_no, $address";
                $data['city']           = $item->address->city->name ?? '';
                $data['locality']       = $item->address->locality_info->name ?? '';
                $data['latitude']       = $item->address->latitude ?? '';
                $data['longitude']      = $item->address->longitude ?? '';
            } else {
                $add_info = json_decode($item->address_id);
                $building = $add_info ? $add_info->building : '';
                $flat_no = $add_info ? $add_info->flat_no : '';
                $address = $add_info ? $add_info->address : '';
                $data['address']        = "$building, $flat_no, $address";
                $data['city']           = $add_info->city_name ?? '';
                $data['locality']       = $add_info->locality ?? '';
                $data['latitude']       = $add_info->latitude ?? '';
                $data['longitude']      = $add_info->longitude ?? '';
            }
    
            $data['payment_moad']   = $item->payment_moad;
            $data['payment_status'] = $item->payment_status;
            $data['note']           = $item->note;
            $data['material_charge']= $item->material_charge;
            $data['material_status']= $item->material_status;
            $data['service_type']   = $item->service_type;
            $data['alternative_dial_code']  = $item->alternative_dial_code;
            $data['alternative_number'] = $item->alternative_number;
            //$data['alternative_number'] = "0000000000";
            $data['date']           = $item->date;
            $data['tip']            = (string) $item->tip_id;
            $data['coupon_id']      = (string) $item->coupon_id;
            $data['is_checkout']    = $item->is_checkout;
            $data['status']         = $item->status;
            $data['pending_approval_by_admin'] = $item->pending_approval_by_admin;
            $isMuted = BellBookingUser::where(['user_id' => auth()->user()->id, 'booking_id' => $item->id])->value('is_bell');
            $data['is_bell'] = $isMuted ? (string) $isMuted : "0";

            $card_attr = [];
            $c = 0;
            $material_total = 0;
            $total_count = 1;
            $material = 0;
            $totalAmount = 0;
            $surcharge = 0;
            $total_maids_material = 0;
            foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                if(!isset($value->sub_cate_id)){
                    $is_maid = 1;
                    $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                    $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                    $attribute = Attribute::where('id',$services->attribute_id)->first();
                    $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                    
                    $params['attribute_price']      = $services->attribute_price ?? null;
                    $params['attribute_qty']        = $value->attribute_qty ?? null;
                    $params['service_type']         = '';
                    
                    $data["attribute"][] = [
                        "category"=>Category::find($service_item->category_id)->name ?? "",
                        "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                        "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                        "name"=>$attribute_item->value ?? "",
                        "price"=>(string) $services->attribute_price,
                        "qty"=>(string) $value->attribute_qty];
                    $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                    
                    if($attribute->name == 'Hours'){
                        $totalAmount *= (int) $attribute_total; 
                    } else {
                        
                        $totalAmount += $attribute_total; 
                    }
                    
                    preg_match('/\d+/', $attribute_item->value, $matches);

                    if (count($matches) > 0) {
                        $number = (int) $matches[0];
                        $total_count *= $number;
                        
                        $total_maids_material *= $number;
                        if ($attribute->name == 'Hours') {
                        } else {
                        }
                    }

                } else {
                    if(empty($value->child_category_id)){
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$item->service_id,
                            'category_id'=>$value->main_sub_cat_id,
                            'sub_category_id'=>$value->sub_cate_id
                        ])->first();
                    } else{
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$item->service_id,
                            'category_id'=>$value->main_sub_cat_id,
                            'sub_category_id'=>$value->sub_cate_id,
                            'child_category_id'=>$value->child_cate_id,
                        ])->first();
                    }
                    if(!empty($service_item)){
                        $services = ServiceAttributeValue::where([
                            // 'ser_attr_val_item_id'=>$service_item->id,
                            'attribute_item_id'=>$value->attribute_item_id,
                        ])->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;

                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name,
                            "sub_category"=>Category::find($service_item->sub_category_id)->name,
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                    
                        
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (float) $attribute_total; 
                        } else {
                            
                            $totalAmount += (float) $attribute_total; 
                        }

                        preg_match('/\d+/', $attribute_item->value, $matches);

                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                        
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                        
                    } 
                    $params['service_type']         = '';
                } 
                $sub_cat = Category::find($value->sub_cate_id);
                $child_cat = ChildCategory::find($value->child_cate_id);

                $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                $paramss['child_cate_id']        = (string) $value->child_cate_id;
                $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                $paramss['attribute_id']         = (string) $value->attribute_id;
                $paramss['attribute_name']       = $value->attribute_name;
                $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                $paramss['attribute_item_name']  = $value->attribute_item_name;
                $paramss['attribute_qty']        = (string) $value->attribute_qty;
                $paramss['attribute_price']      = (string) $value->attribute_price;
                $paramss['service_type']         = $value->service_type;
                $paramss['unit_price']         = $value->unit_price??0;
                array_push($card_attr,$paramss);
            }

            $data['card_attribute'] = $card_attr;
            $totalAmount = (float) $item->amount;

            $material = ($item->material_status == "Apply") ? (float) $item->material_charge : "0";

            if($item->service_id == 10){
                if ($item->sessionPackages->isNotEmpty()) {
                    $data["sessions"] = $item->sessionPackages
                        ->sortBy('date')
                        ->map(function ($session) {

                            $addedStaff = \DB::table('staff_sessions')
                            ->join('staff', 'staff.id', '=', 'staff_sessions.user_id')
                            ->where('staff_sessions.session_id', $session->id)
                            ->select(
                                'staff.id',
                                'staff.user_id',
                                'staff.first_name',
                                'staff.last_name',
                                'staff.phone',
                                'staff.dial_code',
                                'staff_sessions.status as staff_session_status'
                            )
                            ->get();

                            $status = $session->status;

                            // if (!is_null($session->date)) {
                            //     $sessionDate = Carbon::parse($session->date);
                            
                            //     if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                            //         // If the session date is in the past and not today, mark as Expired
                            //         $status = 'Expired';
                            //     } elseif ($sessionDate->isToday()) {
                            //         // If the session date is today, check the session time
                            //         $slot = Slot::find($session->slot_id);
                            //         if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                            //             $status = 'Expired';
                            //         }
                            //     } else {
                            //         $status = $session->status;
                            //     } 
                            // }

                            return [
                                'id' => (string) $session->id,
                                'cart_id' => $session->cart_id,
                                'package_id' => $session->package_id,
                                'slot' => $session->slot,
                                'service_id' => $session->service_id,
                                'date' => $session->date,
                                'time' => $session->time,
                                'status' => $session->status,
                                'added_staff' => $addedStaff
                                // Add any other fields you want explicitly here
                            ];
                        })
                        ->values() 
                        ->toArray(); 

                        // Check if all sessions have past date and time
                        $allSessionsExpired = collect($data["sessions"])->every(function ($session) {
                            if (!is_null($session['date'])) {
                                $sessionDate = Carbon::parse($session['date']);
                                if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                                    // If the date is in the past and not today, the session is expired
                                    return true;
                                } elseif ($sessionDate->isToday() && isset($session['slot']['check_in'])) {
                                    // If the date is today, check the session time
                                    return Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $session['slot']['check_in']));
                                }
                            }
                            return false; // If any session is not expired
                        });

                        // Update the main status if all sessions are expired
                        // if ($allSessionsExpired) {
                        //     $data['status'] = 'Expired';
                        // } else {
                        //     $data['status'] = $item->status; // Retain the original status if not all are expired
                        // }
                        $data['status'] = $item->status; 
                } else {
                    $data["sessions"] = [];
                }
                
                if(isset($item->selected_packages) ){    
                    $totalAmount = 0;            
                    $selectedPackageIds = explode(',', $item->selected_packages);

                    $packages = Packages::whereIn('id', $selectedPackageIds)->get();

                    foreach ($packages as $package) {
                        
                        $data['total_session_count'] = $package->total_sessions;
                        $data['is_package'] = "1";
                        $data["packages"][] = [
                            "name"=>$package->name, 
                            "base_amount"=>(string) $package->amount,
                            "price"=>(string) ((int) $package->amount * (int) $total_count),
                            "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                        ]; 
                        
                        $totalAmount = (float) $package->amount * (float) $total_count; 
                        $material *= ((int) $package->total_sessions + (int) $package->free_sessions);
                
                    }
                } else {

                    $card_data['is_package'] = "0";
                    $card_data['packages'] = [];
                }

            } else {

                $data['is_package'] = "0";
                $data['packages'] = [];
                $data['total_session_count'] = "0";
            }
    
            $data['coupon']         = $item->coupon ? $item->coupon->code : '';
            $data['coupon_amt']     = $item->coupon_amt;
            $order = Order::find($item->order_id); 

            $cod = (int) $item->cod;

            $surcharge = (float) $item->surcharge;

            if($item->payment_type == 2){
                $data['total'] = (string)
                    ((float) ($item->amount + $surcharge + $cod ?? 0) - 
                    (float) ($item->coupon_amt ?? 0) + 
                    (float) ($item->tip_id ?? 0));

            }else{
                    
                $data['total'] = (string)
                ((float) ($item->amount + $surcharge ?? 0) - 
                (float) ($item->coupon_amt ?? 0) + 
                (float) ($item->tip_id ?? 0));
            }

            $data['total'] = $item->g_total;
            $data['subtotal']          = $item->g_total;
            $data['card_attribute'] = $card_attr;
    
            $cards[] = $data;
            $data['packages'] = [];
        }

        // Fetch cards for the current user with pagination
        $card = Card::with('sessionPackages.slot')
        ->where('accept_user_id', auth()->user()->id)
        ->where('status','!=', 'Pending')
        ->where('status','!=', 'Completed')
        ->where('status','!=', 'Canceled')
        // ->whereIn('service_id', $service_ids)
        ->orderBy('id', 'desc')
        ->paginate($limit, ['*'], 'page', $page); 
    
        $my_bookings = [];
        $total_accept_booking = Card::where('accept_user_id', auth()->user()->id)
            ->where('status','!=', 'Pending')
            ->where('status','!=', 'Completed')
            ->where('status','!=', 'Canceled')
            // ->whereIn('service_id', $service_ids)
            ->count();
    
        foreach ($card as $item) {
            $service = Service::find($item->service_id);
            $user = User::find($item->user_id);
            $category = Category::find($item->category_id);
    
            $data = [];  // Initialize $data to avoid leftovers from previous iterations
            $check = StaffCard::where('card_id', $item->id)->with(['user', 'card']);

            if ($check->exists()) {
                $data['added_staff'] = $check->get()->map(function ($staffCard) {
            
                    return [
                        'status' => $staffCard->card->status ?? null,
                        'id' => $staffCard->user_id ?? null,
                        'first_name' => $staffCard->staff->first_name ?? null,
                        'last_name' => $staffCard->staff->last_name ?? null,
                        'phone' => $staffCard->staff->phone ?? null,
                        'dial_code' => $staffCard->staff->dial_code ?? null,
                    ];
                })->toArray();
                $data['payment_type'] = $item->payment_type;
            } else {
                $data['added_staff'] = [];
                $data['payment_type'] = $item->payment_type;
            }

            
            $matchedSession = $item->sessionPackages->first(function ($session) {
                return Carbon::parse($session->date)->gte(Carbon::today());
            });
            
            $data['matched_session_id'] = $matchedSession ? (string) $matchedSession->id : null;

            $data['booking_id']     = (string) $item->id;
            $data['tran_id']        = $item->tran_id?? '';
            $data['user_id']        = (string) $item->user_id;
            $data['user_name']      = $user ? $user->name : '';
            $data['user_email']     = $user ? $user->email : '';
            $data['user_mobile']    = $user ? $user->phone : '';
            $data['user_dial_code']    = $user ? $user->dial_code : '971';
            $data['service_id']     = (string) $item->service_id;
            $data['accept_user_id'] = (string) $item->accept_user_id;
            $data['service']        = $service ? $service->name : '';
            $data['image']          = asset('/uploads/service/' . ($service->thumbnail_img ?? ''));
            $data['category_id']    = $item->category_id;
            $data['category']       = $category ? $category->name : '';
            $data['slot_id']        = $item->slot_id;
            $data['slot']           = $item->slot ? $item->slot->name : '';
            $data['offline_charge'] = $item->offline_charge;
            $data['offline_discount'] = $item->offline_discount;
    
            // Address handling
            if (is_numeric($item->address_id)) {
                $data['address_id']     = $item->address_id;
                $building = $item->address ? $item->address->building : '';
                $flat_no = $item->address ? $item->address->flat_no : '';
                $address = $item->address ? $item->address->address : '';
                $data['address']        = "$building, $flat_no, $address";
                $data['city']           = $item->address->city->name ?? '';
                $data['locality']       = $item->address->locality_info->name ?? '';
                $data['latitude']       = $item->address->latitude ?? '';
                $data['longitude']      = $item->address->longitude ?? '';
            } else {
                $add_info = json_decode($item->address_id);
                $building = $add_info ? $add_info->building : '';
                $flat_no = $add_info ? $add_info->flat_no : '';
                $address = $add_info ? $add_info->address : '';
                $data['address']        = "$building, $flat_no, $address";
                $data['city']           = $add_info->city_name ?? '';
                $data['locality']       = $add_info->locality ?? '';
                $data['latitude']       = $add_info->latitude ?? '';
                $data['longitude']      = $add_info->longitude ?? '';
            }
    
            $data['payment_moad']   = $item->payment_moad;
            $data['payment_status'] = $item->payment_status;
            $data['note']           = $item->note;
            $data['material_charge']= $item->material_charge;
            $data['material_status']= $item->material_status;
            $data['service_type']   = $item->service_type;
            $data['alternative_dial_code']  = $item->alternative_dial_code;
            $data['alternative_number'] = $item->alternative_number;
            //$data['alternative_number'] = "0000000000";
            $data['date']           = $item->date;
            $data['tip']            = (string) $item->tip_id;
            $data['coupon_id']      = (string) $item->coupon_id;
            $data['is_checkout']    = $item->is_checkout;
            $data['status']         = $item->status;
            $data['pending_approval_by_admin'] = $item->pending_approval_by_admin;
            $isMuted = BellBookingUser::where(['user_id' => auth()->user()->id, 'booking_id' => $item->id])->value('is_bell');
            $data['is_bell'] = $isMuted ? (string) $isMuted : "0";

            $card_attr = [];
            $c = 0;
            $material_total = 0;
            $total_count = 1;
            $material = 0;
            $totalAmount = 0;
            $total_maids_material = 0;
            foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                if(!isset($value->sub_cate_id)){
                    $is_maid = 1;
                    $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                    $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                    $attribute = Attribute::where('id',$services->attribute_id)->first();
                    $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                    
                    $params['attribute_price']      = $services->attribute_price ?? null;
                    $params['attribute_qty']        = $value->attribute_qty ?? null;
                    $params['service_type']         = '';
                    
                    $data["attribute"][] = [
                        "category"=>Category::find($service_item->category_id)->name ?? "",
                        "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                        "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                        "name"=>$attribute_item->value ?? "",
                        "price"=>(string) $services->attribute_price,
                        "qty"=>(string) $value->attribute_qty];
                    $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                    
                    if($attribute->name == 'Hours'){
                        $totalAmount *= (int) $attribute_total; 
                    } else {
                        
                        $totalAmount += $attribute_total; 
                    }
                    
                    preg_match('/\d+/', $attribute_item->value, $matches);

                    if (count($matches) > 0) {
                        $number = (int) $matches[0];
                        $total_count *= $number;
                        
                        $total_maids_material *= $number;
                        if ($attribute->name == 'Hours') {
                        } else {
                        }
                    }

                } else {
                    if(empty($value->child_category_id)){
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$item->service_id,
                            'category_id'=>$value->main_sub_cat_id,
                            'sub_category_id'=>$value->sub_cate_id
                        ])->first();
                    } else{
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$item->service_id,
                            'category_id'=>$value->main_sub_cat_id,
                            'sub_category_id'=>$value->sub_cate_id,
                            'child_category_id'=>$value->child_cate_id,
                        ])->first();
                    }
                    if(!empty($service_item)){
                        $services = ServiceAttributeValue::where([
                            // 'ser_attr_val_item_id'=>$service_item->id,
                            'attribute_item_id'=>$value->attribute_item_id,
                        ])->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;

                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name,
                            "sub_category"=>Category::find($service_item->sub_category_id)->name,
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                    
                        
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (float) $attribute_total; 
                        } else {
                            
                            $totalAmount += (float) $attribute_total; 
                        }

                        preg_match('/\d+/', $attribute_item->value, $matches);

                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                        
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                        
                    } 
                    $params['service_type']         = '';
                } 
                $sub_cat = Category::find($value->sub_cate_id);
                $child_cat = ChildCategory::find($value->child_cate_id);

                $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                $paramss['child_cate_id']        = (string) $value->child_cate_id;
                $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                $paramss['attribute_id']         = (string) $value->attribute_id;
                $paramss['attribute_name']       = $value->attribute_name;
                $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                $paramss['attribute_item_name']  = $value->attribute_item_name;
                $paramss['attribute_qty']        = (string) $value->attribute_qty;
                $paramss['attribute_price']      = (string) $value->attribute_price;
                $paramss['service_type']         = $value->service_type;
                $paramss['unit_price']         = $value->unit_price??0;
                array_push($card_attr,$paramss);
            }

            $data['card_attribute'] = $card_attr;
            $totalAmount = (float) $item->amount;

            $material = ($item->material_status == "Apply") ? (float) $item->material_charge : "0";

            if($item->service_id == 10){
                
                if ($item->sessionPackages->isNotEmpty()) {
                    $data["sessions"] = $item->sessionPackages
                        ->sortBy('date')
                        ->map(function ($session) {
                             $addedStaff = \DB::table('staff_sessions')
                            ->join('staff', 'staff.id', '=', 'staff_sessions.user_id')
                            ->where('staff_sessions.session_id', $session->id)
                            ->select(
                                'staff.id',
                                'staff.user_id',
                                'staff.first_name',
                                'staff.last_name',
                                'staff.phone',
                                'staff.dial_code',
                                'staff_sessions.status as staff_session_status'
                            )
                            ->get();
                            return [
                                'id' => (string) $session->id,
                                'cart_id' => $session->cart_id,
                                'package_id' => $session->package_id,
                                'slot' => $session->slot,
                                'service_id' => $session->service_id,
                                'date' => $session->date,
                                'time' => $session->time,
                                'status' => $session->status,
                                'added_staff' => $addedStaff
                            ];
                        })
                        ->values() 
                        ->toArray(); 
                } else {
                    $data["sessions"] = [];
                }
                
                if(isset($item->selected_packages) ){    
                    $totalAmount = 0;            
                    $selectedPackageIds = explode(',', $item->selected_packages);

                    $packages = Packages::whereIn('id', $selectedPackageIds)->get();

                    foreach ($packages as $package) {
                        
                        $data['total_session_count'] = $package->total_sessions;
                        $data['is_package'] = "1";
                        $data["packages"][] = [
                            "name"=>$package->name, 
                            "base_amount"=>(string) $package->amount,
                            "price"=>(string) ((int) $package->amount * (int) $total_count),
                            "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                        ]; 
                        
                        $totalAmount = (float) $package->amount * (float) $total_count; 
                        $material *= ((int) $package->total_sessions + (int) $package->free_sessions);
                
                    }
                } else {

                    $data['is_package'] = "0";
                    $data['packages'] = [];
                    $data['total_session_count'] = "0";
                }

            } else {

                $data['is_package'] = "0";
                $data['packages'] = [];
            }
    
            $data['coupon']         = $item->coupon ? $item->coupon->code : '';
            $data['coupon_amt']     = $item->coupon_amt;
            $order = Order::find($item->order_id); 

            $cod = (int) $item->cod;
    
            $surcharge = (float) $item->surcharge;

            if($item->payment_type == 2){
                $data['total'] = (string)
                    ((float) ($item->amount + $surcharge + $cod ?? 0) - 
                    (float) ($order->coupon_amount ?? 0) + 
                    (float) ($order->tip_amount ?? 0));

            }else{
                    
                $data['total'] = (string)
                ((float) ($item->amount + $surcharge ?? 0) - 
                (float) ($order->coupon_amount ?? 0) + 
                (float) ($order->tip_amount ?? 0));
            }
            $data['subtotal']          = $item->g_total;
            $data['total'] = $item->g_total;
            $data['card_attribute'] = $card_attr;
    
            $my_bookings[] = $data;
        }

        // Return response with pagination metadata
        return $this->sendResponse([
            'new_bookings'=>$cards,
            'my_bookings'=>$my_bookings,
            'total_new_booking'=>(string) $total_new_booking,
            'total_accept_booking'=>(string) $total_accept_booking,
        ], 'Home');
    }    
    
    public function get_my_job(Request $request)
    {
        $limit = $request->get('limit', 10); 
        $page = $request->get('page', 1); 
    
        // Fetch cards for the current user with pagination
        $card = Card::where('accept_user_id', auth()->user()->id)
                    ->where('status', '!=', 'Canceled')
                    ->where('status', '!=', 'Completed')
                    ->paginate($limit, ['*'], 'page', $page); 
    
        $cards = [];
    
        foreach ($card as $value) {
            $service = Service::find($value->service_id);
            $user = User::find($value->user_id);
            $category = Category::find($value->category_id);
    
            $data = [];  // Initialize $data to avoid leftovers from previous iterations
            $data['booking_id']     = (string) $value->id;
            $data['tran_id']        = $value->tran_id ?? '';
            $data['user_id']        = (string) $value->user_id;
            $data['user_name']      = $user ? $user->name : '';
            $data['user_email']     = $user ? $user->email : '';
            $data['user_mobile']    = $user ? $user->phone : '';
            $data['user_dial_code']    = $user ? $user->dial_code : '971';
            $data['service_id']     = $value->service_id;
            $data['accept_user_id'] = $value->accept_user_id;
            $data['service']        = $service ? $service->name : '';
            $data['image']          = asset('/uploads/service/' . ($service->thumbnail_img ?? ''));
            $data['category_id']    = $value->category_id;
            $data['category']       = $category ? $category->name : '';
            $data['slot_id']        = $value->slot_id;
            $data['slot']           = $value->slot ? $value->slot->name : '';
            $data['offline_charge'] = $value->offline_charge;
            $data['offline_discount'] = $value->offline_discount;
    
            // Address handling
            if (is_numeric($value->address_id)) {
                $data['address_id']     = $value->address_id;
                $building = $value->address ? $value->address->building : '';
                $flat_no = $value->address ? $value->address->flat_no : '';
                $address = $value->address ? $value->address->address : '';
                $data['address']        = "$building, $flat_no, $address";
                $data['city']           = $value->address->city->name ?? '';
                $data['locality']       = $value->address->locality_info->name ?? '';
                $data['latitude']       = $value->address->latitude ?? '';
                $data['longitude']      = $value->address->longitude ?? '';
            } else {
                $add_info = json_decode($value->address_id);
                $building = $add_info ? $add_info->building : '';
                $flat_no = $add_info ? $add_info->flat_no : '';
                $address = $add_info ? $add_info->address : '';
                $data['address']        = "$building, $flat_no, $address";
                $data['city']           = $add_info->city_name ?? '';
                $data['locality']       = $add_info->locality ?? '';
                $data['latitude']       = $add_info->latitude ?? '';
                $data['longitude']      = $add_info->longitude ?? '';
            }
    
            $data['payment_moad']   = $value->payment_moad;
            $data['payment_status'] = $value->payment_status;
            $data['note']           = $value->note;
            $data['material_charge']= $value->material_charge;
            $data['material_status']= $value->material_status;
            $data['service_type']   = $value->service_type;
            $data['alternative_dial_code']  = $value->alternative_dial_code;
            $data['alternative_number'] = $value->alternative_number;
            $data['date']           = $value->date;
            $data['tip']            = (string) $value->tip_id;
            $data['coupon_id']      = (string) $value->coupon_id;
            $data['is_checkout']    = $value->is_checkout;
            $data['status']         = $value->status;
            $data['pending_approval_by_admin'] = $value->pending_approval_by_admin;
            $isMuted = BellBookingUser::where(['user_id' => auth()->user()->id, 'booking_id' => $value->id])->value('is_bell');
            $data['is_bell'] = $isMuted ? (string) $isMuted : "0";

    
            // Card attributes and addons
            $card_attr = [];
            foreach (CardAttribute::where('card_id', $value->id)->get() as $item) {
                $sub_cat = Category::find($item->sub_cate_id);
                $child_cat = ChildCategory::find($item->child_cate_id);
    
                $params = [];
                $params['sub_cate_id']          = $item->sub_cate_id;
                $params['sub_cate_name']        = $sub_cat ? $sub_cat->name : '';
                $params['main_sub_cat_id']      = $item->main_sub_cat_id;
                $params['main_sub_cat_name']    = $item->main_sub_cat ? $item->main_sub_cat->name : '';
                $params['child_cate_id']        = $item->child_cate_id;
                $params['child_cate']           = $child_cat ? $child_cat->name : '';
                $params['attribute_id']         = $item->attribute_id;
                $params['attribute_name']       = $item->attribute_name;
                $params['attribute_item_id']    = $item->attribute_item_id;
                $params['attribute_item_name']  = $item->attribute_item_name;
                $params['attribute_qty']        = $item->attribute_qty;
                $params['attribute_price']      = $item->attribute_price;
                $params['service_type']         = $item->service_type;
    
                $addons = [];
                foreach (CardAddon::where('card_id', $value->id)->where('card_attribute_id', $item->id)->get() as $cardaddon) {
                    $addon = [];
                    $addon['card_id']               = $cardaddon->id;
                    $addon['card_attribute_id']     = $cardaddon->id;
                    $addon['add_on_id']             = $cardaddon->add_on_id;
                    $addon['name']                  = $cardaddon->name;
                    $addon['value']                 = $cardaddon->value;
                    $addon['percentage']            = $cardaddon->percentage;
                    $addons[] = $addon;
                }
                $params['addon'] = $addons;
                $card_attr[] = $params;
            }
    
            $data['coupon']         = $value->coupon ? $value->coupon->code : '';
            $data['coupon_amt']     = $value->coupon_amt;
            $data['total']       = $value->amount;
            $data['subtotal']          = $value->g_total;
            $data['card_attribute'] = $card_attr;
    
            $cards[] = $data;
        }
    
        // Return response with pagination metadata
        return $this->sendResponse($cards, 'My Jobs');
    }    
    
    // public function get_active_booking(Request $request)
    // {
    //     $date = $request->date;
    //     if(auth()->user()->role == 'vendor'){
    //         if(!empty($date)){
    //             $card = Card::with('sessionPackages.slot')
    //             ->where('accept_user_id', auth()->user()->id)
    //             ->where(function ($query) use ($date) {
    //                 $query->where('date', $date)
    //                 ->orWhereHas('sessionPackages', function ($subQuery) use ($date) {
    //                     $subQuery->where('date', $date);
    //                 });
    //             })
    //             ->where('status','!=', 'Pending')
    //             ->where('status','!=', 'Completed')
    //             ->where('status','!=', 'Canceled')
    //             ->orderBy('id', 'DESC')->get();
    //         } else{
    //             $card = Card::with('sessionPackages.slot')
    //             ->where('accept_user_id', auth()->user()->id)
    //             ->where('status','!=', 'Pending')
    //             ->where('status','!=', 'Completed')
    //             ->where('status','!=', 'Canceled')
    //             ->orderBy('id', 'DESC')->get();
    //         }

    //         $check_staff = 1;
    //     } else {

    //         $staff = auth()->user()->staff; 
    //         $staffId = $staff ? $staff->id : null;
    //         $cards = collect(); // Initialize a collection to hold the combined results

    //         // Query for StaffCard
    //         $staffCards = StaffCard::where('user_id', $staffId)
    //         ->where('status', '!=', 'Completed')
    //             ->with(['card', 'sessionPackages.slot'])
    //             ->orderBy('id', 'DESC')
    //             ->get()
    //             ->map(function ($staffCard) {
    //                 $result = [];
    //                 if ($staffCard->sessionPackages && $staffCard->sessionPackages->isNotEmpty()) {
    //                     foreach ($staffCard->sessionPackages as $sessionPackage) {
    //                         $card = $staffCard->card->replicate();
    //                         $card->status = $sessionPackage->status;
    //                         $card->session_id = $sessionPackage->id;
    //                         $card->date = $sessionPackage->date;
    //                         $card->id = $sessionPackage->cart_id;
    //                         $result[] = $card;
    //                     }
    //                 }
            
    //                 if ($staffCard->card && empty($result)) {
    //                     $card = $staffCard->card;
    //                     $card->status = $staffCard->status;
    //                     $result[] = $card;
    //                 }
            
    //                 return $result;
    //             })
    //             ->flatten(1) 
    //             ->filter();
            
    //         $cards = $cards->merge($staffCards);
            
    //         $staffSessions = StaffSession::where('user_id', $staffId)
    //         ->where('status' ,'!=', 'Completed')
    //         ->where('status' ,'!=', 'Canceled')
    //         ->with(['card', 'slot', 'sessionPackage'])
    //         ->orderBy('id', 'DESC')
    //         ->get()
    //         ->map(function ($staffSession) {
    //             $result = [];
        
    //             // Check if card and sessionPackage relationships exist
    //             if ($staffSession->card && $staffSession->sessionPackage) {
    //                 $sessionPackage = $staffSession->sessionPackage;
    //                 $card = $staffSession->card->replicate();
        
    //                 $card->status = $sessionPackage->status;
    //                 $card->session_id = $sessionPackage->id; 
    //                 $card->date = $sessionPackage->date; 
    //                 $card->id = $sessionPackage->cart_id; 
    //                 if($sessionPackage->status != 'Completed' && $sessionPackage->status != 'Cancelled'){
    //                     $result[] = $card;
    //                 }
    //             }
        
    //             if ($staffSession->card && empty($result)) {
    //                 $card = $staffSession->card;
    //                 $card->status = $staffSession->status;
    //                 if($sessionPackage->status != 'Completed' && $sessionPackage->status != 'Cancelled'){
    //                     $result[] = $card;
    //                 }
    //             }
        
    //             return $result;
    //         })
    //         ->flatten(1) 
    //         ->filter();
            
    //         $card = $cards->merge($staffSessions);
                        
        
    //         $check_staff = 2;
    //     }
  
    //     $cards = [];
    //     $surcharge = 0;
    //     foreach ($card as $key => $item) {

    //         $service = Service::find($item->service_id);
    //         if($check_staff == 1){
    //             $check = StaffCard::where('card_id', $item->id)->with(['user', 'card']);

    //             if ($check->exists()) {
    //                 $data['added_staff'] = $check->get()->map(function ($staffCard) {
                
    //                     return [
    //                         'status' => $staffCard->status ?? null,
    //                         'id' => $staffCard->user_id ?? null,
    //                         'first_name' => $staffCard->staff->first_name ?? null,
    //                         'last_name' => $staffCard->staff->last_name ?? null,
    //                         'phone' => $staffCard->staff->phone ?? null,
    //                         'dial_code' => $staffCard->staff->dial_code ?? null,
    //                     ];
    //                 })->toArray();
    //                 $data['payment_type'] = $item->payment_type;
    //             } else {
    //                 $data['added_staff'] = [];
    //                 $data['payment_type'] = $item->payment_type;
    //             }
    //         }else{
    //             $check = StaffSession::where('session_id', $item->session_id)->with(['user']);

    //             if ($check->exists()) {
    //                 $data['added_staff'] = $check->get()->map(function ($staffCard) {
                
    //                     return [
    //                         'status' => $staffCard->status ?? null,
    //                         'id' => $staffCard->user_id ?? null,
    //                         'first_name' => $staffCard->staff->first_name ?? null,
    //                         'last_name' => $staffCard->staff->last_name ?? null,
    //                         'phone' => $staffCard->staff->phone ?? null,
    //                         'dial_code' => $staffCard->staff->dial_code ?? null,
    //                     ];
    //                 })->toArray();
    //                 $data['payment_type'] = $item->payment_type;
    //             } else {
    //                 $data['added_staff'] = [];
    //                 $data['payment_type'] = $item->payment_type;
    //             }
    //         }

    //         $user = User::find($item->user_id);
    //         $category = Category::find($item->category_id);
    //         if(isset($item->session_id)){
    //             $data['session_id']     = (string) $item->session_id;
    //         }
    //         $data['booking_id']     = (string) $item->id;
    //         $data['tran_id']        = (string) $item->tran_id;

    //         $data['user_id']        = (string) $item->user_id;
    //         $data['user_name']      = $user?$user->name:'';
    //         $data['user_email']     = $user?$user->email:'';
    //         $data['user_mobile']    = $user?$user->phone:'';
    //         $data['service_id']     = $item->service_id;
    //         $data['service']        = $service->name;
    //         $data['image']          = \URL::to('/').'/uploads/service/'.$service->thumbnail_img;
    //         $data['category_id']    = $item->category_id;
    //         $data['category']       = $category?$category->name:'';
    //         $data['slot_id']        = $item->slot_id;
    //         $data['slot']           = $item->slot?$item->slot->name:'';
    //         $data['offline_charge'] = $item->offline_charge;
    //         $data['offline_discount'] = $item->offline_discount;
    //         if(is_numeric($item->address_id)){

    //             $data['address_id']     = $item->address_id;

    //             $building = $item->address?$item->address->building:'';
    //             $flat_no = $item->address?$item->address->flat_no:'';
    //             $address = $item->address?$item->address->address:'';

    //             $latitude = $item->address?$item->address->latitude:'';
    //             $longitude = $item->address?$item->address->longitude:'';
    //             $data['address']        = $building.', '. $flat_no.', '.$address;

    //             if($item->address && $item->address->city){
    //                 $city = $item->address->city->name;
    //             } else {
    //                 $city = "";
    //             }

    //             $data['city']           = $city;

    //             if($item->address && $item->address->locality_info){
    //                 $locality = $item->address->locality_info->name;
    //             } else {
    //                 $locality = "";
    //             }
    //             $data['locality']       = $locality;
                
    //             $data['latitude']       = $latitude;
    //             $data['longitude']      = $longitude;

    //         } else {

    //             $add_info = json_decode($item->address_id);

    //             $data['address_id']     = '';


    //             $building = $add_info?$add_info->building:'';
    //             $flat_no = $add_info?$add_info->flat_no:'';
    //             $address = $add_info?$add_info->address:'';

    //             $latitude = $add_info?$add_info->latitude:'';
    //             $longitude = $add_info?$add_info->longitude:'';
    //             $data['address']        = $building.', '. $flat_no.', '.$address;

    //             if($add_info && $add_info->city_name){
    //                 $city = $add_info->city_name;
    //             } else {
    //                 $city = "";
    //             }

    //             $data['city']           = $city;

    //             if($add_info && $add_info->locality){
    //                 $locality = $add_info->locality;
    //             } else {
    //                 $locality = "";
    //             }
    //             $data['locality']       = $locality;
                
    //             $data['latitude']       = $latitude;
    //             $data['longitude']      = $longitude;

    //         }
    //         $data['payment_moad']   = $item->payment_moad;
    //         $data['payment_status'] = $item->payment_status;
    //         $data['note']           = $item->note;
    //         $data['material_charge']= $item->material_charge;
    //         $data['material_status']= $item->material_status;
    //         $data['service_type']   = $item->service_type;
    //         $data['alternative_dial_code']  = $item->alternative_dial_code;
    //         $data['alternative_number'] = $item->alternative_number;
    //         $data['date']           = $item->date;
    //         $data['tip']            = $item->tip_id;
    //         $data['coupon_id']      = $item->coupon_id;
    //         $data['is_checkout']    = $item->is_checkout;
    //         $data['status']         = $item->status;
    //         $data['pending_approval_by_admin']         = $item->pending_approval_by_admin;
            
    //         $card_attr = [];
    //         $c = 0;
    //         $material_default = ($request->material_status == "Apply") ? (float) $service->material_price : 0;
    //         $material_total = 0;
    //         $total_count = 1;
    //         $material = 0;
    //         $totalAmount = 0;
    //         $total_maids_material = 0;
    //         foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
    //             if(!isset($value->sub_cate_id)){
    //                 $is_maid = 1;
    //                 $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
    //                 $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
    //                 $attribute = Attribute::where('id',$services->attribute_id)->first();
    //                 $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                    
    //                 $params['attribute_price']      = $services->attribute_price ?? null;
    //                 $params['attribute_qty']        = $value->attribute_qty ?? null;
    //                 $params['service_type']         = '';
                    
    //                 $data["attribute"][] = [
    //                     "category"=>Category::find($service_item->category_id)->name ?? "",
    //                     "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
    //                     "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
    //                     "name"=>$attribute_item->value ?? "",
    //                     "price"=>(string) $services->attribute_price,
    //                     "qty"=>(string) $value->attribute_qty];
    //                 $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                    
    //                 if($attribute->name == 'Hours'){
    //                     $totalAmount *= (int) $attribute_total; 
    //                 } else {
                        
    //                     $totalAmount += $attribute_total; 
    //                 }
                    
    //                 preg_match('/\d+/', $attribute_item->value, $matches);
            
    //                 if (count($matches) > 0) {
    //                     $number = (int) $matches[0];
    //                     $total_count *= $number;
                        
    //                     if ($attribute->name == 'Hours') {
    //                     } else {
    //                         $total_maids_material *= $number;
    //                     }
    //                 }
            
    //             } else {
    //                 if(empty($value->child_category_id)){
    //                     $service_item = ServiceAttributeValueItem::where([
    //                         'service_id'=>$item->service_id,
    //                         'category_id'=>$value->main_sub_cat_id,
    //                         'sub_category_id'=>$value->sub_cate_id
    //                     ])->first();
    //                 } else{
    //                     $service_item = ServiceAttributeValueItem::where([
    //                         'service_id'=>$item->service_id,
    //                         'category_id'=>$value->main_sub_cat_id,
    //                         'sub_category_id'=>$value->sub_cate_id,
    //                         'child_category_id'=>$value->child_cate_id,
    //                     ])->first();
    //                 }
    //                 if(!empty($service_item)){
    //                     $services = ServiceAttributeValue::where([
    //                         // 'ser_attr_val_item_id'=>$service_item->id,
    //                         'attribute_item_id'=>$value->attribute_item_id,
    //                     ])->first();
    //                     $attribute = Attribute::where('id',$services->attribute_id)->first();
    //                     $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
    //                     $params['attribute_price']      = $services->attribute_price ?? null;
    //                     $params['attribute_qty']        = $value->attribute_qty ?? null;
            
    //                     $data["attribute"][] = [
    //                         "category"=>Category::find($service_item->category_id)->name,
    //                         "sub_category"=>Category::find($service_item->sub_category_id)->name,
    //                         "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
    //                         "name"=>$attribute_item->value ?? "",
    //                         "price"=>(string) $services->attribute_price,
    //                         "qty"=>(string) $value->attribute_qty];
                    
                        
    //                     $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
    //                     if($attribute->name == 'Hours'){
    //                         $totalAmount *= (float) $attribute_total; 
    //                     } else {
                            
    //                         $totalAmount += (float) $attribute_total; 
    //                     }
            
    //                     preg_match('/\d+/', $attribute_item->value, $matches);
            
    //                     if (count($matches) > 0) {
    //                         $number = (int) $matches[0];
    //                         $total_count *= $number;
                        
    //                         if ($attribute->name == 'Hours') {
    //                         } else {
    //                             $total_maids_material *= $number;
    //                         }
    //                     }
                        
    //                 } 
    //                 $params['service_type']         = '';
    //             } 
    //             $sub_cat = Category::find($value->sub_cate_id);
    //             $child_cat = ChildCategory::find($value->child_cate_id);
            
    //             $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
    //             $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
    //             $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
    //             $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
    //             $paramss['child_cate_id']        = (string) $value->child_cate_id;
    //             $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
    //             $paramss['attribute_id']         = (string) $value->attribute_id;
    //             $paramss['attribute_name']       = $value->attribute_name;
    //             $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
    //             $paramss['attribute_item_name']  = $value->attribute_item_name;
    //             $paramss['attribute_qty']        = (string) $value->attribute_qty;
    //             $paramss['attribute_price']      = (string) $value->attribute_price;
    //             $paramss['service_type']         = $value->service_type;
            
    //             array_push($card_attr,$paramss);
    //         }
            
    //         $data['card_attribute'] = $card_attr;
            
    //         if ($item->sessionPackages->isNotEmpty()) {
    //             $data["sessions"] = $item->sessionPackages
    //                 ->sortBy('date')
    //                 ->map(function ($session) {
    //                     return [
    //                         'id' => $session->id,
    //                         'cart_id' => $session->cart_id,
    //                         'package_id' => $session->package_id,
    //                         'slot' => $session->slot,
    //                         'service_id' => $session->service_id,
    //                         'date' => $session->date,
    //                         'time' => $session->time,
    //                         'status' => $session->status,
    //                     ];
    //                 })
    //                 ->values() 
    //                 ->toArray(); 
    //         } else {
    //             $data["sessions"] = [];
    //         }

    //         $totalAmount = (float) $item->amount;
            
    //         $material = ($item->material_status == "Apply") ? (float) $item->material_charge : "0";
            
    //         if($item->service_id == 10){
            
    //             if(isset($item->selected_packages) ){    
    //                 $totalAmount = 0;            
    //                 $selectedPackageIds = explode(',', $item->selected_packages);
            
    //                 $packages = Packages::whereIn('id', $selectedPackageIds)->get();
            
    //                 foreach ($packages as $package) {
                        
    //                     $data['total_session_count'] = $package->total_sessions;
    //                     $data['is_package'] = "1";
    //                     $data["packages"][] = [
    //                         "name"=>$package->name, 
    //                         "base_amount"=>(string) $package->amount,
    //                         "price"=>(string) ((int) $package->amount * (int) $total_count),
    //                         "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
    //                     ]; 
                        
    //                     $totalAmount = (float) $package->amount * (float) $total_count; 
    //                     $material *= ((int) $package->total_sessions + (int) $package->free_sessions);
                
    //                 }
    //             } else {
            
    //                 $data['is_package'] = "0";
    //                 $data['packages'] = [];
    //                 $data['total_session_count'] = "0";
    //             }
            
    //         } else {
            
    //             $data['is_package'] = "0";
    //             $data['packages'] = [];
    //         }
    //         $isMuted = BellBookingUser::where(['user_id' => auth()->user()->id, 'booking_id' => $item->id])->value('is_bell');
    //         $data['is_bell'] = $isMuted ? (string) $isMuted : "0";

    //         $data['coupon']         = $item->coupon?$item->coupon->code:'';
    //         $data['coupon_amt']     = $item->coupon_amt;
    //         $order = Order::find($item->order_id); 

    //         $cod = (int) HomeSetting::first()->cash_surcharge;

    //         $surcharge = (float) Service::find($item->service_id)->cod_charge;
    //         if($item->payment_type == 2){
    //             $data['total'] = (string)
    //                 ((float) ($item->amount + $surcharge + $cod ?? 0) - 
    //                 (float) ($order->coupon_amount ?? 0) + 
    //                 (float) ($order->tip_amount ?? 0));

    //         }else{
                    
    //             $data['total'] = (string)
    //             ((float) ($item->amount + $surcharge ?? 0) - 
    //             (float) ($order->coupon_amount ?? 0) + 
    //             (float) ($order->tip_amount ?? 0));
    //         }

    //         $data['subtotal']          = $item->g_total;
    //         $data['card_attribute'] = $card_attr;
           
    //         array_push($cards, $data);
    //         $data['packages'] = [];
    //     }
    //     return $this->sendResponse($cards, 'Active Bookings');
    // }

    
    /**
     * Filter sessions/cards by date condition
     *
     * @param $item
     * @param string|null $date
     * @return bool
     */
    private function filterByDate($item, ?string $date): bool
    {
        if (!$item->date) {
            return false;
        }

        $itemDate = Carbon::parse($item->date);

        if ($date === 'upcoming') {
            return $itemDate->greaterThan(Carbon::tomorrow());
        } elseif (!empty($date)) {
            return $itemDate->isSameDay(Carbon::parse($date));
        } else {
            if ($itemDate->greaterThan(Carbon::today())) {
                return true;
            } elseif ($itemDate->isToday() && isset($item->slot)) {
                return Carbon::now('Asia/Dubai')->lt(Carbon::createFromFormat('H:i:s', $item->slot->check_in));
            }
        }

        return false;
    }


    public function get_active_booking(Request $request)
    {
        $limit = $request->get('limit', 10);
        $page = $request->get('page', 1); 
        $date = $request->date; 
        $user = User::find(auth()->user()->id);
        if($user->wallet_balance < 0 || $user->wallet_balance == '0'){
            $wallet = '0';
        } else {
            $wallet = $user->wallet_balance;
        }
        $sellerId = Seller::where('user_id', $user->id)->value('id'); // Get seller ID directly
        $serviceIds = SellerService::where('seller_id', $sellerId)->pluck('service_id')->toArray();
        if(!empty($date)){

            if(auth()->user()->role == 'vendor'){
                \DB::enableQueryLog();
                $card = Card::with(['sessionPackages.slot'])
                //->whereIn('service_id', $serviceIds)
                ->where('accept_user_id', auth()->user()->id)
                ->where(function ($query) use ($date) {
                    if ($date === 'upcoming') {
                        $query->where(function ($subQuery) {
                            $subQuery->where('service_id', '!=', 10)
                                ->where('date', '>', Carbon::tomorrow());
                        })
                        ->orWhere(function ($subQuery) {
                            $subQuery->where('service_id', 10)
                                ->whereHas('sessionPackages', function ($innerQuery) {
                                    $innerQuery->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])->where('date', '>', Carbon::tomorrow());
                                });
                        });
                    }else if($date =='all'){
                        $query->whereIn('status',['Accept','In Progress','Upcoming','Expired','Mark As Arrived'] );
                    } else if(!empty($date)) {
                        $query->where(function ($subQuery) use ($date) {
                            $subQuery
                            ->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])
                            ->where('service_id', '!=', 10)
                                ->where('date', $date);
                        })
                        ->orWhere(function ($subQuery) use ($date) {
                            $subQuery->where('service_id', 10)
                            //->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])
                            ->whereHas('sessionPackages', function ($innerQuery) use ($date) {
                                $innerQuery
                                ->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived','Pending'])
                                ->where('date', $date);
                            });
                        });
                    } else {
                        // For services other than service_id = 10
                        $query->where(function ($subQuery) {
                            $subQuery
                                ->where('service_id', '!=', 10)
                                ->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])
                                ->where(function ($innerQuery) {
                                    $innerQuery->where('date', '>', Carbon::today()) // Allow only future dates
                                        ->orWhere(function ($dateQuery) {
                                            $dateQuery
                                ->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])->where('date', '=', Carbon::today()) // Allow today's cards with future times
                                    ->whereHas('slot', function ($timeQuery) {
                                        $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                    });
                                });
                            });
                        })
                        ->orWhere(function ($query) {
                            // For service_id = 10, use sessionPackages for date and slot
                            $query->where('service_id', 10)
                            ->where('status', '!=','Accept')
                                ->whereHas('sessionPackages', function ($subQuery) {
                                    $subQuery
                                ->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])
                                    ->where(DB::raw('DATE(date)'), '>', Carbon::today()->toDateString()) // Allow future dates only
                                        ->orWhere(function ($dateQuery) {
                                            $dateQuery
                                ->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])
                                            ->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Allow today's sessions
                                                ->whereHas('slot', function ($timeQuery) {
                                                    $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                                });
                                        });
                                });
                        });
                        
                    }
                })
                ->where('is_checkout', 'Done')
                // ->whereDoesntHave('vendorCardStatuses', function ($query) {
                //     $query->where('vendor_id', auth()->id())
                //         ->where('status', 'Cancelled');
                // })
                ->orderBy('id', 'DESC');
                // Get the raw SQL and bindings before pagination
                // $sql = $card->toSql();
                // $bindings = $card->getBindings();
                
                // // Replace ? placeholders with actual values safely
                // $fullQuery = vsprintf(str_replace('?', "'%s'", $sql), $bindings);
                
                // // Output the compiled query
                // dd($fullQuery);

                $card = $card->paginate($limit, ['*'], 'page', $page);
                //dd(\DB::getQueryLog());
                
                $check_staff = 1;
            } else {
                
                $staff = auth()->user()->staff; 
                $staffId = $staff ? $staff->id : null;
                $cards = collect();

                // Query for StaffCard
                $staffCards = StaffCard::where('user_id', $staffId)
                    ->where('status', '!=', 'Completed')
                    ->with(['card', 'sessionPackages.slot'])
                    ->orderBy('id', 'DESC')
                    ->get()
                    ->map(function ($staffCard) use ($date) {
                        $result = [];

                        if ($staffCard->sessionPackages && $staffCard->sessionPackages->isNotEmpty()) {
                            foreach ($staffCard->sessionPackages as $sessionPackage) {
                                if ($this->filterByDate($sessionPackage, $date)) {
                                    $card = $staffCard->card->replicate();
                                    $card->status = $sessionPackage->status;
                                    $card->session_id = $sessionPackage->id;
                                    $card->date = $sessionPackage->date;
                                    $card->id = $sessionPackage->cart_id;
                                    $result[] = $card;
                                }
                            }
                        }

                        if ($staffCard->card && empty($result)) {
                            $card = $staffCard->card;
                            if ($this->filterByDate($card, $date)) {
                                $card->status = $staffCard->status;
                                $result[] = $card;
                            }
                        }

                        return $result;
                    })
                    ->flatten(1)
                    ->filter();

                $staffSessions = StaffSession::where('user_id', $staffId)
                    ->whereNotIn('status', ['Completed', 'Canceled'])
                    ->with(['card', 'slot', 'sessionPackage'])
                    ->orderBy('id', 'DESC')
                    ->get()
                    ->map(function ($staffSession) use ($date) {
                        $result = [];

                        if ($staffSession->card && $staffSession->sessionPackage) {
                            $sessionPackage = $staffSession->sessionPackage;
                            if ($this->filterByDate($sessionPackage, $date)) {
                                $card = $staffSession->card->replicate();
                                $card->status = $sessionPackage->status;
                                $card->session_id = $sessionPackage->id;
                                $card->date = $sessionPackage->date;
                                $card->id = $sessionPackage->cart_id;
                                if (!in_array($sessionPackage->status, ['Completed', 'Cancelled'])) {
                                    $result[] = $card;
                                }
                            }
                        }

                        if ($staffSession->card && empty($result)) {
                            $card = $staffSession->card;
                            if ($this->filterByDate($card, $date)) {
                                $card->status = $staffSession->status;
                                $result[] = $card;
                            }
                        }

                        return $result;
                    })
                    ->flatten(1)
                    ->filter();

                $card = $cards->merge($staffCards)->merge($staffSessions);
                $check_staff = 2;
            }
        } else{
            
            if(auth()->user()->role == 'vendor'){
                $card = Card::with('slot')
                ->whereIn('service_id', $serviceIds)
                ->where('is_checkout', 'Done')
                ->where('accept_user_id', auth()->user()->id)
                ->whereDoesntHave('vendorCardStatuses', function ($query) {
                    $query->where('vendor_id', auth()->id())
                        ->where('status', 'Cancelled');
                })
                ->where(function ($query) {
                    // For services other than service_id = 10
                    $query->where(function ($subQuery) {
                        $subQuery
                            ->where('service_id', '!=', 10)
                            ->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])
                            ->where(function ($innerQuery) {
                                $innerQuery->where('date', '>', Carbon::today()) // Allow only future dates
                                    ->orWhere(function ($dateQuery) {
                                        $dateQuery->where('date', '=', Carbon::today()) // Allow today's cards with future times
                                            ->whereHas('slot', function ($timeQuery) {
                                                $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                            });
                                    });
                            });
                    })
                    ->orWhere(function ($query) {
                        // For service_id = 10, use sessionPackages for date and slot
                        $query->where('service_id', 10)
                        ->where('status', '!=','Accept')
                            ->whereHas('sessionPackages', function ($subQuery) {
                                $subQuery
                                ->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])
                                ->where(DB::raw('DATE(date)'), '>', Carbon::today()->toDateString()) // Allow future dates only
                                ->orWhere(function ($dateQuery) {
                                    $dateQuery
                                ->whereIn('status', ['Accept','In Progress','Upcoming','Expired','Mark As Arrived'])
                                    ->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Allow today's sessions
                                    ->whereHas('slot', function ($timeQuery) {
                                        $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                    });
                                });
                            });
                    });
                })
                ->orderBy('id', 'DESC')
                ->paginate($limit, ['*'], 'page', $page);
                $check_staff = 1;
            } else {
                        
                $staff = auth()->user()->staff; 
                $staffId = $staff ? $staff->id : null;
                $cards = collect(); // Initialize a collection to hold the combined results

                // Query for StaffCard
                $staffCards = StaffCard::where('user_id', $staffId)
                ->where('status', '!=', 'Completed')
                ->with(['card', 'sessionPackages.slot'])
                ->orderBy('id', 'DESC')
                ->get()
                ->map(function ($staffCard) {
                    $result = [];
                    if ($staffCard->sessionPackages && $staffCard->sessionPackages->isNotEmpty()) {
                        foreach ($staffCard->sessionPackages as $sessionPackage) {
                            $card = $staffCard->card->replicate();
                            $card->status = $sessionPackage->status;
                            $card->session_id = $sessionPackage->id;
                            $card->date = $sessionPackage->date;
                            $card->id = $sessionPackage->cart_id;
                            $result[] = $card;
                        }
                    }
            
                    if ($staffCard->card && empty($result)) {
                        $card = $staffCard->card;
                        $card->status = $staffCard->status;
                        $result[] = $card;
                    }
                
                    return $result;
                })
                ->flatten(1) 
                ->filter();
                
                $cards = $cards->merge($staffCards);
                
                $staffSessions = StaffSession::where('user_id', $staffId)
                ->where('status' ,'!=', 'Completed')
                ->where('status' ,'!=', 'Canceled')
                ->with(['card', 'slot', 'sessionPackage'])
                ->orderBy('id', 'DESC')
                ->get()
                ->map(function ($staffSession) {
                    $result = [];
            
                    // Check if card and sessionPackage relationships exist
                    if ($staffSession->card && $staffSession->sessionPackage) {
                        $sessionPackage = $staffSession->sessionPackage;
                        $card = $staffSession->card->replicate();
            
                        $card->status = $sessionPackage->status;
                        $card->session_id = $sessionPackage->id; 
                        $card->date = $sessionPackage->date; 
                        $card->id = $sessionPackage->cart_id; 
                        if($sessionPackage->status != 'Completed' && $sessionPackage->status != 'Cancelled'){
                            $result[] = $card;
                        }
                    }
            
                    if ($staffSession->card && empty($result)) {
                        $card = $staffSession->card;
                        $card->status = $staffSession->status;
                        if($sessionPackage->status != 'Completed' && $sessionPackage->status != 'Cancelled'){
                            $result[] = $card;
                        }
                    }
            
                    return $result;
                })
                ->flatten(1) 
                ->filter();
                
                $card = $cards->merge($staffSessions);
                $check_staff = 2;
            }
        
        }
        

        // Initialize the response array
        $cards = [];

        // Check if there are results in the query
        if ($card->count()) {
            foreach ($card as $item) {
                $service = Service::find($item->service_id);

                $check = StaffCard::where('card_id', $item->id)->with(['user', 'card']);

                $matchedSession = $item->sessionPackages->first(function ($session) use ($date) {
                    if (empty($date)) {
                        return true; 
                    }

                    // Check if the date is 'upcoming'
                    if ($date === 'upcoming') {
                        return Carbon::parse($session->date)->gte(Carbon::tomorrow());
                    }
                
                    // For specific date matching
                    return $session->date == $date;
                });
                
                $data['matched_session_id'] = $matchedSession ? (string) $matchedSession->id : null;
                
                if ($check->exists()) {
                    $data['added_staff'] = $check->get()->map(function ($staffCard) {

                        return [
                            'status' => $staffCard->card->status ?? null,
                            'id' => (string) $staffCard->staff->id ?? null,
                            'user_id' => (string) $staffCard->staff->user_id ?? null,
                            'first_name' => $staffCard->staff->first_name ?? null,
                            'last_name' => $staffCard->staff->last_name ?? null,
                            'phone' => $staffCard->staff->phone ?? null,
                            'dial_code' => $staffCard->staff->dial_code ?? null,
                        ];
                    })->toArray();
                    $data['payment_type'] = $item->payment_type;
                } else {
                    $data['added_staff'] = [];
                    $data['payment_type'] = $item->payment_type;
                }

                $user = User::find($item->user_id);
                $category = Category::find($item->category_id);

                if(isset($item->session_id)){
                    $data['session_id']     = (string) $item->session_id;
                }

                $data['booking_id']     = (string) $item->id;
                $data['tran_id']        = (string) normalizeId($item->tran_id);
                $data['user_id']        = (string) $item->user_id;
                $data['user_name']      = $user ? $user->name : '';
                $data['user_email']     = $user ? $user->email : '';
                $data['user_mobile']    = $user ? $user->phone : '';
                //$data['user_mobile']    = '000000000';
                $data['user_dial_code']    = $user ? $user->dial_code : '971';
                
                $data['service_id']     = (string) $item->service_id;
                $data['service']        = $service->name;
                $data['image']          = asset('/uploads/service/' . $service->thumbnail_img);
                $data['category_id']    = (string) $item->category_id;
                $data['category']       = $category ? $category->name : '';
                $data['slot_id']        = $item->slot_id;
                $data['slot']           = $item->slot ? $item->slot->name : '';
                $data['offline_charge'] = $item->offline_charge;
                $data['offline_discount'] = $item->offline_discount;
                // if (!is_null($item->date) && Carbon::parse($item->date)->isPast()) {
                //     $data['status'] = 'Expired';
                // } else {
                //     $data['status'] = $item->status;
                // }          
                $data['status'] = $item->status;      
                // Address Logic
                if (is_numeric($item->address_id)) {
                    $data['address_id'] = $item->address_id;
                    $building = $item->address ? $item->address->building : '';
                    $flat_no = $item->address ? $item->address->flat_no : '';
                    $address = $item->address ? $item->address->address : '';
                    $data['address'] = $building . ', ' . $flat_no . ', ' . $address;
                    $data['city'] = $item->address && $item->address->city ? $item->address->city->name : '';
                    $data['locality'] = $item->address && $item->address->locality_info ? $item->address->locality_info->name : '';
                    $data['latitude'] = $item->address ? $item->address->latitude : '';
                    $data['longitude'] = $item->address ? $item->address->longitude : '';
                } else {
                    // For custom address in JSON
                    $add_info = json_decode($item->address_id);
                    $data['address_id'] = '';
                    $building = $add_info ? $add_info->building : '';
                    $flat_no = $add_info ? $add_info->flat_no : '';
                    $address = $add_info ? $add_info->address : '';
                    $data['address'] = $building . ', ' . $flat_no . ', ' . $address;
                    $data['city'] = $add_info && isset($add_info->city_name) ? $add_info->city_name : '';
                    $data['locality'] = $add_info && $add_info->locality ? $add_info->locality : '';
                    $data['latitude'] = $add_info ? $add_info->latitude : '';
                    $data['longitude'] = $add_info ? $add_info->longitude : '';
                }

                $data['payment_moad']   = $item->payment_moad;
                $data['payment_status'] = $item->payment_status;
                $data['note']           = $item->note;
                $data['material_charge']= (string) $item->material_charge;
                $data['material_status']= $item->material_status;
                $data['service_type']   = $item->service_type;
                $data['alternative_dial_code']  = $item->alternative_dial_code;
                $data['alternative_number'] = $item->alternative_number;
                //$data['alternative_number'] = "0000000000";
                $data['date']           = $item->date;
                $data['tip']            = (string) $item->tip_id;
                $data['coupon_id']      = $item->coupon_id;
                $data['is_checkout']    = $item->is_checkout;

                // Card Attributes and Add-ons
                $card_attr = [];
                $c = 0;
                $material_total = 0;
                $material = 0;
                $total_count = 1;
                $totalAmount = 1;
                $surcharge = 0;
                $total_maids_material = 0;

                foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                    if(!isset($value->sub_cate_id)){
                        $is_maid = 1;
                        $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                        $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
                        $params['service_type']         = '';
                        
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name ?? "",
                            "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (int) $attribute_total; 
                        } else {
                            
                            $totalAmount += $attribute_total; 
                        }
                        
                        preg_match('/\d+/', $attribute_item->value, $matches);
                
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                            
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                
                    } else {
                        if(empty($value->child_category_id)){
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id
                            ])->first();
                        } else{
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id,
                                'child_category_id'=>$value->child_cate_id,
                            ])->first();
                        }
                        if(!empty($service_item)){
                            $services = ServiceAttributeValue::where([
                                // 'ser_attr_val_item_id'=>$service_item->id,
                                'attribute_item_id'=>$value->attribute_item_id,
                            ])->first();
                            $attribute = Attribute::where('id',$services->attribute_id)->first();
                            $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                            
                            $params['attribute_price']      = $services->attribute_price ?? null;
                            $params['attribute_qty']        = $value->attribute_qty ?? null;
                
                            $data["attribute"][] = [
                                "category"=>Category::find($service_item->category_id)->name,
                                "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                "name"=>$attribute_item->value ?? "",
                                "price"=>(string) $services->attribute_price,
                                "qty"=>(string) $value->attribute_qty];
                        
                            
                            $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                            
                            if($attribute->name == 'Hours'){
                                $totalAmount *= (float) $attribute_total; 
                            } else {
                                
                                $totalAmount += (float) $attribute_total; 
                            }
                
                            preg_match('/\d+/', $attribute_item->value, $matches);
                
                            if (count($matches) > 0) {
                                $number = (int) $matches[0];
                                $total_count *= $number;
                            
                                $total_maids_material *= $number;
                                if ($attribute->name == 'Hours') {
                                } else {
                                }
                            }
                            
                        } 
                        $params['service_type']         = '';
                    } 
                    $sub_cat = Category::find($value->sub_cate_id);
                    $child_cat = ChildCategory::find($value->child_cate_id);

                    $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                    $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                    $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                    $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                    $paramss['child_cate_id']        = (string) $value->child_cate_id;
                    $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                    $paramss['attribute_id']         = (string) $value->attribute_id;
                    $paramss['attribute_name']       = $value->attribute_name;
                    $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                    $paramss['attribute_item_name']  = $value->attribute_item_name;
                    $paramss['attribute_qty']        = (string) $value->attribute_qty;
                    $paramss['attribute_price']      = (string) $value->attribute_price;
                    $paramss['service_type']         = $value->service_type;
                    $paramss['unit_price']         = $value->unit_price??0;
                    array_push($card_attr,$paramss);
                }

                if($item->service_id == 10){  
                    if ($item->sessionPackages->isNotEmpty()) {
                        $data["sessions"] = $item->sessionPackages
                            ->sortBy('date')
                            ->map(function ($session) {
                                // Fetch staff details with the status from staff_sessions
                                $addedStaff = \DB::table('staff_sessions')
                                ->join('staff', 'staff.id', '=', 'staff_sessions.user_id')
                                ->where('staff_sessions.session_id', $session->id)
                                ->select(
                                    'staff.id',
                                    'staff.user_id',
                                    'staff.first_name',
                                    'staff.last_name',
                                    'staff.phone',
                                    'staff.dial_code',
                                    'staff_sessions.status as staff_session_status'
                                )
                                ->get();
                                
                                return [
                                    'id' => $session->id,
                                    'cart_id' => $session->cart_id,
                                    'package_id' => $session->package_id,
                                    'slot' => $session->slot,
                                    'service_id' => $session->service_id,
                                    'date' => $session->date,
                                    'time' => $session->time,
                                    'status' => $session->status,
                                    'added_staff' => $addedStaff,
                                ];
                            })
                            ->values() 
                            ->toArray(); 
                            
                            // Check if all sessions have past date and time
                            // $allSessionsExpired = collect($data["sessions"])->every(function ($session) {
                            //     if (!is_null($session['date'])) {
                            //         $sessionDate = Carbon::parse($session['date']);
                            //         if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                            //             // If the date is in the past and not today, the session is expired
                            //             return true;
                            //         } elseif ($sessionDate->isToday() && isset($session['slot']['check_in'])) {
                            //             // If the date is today, check the session time
                            //             return Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $session['slot']['check_in']));
                            //         }
                            //     }
                            //     return false; // If any session is not expired
                            // });

                            // // Update the main status if all sessions are expired
                            // if ($allSessionsExpired) {
                            //     $data['status'] = 'Expired';
                            // } else {
                            //     $data['status'] = $item->status;
                            // }
                    } else {
                        $data["sessions"] = [];
                    }
                    
                    if(isset($item->selected_packages) ){
                        $totalAmount = 0;            
                        $selectedPackageIds = explode(',', $item->selected_packages);
        
                        $packages = Packages::whereIn('id', $selectedPackageIds)->get();
        
                        foreach ($packages as $package) {
                            
                            $data['is_package'] = "1";
                            $data["packages"][] = [
                                "name"=>$package->name, 
                                "base_amount"=>(string) $package->amount,
                                "price"=>(string) ((int) $package->amount * (int) $total_count),
                                "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                            ]; 
                            
                            $totalAmount = ((int) $package->amount * (int) $total_count) -(float)$value->coupon_amt; 
                            $material *= ((int) $package->total_sessions + (int) $package->free_sessions);
                
                        }
                    } else {
                    
                        $data['is_package'] = "0";
                        $data['packages'] = [];
                    }

                    $sessions = SessionPackages::with('package')->where('cart_id', $value->id)->get();
                    $free_sessions = 0;
                    $per_week = 0;
                    $total_sessions = 0;
                    // Loop through sessions to access related package data
                    foreach ($sessions as $session) {
                        if ($session->package) { 
                            $total_sessions = $session->package->total_sessions;
                            $free_sessions = $session->package->free_sessions;
                            $per_week = $session->package->per_week;
                        }
                    }
                    $data['session_history'] = (object) [
                        'total_sessions' => $total_sessions,
                        'free_sessions' => $free_sessions,
                        'per_week' => $per_week,
                    ];
                } else {
                    
                    $data['is_package'] = "0";
                    $data['packages'] = [];
                }

                $data['coupon']         = $item->coupon ? $item->coupon->code : '';
                $data['coupon_amt']     = $item->coupon_amt;
                $data['subtotal']       = $item->g_total;
                $order = Order::find($item->order_id); 

                $cod = (int) $item->cod;
    
                $surcharge = (float) $item->surcharge;

                if($item->payment_type == 2){
                    $data['total'] = (string)
                        ((float) ($item->amount + $surcharge + $cod ?? 0) - 
                        (float) ($item->coupon_amt ?? 0) + 
                        (float) ($item->tip_id ?? 0));

                }else{
                        
                    $data['total'] = (string)
                    ((float) ($item->amount + $surcharge ?? 0) - 
                    (float) ($item->coupon_amt ?? 0) + 
                    (float) ($item->tip_id ?? 0));
                }

                $data['total'] = (string) $item->g_total;
                $data['card_attribute'] = $card_attr;
                $isMuted = BellBookingUser::where(['user_id' => auth()->user()->id, 'booking_id' => $item->id])->value('is_bell');
                $data['is_bell'] = $isMuted ? (string) $isMuted : "0";

                $cards[] = $data;
                
                $data['packages'] = [];
            }

            // Return response with pagination info
            return $this->sendResponse($cards, 'Active Bookings');
        } else {
            return $this->sendResponse([], 'No data found.');
        }
    }

    public function confirm_details(Request $request)
    {
        if($request->cart_id){

            $data = [];
            $totalAmount = 0;
            $cart = Card::with('sessionPackages.slot')->find($request->cart_id);
            if (!$cart) {
                return $this->sendError('Cart Not Exist!');
            }

            $service = Service::find($cart->service_id);
            $material_default = ($cart->material_status == "Apply") ? (float) $service->material_price : 0;
            $material_total = 0;
            $card_attr = [];
            $material = 0;
            $is_maid = 0;
            $total_maids_material = 1;
            $total_count = 1;
            $cod = 0;
            $surcharge = (float) Service::find($cart->service_id)->cod_charge;
            $cod = (int) HomeSetting::first()->cash_surcharge;
            
            if (CardAttribute::where('card_id', $cart->id)->exists()) {
                $data["service_name"] = $service->name;
                $c = 0;
                foreach (CardAttribute::where('card_id', $cart->id)->get() as $value) {
                    if(!isset($value->sub_cate_id)){
                        $is_maid = 1;
                        $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                        $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
                        $params['service_type']         = '';
                        
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name ?? "",
                            "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $value->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (int) $attribute_total; 
                        } else {
                            
                            $totalAmount += $attribute_total; 
                        }
                        
                        preg_match('/\d+/', $attribute_item->value, $matches);
                
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                            
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                
                    } else {
                        if(empty($value->child_category_id)){
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$cart->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id
                            ])->first();
                        } else{
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$cart->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id,
                                'child_category_id'=>$value->child_cate_id,
                            ])->first();
                        }
                        if(!empty($service_item)){
                            $services = ServiceAttributeValue::where([
                                // 'ser_attr_val_item_id'=>$service_item->id,
                                'attribute_item_id'=>$value->attribute_item_id,
                            ])->first();
                            $attribute = Attribute::where('id',$services->attribute_id)->first();
                            $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                            
                            $params['attribute_price']      = $services->attribute_price ?? null;
                            $params['attribute_qty']        = $value->attribute_qty ?? null;
                
                            $data["attribute"][] = [
                                "category"=>Category::find($service_item->category_id)->name,
                                "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                "name"=>$attribute_item->value ?? "",
                                "price"=>(string) $value->attribute_price,
                                "qty"=>(string) $value->attribute_qty];
                        
                            
                            $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                            
                            if($attribute->name == 'Hours'){
                                $totalAmount *= (float) $attribute_total; 
                            } else {
                                
                                $totalAmount += (float) $attribute_total; 
                            }
                
                            preg_match('/\d+/', $attribute_item->value, $matches);
                
                            if (count($matches) > 0) {
                                $number = (int) $matches[0];
                                $total_count *= $number;
                            
                                $total_maids_material *= $number;
                                if ($attribute->name == 'Hours') {
                                } else {
                                }
                            }
                            
                        } 
                        $params['service_type']         = '';
                    } 
                    $sub_cat = Category::find($value->sub_cate_id);
                    $child_cat = ChildCategory::find($value->child_cate_id);
    
                    $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                    $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                    $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                    $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                    $paramss['child_cate_id']        = (string) $value->child_cate_id;
                    $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                    $paramss['attribute_id']         = (string) $value->attribute_id;
                    $paramss['attribute_name']       = $value->attribute_name;
                    $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                    $paramss['attribute_item_name']  = $value->attribute_item_name;
                    $paramss['attribute_qty']        = (string) $value->attribute_qty;
                    $paramss['attribute_price']      = (string) $value->attribute_price;
                    $paramss['service_type']         = $value->service_type;
                    $paramss['unit_price']         = $value->unit_price??0;
                    array_push($card_attr,$paramss);
                }
    
                $card_data['card_attribute'] = $card_attr;

            }
            if($service->id == 10){
                $material_total = $total_maids_material;
            } else {
                $material_total = $material_total;
            }
            $material = ($cart->material_status == "Apply") ? (float) $material_total : "0";
           
            $totalAmount = ((float)$cart->amount);
            if($service->id == 10){
                if($cart->sessionPackages){ 
                    $data["sessions"] = $cart->sessionPackages
                    ->sortBy('date')
                    ->map(function ($session) {
                        return [
                            'id' => (string)$session->id,
                            'cart_id' => $session->cart_id,
                            'package_id' => $session->package_id,
                            'slot' => $session->slot,
                            'service_id' => $session->service_id,
                            'date' => $session->date,
                            'time' => $session->time,
                            'status' => $session->status,
                        ];
                    })
                    ->values() 
                    ->toArray(); 
                }else{
                    $data["session_packages"] = []; 
                }
                if(isset($cart->selected_packages)){                
                    $selectedPackageIds = explode(',', $cart->selected_packages);
                    $packages = Packages::whereIn('id', $selectedPackageIds)->get();

                    if ($packages->isNotEmpty()) {
                        $data["packages"] = [];
                    
                        foreach ($packages as $package) {
                            $data["packages"][] = [
                                "name" => $package->name,
                                "base_amount" => (string) $package->amount,
                                "price" => (string) ((int) $package->amount * (int) $total_count),
                                "save_amount" => (string) ((int) $package->save_amount * (int) $total_count),
                            ];
                            $totalAmount = ((int) $package->amount * (int) $total_count); 
                            $material *= ((int) $package->total_sessions) ;
                        }
                    } else {
                        $data["packages"] = [];
                        $data['is_package'] = "0";
                        $data['total_session_count'] = "0";
                    }
                    
                } else {
                    $data["packages"] = [];
                }
            } else{
                
                $data["packages"] = [];
            }
            
            $material *= $material_default;
            $data['material_charge'] = $material;
            $data["material"] = (string) $material;

            $data["material_status"] = (string) $cart->material_status;
            if($cart->service_id != 10){
                if (empty($cart->slot_id)) {
                    return $this->sendError('Time is missing!');
                }
                if (empty($cart->date)) {
                    return $this->sendError('Date is missing!');
                }
            }
            $data["date"] = $cart->date ?? "";
            $data['preffered_days'] = $cart->preffered_days;
            $data["time"] = ($cart->slot_id) ? Slot::find($cart->slot_id)->name : "";
            
            if($request->payment_type == 2){
                $totalAmount += $cod;
                $data["cod_charge"] = (string) $cod;
            }
            $totalAmount += $surcharge;
            if($cart->material_status == 'Apply'){
                $totalAmount += $material;
            }
            $data["surcharge"] = (string) $surcharge;

            $cart['total'] = (string) $totalAmount;
            $cart['g_total'] = (string) $totalAmount;
            $cart["surcharge"] = (string) $surcharge;
            $data["cart"] = $cart;
            $data["total_amount"] = (string) $totalAmount;
            $data["sub_total"] = (string) $totalAmount;
            $data["user"] = auth()->user();
            $data["address"] = optional(Address::where(['user_id' => auth()->user()->id])->first())->address ?? "";
            $data["address_object"] = (object) optional(Address::where(['user_id' => auth()->user()->id])->first())->toArray() ?? [];
            if(is_numeric($cart->address_id)){
                $data["address_object"] = (object) optional(Address::where(['id' => $cart->address_id])->first())->toArray() ?? [];
            }else{
                $data["address_object"] = (object) optional(Address::where(['id' => json_decode($cart->address_id)->id])->first())->toArray() ?? [];
            }

            return $this->sendResponse($data, 'Confirm Cart Section!');
        } else {
            return $this->sendResponse([], 'Missing Fields Required!');
        }
    }

    public function get_status_booking(Request $request, $status = 1)
    {
        $statusName = '';

        // Map numeric status to the corresponding status name
        switch ($status) {
            case 1:
                $statusName = 'Pending';
                break;
            case 2:
                $statusName = 'Accept';
                break;
            case 3:
                $statusName = 'Canceled';
                break;
            case 4:
                $statusName = 'Completed';
                break;
            case 5:
                $statusName = 'Mark As Arrived';
                break;
            case 6:
                $statusName = 'In Progress';
                break;
            default:
                $statusName = 'Pending'; 
                break;
        }

        $card = Card::where('accept_user_id',auth()->user()->id)->where('status', $statusName)->orderBy('id', 'DESC')->get();
  
        $cards = [];

        foreach ($card as $key => $value) {

            $service = Service::find($value->service_id);
            $user = User::find($value->user_id);
            $category = Category::find($value->category_id);

            $data['booking_id']     = (string) $value->id;
            $data['tran_id']        = (string) normalizeId($value->tran_id);
            if(isset($value->tabby_payment_response_id)){
                $data['tran_id']    = $value->tabby_payment_response_id;
            } elseif (isset($value->paymentTranId)) {
                $data['tran_id']    = $value->paymentTranId;
            } else {
                $data['tran_id']    = '';
            }

            $data['user_id']        = $value->user_id;
            $data['user_name']      = $user?$user->name:'';
            $data['user_email']     = $user?$user->email:'';
            $data['user_mobile']    = $user?$user->phone:'';
            $data['user_dial_code']    = $user ? $user->dial_code : '971';
            $data['service_id']     = $value->service_id;
            $data['service']        = $service->name;
            $data['image']          = asset('/uploads/service/'.$service->thumbnail_img);
            $data['category_id']    = $value->category_id;
            $data['category']       = $category?$category->name:'';
            $data['slot_id']        = $value->slot_id;
            $data['slot']           = $value->slot?$value->slot->name:'';
            $data['offline_charge'] = $value->offline_charge;
            $data['offline_discount'] = $value->offline_discount;
            if(is_numeric($value->address_id)){

                $data['address_id']     = $value->address_id;

                $building = $value->address?$value->address->building:'';
                $flat_no = $value->address?$value->address->flat_no:'';
                $address = $value->address?$value->address->address:'';

                $latitude = $value->address?$value->address->latitude:'';
                $longitude = $value->address?$value->address->longitude:'';
                $data['address']        = $building.', '. $flat_no.', '.$address;

                if($value->address && $value->address->city){
                    $city = $value->address->city->name;
                } else {
                    $city = "";
                }

                $data['city']           = $city;

                if($value->address && $value->address->locality_info){
                    $locality = $value->address->locality_info->name;
                } else {
                    $locality = "";
                }
                $data['locality']       = $locality;
                
                $data['latitude']       = $latitude;
                $data['longitude']      = $longitude;

            } else {

                $add_info = json_decode($value->address_id);

                $data['address_id']     = '';


                $building = $add_info?$add_info->building:'';
                $flat_no = $add_info?$add_info->flat_no:'';
                $address = $add_info?$add_info->address:'';

                $latitude = $add_info?$add_info->latitude:'';
                $longitude = $add_info?$add_info->longitude:'';
                $data['address']        = $building.', '. $flat_no.', '.$address;

                if($add_info && $add_info->city_name){
                    $city = $add_info->city_name;
                } else {
                    $city = "";
                }

                $data['city']           = $city;

                if($add_info && $add_info->locality){
                    $locality = $add_info->locality;
                } else {
                    $locality = "";
                }
                $data['locality']       = $locality;
                
                $data['latitude']       = $latitude;
                $data['longitude']      = $longitude;

            }
            $data['payment_moad']   = $value->payment_moad;
            $data['payment_status'] = $value->payment_status;
            $data['note']           = $value->note;
            $data['material_charge']= $value->material_charge;
            $data['material_status']= $value->material_status;
            $data['service_type']   = $value->service_type;
            $data['alternative_dial_code']  = $value->alternative_dial_code;
            $data['alternative_number'] = $value->alternative_number;
            $data['date']           = $value->date;
            $data['tip']            = $value->tip_id;
            $data['coupon_id']      = $value->coupon_id;
            $data['is_checkout']    = $value->is_checkout;
            $data['status']         = $value->status;
            $data['pending_approval_by_admin']         = $value->pending_approval_by_admin;
            
            $card_attr = [];
            $sub_total = '00';
            $subtotal = '00';
            $total = '00';
            foreach (CardAttribute::where('card_id',$value->id)->get() as $key => $item) {

                $sub_cat = Category::find($value->sub_cate_id);
                $child_cat = ChildCategory::find($value->child_cate_id);

                $params['sub_cate_id']          = $item->sub_cate_id;
                $params['sub_cate_name']        = $sub_cat?$sub_cat->name:'';
                $params['main_sub_cat_id']      = $item->main_sub_cat_id;
                $params['main_sub_cat_name']    = $item->main_sub_cat?$item->main_sub_cat->name:'';
                $params['child_cate_id']        = $item->child_cate_id;
                $params['child_cate']           = $item->child_cate?$item->child_cate->name:'';
                $params['attribute_id']         = $item->attribute_id;
                $params['attribute_name']       = $item->attribute_name;
                $params['attribute_item_id']    = $item->attribute_item_id;
                $params['attribute_item_name']  = $item->attribute_item_name;
                $params['attribute_qty']        = $item->attribute_qty;
                $params['attribute_price']      = $item->attribute_price;
                $params['service_type']         = $item->service_type;
                $addons = [];

                foreach (CardAddon::where('card_id',$value->id)->where('card_attribute_id',$item->id)->get() as $key => $cardaddon) {
                    $addon['card_id']               = $cardaddon->id;
                    $addon['card_attribute_id']     = $cardaddon->id;
                    $addon['add_on_id']             = $cardaddon->add_on_id;
                    $addon['name']                  = $cardaddon->name;
                    $addon['value']                 = $cardaddon->value;
                    $addon['percentage']            = $cardaddon->percentage;
                    array_push($addons,$addon);
                }
                $params['addon']      = $addons;
                array_push($card_attr,$params);
            }

            $data['coupon']         = $value->coupon?$value->coupon->code:'';
            $data['coupon_amt']     = $value->coupon_amt;
            $data['total']       = $value->amount;
            $data['subtotal']          = $value->g_total;
            $data['card_attribute'] = $card_attr;
           
            array_push($cards, $data);
        }
        return $this->sendResponse($cards, 'Bookings');
    }

    public function get_completed_booking(Request $request)
    {
       
        $limit = $request->get('limit', 10);
        $page = $request->get('page', 1); 
        $date = $request->date; 
        $user = User::find(auth()->user()->id);
        if($user->wallet_balance < 0 || $user->wallet_balance == '0'){
            $wallet = '0';
        } else {
            $wallet = $user->wallet_balance;
        }
        $sellerId = Seller::where('user_id', $user->id)->value('id'); // Get seller ID directly
        $serviceIds = SellerService::where('seller_id', $sellerId)->pluck('service_id')->toArray();
        if(!empty($date)){

            if(auth()->user()->role == 'vendor'){
                $card = Card::with(['sessionPackages.slot'])
                //->whereIn('service_id', $serviceIds)
                ->where('accept_user_id', auth()->user()->id)
                ->where(function ($query) use ($date) {
                    if ($date === 'upcoming') {
                        $query->where(function ($subQuery) {
                            $subQuery->where('service_id', '!=', 10)
                                ->where('date', '>', Carbon::tomorrow());
                        })
                        ->orWhere(function ($subQuery) {
                            $subQuery->where('service_id', 10)
                                ->whereHas('sessionPackages', function ($innerQuery) {
                                    $innerQuery->whereIn('status', ['Completed'])->where('date', '>', Carbon::tomorrow());
                                });
                        });
                    } else if(!empty($date)) {
                        $query->where(function ($subQuery) use ($date) {
                            $subQuery->whereIn('status', ['Completed'])->where('service_id', '!=', 10)
                                ->where('date', $date);
                        })
                        ->orWhere(function ($subQuery) use ($date) {
                            $subQuery->where('service_id', 10)
                            ->whereIn('status', ['Completed'])
                            ->whereHas('sessionPackages', function ($innerQuery) use ($date) {
                                $innerQuery->whereIn('status', ['Completed'])
                                ->where('date', $date);
                            });
                        });
                    } else {
                        // For services other than service_id = 10
                        $query->where(function ($subQuery) {
                            $subQuery
                                ->where('service_id', '!=', 10)
                                ->whereIn('status', ['Completed'])
                                ->where(function ($innerQuery) {
                                    $innerQuery->where('date', '>', Carbon::today()) // Allow only future dates
                                        ->orWhere(function ($dateQuery) {
                                            $dateQuery
                                ->whereIn('status', ['Completed'])->where('date', '=', Carbon::today()) // Allow today's cards with future times
                                    ->whereHas('slot', function ($timeQuery) {
                                        $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                    });
                                });
                            });
                        })
                        ->orWhere(function ($query) {
                            // For service_id = 10, use sessionPackages for date and slot
                            $query->where('service_id', 10)
                            ->whereIn('status', ['Completed'])
                                ->whereHas('sessionPackages', function ($subQuery) {
                                    $subQuery
                                ->whereIn('status', ['Completed'])
                                    ->where(DB::raw('DATE(date)'), '>', Carbon::today()->toDateString()) // Allow future dates only
                                        ->orWhere(function ($dateQuery) {
                                            $dateQuery
                                ->whereIn('status', ['Completed'])
                                            ->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Allow today's sessions
                                                ->whereHas('slot', function ($timeQuery) {
                                                    $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                                                });
                                        });
                                });
                        });
                        
                    }
                })
                ->where('is_checkout', 'Done')
                ->whereDoesntHave('vendorCardStatuses', function ($query) {
                    $query->where('vendor_id', auth()->id())
                        ->where('status', 'Cancelled');
                })
                ->orderBy('id', 'DESC')
                ->paginate($limit, ['*'], 'page', $page);
                $check_staff = 1;
            } else {
                
                $staff = auth()->user()->staff; 
                $staffId = $staff ? $staff->id : null;
                $cards = collect();

                // Query for StaffCard
                $staffCards = StaffCard::where('user_id', $staffId)
                    ->where('status' ,'=', 'Completed')
                    ->with(['card', 'sessionPackages.slot'])
                    ->orderBy('id', 'DESC')
                    ->get()
                    ->map(function ($staffCard) use ($date) {
                        $result = [];

                        if ($staffCard->sessionPackages && $staffCard->sessionPackages->isNotEmpty()) {
                            foreach ($staffCard->sessionPackages as $sessionPackage) {
                                if ($this->filterByDate($sessionPackage, $date)) {
                                    $card = $staffCard->card->replicate();
                                    $card->status = $sessionPackage->status;
                                    $card->session_id = $sessionPackage->id;
                                    $card->date = $sessionPackage->date;
                                    $card->id = $sessionPackage->cart_id;
                                    $result[] = $card;
                                }
                            }
                        }

                        if ($staffCard->card && empty($result)) {
                            $card = $staffCard->card;
                            if ($this->filterByDate($card, $date)) {
                                $card->status = $staffCard->status;
                                $result[] = $card;
                            }
                        }

                        return $result;
                    })
                    ->flatten(1)
                    ->filter();

                $staffSessions = StaffSession::where('user_id', $staffId)
                ->where('status' ,'=', 'Completed')
                    ->with(['card', 'slot', 'sessionPackage'])
                    ->orderBy('id', 'DESC')
                    ->get()
                    ->map(function ($staffSession) use ($date) {
                        $result = [];

                        if ($staffSession->card && $staffSession->sessionPackage) {
                            $sessionPackage = $staffSession->sessionPackage;
                            if ($this->filterByDate($sessionPackage, $date)) {
                                $card = $staffSession->card->replicate();
                                $card->status = $sessionPackage->status;
                                $card->session_id = $sessionPackage->id;
                                $card->date = $sessionPackage->date;
                                $card->id = $sessionPackage->cart_id;
                                if (!in_array($sessionPackage->status, ['Completed', 'Cancelled'])) {
                                    $result[] = $card;
                                }
                            }
                        }

                        if ($staffSession->card && empty($result)) {
                            $card = $staffSession->card;
                            if ($this->filterByDate($card, $date)) {
                                $card->status = $staffSession->status;
                                $result[] = $card;
                            }
                        }

                        return $result;
                    })
                    ->flatten(1)
                    ->filter();

                $card = $cards->merge($staffCards)->merge($staffSessions);
                $check_staff = 2;
            }
        } else{
            
            if(auth()->user()->role == 'vendor'){
                $card = Card::with('slot')
                //->whereIn('service_id', $serviceIds)
                ->where('is_checkout', 'Done')
                ->where('accept_user_id', auth()->user()->id)
                ->whereDoesntHave('vendorCardStatuses', function ($query) {
                    $query->where('vendor_id', auth()->id())
                        ->where('status', 'Cancelled');
                })
                ->where(function ($query) {
                    $query->whereIn('status', ['Completed']);
                    // For services other than service_id = 10
                    // $query->where(function ($subQuery) {
                    //     $subQuery
                    //         ->where('service_id', '!=', 10)
                    //         ->whereIn('status', ['Completed']);
                    // })
                    // ->orWhere(function ($query) {
                    //     // For service_id = 10, use sessionPackages for date and slot
                    //     $query->where('service_id', 10)
                    //     ->whereIn('status', ['Completed'])
                    //         ->whereHas('sessionPackages', function ($subQuery) {
                    //             $subQuery
                    //             ->whereIn('status', ['Completed']);
                    //         });
                    // });
                })
                ->orderBy('id', 'DESC')
                ->paginate($limit, ['*'], 'page', $page);
                $check_staff = 1;
            } else {
                        
                $staff = auth()->user()->staff; 
                $staffId = $staff ? $staff->id : null;
                $cards = collect(); // Initialize a collection to hold the combined results

                // Query for StaffCard
                $staffCards = StaffCard::where('user_id', $staffId)
                ->whereIn('status', ['Completed'])
                ->with(['card', 'sessionPackages.slot'])
                ->orderBy('id', 'DESC')
                ->get()
                ->map(function ($staffCard) {
                    $result = collect();
                    if ($staffCard->sessionPackages && $staffCard->sessionPackages->isNotEmpty()) {
                        foreach ($staffCard->sessionPackages as $sessionPackage) {
                            $card = $staffCard->card->replicate();
                            $card->status = $sessionPackage->status;
                            $card->session_id = $sessionPackage->id;
                            $card->date = $sessionPackage->date;
                            $card->id = $sessionPackage->cart_id;
                            $result->push($card);
                        }
                    }

                    if ($staffCard->card && $result->isEmpty()) {
                        $card = $staffCard->card;
                        $card->status = $staffCard->status;
                        $result->push($card);
                    }

                    return $result;
                })
                ->flatten(1)
                ->filter();

                // Merge into the main cards collection
                $cards = $cards->merge($staffCards);

                // Query for StaffSession
                $staffSessions = StaffSession::where('user_id', $staffId)
                ->whereIn('status', ['Completed'])
                ->with(['card', 'slot', 'sessionPackage'])
                ->orderBy('id', 'DESC')
                ->get()
                ->map(function ($staffSession) {
                    $result = collect();

                    if ($staffSession->card && $staffSession->sessionPackage) {
                        $sessionPackage = $staffSession->sessionPackage;
                        if ($sessionPackage->status == 'Completed') { // Ensure Completed status is checked before adding
                            $card = $staffSession->card->replicate();
                            $card->status = $sessionPackage->status;
                            $card->session_id = $sessionPackage->id;
                            $card->date = $sessionPackage->date;
                            $card->id = $sessionPackage->cart_id;
                            $result->push($card);
                        }
                    }

                    if ($staffSession->card && $result->isEmpty()) {
                        $card = $staffSession->card;
                        $card->status = $staffSession->status;
                        if ($card->status == 'Completed') { // Ensure we only include completed sessions
                            $result->push($card);
                        }
                    }

                    return $result;
                })
                ->flatten(1)
                ->filter();

                // Merge the processed staffSessions into the main cards collection
                $cards = $cards->merge($staffSessions);

                // Apply Pagination
                $total = $cards->count();
                $cards = $cards->slice(($page - 1) * $limit, $limit)->values(); // Slice the collection for pagination
                $card = new LengthAwarePaginator($cards, $total, $limit, $page, [
                'path' => request()->url(),
                'query' => request()->query()
                ]);


                $check_staff = 2;
            }

        }

        $cards = [];

        $surcharge = 0;
        foreach ($card as $key => $item) {

            $service = Service::find($item->service_id);

            $check = StaffCard::where('card_id', $item->id)->with(['user', 'card']);

            if ($check->exists()) {
                $data['added_staff'] = $check->get()->map(function ($staffCard) {
                    
                    return [
                        'status' => $staffCard->card->status ?? null,
                        'id' => (string) $staffCard->staff->id ?? null,
                        'user_id' => (string) $staffCard->staff->user_id ?? null,
                        'first_name' => $staffCard->staff->first_name ?? null,
                        'last_name' => $staffCard->staff->last_name ?? null,
                        'phone' => $staffCard->staff->phone ?? null,
                        'dial_code' => $staffCard->staff->dial_code ?? null,
                    ];
                })->toArray();
                $data['payment_type'] = $item->payment_type;
            } else {
                $data['added_staff'] = [];
                $data['payment_type'] = $item->payment_type;
            }

            
            $matchedSession = $item->sessionPackages->first(function ($session) {
                return Carbon::parse($session->date)->gte(Carbon::today());
            });
            
            $data['matched_session_id'] = $matchedSession ? (string) $matchedSession->id : null;

            $user = User::find($item->user_id);
            $category = Category::find($item->category_id);
            if(isset($item->session_id)){
                $data['session_id']     = (string) $item->session_id;
            }
            $data['booking_id']     = (string) $item->id;
            $data['tran_id']     = (string) normalizeId($item->tran_id);

            $data['user_id']        = (string) $item->user_id;
            $data['user_name']      = $user?$user->name:'';
            $data['user_email']     = $user?$user->email:'';
            $data['user_mobile']    = $user?$user->phone:'';
            //$data['user_mobile']    = '000000000';
            $data['user_dial_code']    = $user ? $user->dial_code : '971';
            $data['service_id']     = (string)$item->service_id;
            $data['service']        = $service->name;
            $data['image']          = asset('/uploads/service/'.$service->thumbnail_img);
            $data['category_id']    = $item->category_id;
            $data['category']       = $category?$category->name:'';
            $data['slot_id']        = $item->slot_id;
            $data['slot']           = $item->slot?$item->slot->name:'';
            $data['offline_charge'] = $item->offline_charge;
            $data['offline_discount'] = $item->offline_discount;
            if(is_numeric($item->address_id)){

                $data['address_id']     = $item->address_id;

                $building = $item->address?$item->address->building:'';
                $flat_no = $item->address?$item->address->flat_no:'';
                $address = $item->address?$item->address->address:'';

                $latitude = $item->address?$item->address->latitude:'';
                $longitude = $item->address?$item->address->longitude:'';
                $data['address']        = $building.', '. $flat_no.', '.$address;

                if($item->address && $item->address->city){
                    $city = $item->address->city->name;
                } else {
                    $city = "";
                }

                $data['city']           = $city;

                if($item->address && $item->address->locality_info){
                    $locality = $item->address->locality_info->name;
                } else {
                    $locality = "";
                }
                $data['locality']       = $locality;
                
                $data['latitude']       = $latitude;
                $data['longitude']      = $longitude;

            } else {

                $add_info = json_decode($item->address_id);

                $data['address_id']     = '';


                $building = $add_info?$add_info->building:'';
                $flat_no = $add_info?$add_info->flat_no:'';
                $address = $add_info?$add_info->address:'';

                $latitude = $add_info?$add_info->latitude:'';
                $longitude = $add_info?$add_info->longitude:'';
                $data['address']        = $building.', '. $flat_no.', '.$address;

                if($add_info && isset($add_info->city->name)){
                    $city = $add_info->city->name;
                } else {
                    $city = "";
                }

                $data['city']           = $city;

                if($add_info && isset($add_info->locality_info->name) && $add_info->locality_info->name){
                    $locality = $add_info->locality_info->name;
                } else {
                    $locality = "";
                }
                $data['locality']       = $locality;
                
                $data['latitude']       = $latitude;
                $data['longitude']      = $longitude;

            }
            $data['payment_moad']   = $item->payment_moad;
            $data['payment_status'] = $item->payment_status;
            $data['note']           = $item->note;
            $data['material_charge']= $item->material_charge;
            $data['material_status']= $item->material_status;
            $data['service_type']   = $item->service_type;
            $data['alternative_dial_code']  = $item->alternative_dial_code;
            $data['alternative_number'] = $item->alternative_number;
            //$data['alternative_number'] = "0000000000";
            $data['date']           = $item->date;
            $data['tip']            = (string)$item->tip_id;
            $data['coupon_id']      = $item->coupon_id;
            $data['is_checkout']    = $item->is_checkout;
            $data['status']         = $item->status;
            $data['pending_approval_by_admin']         = $item->pending_approval_by_admin;
            
            $card_attr = [];
            $material_default = ($request->material_status == "Apply") ? (float) $service->material_price : 0;
            $c = 0;
            $material_total = 0;
            $total_count = 1;
            $material = 0;
            $totalAmount = 0;
            $total_maids_material = 0;
            foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                if(!isset($value->sub_cate_id)){
                    $is_maid = 1;
                    $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                    $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                    $attribute = Attribute::where('id',$services->attribute_id)->first();
                    $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                    
                    $params['attribute_price']      = $services->attribute_price ?? null;
                    $params['attribute_qty']        = $value->attribute_qty ?? null;
                    $params['service_type']         = '';
                    
                    $data["attribute"][] = [
                        "category"=>Category::find($service_item->category_id)->name ?? "",
                        "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                        "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                        "name"=>$attribute_item->value ?? "",
                        "price"=>(string) $services->attribute_price,
                        "qty"=>(string) $value->attribute_qty];
                    $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                    
                    if($attribute->name == 'Hours'){
                        $totalAmount *= (int) $attribute_total; 
                    } else {
                        
                        $totalAmount += $attribute_total; 
                    }
                    
                    preg_match('/\d+/', $attribute_item->value, $matches);
            
                    if (count($matches) > 0) {
                        $number = (int) $matches[0];
                        $total_count *= $number;
                        
                        $total_maids_material *= $number;
                        if ($attribute->name == 'Hours') {
                        } else {
                        }
                    }
            
                } else {
                    if(empty($value->child_category_id)){
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$item->service_id,
                            'category_id'=>$value->main_sub_cat_id,
                            'sub_category_id'=>$value->sub_cate_id
                        ])->first();
                    } else{
                        $service_item = ServiceAttributeValueItem::where([
                            'service_id'=>$item->service_id,
                            'category_id'=>$value->main_sub_cat_id,
                            'sub_category_id'=>$value->sub_cate_id,
                            'child_category_id'=>$value->child_cate_id,
                        ])->first();
                    }
                    if(!empty($service_item)){
                        $services = ServiceAttributeValue::where([
                            // 'ser_attr_val_item_id'=>$service_item->id,
                            'attribute_item_id'=>$value->attribute_item_id,
                        ])->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
            
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name,
                            "sub_category"=>Category::find($service_item->sub_category_id)->name,
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                    
                        
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (float) $attribute_total; 
                        } else {
                            
                            $totalAmount += (float) $attribute_total; 
                        }
            
                        preg_match('/\d+/', $attribute_item->value, $matches);
            
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                        
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                        
                    } 
                    $params['service_type']         = '';
                } 
                $sub_cat = Category::find($value->sub_cate_id);
                $child_cat = ChildCategory::find($value->child_cate_id);
            
                $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                $paramss['child_cate_id']        = (string) $value->child_cate_id;
                $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                $paramss['attribute_id']         = (string) $value->attribute_id;
                $paramss['attribute_name']       = $value->attribute_name;
                $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                $paramss['attribute_item_name']  = $value->attribute_item_name;
                $paramss['attribute_qty']        = (string) $value->attribute_qty;
                $paramss['attribute_price']      = (string) $value->attribute_price;
                $paramss['service_type']         = $value->service_type;
                $paramss['unit_price']         = $value->unit_price??0;
                array_push($card_attr,$paramss);
            }
            
            $data['card_attribute'] = $card_attr;
            $totalAmount = (float) $item->amount;
            
            $material = ($item->material_status == "Apply") ? (float) $item->material_charge : "0";
            
            if($item->service_id == 10){
                
                if ($item->sessionPackages->isNotEmpty()) {
                    $data["sessions"] = $item->sessionPackages
                        ->sortBy('date')
                        ->map(function ($session) {
                            // Fetch staff details with the status from staff_sessions
                            $addedStaff = \DB::table('staff_sessions')
                            ->join('staff', 'staff.id', '=', 'staff_sessions.user_id')
                            ->where('staff_sessions.session_id', $session->id)
                            ->select(
                                'staff.id',
                                'staff.user_id',
                                'staff.first_name',
                                'staff.last_name',
                                'staff.phone',
                                'staff.dial_code',
                                'staff_sessions.status as staff_session_status'
                            )
                            ->get();
                            return [
                                'id' => $session->id,
                                'cart_id' => $session->cart_id,
                                'package_id' => $session->package_id,
                                'slot' => $session->slot,
                                'service_id' => $session->service_id,
                                'date' => $session->date,
                                'time' => $session->time,
                                'status' => $session->status,
                                'added_staff' => $addedStaff,
                            ];
                        })
                        ->values() 
                        ->toArray(); 
                } else {
                    $data["sessions"] = [];
                }
                
                if(isset($item->selected_packages) ){    
                    $totalAmount = 0;            
                    $selectedPackageIds = explode(',', $item->selected_packages);
            
                    $packages = Packages::whereIn('id', $selectedPackageIds)->get();
            
                    foreach ($packages as $package) {
                        
                        $data['total_session_count'] = $package->total_sessions;
                        $data['is_package'] = "1";
                        $data["packages"][] = [
                            "name"=>$package->name, 
                            "base_amount"=>(string) $package->amount,
                            "price"=>(string) ((int) $package->amount * (int) $total_count),
                            "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                        ]; 
                        
                        $totalAmount = (float) $package->amount * (float) $total_count; 
                        $material *= ((int) $package->total_sessions + (int) $package->free_sessions);
                
                    }
                } else {
            
                    $data['is_package'] = "0";
                    $data['packages'] = [];
                    $data['total_session_count'] = "0";
                }
            
            } else {
            
                $data['is_package'] = "0";
                $data['packages'] = [];
            }

            $data['coupon']         = $item->coupon?$item->coupon->code:'';
            $data['coupon_amt']     = $item->coupon_amt;
            $order = Order::find($item->order_id); 

            $cod = (int) $item->cod;
    
            $surcharge = (float) $item->surcharge;

            if($item->payment_type == 2){
                $data['total'] = (string)
                    ((float) ($item->amount + $surcharge + $cod ?? 0) - 
                    (float) ($item->coupon_amt ?? 0) + 
                    (float) ($item->tip_id ?? 0));

            }else{
                    
                $data['total'] = (string)
                ((float) ($item->amount + $surcharge ?? 0) - 
                (float) ($item->coupon_amt ?? 0) + 
                (float) ($item->tip_id ?? 0));
            }

            $data['total'] = (string)$item->g_total;
            $data['subtotal']       = $item->g_total;
            $data['card_attribute'] = $card_attr;
           
            array_push($cards, $data);
            
            $data['packages'] = [];
        }
        return $this->sendResponse($cards, 'Completed Bookings');
    }

    public function get_user_bookings(Request $request)
    {
        $card = Card::where('accept_user_id',$request->vendor_id)->orderBy('id', 'DESC')->get();
  
        $cards = [];

        foreach ($card as $key => $value) {

            $service = Service::find($value->service_id);
            $user = User::find($value->user_id);
            $category = Category::find($value->category_id);

            $data['booking_id']     = (string) $value->id;
            $data['tran_id']        = (string) normalizeId($value->tran_id);

            $data['user_id']        = $value->user_id;
            $data['user_name']      = $user?$user->name:'';
            $data['user_email']     = $user?$user->email:'';
            $data['user_mobile']    = $user?$user->phone:'';
            $data['user_dial_code']    = $user ? $user->dial_code : '971';
            $data['service_id']     = $value->service_id;
            $data['service']        = $service->name;
            $data['image']          = asset('/uploads/service/'.$service->thumbnail_img);
            $data['category_id']    = $value->category_id;
            $data['category']       = $category?$category->name:'';
            $data['slot_id']        = $value->slot_id;
            $data['slot']           = $value->slot?$value->slot->name:'';
            $data['offline_charge'] = $value->offline_charge;
            $data['offline_discount'] = $value->offline_discount;
            if(is_numeric($value->address_id)){

                $data['address_id']     = $value->address_id;

                $building = $value->address?$value->address->building:'';
                $flat_no = $value->address?$value->address->flat_no:'';
                $address = $value->address?$value->address->address:'';

                $latitude = $value->address?$value->address->latitude:'';
                $longitude = $value->address?$value->address->longitude:'';
                $data['address']        = $building.', '. $flat_no.', '.$address;

                if($value->address && $value->address->city){
                    $city = $value->address->city->name;
                } else {
                    $city = "";
                }

                $data['city']           = $city;

                if($value->address && $value->address->locality_info){
                    $locality = $value->address->locality_info->name;
                } else {
                    $locality = "";
                }
                $data['locality']       = $locality;
                
                $data['latitude']       = $latitude;
                $data['longitude']      = $longitude;

            } else {

                $add_info = json_decode($value->address_id);

                $data['address_id']     = '';


                $building = $add_info?$add_info->building:'';
                $flat_no = $add_info?$add_info->flat_no:'';
                $address = $add_info?$add_info->address:'';

                $latitude = $add_info?$add_info->latitude:'';
                $longitude = $add_info?$add_info->longitude:'';
                $data['address']        = $building.', '. $flat_no.', '.$address;

                if($add_info && $add_info->city_name){
                    $city = $add_info->city_name;
                } else {
                    $city = "";
                }

                $data['city']           = $city;

                if($add_info && $add_info->locality){
                    $locality = $add_info->locality;
                } else {
                    $locality = "";
                }
                $data['locality']       = $locality;
                
                $data['latitude']       = $latitude;
                $data['longitude']      = $longitude;

            }
            $data['payment_moad']   = $value->payment_moad;
            $data['payment_status'] = $value->payment_status;
            $data['note']           = $value->note;
            $data['material_charge']= $value->material_charge;
            $data['material_status']= $value->material_status;
            $data['service_type']   = $value->service_type;
            $data['alternative_dial_code']  = $value->alternative_dial_code;
            $data['alternative_number'] = $value->alternative_number;
            $data['date']           = $value->date;
            $data['tip']            = $value->tip_id;
            $data['coupon_id']      = $value->coupon_id;
            $data['is_checkout']    = $value->is_checkout;
            $data['status']         = $value->status;
            $data['pending_approval_by_admin']         = $value->pending_approval_by_admin;
            
            $card_attr = [];
            $sub_total = '00';
            $subtotal = '00';
            $total = '00';
            foreach (CardAttribute::where('card_id',$value->id)->get() as $key => $item) {

                $sub_cat = Category::find($value->sub_cate_id);
                $child_cat = ChildCategory::find($value->child_cate_id);

                $params['sub_cate_id']          = $item->sub_cate_id;
                $params['sub_cate_name']        = $sub_cat?$sub_cat->name:'';
                $params['main_sub_cat_id']      = $item->main_sub_cat_id;
                $params['main_sub_cat_name']    = $item->main_sub_cat?$item->main_sub_cat->name:'';
                $params['child_cate_id']        = $item->child_cate_id;
                $params['child_cate']           = $item->child_cate?$item->child_cate->name:'';
                $params['attribute_id']         = $item->attribute_id;
                $params['attribute_name']       = $item->attribute_name;
                $params['attribute_item_id']    = $item->attribute_item_id;
                $params['attribute_item_name']  = $item->attribute_item_name;
                $params['attribute_qty']        = $item->attribute_qty;
                $params['attribute_price']      = $item->attribute_price;
                $params['service_type']         = $item->service_type;
                $addons = [];

                foreach (CardAddon::where('card_id',$value->id)->where('card_attribute_id',$item->id)->get() as $key => $cardaddon) {
                    $addon['card_id']               = $cardaddon->id;
                    $addon['card_attribute_id']     = $cardaddon->id;
                    $addon['add_on_id']             = $cardaddon->add_on_id;
                    $addon['name']                  = $cardaddon->name;
                    $addon['value']                 = $cardaddon->value;
                    $addon['percentage']            = $cardaddon->percentage;
                    array_push($addons,$addon);
                }
                $params['addon']      = $addons;
                array_push($card_attr,$params);
            }

            $data['coupon']         = $value->coupon?$value->coupon->code:'';
            $data['coupon_amt']     = $value->coupon_amt;
            $data['total']       = $value->amount;
            $data['subtotal']          = $value->g_total;
            $data['card_attribute'] = $card_attr;
           
            array_push($cards, $data);
        }
        return $this->sendResponse($cards, 'My Bookings');
    }

    public function delete_bookings_by_user(Request $request)
    {
        $card = Card::find($request->card_id);
        if($card) {
            $card->delete();
            return $this->sendResponse([], 'Delete item successfully!');
        }
        return $this->sendError('Item already deleted!');
    }

    public function get_bookings_by_user(Request $request)
    {
        $card = Card::with('sessionPackages.slot')
        ->where(['user_id'=>auth()->user()->id])
        ->where('is_checkout', '!=', 'Done')
        ->orderBy('id', 'DESC')
        ->get();
        
        if($card){

            $cards = [];

            
            $cards_detail = [];
            $total_amount = 0;

            $cards['coupon_status']     = (string) "no";
            $cards['tip_status']     = (string) "no";
            $coupon_amount = 0;
            if(!empty($request->coupon_code)){
                $coupon = $this->apply_coupon_calculation($request->coupon_code,$request);
                if($coupon["message"] == "Coupon Applied"){
                    $cards['coupon_status']     = (string) "yes";
                    $cards['coupon_message']     = $coupon["message"];
                    $coupon_amount              = $coupon["data"]["single_coupon_amount"];
                } else { 
                    $cards['coupon_message']     = $coupon["message"];
                }
            }

            $tip_amount = 0;
            if(!empty($request->tip_amount)){
                $tip_amount = $request->tip_amount;
                $cards['tip_status']     = (string) "yes";
            }
            $total_count = 1;
            $card_id = 0;
            $cod = 0;
            $surcharge = 0;
            foreach ($card as $key => $item) {
               
                $card_id = $item->id;
                $service = Service::find($item->service_id);
                
               
                $user = User::find($item->user_id);
                
                $category = Category::find($item->category_id);
                $totalAmount = 0;
                
                $building = $item->address ? $item->address->building : '';
                $flat_no = $item->address ? $item->address->flat_no : '';
                $address = $item->address ? $item->address->address : '';
                
                $cod = (int) HomeSetting::first()->cash_surcharge;
                $surcharge = (float) Service::find($item->service_id)->cod_charge;
                
                if(is_numeric($item->address_id)){
                    $address_id = $item->address_id;
                }else{
                    $address_id = json_decode($item->address_id)->id??'';
                }
                $card_data = [
                    'id'                     => (string) $item->id,
                    'user_name'              => $user?$user->name:'',
                    'user_email'             => $user?$user->email:'',
                    'user_mobile'            => $user?$user->phone:'',
                    'sessions' => $item->sessionPackages->isNotEmpty() 
                    ? $item->sessionPackages
                    ->sortBy('date')
                    ->map(function ($session) {
                        return [
                            'id' => (string)$session->id,
                            'cart_id' => $session->cart_id,
                            'package_id' => $session->package_id,
                            'slot' => $session->slot,
                            'service_id' => $session->service_id,
                            'date' => $session->date,
                            'time' => $session->time,
                            'status' => $session->status,
                        ];
                    })
                    ->values()
                    ->toArray()
                    : [], 
                    'user_id'                => (string) $item->user_id,
                    'service_id'             => (string) $item->service_id,
                    'service_name'           => $item->service_name, 
                    'service'           => $item->service_name, 
                    'image'                  => asset('uploads/service/'.$service->thumbnail_img),
                    'is_revisit'             => empty($item->is_revisit) ? "0" : "1",
                    'category_id'            => (string) $item->category_id,
                    'category'               => $category?$category->name:'',
                    'slot_id'                => (string) $item->slot_id,
                    'slot'                   => $item->slot?$item->slot->name:'',
                    'address_id'             => (string) $address_id,
                    'address'                => "$building, $flat_no, $address",
                    'tran_id'                => (string) normalizeId($item->tran_id),
                    'payment_status'         => $item->payment_status,
                    'alternative_dial_code'  => $item->alternative_dial_code ?? "",
                    'alternative_number'     => $item->alternative_number,
                    'note'                   => $item->note,
                    'date'                   => $item->date,
                    'status'                 => $item->status,
                    'accept_user_id'         => (string) $item->accept_user_id,
                    'material_status'        => $item->material_status,
                    'material_charge'        => $item->material_charge,
                    'is_checkout'            => $item->is_checkout,
                    'payment_collected'      => $item->payment_collected,
                    'service_completed'      => $item->service_completed,
                    'service_completed_date' => $item->service_completed_date,
                    'work_done'              => $item->work_done,
                    'pending_approval_by_admin' => $item->pending_approval_by_admin,
                    'booking_from'           => $item->booking_from,
                    'created_at'             => $item->created_at,
                    'updated_at'             => $item->updated_at,
                    'selected_packages'      => $item->selected_packages,
                    'preferred_days'         => $item->preffered_days,
                    'offline_charge'         => (string) $item->offline_charge,
                    'offline_discount'         => (string) $item->offline_discount,
                    'cod_charge'             => (string) $surcharge,
                    'surcharge'              => (string) $cod,
                ];
                $allHaveSlotId = true;
                if($item->service_id != 10){
                    if (empty($item->slot_id)) {
                        $allHaveSlotId = false;
                    }
                } else {
                    if ($item->sessionPackages->isNotEmpty() && !empty($item->sessionPackages[0]->date)) {
                        $allHaveSlotId = true;
                    } else {
                        $allHaveSlotId = false;
                    }
                }
                
                if($allHaveSlotId && $item->address_id) {
                    $card_data['is_draft'] = "no";
                    $card_data['step'] = "0";
                }
                
                if (!$allHaveSlotId) {
                    $card_data['is_draft'] = "yes";
                    $card_data['step'] = "3";
                }
                
                if(empty($item->address_id)){
                    $card_data['is_draft'] = "yes";
                    $card_data['step'] = "2";
                }else{
                     if(is_numeric($item->address_id)){
                       $add_res = Address::find($item->address_id);
                        if ($add_res == null) {
                            $card_data['is_draft'] = "yes";
                            $card_data['step'] = "2";
                        }

                    }
                }
                
                if(ServiceAttributeValueItem::where('service_id',$service->id)->with('sub_category')->first()->sub_category){
                    $card_data['sub_cate_yes'] = 'Yes';
                } else {
                    $card_data['sub_cate_yes'] = 'No';
                }

                
                $items = Service::find($item->service_id);
                $material_default = ($item->material_status == "Apply") ? (float) $items->material_price : 0;
            
                // Card Attributes and Add-ons
                $card_attr = [];
                $c = 0;
                $material_total = 0;
                $total_count = 1;
                $material = 0;
                $total_maids_material = 1;
                foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                    if(!isset($value->sub_cate_id)){
                        $is_maid = 1;
                        $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                        $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
                        $params['service_type']         = '';
                        
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name ?? "",
                            "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            $totalAmount *= (int) $attribute_total; 
                        } else {
                            
                            $totalAmount += $attribute_total; 
                        }
                        
                        preg_match('/\d+/', $attribute_item->value, $matches);
                
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                            
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                
                    } else {
                        if(empty($value->child_category_id)){
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id
                            ])->first();
                        } else{
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$item->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id,
                                'child_category_id'=>$value->child_cate_id,
                            ])->first();
                        }
                        if(!empty($service_item)){
                            $services = ServiceAttributeValue::where([
                                // 'ser_attr_val_item_id'=>$service_item->id,
                                'attribute_item_id'=>$value->attribute_item_id,
                            ])->first();
                            $attribute = Attribute::where('id',$services->attribute_id)->first();
                            $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                            
                            $params['attribute_price']      = $services->attribute_price ?? null;
                            $params['attribute_qty']        = $value->attribute_qty ?? null;
                
                            $data["attribute"][] = [
                                "category"=>Category::find($service_item->category_id)->name,
                                "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                "name"=>$attribute_item->value ?? "",
                                "price"=>(string) $services->attribute_price,
                                "qty"=>(string) $value->attribute_qty];
                        
                            
                            $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                            
                            if($attribute->name == 'Hours'){
                                $totalAmount *= (float) $attribute_total; 
                            } else {
                                
                                $totalAmount += (float) $attribute_total; 
                            }
                
                            preg_match('/\d+/', $attribute_item->value, $matches);
                
                            if (count($matches) > 0) {
                                $number = (int) $matches[0];
                                $total_count *= $number;
                            
                                $total_maids_material *= $number;
                                if ($attribute->name == 'Hours') {
                                } else {
                                }
                            }
                            
                        } 
                        $params['service_type']         = '';
                    } 
                    $sub_cat = Category::find($value->sub_cate_id);
                    $child_cat = ChildCategory::find($value->child_cate_id);

                    $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                    $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                    $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                    $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                    $paramss['child_cate_id']        = (string) $value->child_cate_id;
                    $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                    $paramss['attribute_id']         = (string) $value->attribute_id;
                    $paramss['attribute_name']       = $value->attribute_name;
                    $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                    $paramss['attribute_item_name']  = $value->attribute_item_name;
                    $paramss['attribute_qty']        = (string) $value->attribute_qty;
                    $paramss['attribute_price']      = (string) $value->attribute_price;
                    $paramss['service_type']         = $value->service_type;
                    $paramss['unit_price']         = $value->unit_price??0;
                    array_push($card_attr,$paramss);
                }

                $card_data['card_attribute'] = $card_attr;

                if($item->service_id == 10){
                    $material_total = $total_maids_material;
                } else {
                    $material_total = $material_total;
                }
                $material = ($item->material_status == "Apply") ? (float) $material_total : "0";
        
                $totalAmount = ((float)$item->amount-(float)$item->coupon_amt);
                if($item->service_id == 10){
                    if(isset($item->selected_packages) ){        
                        $selectedPackageIds = explode(',', $item->selected_packages);
                
                        $packages = Packages::whereIn('id', $selectedPackageIds)->get();
                
                        foreach ($packages as $package) {
                            
                            $card_data['is_package'] = "1";
                            $card_data["packages"][] = [
                                "name"=>$package->name, 
                                "base_amount"=>(string) $package->amount,
                                "price"=>(string) ((int) $package->amount * (int) $total_count),
                                "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                            ]; 
                            $totalAmount = ((int) $package->amount * (int) $total_count)-(float)$value->coupon_amt; 
                            $material *= ((int) $package->total_sessions);
                
                        }
                    } else {
                
                        $card_data['is_package'] = "0";
                        $card_data['packages'] = [];
                    }
                
                } else {
                    $card_data["session_packages"] = []; 
                    $card_data['is_package'] = "0";
                    $card_data['packages'] = [];
                }

                $data['coupon']         = $item->coupon?$item->coupon->code:'';
                $data['subtotal']       = (string) $totalAmount ?? "";
                $data['coupon_amt']     = (string) $item->coupon_amt ?? "";

                
                $material *= $material_default;
                $material = $item->material_charge;
                $totalAmount += $material;
                $data['total']          = (string) $totalAmount ?? 0;
                $totalAmount += $surcharge;
                
                if($request->payment_type == 2){
                    $totalAmount += $cod;
                }
                
                $card_data['material_charge'] = (string) $material;
                $card_data['g_total'] = (string) $totalAmount;
                $card_data['total'] = (string) $totalAmount;
                $card_data['subtotal'] = (string) $totalAmount;
                $cards_detail[] = $card_data;
                $total_amount += $totalAmount;

                $data['card_attribute'] = $card_attr;
            }

            $cards['card'] = $cards_detail;
            if($coupon_amount > 0){
                $cards['coupon_amount']     = (string) $coupon_amount;
                $cards['coupon_status']     = "yes";
                $total_amount -= $coupon_amount;
            }
            
            if ($tip_amount > 0) {
                $cards['tip_amount'] = (string) $tip_amount;
                $cards['tip_status'] = "yes";
                $total_amount += $tip_amount;
            } else {
                $cards['tip_amount'] = (string) $tip_amount;
                $cards['tip_status'] = "no";
            }
            
            $cards['user_balance']  = auth()->user()->wallet_balance;
            $rewardData = $this->get_reward_price($total_amount);

            $cards['sub_total']         = (string) $total_amount;
            

            if ($rewardData !== null) {
                $cards["remaining_reward_points"] = (string) $rewardData['remaining_reward_points'];
                $cards["reward_amount"] = (string) $this->get_reward_price($total_amount)['final_amount'];
                // $cards['total']         = (string) ((float) $total_amount - (float) $this->get_reward_price($total_amount)['final_amount']);
                // $cards['g_total']         = (string) ((float) $total_amount - (float) $this->get_reward_price($total_amount)['final_amount']);
                
                $cards["total"] = (string) $total_amount; 
                $cards["g_total"] = (string) $total_amount; 
            } else {
                $cards["remaining_reward_points"] = '0'; 
                $cards["reward_amount"] = '0'; 
                $cards["total"] = (string) $total_amount; 
                $cards["g_total"] = (string) $total_amount; 
            }


            return $this->sendResponse($cards, 'My Bookings');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }
    public function accept_booking(Request $request)
    { 
        $user = User::find(auth()->user()->id);
        if($user->is_available == 1){
            $card = Card::find($request->booking_id);
            $seller = Seller::where('user_id',$user->id)->first();
            if($card->service_id == 10){
                // $sessionsToUpdate = SessionPackages::where('cart_id', $card->id)
                // ->where(function ($query) {
                //     $query->where('date', '>', Carbon::today()->toDateString()) // Future dates
                //     ->orWhere(function ($subQuery) {
                //         $subQuery->where('date', '=', Carbon::today()->toDateString()) // Today's date
                //             ->whereHas('slot', function ($slotQuery) {
                //                 $slotQuery->whereTime('check_in', '>=', Carbon::now('Asia/Dubai')->format('H:i:s')); // Future times
                //             });
                //     });
                // })
                // ->orderBy('date', 'asc')
                // ->get();
                $sessionsToUpdate = SessionPackages::where('cart_id', $card->id)
                // ->where(function ($query) {
                //     $query->where('date', '>', Carbon::today()->toDateString()) // Future dates
                //     ->orWhere(function ($subQuery) {
                //         $subQuery->where('date', '=', Carbon::today()->toDateString()) // Today's date
                //             ->whereHas('slot', function ($slotQuery) {
                //                 $slotQuery->whereTime('check_in', '>=', Carbon::now('Asia/Dubai')->format('H:i:s')); // Future times
                //             });
                //     });
                // })
                ->orderBy('date', 'asc')
                ->get(); 

                if ($sessionsToUpdate->isNotEmpty()) {
                    // Update all pending sessions to "Upcoming"
                    SessionPackages::where('cart_id', $card->id)
                        ->where('status', 'Pending')
                        ->update(['status' => 'Upcoming']);

                    // Loop through sessions and check if they start within 2 hours
                    foreach ($sessionsToUpdate as $session) {
                        $slot = Slot::find($session->time);
                        if ($slot) {
                            $sessionTime = Carbon::createFromFormat('Y-m-d H:i:s', $session->date . ' ' . $slot->check_in);

                            if (Carbon::now('Asia/Dubai')->diffInHours($sessionTime, false) <= 2) {
                                // Mark this session as "Accept"
                                $session->update(['status' => 'Accept']);
                                
                                Log::info("Session ID {$session->id} marked as Accept.");
                            }
                        }
                    }
                }
            }
            
            if($user && $seller){
                if($card){
                    
                    if($card->status == "Accept"){
                        return $this->sendError('Sorry, this job is assigned to other provider.');
                    } else {

                        $data['accept_user_id']         = $user->id;
                        $data['accept_user_company_id'] = $seller?$seller->id:'';
                        $data['status']                 = 'Accept';
                        
                        $seller = Seller::where('user_id', auth()->user()->id)->first();

                        if ($seller) {
                            $query = SellerService::where('seller_id', $seller->id)
                                ->where('service_id', $card->service_id);
                            
                            \Log::info('SellerService Query:', ['query' => $query->toSql(), 'bindings' => $query->getBindings()]);
                            
                            $sellerService = $query->first();
                        } else {
                            $sellerService = null;
                        }

                        $commission = null;

                        if (isset($sellerService) && isset($sellerService->commission)) {
                            $commission = $sellerService->commission;
                        } else {
                            $service = Service::find($card->service_id);
                        
                            if ($service && $service->category) {
                                $commission = $service->category->commission;
                            }
                        }
                        
                        // Default to 0 if no commission is found
                        $commission = $commission ?? 0;
                        $data['urban_commission'] = $commission;

                        $card->update($data);

                        // Update booking status in Firebase
                        $status_data["cart/{$card->id}/status"] = "Accept";

                        $this->database->getReference()->update($status_data);
                        exec("php ".base_path()."/artisan accept_booking:notification ".$card->id." > /dev/null 2>&1 & ");

                    }    
                    
                                
                    // Fetch all sessions with status 'Pending'
                    $sessions = SessionPackages::whereIn('status', ['Pending','Expired','Upcoming','Accept'])->get();
                    
                    foreach ($sessions as $session) {
                        // Parse the session date
                        $sessionDate = Carbon::parse($session->date, 'Asia/Dubai');
                    
                        // Find the slot for the session
                        $slot = Slot::find($session->time);
                    
                        if ($slot) {
                            // Get the check-in time from the slot
                            $checkInTime = Carbon::createFromFormat('H:i:s', $slot->check_in, 'Asia/Dubai');
                            $currentTime = Carbon::now('Asia/Dubai');
                    
                            // Log the session information for debugging
                            Log::info("Testing session ID: {$session->id}");
                            Log::info("Session date: {$sessionDate->toDateString()}");
                            Log::info("Slot check-in time: {$checkInTime->format('H:i:s')}");
                            Log::info("Current time: {$currentTime->format('H:i:s')}");
                    
                            // Determine if the session is expired
                            if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                                // If the session date is in the past and not today, mark as Expired
                                Log::info("Session ID {$session->id} marked as Expired (past date).");
                                //$session->update(['status' => 'Expired']);
                            } elseif ($sessionDate->isToday() && $currentTime->greaterThanOrEqualTo($checkInTime)) {
                                // If the session date is today and the current time is past the check-in time
                                Log::info("Session ID {$session->id} marked as Expired (past time).");
                                //$session->update(['status' => 'Expired']);
                            } else {
                                Log::info("Session ID {$session->id} is not expired.");
                                if($session->status == 'Expired'){
                                    $session->update(['status' => 'Pending']);
                                }
                            }
                        } else {
                            Log::warning("No slot found for session ID: {$session->id}");
                        }
                    }

                    return $this->sendResponse([], 'Booking Accepted Successfuly!');
                } else {
                    return $this->sendError('Sorry, this job is assigned to other provider.');
                }
            } else {
                return $this->sendError('Vendor not found.');
            }
        } else {
            return $this->sendError('Vendor is not available.');
        }
    }

    public function mark_arrived(Request $request)
    {
        $card = Card::find($request->booking_id);

                
        if(auth()->user()->role == "vendor"){
            if($card->accept_user_id){
                if($card->accept_user_id != auth()->user()->id){
                    return $this->sendError('Booking id is invalid!');
                }
            } else {
                return $this->sendError('Booking not accepted right now!');
            }
        }

        // if(auth()->user()->role == "staff"){
        //     $staff_card = StaffCard::where('card_id', $card->id)
        //     ->where('user_id', auth()->user()->staff->id)
        //     ->exists();
        //     if(!$staff_card){
        //         return $this->sendError('Booking id is invalid!');
        //     }
        // }

        if($card){

            if($card->service_id != 10){
                if(auth()->user()->role == "staff"){
                    $check = StaffCard::where('card_id', $card->id)
                    ->exists();

                    $data         = [];
                    if ($check) {

                        StaffCard::where('card_id', $card->id)
                        ->where('user_id', auth()->user()->staff->id)
                        ->update(['status' => 'Mark As Arrived']);

                        $allSessionsCompleted = StaffCard::where('card_id', $card->id)
                        ->where('status', '!=', 'Pending') 
                        ->where('status', '!=', 'Upcoming') 
                        ->where('status', '!=', 'Accept')
                        ->where('status', '!=', 'Expired')
                        ->exists(); 

                        if ($allSessionsCompleted) {
                            $data['status']         = 'Mark As Arrived';
                            $data['service_start_datetime'] = date('Y-m-d H:i:s');
                            $card->update($data);
                        }
                    } 
                        
                } else {

                    $data['status']         = 'Mark As Arrived';
                        
                    $data['service_start_datetime'] = date('Y-m-d H:i:s');
                    $card->update($data);
                }
            }

            if($card->service_id == 10){
                
               // Find the session by ID
                $session = SessionPackages::find($request->session_id);
                if ($session) {
                    $userId = auth()->user()->id;
                    $staff = auth()->user()->staff ?? null;
                    $staffId = $staff ? $staff->id : null;

                    if (auth()->user()->role == "staff") {
                        // Update the staff session status
                        $staffSession = StaffSession::where([
                            'session_id' => $request->session_id,
                            'user_id' => $staffId,
                        ])->first();

                        if ($staffSession) {
                            $staffSession->status = 'Mark As Arrived';
                            $staffSession->save();
                        }
                    }
                    
                   

                    // Check if all related staff sessions are marked as 'Mark As Arrived'
                    $allStaffSessionsMarkedArrived = StaffSession::where('session_id', $session->id)
                    ->where('status', '!=', 'Accept')
                    ->where('status', '!=', 'Pending')
                    ->where('status', '!=', 'Upcoming')
                    ->where('status', '!=', 'Expired')
                    ->get();
                    $allCompleteStaffSessionsMarkedArrived= StaffSession::where('session_id', $session->id)->get();
                   
                   $getallStaffSessionsMarkedArrived = StaffSession::where('session_id', $session->id)->first();
                   if($allStaffSessionsMarkedArrived->count()==$allCompleteStaffSessionsMarkedArrived->count() || empty( $getallStaffSessionsMarkedArrived)){
                      
                        $session->status = 'Mark As Arrived';
                        $session->save();
                   }
                    $allSessionsCompleted = SessionPackages::where('cart_id', $card->id)
                    ->where('status', '!=', 'Accept')
                    ->where('status', '!=', 'Pending')
                    ->where('status', '!=', 'Upcoming')
                    ->where('status', '!=', 'Expired')
                    
                    ->get();
                    $allCompleteSessionsCompleted = SessionPackages::where('cart_id', $card->id)
                    
                    ->get();
                   
                    if ($allSessionsCompleted->count()==$allCompleteSessionsCompleted->count()) {
                         // Update the session package status
                        
                        $data['status']         = 'Mark As Arrived';
                        $data['service_start_datetime'] = date('Y-m-d H:i:s');
                        $card->update($data);
                    }
                }

            
            }
            
            // Update booking status in Firebase
            $status_data["cart/{$card->id}/status"] = "Mark As Arrived";

            $this->database->getReference()->update($status_data);

            if(auth()->user()->role == "staff"){
                exec("php ".base_path()."/artisan send_mark-arrived_notification:push ".$card->id." ".auth()->user()->id." > /dev/null 2>&1 & ");
            }else{
                exec("php ".base_path()."/artisan send_mark-arrived_notification:push ".$card->id." 0 > /dev/null 2>&1 & ");
            }
            return $this->sendResponse([], 'En route to work');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function booking_started(Request $request)
    {
        $card = Card::find($request->booking_id);

        if(auth()->user()->role == "vendor"){
            if($card->accept_user_id){
                if($card->accept_user_id != auth()->user()->id){
                    return $this->sendError('Booking id is invalid!');
                }
            }
        }
        
        // if(auth()->user()->role == "staff"){
        //     $staff_card = StaffCard::where('card_id', $card->id)
        //     ->where('user_id', auth()->user()->staff->id)
        //     ->exists();
        //     if(!$staff_card){
        //         return $this->sendError('Booking id is invalid!');
        //     }
        // }

        if($card){
            if($card->service_id != 10){
                if(auth()->user()->role == "staff"){
                    $check = StaffCard::where('card_id', $card->id)
                    ->exists();

                    $data         = [];
                    if ($check) {
                        
                        StaffCard::where('card_id', $card->id)
                        ->where('user_id', auth()->user()->staff->id)
                        ->update(['status' => 'In Progress']);

                        $allSessionsCompleted = StaffCard::where('card_id', $card->id)
                        ->where('status', '!=', 'Mark As Arrived') 
                        ->where('status', '!=', 'Accept')
                        ->where('status', '!=', 'Pending')
                        ->where('status', '!=', 'Expired')
                        ->exists(); 

                        if ($allSessionsCompleted) {
                            $data['service_start_datetime'] = date('Y-m-d H:i:s');
                            $data['status']         = 'In Progress';
                            $card->update($data);
                        }
                    } 
                } else {
                        $data['status']         = 'In Progress';
                            
                        $data['service_start_datetime'] = date('Y-m-d H:i:s');
                        $card->update($data);
                }
            }

            if($card->service_id == 10){
               // Find the session by ID
                $session = SessionPackages::find($request->session_id);
                if ($session) {
                    $userId = auth()->user()->id;

                    if (auth()->user()->role == "staff") {
                        $staff = auth()->user()->staff;
                        $staffId = $staff ? $staff->id : null;

                        // Update the staff session status
                        $staffSession = StaffSession::where([
                            'session_id' => $request->session_id,
                            'user_id' => $staffId,
                        ])->first();

                        if ($staffSession) {
                            $staffSession->status = 'In Progress';
                            $staffSession->save();
                        }
                    }

                    // Update the session package status to 'In Progress'
                    
                    
                    $allStaffSessionsMarkedArrived = StaffSession::where('session_id', $session->id)
                    ->where('status', '!=', 'Accept')
                    ->where('status', '!=', 'Pending')
                    ->where('status', '!=', 'Upcoming')
                    ->where('status', '!=', 'Mark As Arrived')
                    ->where('status', '!=', 'Expired')
                    ->get();
                   
                    $allCompleteStaffSessionsMarkedArrived= StaffSession::where('session_id', $session->id)->get();
                   
                   $getallStaffSessionsMarkedArrived = StaffSession::where('session_id', $session->id)->first();
                   if($allStaffSessionsMarkedArrived->count()==$allCompleteStaffSessionsMarkedArrived->count() || empty( $getallStaffSessionsMarkedArrived)){
                   
                    $session->status = 'In Progress';
                    $session->save();
                   }
                   $allSessionsCompleted = SessionPackages::where('cart_id', $card->id)
                   ->whereIn('status' , ['Completed','In Progress'])
                   ->get(); 
                   
                   $allCompleteSessionsCompleted = SessionPackages::where('cart_id', $card->id)
                   
                   ->get();
                  
                   if ($allSessionsCompleted->count()==$allCompleteSessionsCompleted->count()) {
                        $data['status']         = 'In Progress';
                        $data['assign_id']      = auth()->user()->id;
                        $card->update($data);
                    }
                }

            }
           
            // Update booking status in Firebase
            $status_data["cart/{$card->id}/status"] = "In Progress";

            $this->database->getReference()->update($status_data);

            if(auth()->user()->role == "staff"){
                exec("php ".base_path()."/artisan booking_started_notification:push ".$card->id." ".auth()->user()->id." > /dev/null 2>&1 & ");
            }else{
                exec("php ".base_path()."/artisan booking_started_notification:push ".$card->id." 0 > /dev/null 2>&1 & ");
            }

            return $this->sendResponse([], 'Job Started Successfully!');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function payment_collected(Request $request)
    {
        $card = Card::find($request->booking_id);

        if($card){
            $data['payment_collected']  = 'Yes';
            $card->update($data);
            return $this->sendResponse([], 'Payment Collected');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    // Final By Yash sir, Tahir, Moiz, Mohit 04/01/2024
    public function oold_service_completed(Request $request)
    {
        $card = Card::find($request->booking_id);
        
        if($card){
            $data['status']                     = 'Completed';
            $data['service_completed']          = 'Yes';
            $data['payment_collected']          = 'Yes';
            $data['service_completed_date']     = date('Y-m-d H:i:s');
            $card->update($data);

            $card       = Card::find($request->booking_id);
            $setting    = HomeSetting::first();

            $service    = Service::find($card->service_id);

            $um_commission      = $service?$service->um_commission:'0';
            $bank_percentage    = $setting?$setting->bank_percentage:'0';
            $bank_charges       = $setting?$setting->bank_charges:'0';
            
            $total = '0';
            foreach (CardAttribute::where('card_id',$card->id)->get() as $key => $crdatr) {
                $ttotal = $crdatr->attribute_price*$crdatr->attribute_qty;
                $total += $ttotal;
            }
            
            foreach (CardAddon::where('card_id',$card->id)->get() as $key => $addon) {
                $attotal = $addon->value;
                $total += $attotal;
            }

            if($card->material_status=='Apply'){
                $total += $card->material_charge;
            }

            // $params['job_value']  = $total;
            
            $total = $card->g_total;
            if($card->payment_moad=='Cash'){
                
                $params['job_value']  = $card->g_total;

                // Step 1
                $jobValue = $card->g_total;
                // $jobValue = $total;

                // Step 2
                if($card && $card->coupon_id){
                    $coupon = CardCoupon::where('card_id',$card->id)->first();
                      if($coupon){
                        $amount = $coupon->amount;
                        if($coupon->type=='Amt'){
                          $coupon_Amt = $amount;
                        } else {
                          $per = ($amount / 100) * $total;

                          if($per>$coupon->max_amount){
                            $coupon_Amt = $coupon->max_amount;
                          } else {
                            $coupon_Amt = $per;
                          }

                        }
                    } else {
                        $coupon_Amt = '00';
                    }
                    $total -= $coupon_Amt;
                    $params['coupon_amt'] = $coupon_Amt;
                } else {
                    $coupon_Amt = '00';
                }

                // Step 3
                $total += $card?$card->cod_charge:'0';

                // Step 4
                $total += $card?$card->tip_id:'0';

                $online_k_liye = $total;

                // Step 5
                // $um_com_amt = ($um_commission / 100) * $total;
                // $total -= round($um_com_amt,2);
                // $cal_per     = 100 - $um_commission;
                // $um_commission = $cal_per;
                // $um_com_amt  = ($cal_per / 100) * $jobValue;

                // $ftotal      = round($um_com_amt,2);

                $um_com_amt = ($jobValue * $um_commission) / 100;
                $ftotal = round($um_com_amt,2);

                // $ftotal -= $coupon_Amt;

                // Step 6
                $bnk_f_amt   = '0';
                 
                // Step 7 
             
                $net_ear = $total - $ftotal;

            } else {

                $total = '0';
                foreach (CardAttribute::where('card_id',$card->id)->get() as $key => $crdatr) {
                    $ttotal = $crdatr->attribute_price*$crdatr->attribute_qty;
                    $total += $ttotal;
                }
                
                foreach (CardAddon::where('card_id',$card->id)->get() as $key => $addon) {
                    $attotal = $addon->value;
                    $total += $attotal;
                }

                if($card->material_status=='Apply'){
                    $total += $card->material_charge;
                }
               
                // Step 1
                $jobValue = $total;

                $params['job_value']  = $jobValue;

                // Step 2
                if($card && $card->coupon_id){
                    $coupon = CardCoupon::where('card_id',$card->id)->first();
                      if($coupon){
                        $amount = $coupon->amount;
                        if($coupon->type=='Amt'){
                          $coupon_Amt = $amount;
                        } else {
                          $per = ($amount / 100) * $total;

                          if($per>$coupon->max_amount){
                            $coupon_Amt = $coupon->max_amount;
                          } else {
                            $coupon_Amt = $per;
                          }

                        }
                    } else {
                        $coupon_Amt = '00';
                    }
                    // $total -= $coupon_Amt;
                    $params['coupon_amt'] = $coupon_Amt;
                } else {
                    $coupon_Amt = '00';
                }

                // Step 3
                $total += $card?$card->tip_id:'0';

                // Step 4
                $total -= $coupon_Amt;
                $online_k_liye = $total;

                // Step 5
                // $ftotal      = '0';
                // $cal_per     = 100 - $um_commission;
                // $um_commission = $cal_per;
                // $um_com_amt  = ($cal_per / 100) * $jobValue;
                // $ftotal      = round($um_com_amt,2);
                              
                $um_com_amt = ($jobValue * $um_commission) / 100;
                $ftotal = round($um_com_amt,2);

                // Step 6
                // $bnk_f_amt   = $total * 100 / ($bank_percentage + 100);
                // $f_b_a       = $total - $bnk_f_amt;
                // $_f_bnk_amt  = round($f_b_a,2)+$bank_charges;                

                $bnk_f_amt   = $total * $bank_percentage / 100;
                // $f_b_a       = $total - $bnk_f_amt;
                $_f_bnk_amt  = round($bnk_f_amt,2)+$bank_charges;

                // Step 7       
                $net_ear    = $total - ($ftotal + $_f_bnk_amt);
                 
            }

            $params['card_id']          = $card->id;
            $params['card_total']       = $jobValue;
            
            $params['cash_surcharge']   = $card?$card->cod_charge:'0';
            $params['tip']              = $card?$card->tip_id:'0';
            $params['um_comission']     = $um_commission;
            $params['um_com_amt']       = $ftotal;

            if($card->payment_moad=='Card'){
                $params['bank_fees']        = $bank_percentage;
                $params['bank_fees_amt']    = $_f_bnk_amt;
            } else {
                $params['bank_fees']        = '0';
                $params['bank_fees_amt']    = '0';
            }

            $params['payment_moad']     = $card->payment_moad=='Cash'?'Cash':'Prepaid';
            $params['net_balance']      = $net_ear;                
           
            $vendor_id = $card->accept_user_id;
            $user = User::find($vendor_id);

            if($vendor_id && isset($vendor_id) && $user && isset($user)){
                $vendor_old_balance = $user->wallet_balance;

                if($card->payment_moad=='Cash'){
                    $avl_ven_blc = ($vendor_old_balance-$jobValue)+$net_ear;
                } else {
                    $avl_ven_blc = $vendor_old_balance+$net_ear;
                }
                $user_paramas['wallet_balance'] = $avl_ven_blc;

                $user->update($user_paramas);

                $params['vendor_id'] = $vendor_id;   
                $res = PayOutBalance::create($params);
              
                // return $this->sendResponse($res, 'Booking Successfully Completed');
            } else {
                return $this->sendError('Vendor not found.');
            }

            if($card->user && $card->user->email){

                if($card && $card->user){
                    $customer = $card->user?$card->user->name:'';
                } else {
                    $customer = 'No Name';
                }

                if($card && $card->service){
                    $service = $card->service?$card->service->name:'';
                } else {
                    $service = 'No Service';
                }

                $array['view']      = 'emails.booking_completed';
                $array['subject']   = 'Booking Confirmation with '.$customer.' for '.$service;
                $array['data']      = $card;
                // \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
            }

            if($card->user && $card->user->name && $card->user->phone){
                $customer_name = $card->user->name;
                $message = "Dear ($customer_name), \nThanks for shopping with us! To help improve our services, please click here https://9a4yhhhzdd7.typeform.com/to/FoG6FNhq to rate your experience. Thank you, Urbanmop.com";
                $msg = urlencode($message);
                $mobile = $card->user->phone;
                $res=send_sms_to_mobile($mobile,$msg);
            }
            
            update_booking($card->id);
            return $this->sendResponse([], 'Service Completed');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function old_service_completed(Request $request)
    {
        $card = Card::find($request->booking_id);
        
        if($card){
            $data['status']                     = 'Completed';
            $data['service_completed']          = 'Yes';
            $data['payment_collected']          = 'Yes';
            $data['service_completed_date']     = date('Y-m-d H:i:s');
            $card->update($data);

            $card       = Card::find($request->booking_id);
            $setting    = HomeSetting::first();

            $service    = Service::find($card->service_id);

            $um_commission      = $service?$service->um_commission:'0';
            $bank_percentage    = $setting?$setting->bank_percentage:'0';
            $bank_charges       = $setting?$setting->bank_charges:'0';
            
            $total = '0';
            foreach (CardAttribute::where('card_id',$card->id)->get() as $key => $crdatr) {
                $ttotal = $crdatr->attribute_price*$crdatr->attribute_qty;
                $total += $ttotal;
            }
            
            foreach (CardAddon::where('card_id',$card->id)->get() as $key => $addon) {
                $attotal = $addon->value;
                $total += $attotal;
            }

            $params['job_value']  = $total;
            
            $jtotal = $total; 

            $tip_amt = $card?$card->tip_id:'0';

            // Step 1
            $jobValue = $total+$tip_amt;

            // Step 2
            if($card && $card->coupon_id){
                $coupon = CardCoupon::where('card_id',$card->id)->first();
                  if($coupon){
                    $amount = $coupon->amount;
                    if($coupon->type=='Amt'){
                      $coupon_Amt = $amount;
                    } else {
                      $per = ($amount / 100) * $total;

                      if($per>$coupon->max_amount){
                        $coupon_Amt = $coupon->max_amount;
                      } else {
                        $coupon_Amt = $per;
                      }

                    }
                } else {
                    $coupon_Amt = '00';
                }
                $total -= $coupon_Amt;
                $params['coupon_amt'] = $coupon_Amt;
            }

            // Step 3
            $total -= $card?$card->cod_charge:'0';

            // Step 4
            $total -= $card?$card->tip_id:'0';

            // Step 5
            $um_com_amt = ($um_commission / 100) * $jtotal;
            $total -= round($um_com_amt,2);

            // Step 6
            if($card->payment_moad=='Card'){
                $bnk_f_amt = ($bank_percentage / 100) * $jobValue;
                $total -= round($bnk_f_amt,2)+$bank_charges;
            } else {
                $bnk_f_amt = '0';
            }
             
            // Step 7 
            $net_ear = $total;

            $params['card_id']          = $card->id;
            $params['card_total']       = $jobValue;
            
            $params['cash_surcharge']   = $card?$card->cod_charge:'0';
            $params['tip']              = $card?$card->tip_id:'0';
            $params['um_comission']     = $um_commission;
            $params['um_com_amt']       = round($um_com_amt,2);

            if($card->payment_moad=='Card'){
                $params['bank_fees']        = $bank_percentage;
                $params['bank_fees_amt']    = round($bnk_f_amt,2)+$bank_charges;;
            } else {
                $params['bank_fees']        = '0';
                $params['bank_fees_amt']    = '0';
            }

            $params['payment_moad']     = $card->payment_moad=='Cash'?'Cash':'Prepaid';
            $params['net_balance']      = $net_ear;                
            
            $vendor_id = $card->accept_user_id;
            $user = User::find($vendor_id);

            if($vendor_id && isset($vendor_id) && $user && isset($user)){
                $vendor_old_balance = $user->wallet_balance;

                if($card->payment_moad=='Cash'){
                    $avl_ven_blc = ($vendor_old_balance-$jobValue)+$net_ear;
                } else {
                    $avl_ven_blc = $vendor_old_balance+$net_ear;
                }
                $user_paramas['wallet_balance'] = $avl_ven_blc;

                $user->update($user_paramas);

                $params['vendor_id'] = $vendor_id;   
                $res = PayOutBalance::create($params);
                // return $this->sendResponse($res, 'Booking Successfully Completed');
            } else {
                return $this->sendError('Vendor not found.');
            }

            if($card->user && $card->user->email){

                if($card && $card->user){
                    $customer = $card->user?$card->user->name:'';
                } else {
                    $customer = 'No Name';
                }

                if($card && $card->service){
                    $service = $card->service?$card->service->name:'';
                } else {
                    $service = 'No Service';
                }

                $array['view']      = 'emails.booking_completed';
                $array['subject']   = 'Booking Confirmation with '.$customer.' for '.$service;
                $array['data']      = $card;
                // \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
            }

            if($card->user && $card->user->name && $card->user->phone){
                $customer_name = $card->user->name;
                $message = "Dear ($customer_name), \nThanks for shopping with us! To help improve our services, please click here https://www.urbanmop.com to rate your experience. Thank you, Urbanmop.com";
                $msg = urlencode($message);
                $mobile = $card->user->phone;
                $res=send_sms_to_mobile($mobile,$msg);
            }
            
            update_booking($card->id);
            return $this->sendResponse([], 'Service Completed');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }
    
      public function send_notification(Request $request)
      {
        $user = User::find($request->user_id);

        if ($user) {
            $device_tokens = $user->user_device_token;
            $firebase_user_key = $user->firebase_user_key;
        
            if (!empty($device_tokens) && $device_tokens != '0') {
                if (strlen($device_tokens) > 70) {
                    // Logic when token length exceeds 70
                    $title  = $request->title;
                    $body   = $request->body;
                    $text   = $request->body;

                    if (!empty($firebase_user_key)) {
                        $user_firebase_key = $firebase_user_key; 
                            
                        send_single_notification(
                            $device_tokens,
                            [
                                "title" => $title,
                                "body" => $body,
                                "icon" => 'myicon',
                                "sound" => 'default',
                                "click_action" => "EcomNotification",
                            ],
                            $this->convert_all_elements_to_string_fcm_change($request->data)
                        );

                        return $this->sendResponse([], 'Notification Sent.');
                    }
                }
            } else {
                return $this->sendError('Device Token not exist.');
            }
        } else {
            return $this->sendError('User not exist.');
        }
    }

    function convert_all_elements_to_string_fcm_change($data)
    {
        $data = json_decode($data);
        $converted = [];
        foreach ($data as $key => $value) {
            $converted[$key] = (string) $value; // Convert all values to strings
        }
        return $converted;
    }    

    // Made 05/01/2024 After Client Meeting with Tahir, Moiz
    public function service_completed(Request $request)
    {
        $card = Card::find($request->booking_id);

        if(auth()->user()->role == "vendor"){
            if($card->accept_user_id){
                if($card->accept_user_id != auth()->user()->id){
                    return $this->sendError('Booking id is invalid!');
                }
            }
        }
        
        // if(auth()->user()->role == "staff"){
        //     $staff_card = StaffCard::where('card_id', $card->id)
        //     ->where('user_id', auth()->user()->staff->id)
        //     ->exists();
        //     if(!$staff_card){
        //         return $this->sendError('Booking id is invalid!');
        //     }
        // }
        
        if($card){
            
            if(auth()->user()->role == "vendor"){
                if($card->service_id != 10){

                    $data['service_completed']          = 'Yes';
                    $data['payment_collected']          = 'Yes';
                    $data['service_completed_date']     = date('Y-m-d H:i:s');
                    $data['status']         = 'Completed';
                    $card->update($data);
                }
            }
            $check = StaffCard::where('card_id', $card->id)
            ->exists();

            $data         = [];
            // $data['status']         = 'Pending';
            if ($check) {
                if($card->service_id != 10){

                    StaffCard::where('card_id', $card->id)
                    ->where('user_id', auth()->user()->staff->id)
                    ->update(['status' => 'Completed']);

                    $data['service_completed']          = 'Yes';
                    $data['payment_collected']          = 'Yes';
                    $data['service_completed_date']     = date('Y-m-d H:i:s');
                    $data['status']         = 'Completed';
                    $card->update($data);
                    
                } else {
                    $session = StaffSession::find($request->session_id);
                    if ($session) {
                        $userId = auth()->user()->id;
                                    
                        $session->status = 'Completed';
                        $session->save();
                    }

                    $session = SessionPackages::find($request->session_id);
                    if ($session) {
                        $userId = auth()->user()->id;
                        $allStaffSessionsCount = StaffSession::where('session_id', $session->id)->count();
                        $completedStaffSessionsCount = StaffSession::where('session_id', $session->id)
                            ->where('status', 'Completed')
                            ->count();

                        if ($allStaffSessionsCount > 0 && $allStaffSessionsCount === $completedStaffSessionsCount) {
                            $session->status = 'Completed';
                            $session->save();
                        }
       
                            
                    }

                    $allSessionsCompleted = SessionPackages::where('cart_id', $card->id)
                    ->whereIn('status' , ['Completed'])
                    ->get();
                    if ($allSessionsCompleted) {
                        $data['service_completed']          = 'Yes';
                        $data['payment_collected']          = 'Yes';
                        $data['service_completed_date']     = date('Y-m-d H:i:s');
                        $data['status']         = 'Completed';
                        $card->update($data);
                    }
                }
                
            } else {

                if($card->service_id == 10){
                
                    // Find the session by ID
                    $session = SessionPackages::find($request->session_id);
                    if ($session) {
                        $userId = auth()->user()->id;
    
                        if (auth()->user()->role == "staff") {
                            $staff = auth()->user()->staff;
                            $staffId = $staff ? $staff->id : null;
    
                            // Update the staff session status
                            $staffSession = StaffSession::where([
                                'session_id' => $request->session_id,
                                'user_id' => $staffId,
                            ])->first();
    
                            if ($staffSession) {
                                $staffSession->status = 'Completed';
                                $staffSession->save();
                            }
    

                            $allSessionsCount = StaffSession::where('session_id', $session->id)->count();
                            $completedSessionsCount = StaffSession::where('session_id', $session->id)
                                ->where('status', 'Completed')
                                ->count();
                            
                            if ($allSessionsCount > 0 && $allSessionsCount === $completedSessionsCount) {
                                $session->status = 'Completed';
                                $session->save();
                            }
                            
                        } else {
                            $session->status = 'Completed';
                            $session->save();
                        }
                }
    
                    $allCartsCount = SessionPackages::where('cart_id', $card->id)->count();
                    $completedCartsCount = SessionPackages::where('cart_id', $card->id)
                    ->where('status', 'Completed')
                    ->count();
                
                    if ($allCartsCount > 0 && $allCartsCount === $completedCartsCount) {
                        $data['service_completed']          = 'Yes';
                        $data['payment_collected']          = 'Yes';
                        $data['service_completed_date']     = date('Y-m-d H:i:s');
                        $data['status']         = 'Completed';

                        $card->update($data);
                    }
                    
                }
            }
            

            // Update booking status in Firebase
            $status_data["cart/{$card->id}/status"] = "Completed";

            $this->database->getReference()->update($status_data);

            $card       = Card::find($request->booking_id);
            $setting    = HomeSetting::first();

            $service    = Service::find($card->service_id);

            // $um_commission      = 30;
            $um_commission      = $service?$service->um_commission:'0';
            $bank_percentage    = $setting?$setting->bank_percentage:'0';
            $bank_charges       = $setting?$setting->bank_charges:'0';
            
            $total = $card->amount;

            // Step 1
            $jobValue = $total;

            // Step 2
            $tip      = $card?$card->tip_id:'0';
            $jobValue += $tip;

            // Step 3
            $codCharge = $card?$card->cod_charge:'0';
            $jobValue += $codCharge;

            // Step 4
            if($card && $card->coupon_id){
                $coupon = CardCoupon::where('card_id',$card->id)->first();
                  if($coupon){
                    $amount = $coupon->amount;
                    if($coupon->type=='Amt'){
                      $coupon_Amt = $amount;
                    } else {
                      $per = ($amount / 100) * $total;

                      if($per>$coupon->max_amount){
                        $coupon_Amt = $coupon->max_amount;
                      } else {
                        $coupon_Amt = round($per,2);
                      }

                    }
                } else {
                    $coupon_Amt = '00';
                }
            } else {
                $coupon_Amt = '00';
            }

            $jobValue -= $coupon_Amt;

            // Step 5
            if($card->payment_moad=='Cash'){

                $_f_bnk_amt        = '0';
                $bank_percentage   = '0';

            } else {

                $bnk_f_amt   = $jobValue * $bank_percentage / 100;
                $_f_bnk_amt  = round($bnk_f_amt,2)+$bank_charges;

            }

            // Step 6
            $um_com_amt     = ($total * $um_commission) / 100;
            $um_comm_amt    = round($um_com_amt,2);

            // Step 7
            $um_erning = $um_comm_amt + $codCharge + $tip + $_f_bnk_amt;

            // Step 8
            $vendor_erning = $jobValue - $um_erning;

            //             dd("Total = ".$total, " Tip = ".$tip.", COD = ".$codCharge.", um_commission = ".$um_commission.", Coupon = ".$coupon_Amt. ", Commision Amount from total = ".$um_comm_amt
            // . ", UM Earning = ".$um_erning. " Vendor Earning = ".$vendor_erning);

            $params['job_value']        = $total;
            $params['card_total']       = $jobValue;
            $params['tip']              = $card?$card->tip_id:'0';
            $params['coupon_amt']       = $coupon_Amt;
            $params['cash_surcharge']   = $card?$card->cod_charge:'0';
            $params['bank_fees']        = $bank_percentage;
            $params['bank_fees_amt']    = $_f_bnk_amt;            
            $params['um_comission']     = $um_commission;
            $params['um_com_amt']       = $um_comm_amt;
            $params['vendor_earning']   = round($vendor_erning,2);
            $params['um_earning']       = round($um_erning,2);
            $params['card_id']          = $card->id;
            $params['payment_moad']     = $card->payment_moad=='Cash'?'Cash':'Prepaid';            
            
            $vendor_id = $card->accept_user_id;
            $user = User::find($vendor_id);

            if($vendor_id && isset($vendor_id) && $user && isset($user)){
                $vendor_old_balance = $user->wallet_balance;

                if($card->payment_moad=='Cash'){
                    $net_ear = $vendor_old_balance - $um_erning;
                } else {
                    $net_ear = $vendor_old_balance + $vendor_erning;
                }

                $params['net_balance']   = round($vendor_erning,2);    
                
                $user_paramas['wallet_balance'] = round($net_ear,2);

                $user->update($user_paramas);

                $params['vendor_id'] = $vendor_id;  
                
                $res = PayOutBalance::create($params);
              
                // return $this->sendResponse($res, 'Booking Successfully Completed');
            } else {
                return $this->sendError('Vendor not found.');
            }

            if($card->user && $card->user->email){

                if($card && $card->user){
                    $customer = $card->user?$card->user->name:'';
                } else {
                    $customer = 'No Name';
                }

                if($card && $card->service){
                    $service = $card->service?$card->service->name:'';
                } else {
                    $service = 'No Service';
                }

                $array['view']      = 'emails.booking_completed';
                $array['subject']   = 'Booking Confirmation with '.$customer.' for '.$service;
                $array['data']      = $card;
                // \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
            }

            if($card->user && $card->user->name && $card->user->phone){
                $customer_name = $card->user->name;
                $message = "Dear ($customer_name), \nThanks for shopping with us! To help improve our services, please click here https://9a4yhhhzdd7.typeform.com/to/FoG6FNhq to rate your experience. Thank you, Urbanmop.com";
                $msg = urlencode($message);
                $mobile = $card->user->phone;
                // $res=send_sms_to_mobile($mobile,$msg);
            }
            update_booking($card->id);

            if(auth()->user()->role == "staff"){
                exec("php ".base_path()."/artisan send_serice_complete_notification:push ".$card->id." ".auth()->user()->id." > /dev/null 2>&1 & ");
            }else{
                exec("php ".base_path()."/artisan send_serice_complete_notification:push ".$card->id." 0 > /dev/null 2>&1 & ");
            }

            // $user = User::find($card->user_id);

            // if ($user) {
            //     $device_tokens = $user->user_device_token;
            //     $firebase_user_key = $user->firebase_user_key;
            
            //     if (!empty($device_tokens) && $device_tokens != '0') {
            //         if (strlen($device_tokens) > 70) {
            //             // Logic when token length exceeds 70
            //             $title  = "#" . $card->id;
            //             $body   = "Your booking has been completed!";
            //             $text   = "Your booking has been completed!";

            //             if (!empty($firebase_user_key)) {
            //                 $user_firebase_key = $firebase_user_key; 
                                
            //                 $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
            //                     "title" => $title,
            //                     "description" => $body,
            //                     "notificationType" => 'service_complete',
            //                     "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
            //                     "cardId" => (string)$card->id,
            //                     "status" => "1",
            //                     "url" => "",
            //                     "imageURL" => '',
            //                     "read" => "0",
            //                     "seen" => "0",
            //                 ];
            //                 $this->database->getReference()->update($notification_data);

            //                 send_single_notification(
            //                     $device_tokens,
            //                     [
            //                         "title" => $title,
            //                         "body" => $body,
            //                         "icon" => 'myicon',
            //                         "sound" => 'default',
            //                         "click_action" => "EcomNotification",
            //                     ],
            //                     [
            //                         "type" => 'service_complete',
            //                         "notificationID" => time(),
            //                         "status" => "1",
            //                         "imageURL" => "",
            //                         "cardId" => (string)$card->id,
            //                     ]
            //                 );
            //             }
            //         }
            //     }
            // }

            // if(auth()->user()->role == "staff"){
                
            //     $user = User::find(auth()->user()->id);

            //     if ($user) {
            //         $device_tokens = $user->user_device_token;
            //         $firebase_user_key = $user->firebase_user_key;
                
            //         if (!empty($device_tokens) && $device_tokens != '0') {
            //             if (strlen($device_tokens) > 70) {
            //                 // Logic when token length exceeds 70
            //                 $title  = "#" . $card->id;
            //                 $body   = "Your booking has been completed!";
            //                 $text   = "Your booking has been completed!";

            //                 if (!empty($firebase_user_key)) {
            //                     $user_firebase_key = $firebase_user_key; 
                                    
            //                     $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
            //                         "title" => $title,
            //                         "description" => $body,
            //                         "notificationType" => 'booking_started',
            //                         "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
            //                         "cardId" => (string)$card->id,
            //                         "status" => "1",
            //                         "url" => "",
            //                         "imageURL" => '',
            //                         "read" => "0",
            //                         "seen" => "0",
            //                     ];
            //                     $this->database->getReference()->update($notification_data);

            //                     send_single_notification(
            //                         $device_tokens,
            //                         [
            //                             "title" => $title,
            //                             "body" => $body,
            //                             "icon" => 'myicon',
            //                             "sound" => 'default',
            //                             "click_action" => "EcomNotification",
            //                         ],
            //                         [
            //                             "type" => 'booking_started',
            //                             "notificationID" => time(),
            //                             "status" => "1",
            //                             "imageURL" => "",
            //                             "cardId" => (string)$card->id,
            //                         ]
            //                     );
            //                 }
            //             }
            //         }
            //     }
                
            // }

            // $user = User::find($card->accept_user_id);

            // if ($user) {
            //     $device_tokens = $user->user_device_token;
            //     $firebase_user_key = $user->firebase_user_key;
            
            //     if (!empty($device_tokens) && $device_tokens != '0') {
            //         if (strlen($device_tokens) > 70) {
            //             // Logic when token length exceeds 70
            //             $title  = "#" . $card->id;
            //             $body   = "Your booking has been completed!";
            //             $text   = "Your booking has been completed!";

            //             if (!empty($firebase_user_key)) {
            //                 $user_firebase_key = $firebase_user_key; 
                                
            //                 $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
            //                     "title" => $title,
            //                     "description" => $body,
            //                     "notificationType" => 'service_complete',
            //                     "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
            //                     "cardId" => (string)$card->id,
            //                     "status" => "1",
            //                     "url" => "",
            //                     "imageURL" => '',
            //                     "read" => "0",
            //                     "seen" => "0",
            //                 ];
            //                 $this->database->getReference()->update($notification_data);

            //                 send_single_notification(
            //                     $device_tokens,
            //                     [
            //                         "title" => $title,
            //                         "body" => $body,
            //                         "icon" => 'myicon',
            //                         "sound" => 'default',
            //                         "click_action" => "EcomNotification",
            //                     ],
            //                     [
            //                         "type" => 'service_complete',
            //                         "notificationID" => time(),
            //                         "status" => "1",
            //                         "imageURL" => "",
            //                         "cardId" => (string)$card->id,
            //                     ]
            //                 );
            //             }
            //         }
            //     }
            // }
            $method = "";
            if($card->payment_type == 1){
                $method = "Debit/Credit Card";
            } elseif($card->payment_type == 2){
                $method = "Cash";
            } elseif($card->payment_type == 3){
                $method = "Wallet";
            } elseif($card->payment_type == 4){
                $method = "Tabby";
            }
            // $array['view']      = 'emails.service_completed';
            // $array['subject']   = 'Your Service with Urbanmop is Complete!';
            // $array['data']      = $card;
            // \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));

            if($method == 'Cash'){
                return $this->sendResponse([], 'Service Completed on '.$method);
            }else{
                return $this->sendResponse([], 'Service Completed');
            }
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function cod_status(Request $request)
    {
        $card = Card::find($request->booking_id);

        if($card){
            if($request->payment_mode){

                if($request->payment_mode=='Card'){

                    if(isset($request->paymentLinkId)){

                            $data['payment_moad']   = $request->payment_mode;
                            $data['paymentLinkId']  = $request->paymentLinkId;
                            $data['paymentTranId']  = $request->paymentLinkId;
                            $data['pending_approval_by_admin'] = $request->flag;
                            $data['payment_collected']  = 'Yes';
                            $card->update($data);
                            return $this->sendResponse($data, 'Payment Updated');

                    } else {

                        return $this->sendError('Required field is missing.');
                        
                    }

                } else {

                    $data['cod_status']     = $request->cod_status;
                    $data['payment_moad']   = $request->payment_mode;
                    $data['pending_approval_by_admin'] = $request->flag;
                    $data['payment_collected']  = 'Yes';
                    $card->update($data);  
                    return $this->sendResponse($data, 'Payment Updated');                  
                    
                }  

            } else {
                return $this->sendError('Required field is missing.');
            }
            
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function work_done(Request $request)
    {
        $card = Card::find($request->booking_id);

        if($card){
            $data['work_done']  = 'Yes';
            $card->update($data);
            return $this->sendResponse([], 'Work Done');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function booking_canceled_partner(Request $request)
    {
        $card = Card::find($request->booking_id);

        if($card && $card->status != 'Canceled' || $card->status != 'Completed' ){
            $data['status']  = 'Pending';
            $data['accept_user_id'] = 0;
            $card->update($data);
            
            if($card->service_id == 10){
                SessionPackages::where('cart_id', $card->id)->update(['status' => 'Pending']);
            }
            exec("php ".base_path()."/artisan send_all_selle_booking_notification:init ".$card->id." > /dev/null 2>&1 & ");

            $array['view']      = 'emails.booking_cancelled';
            $array['subject']   = 'Booking Has Been Cancelled By Partner';
            $array['data']      = $card;
            \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($array));

            return $this->sendResponse([], 'Booking Cancelled Successfuly!');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function booking_canceled(Request $request)
    {
        $card = Card::find($request->booking_id);

        if($card && $card->status != 'Canceled'){

            if($card->service_id == 10){
                SessionPackages::where('cart_id', $card->id)->update(['status' => 'Canceled']);
            }

            $data['status']  = 'Canceled';
            $card->update($data);


            VendorCardStatus::create([
                'vendor_id'=>auth()->user()->id,
                'card_id'=>$card->id,
                'status'=>'Canceled',
            ]);

            if($card->payment_type == 2){
                 
            } else {
                $customer = User::find($card->user_id);
                $total_amount_total = $card->amount + $card->tip_id + $card->surcharge - $card->coupon_amt;
                $total_amount_total=$total_amount_total;
                $datas = [
                        'user_id' => $card->user_id,
                        'wallet_amount' => $customer->wallet_amount,
                        'amount' => (string)$total_amount_total,
                        'pay_type' => 'REFUND',
                        'type' => 'credit',
                        'pay_method' => 0,
                        'description' => 'Booking Refund for order #'.$card->id,
                    ];
                    
                    if (wallet_history($datas)) {
                        $user = User::find($card->user_id);
                        $user->wallet_balance -= $total_amount_total;
                        $user->save();
                    } 
            }
            $customer = User::find($card->user_id);
            $total_amount_total=25;
            $datas = [
                    'user_id' => $card->user_id,
                    'wallet_amount' => $customer->wallet_amount,
                    'amount' => (string)$total_amount_total,
                    'pay_type' => 'CANCELLATION_CHARGE',
                    'type' => 'debit',
                    'pay_method' => 0,
                    'description' => 'cancellation for order #'.$card->id,
                ];
                
                if (wallet_history($datas)) {
                    $user = User::find($card->user_id);
                    $user->wallet_balance -= $total_amount_total;
                    $user->save();
                }

            $array['view']      = 'emails.booking_cancelled';
            $array['subject']   = 'Your Booking Has Been Cancelled';
            $array['data']      = $card;
            \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));

            return $this->sendResponse([], 'Your booking is successfully cancelled');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function change_slot_and_date_session(Request $request)
    {
        
        if(!empty($request->sessions)){
            
            foreach($request->sessions as $session){
                $card = SessionPackages::find($session['session_id']);
                    
                $data['date']      = $session['date'];
                $data['time']      = $session['slot_id'];
                
                if($session['date'] > date('Y-m-d')){
                    $card_check = Card::find($card->cart_id);
                    if ($card_check && $card_check->accept_user_id) {
                        $data['status']    = 'Upcoming';
                    }else{
                        $data['status'] = 'Pending';
                    }
                    //$data['status']    = 'Upcoming';
                }else if($session['date'] == date('Y-m-d')){
                    $slot = Slot::find($session['slot_id']);
                   
                        $card_check = Card::find($card->cart_id);

                        if ($card_check && $card_check->accept_user_id) {
                            if (Carbon::now()->diffInHours($slot->check_in, false) > 2) {
                                $data['status']    = 'Upcoming';
                            }else{
                                $data['status'] = 'Accept';
                            }
                        } else {
                            $data['status'] = 'Pending';
                        }  
                        
                    
                }
                $card->update($data);
                

                if($card->cart->user && $card->cart->user->email){
                    $array['view']      = 'emails.change_slot_customer';
                    $array['subject']   = 'Slot Changed';
                    $array['data']      = $card;
                    if($card->user){
                        
                        $mail_entry = new MailJobs();
                        $mail_entry->to_email = $card->user->email??'';
                        $mail_entry->subject = 'Slot Changed';
                        $mail_entry->json_array = json_encode($array);
                        $mail_entry->created_at = gmdate('Y-m-d H:i:s');
                        $mail_entry->updated_at = gmdate('Y-m-d H:i:s');
                        $mail_entry->save();
                        exec("php ".base_path()."/artisan mailinit:job ".$mail_entry->id." > /dev/null 2>&1 & ");
                        //\Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
                    }
                }

                if($card->vendor && $card->vendor->email){
                    $array['view']      = 'emails.change_slot_customer';
                    $array['subject']   = 'Slot Changed';
                    $array['data']      = $card;
                    
                    // \Mail::to($card->vendor?$card->vendor->email:'')->send(new \App\Mail\Mail($array));
                }

                $adminarray['view']      = 'emails.change_slot_admin';
                $adminarray['subject']   = 'Slot Changed';
                $adminarray['data']      = $card;
        
                // \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));
            }
            
            $cart_id = SessionPackages::find($request->sessions[0]['session_id'])->cart_id;
            
            // Fetch all sessions with status 'Accept'
            $sessions = SessionPackages::where('cart_id', $cart_id)->get();

            foreach ($sessions as $session) {
                $sessionDate = Carbon::parse($session->date);

                // Check if the session is expired
                $slot = Slot::find($session->time);
                if ($slot && (
                    $sessionDate->isPast() || 
                    ($sessionDate->isToday() && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in)))
                )) {
                    // Update the current session status to 'Expired'
                    // $session->update(['status' => 'Expired']);
                    // Log::info("Update Session ID {$session->id} marked as Expired.");

                    // Find the next session for the same card
                    $nextSessions = SessionPackages::where('cart_id', $session->cart_id)
                    ->whereIn('status',['Pending','Upcoming'])
                    ->where(function ($dateQuery) {
                        $dateQuery->where(DB::raw('DATE(date)'), '=', Carbon::today()->toDateString()) // Allow today's sessions
                        ->whereHas('slot', function ($timeQuery) {
                            $timeQuery->whereRaw("TIME(check_in) > ?", [Carbon::now()->format('H:i:s')]);
                        });
                    })
                    ->get();

                    // Loop through each session and check if it starts within 2 hours from now
                    foreach ($nextSessions as $nextSession) {
                        $nextSlot = Slot::find($nextSession->time);
                        if ($nextSlot) {
                            $nextSessionTime = Carbon::createFromFormat('Y-m-d H:i:s', $nextSession->date . ' ' . $nextSlot->check_in);

                            $card_check = Card::find($nextSession->cart_id);
                            if ($card_check && $card_check->accept_user_id) {
                                if (Carbon::now()->diffInHours($nextSessionTime, false) <= 2) {
                                    // Update the session status to 'Accept'
                                    $nextSession->update(['status' => 'Accept']);
                                    Log::info("Update Session ID {$nextSession->id} marked as Accept.");
                                }else{
                                    
                                    $nextSession->update(['status' => 'Pending']);
                                }
                            }
                        }
                    }
                }
            }
              
           // exec("php ".base_path()."/artisan sessions:update-status > /dev/null 2>&1 & "); 
            
            // Fetch all sessions with status 'Pending'
            $sessions = SessionPackages::whereIn('status', ['Pending','Expired','Upcoming','Accept'])->get();
            
            foreach ($sessions as $session) {
                // Parse the session date
                $sessionDate = Carbon::parse($session->date, 'Asia/Dubai');
            
                // Find the slot for the session
                $slot = Slot::find($session->time);
            
                if ($slot) {
                    // Get the check-in time from the slot
                    $checkInTime = Carbon::createFromFormat('H:i:s', $slot->check_in, 'Asia/Dubai');
                    $currentTime = Carbon::now('Asia/Dubai');
            
                    // Log the session information for debugging
                    Log::info("Testing session ID: {$session->id}");
                    Log::info("Session date: {$sessionDate->toDateString()}");
                    Log::info("Slot check-in time: {$checkInTime->format('H:i:s')}");
                    Log::info("Current time: {$currentTime->format('H:i:s')}");
            
                    // Determine if the session is expired
                    if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                        // If the session date is in the past and not today, mark as Expired
                        Log::info("Session ID {$session->id} marked as Expired (past date).");
                        $session->update(['status' => 'Expired']);
                    } elseif ($sessionDate->isToday() && $currentTime->greaterThanOrEqualTo($checkInTime)) {
                        // If the session date is today and the current time is past the check-in time
                        Log::info("Session ID {$session->id} marked as Expired (past time).");
                        $session->update(['status' => 'Expired']);
                    } else {
                        Log::info("Session ID {$session->id} is not expired.");
                        // if($session->status == 'Expired'){
                        //     $session->update(['status' => 'Pending']);
                        // }
                        
                    }
                } else {
                    Log::warning("No slot found for session ID: {$session->id}");
                }
            }


            
            return $this->sendResponse([], 'Updated successfully');
        } else {
            return $this->sendError('Session not exist.');
        }
       
    }

    public function change_slot_and_date(Request $request)
    {
        $card = Card::where('id', $request->cart_id)
        ->whereIn('status', ['Pending', 'Accept','Expired','Upcoming'])
        ->first();

        if($card){
            $data['slot_id']   = $request->slot_id;
            $data['date']      = $request->date;
            if(date('Y-m-d',strtotime($request->date)) > date('Y-m-d')){
                    if($card->accept_user_id > 0){
                        $data['status']    = 'Upcoming';
                    }else{
                        $data['status']    = 'Pending';
                    }
                    Log::warning("App Upcoming: ".$request->slot_id." : ".$request->cart_id);
                }else if(date('Y-m-d',strtotime($request->date)) == date('Y-m-d')){
                    $slot = Slot::find($request->slot_id);
                    if (Carbon::now()->diffInHours($slot->check_in, false) > 2) {
                        if($card->accept_user_id > 0){
                            $data['status']    = 'Upcoming';
                        }else{
                            $data['status']    = 'Pending';
                        }
                        Log::warning("App Upcoming 2: ".$request->slot_id);
                    }else{
                        if($card->accept_user_id > 0){
                            $data['status']    = 'Accept';
                        }else{
                            $data['status']    = 'Pending';
                        }
                        
                        Log::warning("App Pending: ".$request->slot_id);
                    }
                    
                }
            $card->update($data);
            $cards = Card::with(['user','vendor'])->where('id',$card->id)->get();
            if($card->user && $card->user->email){
                $array['view']      = 'emails.booking_completed';
                $array['subject']   = 'Slot Changed';
                $array['data']      = $cards;
                
                \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));

                }

            if($card->vendor && $card->vendor->email){
                $array['view']      = 'emails.booking_completed_vendor';
                $array['subject']   = 'Slot Changed';
                $array['data']      = $cards;
                $array['user']      = $card->user;
                \Mail::to($card->vendor?$card->vendor->email:'')->cc('sooraj.a2solution@gmail.com')->send(new \App\Mail\Mail($array));
            }

            $adminarray['view']      = 'emails.change_slot_admin';
            $adminarray['subject']   = 'Slot Changed';
            $adminarray['data']      = $card;
           
            // \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));
            
            return $this->sendResponse([], 'Updated successfully');
        } else {
            return $this->sendError('Invalid booking id');
        }
    }

    public function paymentsuccess(Request $request, $orderid='')
    {
        $request['order_id'] = $orderid;
        return $request;
    }

    public function paymentDone(Request $request)
    {
        if($request->card_id){
            if($request->status=='captured'){
        
                // if($request->transactionId=='null' || $request->transactionId == null || $request->transactionId ==''){
                //     // $data['tran_id']    = 'RND-'.rand();
                //     // 11/03/2024 Yash Sir, Lakshay, Mohit

                //     // $ttId = 'RND-'.rand();
                //     // $card_check = Card::find($request->card_id);

                //     // if($card_check && $card_check->paymentLinkId){

                //     //     $curl = curl_init();

                //     //     curl_setopt_array($curl, array(
                //     //       CURLOPT_URL => 'https://business.mamopay.com/manage_api/v1/links/'.$card_check->paymentLinkId,
                //     //       CURLOPT_RETURNTRANSFER => true,
                //     //       CURLOPT_ENCODING => '',
                //     //       CURLOPT_MAXREDIRS => 10,
                //     //       CURLOPT_TIMEOUT => 0,
                //     //       CURLOPT_FOLLOWLOCATION => true,
                //     //       CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                //     //       CURLOPT_CUSTOMREQUEST => 'GET',
                //     //       CURLOPT_HTTPHEADER => array(
                //     //         'Authorization: Bearer sk-3b63062a-a66c-40af-b877-7eda10ce1d32'
                //     //       ),
                //     //     ));

                //     //     $response = curl_exec($curl);

                //     //     curl_close($curl);

                //     //     $response = json_decode($response, true);

                //     //     if($response && $response['charges']){

                //     //         if($response['charges'][0] && $response['charges'][0]['status']=='captured'){

                //     //             $data['tran_id'] = $response['charges'][0]['id'];

                //     //         } else {
                //     //             $data['tran_id']    = $ttId;
                //     //         }

                //     //     } else {
                //     //         $data['tran_id']    = $ttId;
                //     //     }


                //     // } else {
                //     //     $data['tran_id']    = $ttId;
                //     // }

                // } else {
                //     $data['tran_id']    = $request->transactionId;
                // }


                $ttId = 'RND-'.rand();
               
                if($request->paymentLinkId){

                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://business.mamopay.com/manage_api/v1/links/'.$request->paymentLinkId,
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 0,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'GET',
                      CURLOPT_HTTPHEADER => array(
                        'Authorization: Bearer sk-3b63062a-a66c-40af-b877-7eda10ce1d32'
                      ),
                    ));

                    $response = curl_exec($curl);

                    curl_close($curl);

                    $response = json_decode($response, true);

                    if($response && isset($response['charges'])){

                        if($response['charges'][0] && $response['charges'][0]['status']=='captured'){

                            $data['paymentTranId'] = $response['charges'][0]['id'];

                        } else {
                            $data['paymentTranId']    = $ttId;
                        }

                    } else {
                        $data['paymentTranId']    = $ttId;
                    }


                } else {
                    $data['paymentTranId']    = $ttId;
                }

                // $data['tran_id'] = $request->transactionId;

                $data['paymentLinkId'] = $request->paymentLinkId;
                $data['payment_status'] = 'True';
                $data['is_checkout'] = 'Done';

                Card::where('id',$request->card_id)->update($data);

                $card = Card::find($request->card_id);
                $array['view']      = 'emails.invoice';
                $array['subject']   = 'Your Booking Invoice';
                $array['data']      = $card;
                if($card->user && $card->user->email){
                    $res = \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
                }

                $adminarray['view']      = 'emails.invoice';
                $adminarray['subject']   = 'You Have New Service Booking';
                $adminarray['data']      = $card;
               
                \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));

                $tran_id = normalizeId($card->tran_id);
                $message = "Congratulation! You have successfully booked service with UrbanMop. \nYour booking ID is $tran_id \nView booking on UrbanMop \nhttps://www.urbanmop.com \nFor any assistance contact UrbanMop helpline at 052 618 8291 \ 058 581 4007 or send email at booking@urbanmop.com";
                $msg = urlencode($message);
                if($card->user && $card->user->phone){

                    $mobile = $card->user->phone;
                    send_sms_to_mobile($mobile,$msg);

                }

                $ser_users = get_seller_info_by_service($card?$card->service_id:'');
                if($ser_users){
                    foreach ($ser_users as $key => $value) {
                        if(isset($value->device_token)){
                            
                            $token  = $value->device_token;
                                       
                            $service = $card->service?$card->service->name:'No Service';
                                   
                            $title  = 'New Booking Arrived';
                            $body   = "Heads up! A new booking just came in Urbanmop Partner App for '.$service.' Don't miss out on this chance to earn extra money.";
                            $text   = "Heads up! A new booking just came in Urbanmop Partner App for '.$service.' Don't miss out on this chance to earn extra money.";

                            $data = send_notification($token, $title, $body, $text);
                        }
                    }
                }   
                
                return $this->sendResponse([], 'Payment successfully done');
            } else {
                return $this->sendError('Payment Field Try Again.');
            }
        } else {
            return $this->sendError('Card id is required.');
        }
    }

    public function tabby_success(Request $request)
    {
        if($request->card_id){
            if($request->tabby_payment_status){
    
                $data['tabby_payment_status']       = $request->tabby_payment_status;
                $data['tabby_payment_response_id']  = $request->tabby_payment_id;
                $data['payment_status']             = 'True';
                $data['is_checkout']                = 'Done';

                Card::where('id',$request->card_id)->update($data);

                $card = Card::find($request->card_id);
                $array['view']      = 'emails.invoice';
                $array['subject']   = 'You Have New Service Booking';
                $array['data']      = $card;
                if($card->user && $card->user->email){
                    $res = \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
                }

                $adminarray['view']      = 'emails.invoice';
                $adminarray['subject']   = 'You Have New Service Booking';
                $adminarray['data']      = $card;
               
                \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));

                $ser_users = get_seller_info_by_service($card?$card->service_id:'');
                if($ser_users){
                    foreach ($ser_users as $key => $value) {
                        if(isset($value->device_token)){
                            
                            $token  = $value->device_token;
                                       
                            $service = $card->service?$card->service->name:'No Service';
                                   
                            $title  = 'New Booking Arrived';
                            $body   = "Heads up! A new booking just came in Urbanmop Partner App for '.$service.' Don't miss out on this chance to earn extra money.";
                            $text   = "Heads up! A new booking just came in Urbanmop Partner App for '.$service.' Don't miss out on this chance to earn extra money.";

                            $data = send_notification($token, $title, $body, $text);
                        }
                    }
                }   
                
                return $this->sendResponse([], 'Payment successfully done');
            } else {
                return $this->sendError('Payment status is required.');
            }
        } else {
            return $this->sendError('Card id is required.');
        }
    }

    public function tabby_failure(Request $request)
    {
        if($request->card_id){
            if($request->tabby_payment_status){
    
                $data['tabby_payment_status']       = $request->tabby_payment_status;
                $data['tabby_payment_response_id']  = $request->tabby_payment_id;
                $data['payment_status']             = 'False';
                $data['is_checkout']                = 'Done';

                Card::where('id',$request->card_id)->update($data);

                $card = Card::find($request->card_id);
                if($card->user && $card->user->email){
                    $array['view']      = 'emails.booking_faild_customer';
                    $array['subject']   = 'Your Booking Failed';
                    $array['data']      = $card;
                    
                    \Mail::to($card->user?$card->user->email:'')->send(new \App\Mail\Mail($array));
                }

                $adminarray['view']      = 'emails.booking_faild_admin';
                $adminarray['subject']   = 'Booking Failed';
                $adminarray['data']      = $card;
               
                \Mail::to('urbanmop.uae@gmail.com')->send(new \App\Mail\Mail($adminarray));
                
                return $this->sendResponse([], 'Your payment failed. Contact UrbanMop Support');
            } else {
                return $this->sendError('Payment status is required.');
            }
        } else {
            return $this->sendError('Card id is required.');
        }
    }

    public function get_vendor_service($user_id='')
    {
        $seller = Seller::where('user_id',$user_id)->first();
        if($seller){
            $seller_ser = SellerService::where('seller_id',$seller?$seller->id:'')->get();
            $sllr_ser_id = [];
            $datas = [];
            foreach ($seller_ser as $key => $ser_id) {
                array_push($sllr_ser_id, $ser_id->service_id);
            }

            $service = Service::where('status','1')->whereIn('id',$sllr_ser_id)->get();

            foreach ($service as $key => $value) {
                $data['id']     = $value->id;
                $data['title']  = $value->name;
                $data['image']  = asset('/uploads/service/'.$value->thumbnail_img);
                $data['price']  = $value->price;
                array_push($datas, $data);
            }
            return $this->sendResponse($datas, 'Vendor Service');
        } else {
            return $this->sendError('Vendor Not Found.');
        }
    }

    public function financial_calculation(Request $request, $booking_id)
    {
        if($booking_id){
            $card       = Card::find($booking_id);
            $setting    = HomeSetting::first();

            $um_commission      = $setting?$setting->um_commission:'0';
            $bank_percentage    = $setting?$setting->bank_percentage:'0';
            $bank_charges       = $setting?$setting->bank_charges:'0';

            if($card){
                $total = '0';
                foreach (CardAttribute::where('card_id',$card->id)->get() as $key => $crdatr) {
                    $ttotal = $crdatr->attribute_price*$crdatr->attribute_qty;
                    $total += $ttotal;
                }
                
                foreach (CardAddon::where('card_id',$card->id)->get() as $key => $addon) {
                    $attotal = $addon->value;
                    $total += $attotal;
                }

                // Step 1
                $jobValue = $total;

                // Step 2
                if($card && $card->coupon_id){
                    $coupon = CardCoupon::where('card_id',$card->id)->first();
                      if($coupon){
                        $amount = $coupon->amount;
                        if($coupon->type=='Amt'){
                          $coupon_Amt = $amount;
                        } else {
                          $per = ($amount / 100) * $total;

                          if($per>$coupon->max_amount){
                            $coupon_Amt = $coupon->max_amount;
                          } else {
                            $coupon_Amt = $per;
                          }

                        }
                    } else {
                        $coupon_Amt = '00';
                    }
                    $total -= $coupon_Amt;
                    $params['coupon_amt'] = $coupon_Amt;
                }

                // Step 3
                $total -= $card?$card->cod_charge:'0';

                // Step 4
                $total -= $card?$card->tip_id:'0';

                // Step 5
                $um_com_amt = ($um_commission / 100) * $jobValue;
                $total -= round($um_com_amt,2);

                // Step 6
                $bnk_f_amt = ($bank_percentage / 100) * $jobValue;
                $total -= round($bnk_f_amt,2)+$bank_charges;
                 
                // Step 7 
                $net_ear = $total;

                $params['card_id']          = $card->id;
                $params['card_total']       = $jobValue;
                $params['cash_surcharge']   = $card?$card->cod_charge:'0';
                $params['tip']              = $card?$card->tip_id:'0';
                $params['um_comission']     = $um_commission;
                $params['um_com_amt']       = round($um_com_amt,2);
                $params['bank_fees']        = $bank_percentage;
                $params['bank_fees_amt']    = round($bnk_f_amt,2)+'1';
                $params['payment_moad']     = $card->payment_moad=='Cash'?'Cash':'Prepaid';
                $params['net_balance']      = $net_ear;                
                
                $vendor_id = $card->accept_user_id;
                $user = User::find($vendor_id);

                if($vendor_id && isset($vendor_id) && $user && isset($user)){
                    $vendor_old_balance = $user->wallet_balance;

                    if($card->payment_moad=='Cash'){
                        $avl_ven_blc = ($vendor_old_balance-$jobValue)+$net_ear;
                    } else {
                        $avl_ven_blc = $vendor_old_balance+$net_ear;
                    }
                    $user_paramas['wallet_balance'] = $avl_ven_blc;

                    $user->update($user_paramas);

                    $params['vendor_id'] = $vendor_id;   
                    $res = PayOutBalance::create($params);
                    return $this->sendResponse($res, 'Booking Successfully Completed');
                } else {
                    return $this->sendError('Vendor not found.');
                }

            } else {
                return $this->sendError('No Data Found.');
            }
        } else {
            return $this->sendError('Booking id is required.');
        }
    }

    public function remove_coupon($booking_id)
    {
        if($booking_id){

            $data = Card::find($booking_id);

            if($data){
                $params['coupon_id'] = null;
                $data->update($params);
                return $this->sendResponse([], 'Coupon has been removed');
            } else {
                return $this->sendError('Data not found.');
            }

        } else {
            return $this->sendError('Booking id is required.');
        }
    }

    public function get_card_info($booking_id)
    {
        if($booking_id){

            $totalAmount = 0;
            $total_count = 1;
            $surcharge = 0;
            $items = Card::find($booking_id);

            if(!isset($items->user_id)){
                return $this->sendError('User does not exist in booking!');
            }

            if(auth()->user()->role == "customer"){
                if($items->user_id != auth()->user()->id){
                    return $this->sendError('Booking id is invalid!');
                }
            }

            if(auth()->user()->role == "vendor"){
                if($items->accept_user_id > 0){
                    if($items->accept_user_id != auth()->user()->id){
                        return $this->sendError('Sorry, this job is assigned to other provider.');
                    }
                }
            }

            // if(auth()->user()->role == "staff"){
            //     $staff_card = StaffCard::where('card_id', $items->id)
            //     ->where('user_id', auth()->user()->staff->id)
            //     ->exists();
            //     if(!$staff_card){
            //         return $this->sendError('Booking id is invalid!');
            //     }
            // }

            if($items){
                
                $service = Service::find($items->service_id);
                $check = StaffCard::where('card_id', $items->id)->with(['user', 'card']);

                if ($check->exists()) {
                    $data['added_staff'] = $check->get()->map(function ($staffCard) {
                
                        return [
                            'status' => $staffCard->card->status ?? null,
                            'id' => $staffCard->user_id ?? null,
                            'user_id' => $staffCard->staff->user_id ?? null,
                            'first_name' => $staffCard->staff->first_name ?? null,
                            'last_name' => $staffCard->staff->last_name ?? null,
                            'phone' => $staffCard->staff->phone ?? null,
                            'dial_code' => $staffCard->staff->dial_code ?? null,
                            'userFirebaseKey' => $staffCard->user->firebase_user_key ?? null,
                        ];
                    })->toArray();
                    $data['payment_type'] = $items->payment_type;
                } else {
                    $data['added_staff'] = [];
                    $data['payment_type'] = $items->payment_type;
                }
                
                $user = User::find($items->user_id);
                $provider = User::find($items->accept_user_id);
                $provider_address   = Address::where(['user_id'=> $items->accept_user_id])->latest()->first();
                $user_address       = Address::where(['user_id' => auth()->user()->id])->first();
    
                $datas['parent_cart_id'] = (string) optional(Card::where('revisit_id', $booking_id)->first())->id ?? "";                ;
                $data['parent_cart_id'] = (string) optional(Card::where('revisit_id', $booking_id)->first())->id ?? "";                ;

                $data['disclaimer'] = "It is recommended to schedule a revisit after 21 days to ensure the effectiveness of pesticide activation.";
                $datas['disclaimer'] = "It is recommended to schedule a revisit after 21 days to ensure the effectiveness of pesticide activation.";
                if($items->status != 'Completed' && $items->revisit_id != null){
                    $data['show_revisit_button'] = "0";
                    $data['show_disclaimer'] = "0";
                } else {
                    $cardDate = Carbon::parse($items->service_completed_date); 
                    $daysDifference = $cardDate->diffInDays(Carbon::now(), false);
                    if ($daysDifference < 90) {
                        $data['show_revisit_button'] = "1";
                    } else {
                        $data['show_revisit_button'] = "0";
                    }
                    $cardDate = Carbon::parse($items->service_completed_date); 
                    $daysDifference = $cardDate->diffInDays(Carbon::now(), false);
                    if ($daysDifference < 21) {
                        $data['show_disclaimer'] = "1";
                    } else {
                        $data['show_disclaimer'] = "0";
                    }
                }
                if($items->is_revisit == 0){
                    $datas['revisit_cart'] = (object) [];
                }else{
                    if($items->revisit_id != null){
                        $item = Card::find($items->revisit_id);
                        $totalAmount = 0;
                        $total_count = 1;
                        $service = Service::find($item->service_id);
                        $user = User::find($item->user_id);
                        $provider = User::find($item->accept_user_id);
                        $provider_address   = Address::where('user_id', $item->accept_user_id)->first();
                        $user_address       = Address::where('user_id', $user->id)->first();

                        $datas['user_latitude'] = (string) ($user_address->latitude ?? '');
                        $datas['user_longitude'] = (string) ($user_address->longitude ?? '');
                        $datas['provider'] = (object) $provider;
                        $datas['provider_latitude'] = (string) ($provider_address->latitude ?? '');
                        $datas['provider_longitude'] = (string) ($provider_address->longitude ?? '');
                        $datas['is_reviewed'] = Review::where([
                            'customer_id' => auth()->user()->id, 
                            'booking_id' => $item->id
                        ])->exists() ? '1' : '0';


                        $category = Category::find($item->category_id);

                        $datas['id']             = (string) $item->id;
                        if(isset($item->tabby_payment_response_id)){
                            $datas['tran_id']    = $item->tabby_payment_response_id;
                        } elseif (isset($item->paymentTranId)) {
                            $datas['tran_id']    = $item->paymentTranId;
                        } else {
                            $input = [
                                'customer_id' => $item->user_id,
                                'vendor_id' => Seller::where("user_id", $item->accept_user_id)->first()->seller_id ?? null
                            ];
                            
                            $transection = Transection::where($input)->first();
                            $datas['tran_id'] = $transection ? normalizeId($transection->id) : normalizeId($item->tran_id);                
                        }

                        $datas['user_id']        = (string) $item->user_id;
                        $datas['user_name']      = $user ? $user->name : '';
                        $datas['user_email']     = $user ? $user->email : '';
                        $datas['user_mobile']    = $user ? $user->phone : '';
                        //$datas['user_mobile']    = '000000000';
                        $datas['user_dial_code']    = $user ? $user->dial_code : '971';
                        $datas['service_id']     = (string) $item->service_id;
                        $datas['accept_user_id'] = $item->accept_user_id;
                        $datas['service']        = $service->name;
                        $datas['image']          = asset('uploads/service/'.$service->thumbnail_img);
                        $datas['category_id']    = $item->category_id;
                        $datas['category']       = $category ? $category->name : '';
                        $datas['slot_id']        = $item->slot_id;
                        $datas['slot']           = Slot::find($item->slot_id)->name ?? '';
                        $datas['offline_charge'] = $item->offline_charge;
                        $datas['offline_discount'] = $item->offline_discount;

                        // Other details (same as before)
                        $datas['payment_moad']   = $item->payment_moad;
                        $datas['payment_status'] = $item->payment_status;
                        $datas['note']           = $item->note;
                        $datas['material_charge']= (string) $item->material_charge;
                        $datas['material_status']= $item->material_status;
                        $datas['service_type']   = $item->service_type;
                        $datas['alternative_dial_code']  = $item->alternative_dial_code;
                        $datas['alternative_number'] = $item->alternative_number;
                        //$datas['alternative_number'] =  "000000000";
                        $datas['date']           = $item->date;
                        $datas['tip']            = $item->tip_id;
                        $datas['coupon_id']      = $item->coupon_id;
                        $datas['is_checkout']    = $item->is_checkout;
                        $datas['status']         = $item->status;
                        $datas['sub_total']       = $item->g_total;
                        $order = Order::find($item->order_id); 

                        $cod = (int) $item->cod;
                
                        $surcharge = (float) $item->surcharge;

                        if(!empty($datas['parent_cart_id'])){
                            $datas['amount_total'] = (string) 0;
                        } else {
                            
                            if($item->payment_type == 2){
                                $datas['amount_total'] = (string)
                                    ((float) ($item->amount + $surcharge + $cod ?? 0) - 
                                    (float) ($order->coupon_amount ?? 0) + 
                                    (float) ($order->tip_amount ?? 0) - ($item->offline_discount??0));
            
                            }else{
                                    
                                $datas['amount_total'] = (string)
                                ((float) ($item->amount + $surcharge ?? 0) - 
                                (float) ($order->coupon_amount ?? 0) + 
                                (float) ($order->tip_amount ?? 0) - ($item->offline_discount??0) );
                            }
                        }
            

                        $datas['pending_approval_by_admin'] = $item->pending_approval_by_admin;

                        // Card attributes logic (same as before)
                        $card_attr = [];
                        $c = 0;
                        $material_total = 0;
                        $total_maids_material = 0;
                        $material_default = ($item->material_status == "Apply") ? (float) $item->material_price : 0;
                        foreach (CardAttribute::where('card_id', $item->id)->get() as $value) {
                            if(!isset($value->sub_cate_id)){
                                $is_maid = 1;
                                $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                                $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                                $attribute = Attribute::where('id',$services->attribute_id)->first();
                                $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                                
                                $params['attribute_price']      = $services->attribute_price ?? null;
                                $params['attribute_qty']        = $value->attribute_qty ?? null;
                                $params['service_type']         = '';
                                
                                $datas["attribute"][] = [
                                    "category"=>Category::find($service_item->category_id)->name ?? "",
                                    "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                                    "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                    "name"=>$attribute_item->value ?? "",
                                    "price"=>(string) $value->attribute_price,
                                    "qty"=>(string) $value->attribute_qty];
                                $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                                
                                if($attribute->name == 'Hours'){
                                    $totalAmount *= (int) $attribute_total; 
                                } else {
                                    
                                    $totalAmount += $attribute_total; 
                                }
                                
                                preg_match('/\d+/', $attribute_item->value, $matches);

                                if (count($matches) > 0) {
                                    $number = (int) $matches[0];
                                    $total_count *= $number;
                                    
                                    $total_maids_material *= $number;
                                    if ($attribute->name == 'Hours') {
                                    } else {
                                    }
                                }

                            } else {
                                if(empty($value->child_category_id)){
                                    $service_item = ServiceAttributeValueItem::where([
                                        'service_id'=>$item->service_id,
                                        'category_id'=>$value->main_sub_cat_id,
                                        'sub_category_id'=>$value->sub_cate_id
                                    ])->first();
                                } else{
                                    $service_item = ServiceAttributeValueItem::where([
                                        'service_id'=>$item->service_id,
                                        'category_id'=>$value->main_sub_cat_id,
                                        'sub_category_id'=>$value->sub_cate_id,
                                        'child_category_id'=>$value->child_cate_id,
                                    ])->first();
                                }
                                if(!empty($service_item)){
                                    $services = ServiceAttributeValue::where([
                                        // 'ser_attr_val_item_id'=>$service_item->id,
                                        'attribute_item_id'=>$value->attribute_item_id,
                                    ])->first();
                                    $attribute = Attribute::where('id',$services->attribute_id)->first();
                                    $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                                    
                                    $params['attribute_price']      = $services->attribute_price ?? null;
                                    $params['attribute_qty']        = $value->attribute_qty ?? null;

                                    $datas["attribute"][] = [
                                        "category"=>Category::find($service_item->category_id)->name,
                                        "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                        "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                        "name"=>$attribute_item->value ?? "",
                                        "price"=>(string) $value->attribute_price,
                                        "qty"=>(string) $value->attribute_qty];
                                
                                    
                                    $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                                    
                                    if($attribute->name == 'Hours'){
                                        $totalAmount *= (float) $attribute_total; 
                                    } else {
                                        
                                        $totalAmount += (float) $attribute_total; 
                                    }

                                    preg_match('/\d+/', $attribute_item->value, $matches);

                                    if (count($matches) > 0) {
                                        $number = (int) $matches[0];
                                        $total_count *= $number;
                                    
                                        $total_maids_material *= $number;
                                        if ($attribute->name == 'Hours') {
                                        } else {
                                        }
                                    }
                                    
                                } 
                                $params['service_type']         = '';
                            } 
                            $sub_cat = Category::find($value->sub_cate_id);
                            $child_cat = ChildCategory::find($value->child_cate_id);

                            $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                            $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                            $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                            $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                            $paramss['child_cate_id']        = (string) $value->child_cate_id;
                            $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                            $paramss['attribute_id']         = (string) $value->attribute_id;
                            $paramss['attribute_name']       = $value->attribute_name;
                            $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                            $paramss['attribute_item_name']  = $value->attribute_item_name;
                            $paramss['attribute_qty']        = (string) $value->attribute_qty;
                            $paramss['attribute_price']      = (string) $value->attribute_price;
                            $paramss['service_type']         = $value->service_type;
                            $paramss['unit_price']         = $value->unit_price??0;
                            array_push($card_attr,$paramss);
                        }

                        $datas['card_attribute'] = $card_attr;

                        if($item->service_id == 10){
                            $material_total = $total_maids_material;
                        } else {
                            $material_total = $material_total;
                        }
                        $material = ($item->material_status == "Apply") ? (float) $material_total : "0";

                        $data['revisit_cart'] = $datas;
                    }
                }

                $matchedSession = $items->sessionPackages->first(function ($session) {
                    return Carbon::parse($session->date)->gte(Carbon::today());
                });
                
                $data['matched_session_id'] = $matchedSession ? (string) $matchedSession->id : null;
    
                $matchedSession = $items->sessionPackages->first(function ($sessionPackage) {
                    $status = $sessionPackage->status;
                
                    // Exclude sessions with a status of 'Canceled'
                    if ($status != 'Canceled') {
                        // if (!is_null($sessionPackage->date)) {
                        //     $sessionDate = Carbon::parse($sessionPackage->date);
                
                        //     if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                        //         // If the session date is in the past and not today, mark as Expired
                        //         return false;
                        //     } elseif ($sessionDate->isToday()) {
                        //         // If the session date is today, check the session time
                        //         $slot = Slot::find($sessionPackage->time);
                        //         if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                        //             // Mark as expired if current time is past the session time
                        //             return false;
                        //         }
                        //     }
                        // }
                        return true; // Session is valid
                    }
                    return false; // Session is not valid
                });
                
                $data['active_current_session'] = $matchedSession ? (string) $matchedSession->id : null;
                

                $data['provider'] = (object) $provider;
                $data['provider_address'] = (object) ($provider_address);
                $data['provider_latitude'] = (string) ($provider_address->latitude ?? '');
                $data['provider_longitude'] = (string) ($provider_address->longitude ?? '');
        
                $category = Category::find($items->category_id);

                $data['ratings']        = (object) Review::where(['customer_id' => auth()->user()->id, 'service_id' => $service->id])->get();
                $data['id']             = (string) $items->id;
                $data['booking_id']     = (string) $items->id;
                if($items->payment_type != 2){

                if(isset($items->tabby_payment_response_id)){
                    $data['tran_id']    = (string) $items->tabby_payment_response_id;
                } elseif (isset($items->paymentTranId)) {
                    $data['tran_id']    = (string) $items->paymentTranId;
                } else {
                    $input = [
                        'customer_id' => $items->user_id,
                        'vendor_id' => Seller::where("user_id", $items->accept_user_id)->first()->seller_id ?? null
                    ];
                    
                    $transection = Transection::where($input)->first();
                    $data['tran_id'] = $transection ? (string) normalizeId($transection->id) : normalizeId($items->tran_id);     
                }
            }

                $data['is_reviewed'] = Review::where([
                    'customer_id' => auth()->user()->id, 
                    'booking_id' => $items->id
                ])->exists() ? '1' : '0';                
                $data['user_id']        = (string) $items->user_id; 
                $data['user_name']      = $user?$user->name:'';
                $data['user_email']     = $user?$user->email:'';
                $data['user_mobile']    = $user?$user->phone:'';
                //$data['user_mobile']    = '000000000';
                $data['user_dial_code']    = $user ? $user->dial_code : '971';
                $data['service_id']     = (string) $items->service_id;
                $data['service']        = $service->name;
                $data['video']          = $service->video ?? "";
                $data['info']           = $service->info ?? "";
                $data['video_title']    = $service->video_title ?? "";
                $data['video_description']  = $service->video_description ?? "";
                $data['image']          = asset('/uploads/service/'.$service->thumbnail_img);
                $data['category_id']    = $items->category_id;
                $data['category']       = $category?$category->name:'';
                $data['slot_id']        = $items->slot_id;
                $data['slot']           = $items->slot?$items->slot->name:'';


                if(is_numeric($items->address_id)){

                    $data['address_id']     = $items->address_id;

                    $building = $items->address?$items->address->building:'';
                    $flat_no = $items->address?$items->address->flat_no:'';
                    $address = $items->address?$items->address->address:'';

                    $latitude = $items->address?$items->address->latitude:'';
                    $longitude = $items->address?$items->address->longitude:'';
                    $data['address']        = $building.', '. $flat_no.', '.$address;

                    $data['user_address'] = $items->address;
                    $data['user_latitude'] = (string) ($latitude ?? '');
                    $data['user_longitude'] = (string) ($longitude ?? '');

                    if($items->address && $items->address->city){
                        $city = $items->address->city->name;
                    } else {
                        $city = "";
                    }

                    $data['city']           = $city;

                    if($items->address && $items->address->locality_info){
                        $locality = $items->address->locality_info->name;
                    } else {
                        $locality = "";
                    }
                    $data['locality']       = $locality;
                    
                    $data['latitude']       = $latitude;
                    $data['longitude']      = $longitude;

                } else {

                    $add_info = json_decode($items->address_id);

                    $data['address_id']     = '';


                    $building = $add_info?$add_info->building:'';
                    $flat_no = $add_info?$add_info->flat_no:'';
                    $address = $add_info?$add_info->address:'';

                    $latitude = $add_info?$add_info->latitude:'';
                    $longitude = $add_info?$add_info->longitude:'';
                    $data['address']        = $building.', '. $flat_no.', '.$address;
                    $data['user_address']        = (array) $add_info;
                    
                    
                    $data['user_latitude'] = (string) ($latitude ?? '');
                    $data['user_longitude'] = (string) ($longitude ?? '');

                    if($add_info && isset($add_info->city->name)){
                        $city = $add_info->city->name??'';
                    } else {
                        $city = "";
                    }

                    $data['city']           = $city;

                    if($add_info && $add_info->locality){
                        $locality = $add_info->locality;
                    } else {
                        $locality = "";
                    }
                    $data['locality']       = $locality;
                    
                    $data['latitude']       = $latitude;
                    $data['longitude']      = $longitude;

                }


                $data['payment_moad']   = $items->payment_moad;
                $data['payment_status'] = $items->payment_status;
                $data['note']           = $items->note;
                $data['material_status']= $items->material_status;
                $data['service_type']   = $items->service_type;
                $data['alternative_dial_code']  = $items->alternative_dial_code;
                $data['alternative_number'] = $items->alternative_number;
                //$data['alternative_number'] = "000000000";
                $data['date']           = $items->date;
                $data['tip']            = (string) $items->tip_id;
                $data['coupon_id']      = (string) $items->coupon_id;
                $data['is_checkout']    = $items->is_checkout;
                $data['accept_vendor']  = $items->vendor?$items->vendor->name:'';
                $data['accept_vendor_id']  = (string) $items->accept_user_id;
                $data['offline_charge']  = $items->offline_charge;
                $data['offline_discount']  = $items->offline_discount;
                $data['payment_collected']  = $items->payment_collected;
                $data['service_start_datetime']  = $items->service_start_datetime;
                $data['service_completed']  = $items->service_completed;
                $data['service_completed_date']  = $items->service_completed_date;
                $data['work_done']  = $items->work_done;
                $data['cod_status']  = $items->cod_status;
                $data['material_status']  = $items->material_status;
                $data['material_charge']  = (string) $items->material_charge;
                $data['service_type']  = $items->service_type;
                $data['booking_from']  = $items->booking_from;
                $data['cencal_date']  = $items->cencal_date;
                $data['pending_approval_by_admin']  = $items->pending_approval_by_admin;
                $material_default = ($items->material_status == "Apply") ? (float) $service->material_price : 0;
            
                $card_attr = [];
                $c = 0;
                $material_total = 0;
                $total_count = 1;
                $total_maids_material = 1;
                $surcharge = 0;
                $surcharge += (float) $items->surcharge;

                $cod = (int) $items->cod;

                foreach (CardAttribute::where('card_id', $items->id)->get() as $value) {
                    if(!isset($value->sub_cate_id)){
                        $is_maid = 1;
                        $services = ServiceAttributeValue::where('attribute_item_id',$value->attribute_item_id)->first();
                        $service_item = ServiceAttributeValueItem::where('id',$services->ser_attr_val_item_id)->first();
                        $attribute = Attribute::where('id',$services->attribute_id)->first();
                        $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                        
                        $params['attribute_price']      = $services->attribute_price ?? null;
                        $params['attribute_qty']        = $value->attribute_qty ?? null;
                        $params['service_type']         = '';
                        
                        $data["attribute"][] = [
                            "category"=>Category::find($service_item->category_id)->name ?? "",
                            "sub_category"=>Category::find($service_item->sub_category_id)->name ?? "",
                            "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                            "name"=>$attribute_item->value ?? "",
                            "price"=>(string) $services->attribute_price,
                            "qty"=>(string) $value->attribute_qty];
                        $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                        
                        if($attribute->name == 'Hours'){
                            // $totalAmount *= (int) $attribute_total; 
                        } else {
                            
                            // $totalAmount += $attribute_total; 
                        }
                        
                        preg_match('/\d+/', $attribute_item->value, $matches);
                
                        if (count($matches) > 0) {
                            $number = (int) $matches[0];
                            $total_count *= $number;
                            
                            $total_maids_material *= $number;
                            if ($attribute->name == 'Hours') {
                            } else {
                            }
                        }
                
                    } else {
                        if(empty($value->child_category_id)){
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$items->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id
                            ])->first();
                        } else{
                            $service_item = ServiceAttributeValueItem::where([
                                'service_id'=>$items->service_id,
                                'category_id'=>$value->main_sub_cat_id,
                                'sub_category_id'=>$value->sub_cate_id,
                                'child_category_id'=>$value->child_cate_id,
                            ])->first();
                        }
                        if(!empty($service_item)){
                            $services = ServiceAttributeValue::where([
                                // 'ser_attr_val_item_id'=>$service_item->id,
                                'attribute_item_id'=>$value->attribute_item_id,
                            ])->first();
                            $attribute = Attribute::where('id',$services->attribute_id)->first();
                            $attribute_item = AttributeValue::where('id',$value->attribute_item_id)->first();
                            
                            $params['attribute_price']      = $services->attribute_price ?? null;
                            $params['attribute_qty']        = $value->attribute_qty ?? null;
                
                            $data["attribute"][] = [
                                "category"=>Category::find($service_item->category_id)->name,
                                "sub_category"=>Category::find($service_item->sub_category_id)->name,
                                "child_category"=>ChildCategory::find($service_item->child_category_id)->name ?? "",
                                "name"=>$attribute_item->value ?? "",
                                "price"=>(string) $value->attribute_price,
                                "qty"=>(string) $value->attribute_qty];
                        
                            
                            $attribute_total = $params['attribute_price'] * $params['attribute_qty'];
                            
                            if($attribute->name == 'Hours'){
                                // $totalAmount *= (float) $attribute_total; 
                            } else {
                                
                                // $totalAmount += (float) $attribute_total; 
                            }
                
                            preg_match('/\d+/', $attribute_item->value, $matches);
                
                            if (count($matches) > 0) {
                                $number = (int) $matches[0];
                                $total_count *= $number;
                            
                                $total_maids_material *= $number;
                                if ($attribute->name == 'Hours') {
                                } else {
                                }
                            }
                            
                        } 
                        $params['service_type']         = '';
                    } 
                    $sub_cat = Category::find($value->sub_cate_id);
                    $child_cat = ChildCategory::find($value->child_cate_id);
                
                    $paramss['sub_cate_id']          = (string) $value->sub_cate_id;
                    $paramss['sub_cate_name']        = $child_cat?$child_cat->name:'';
                    $paramss['main_sub_cat_id']      = (string) $value->main_sub_cat_id;
                    $paramss['main_sub_cat_name']    = $value->main_sub_cat?$value->main_sub_cat->name:'';
                    $paramss['child_cate_id']        = (string) $value->child_cate_id;
                    $paramss['child_cate']           = $value->child_cate?$value->child_cate->name:'';
                    $paramss['attribute_id']         = (string) $value->attribute_id;
                    $paramss['attribute_name']       = $value->attribute_name;
                    $paramss['attribute_item_id']    = (string) $value->attribute_item_id;
                    $paramss['attribute_item_name']  = $value->attribute_item_name;
                    $paramss['attribute_qty']        = (string) $value->attribute_qty;
                    $paramss['attribute_price']      = (string) $value->attribute_price;
                    $paramss['service_type']         = $value->service_type;
                    $paramss['unit_price']         = $value->unit_price??0;
                    array_push($card_attr,$paramss);
                }
                if($items->service_id == 10){
                    $material_total = $total_maids_material;
                } else {
                    $material_total = $material_total;
                }
                $material = ($items->material_status == "Apply") ? (float) $material_total : "0";
                $totalAmount = (float) $items->amount;
                
                $data['status'] = $items->status;
                                
                if($items->service_id == 10){  

                    if(isset($items->selected_packages) ){
                        $totalAmount = 0;            
                        $selectedPackageIds = explode(',', $items->selected_packages);

                        $packages = Packages::whereIn('id', $selectedPackageIds)->get();

                        foreach ($packages as $package) {
                            
                            $datas['is_package'] = "1";
                            $datas["packages"][] = [
                                "name"=>$package->name, 
                                "base_amount"=>(string) $package->amount,
                                "price"=>(string) ((int) $package->amount * (int) $total_count),
                                "save_amount"=>(string) ((int) $package->save_amount * (int) $total_count)
                            ]; 
                            
                            $totalAmount = ((int) $package->amount * (int) $total_count) -(float)$value->coupon_amt; 
                            $material *= ((int) $package->total_sessions + (int) $package->free_sessions);
                    
                        }
                    } else {
                    
                        $datas['is_package'] = "0";
                        $datas['packages'] = [];
                    }

                    $free_sessions = 0;
                    $per_week = 0;
                    $total_sessions = 0;
                    $is_package = 0;
                    
                    $completed_session = SessionPackages::with('package')
                    ->where(['cart_id' => $items->id, 'status' => 'Completed'])
                    ->count();

                    $datas['status']         = $items->status;
                    $sessions = SessionPackages::with(['package', 'slot'])
                    ->where('cart_id', $items->id)
                    ->orderBy('date') // Order by date
                    ->get()
                    ->map(function ($sessionPackage) {
                        $addedStaff = \DB::table('staff_sessions')
                            ->join('staff', 'staff.id', '=', 'staff_sessions.user_id')
                            ->where('staff_sessions.session_id', $sessionPackage->id)
                            ->select(
                                'staff.id',
                                'staff.user_id',
                                'staff.first_name',
                                'staff.last_name',
                                'staff.phone',
                                'staff.dial_code',
                                'staff_sessions.status as staff_session_status'
                            )
                            ->get();
                
                        return [
                            'session_id' => (string) $sessionPackage->id,
                            'package_id' => $sessionPackage->package_id,
                            'package' => $sessionPackage->package,
                            'slot' => $sessionPackage->slot,
                            'date' => $sessionPackage->date,
                            'status' => $sessionPackage->status,
                            'time' => $sessionPackage->time,
                            'added_staff' => $addedStaff,
                        ];
                    });
                
                    $sessions = $sessions->sortBy(function ($session) {
                        return [$session['date'], (int) $session['time']];
                    })->values();
                

                    $allSessionsExpired = collect($sessions)->every(function ($session) {
                        if (!is_null($session['date'])) {
                            $sessionDate = Carbon::parse($session['date']);
                            if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                                // If the date is in the past and not today, the session is expired
                                return true;
                            } elseif ($sessionDate->isToday() && isset($session['slot']['check_in'])) {
                                // If the date is today, check the session time
                                return Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $session['slot']['check_in']));
                            }
                        }
                        return false;
                    });
                    
                    // Check if all sessions have the same status
                    $allSameStatus = collect($sessions)->pluck('status')->unique()->count() == 1;
                    $sameStatus = $allSameStatus ? $sessions[0]['status'] : null;
                    
                    if($sameStatus == 'Canceled'){
                        if ($allSameStatus && $sameStatus) {
                            $data['status'] = $sameStatus;
                        } else {
                            $data['status'] = $items->status;
                        }   
                    } else {
                        if ($allSameStatus && $sameStatus) {
                            $data['status'] = $sameStatus;
                        } else {
                            $data['status'] = $items->status;
                        }  
                    }           

                    foreach ($sessions as $session) {
                        // Check if package exists
                        if ($session['package']) {
                            $total_sessions = $session['package']['total_sessions'] ?? 0;
                            $free_sessions = $session['package']['free_sessions'] ?? 0;
                            $per_week = $session['package']['per_week'] ?? 0;
                        }
                    }

                    $data['session_history'] = (object) [
                        'total_sessions' => (string)$total_sessions,
                        'free_sessions' => $free_sessions,
                        'per_week' => $per_week,
                        'sessions' => $sessions,
                        'completed_session' => (string) $completed_session,
                    ];


                } else {
                    
                    $data['session_history'] = (object) [];
                    $data['is_package'] = "0";
                    $data['packages'] = [];

                    // if (!is_null($items->date)) {
                    //     $itemDate = Carbon::parse($items->date);

                    //     if ($itemDate->isPast() && !$itemDate->isToday()) {
                    //         // If the session date is in the past and not today, mark as Expired
                    //         $data['status'] = 'Expired';
                    //     } elseif ($itemDate->isToday()) {
                    //         // If the session date is today, check the session time
                    //         $slot = Slot::find($items->slot_id);
                    //         if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                    //             $data['status'] = 'Expired';
                    //         }
                    //     } else {
                    //         $data['status'] = $items->status;
                    //     } 
                    // }
                    
                }

                $material *= $material_default;
                $totalAmount += (float) $items->material_charge ?? 0;
                $data['subtotal'] = (string) $totalAmount;
                if($items->payment_type == 2){
                    $totalAmount += (float) $cod;
                    $data['cod_charge'] = (string) $cod;
                }
                $totalAmount += (float) $surcharge;
                $data['surcharge'] = (string) $surcharge;

                $totalAmount = number_format($totalAmount, 2, '.', '');

                $totalAmount += (float) $items->tip_id;
                $totalAmount -= (float) $items->coupon_amt;
                if($items->offline_discount > 0){
                    $totalAmount= $totalAmount - $items->offline_discount;
                }
                $data['material_charge'] = (string)  $items->material_charge ?? 0;

                $data['coupon']         = $items->coupon?$items->coupon->code:'';
                
                if(empty($datas['parent_cart_id'])){
                    $data['coupon_amt']     = $items->coupon_amt;
                    $data['coupon_amount']  = $items->coupon_amt;
                    $data['tip_amount']     = $items->tip_id;
                }else {
                    $data['coupon_amt']     = "0";
                    $data['coupon_amount']  = "0";
                    $data['tip_amount']     = "0";
                }
                

                $totalAmount = number_format($totalAmount, 2, '.', '');
                
                if(!empty($datas['parent_cart_id'])){
                    $data['total']          = (string) 0;
                    $data['total_amount']          = (string) 0;
                } else {
                    $data['total']          = (string) $totalAmount;
                    $data['total_amount']          = (string) $totalAmount;
                }

                $data['card_attribute'] = $card_attr;
                $isMuted = BellBookingUser::where(['user_id' => auth()->user()->id, 'booking_id' => $items->id])->value('is_bell');
                $data['is_bell'] = $isMuted ? (string) $isMuted : "0";

                $data['preffered_days'] = $items->preffered_days;
                $data['tran_id'] = (string) normalizeId($items->tran_id);
                $card_id = $items->id;

                if ($items->service_id == 10) {
                    $selectedPackageIds = explode(',', $items->selected_packages);
                    $data['package_id'] = $selectedPackageIds[0];
                    $data["time"] = ($items->slot_id) ? Slot::find($items->slot_id)->name : "";

                    $completed_session = SessionPackages::with('package')
                        ->where(['cart_id' => $card_id, 'status' => 'Completed'])
                        ->count();

                    $free_sessions = 0;
                    $per_week = 0;
                    $total_sessions = 0;
                    $is_package = 0;

                    // Initialize packages array to avoid duplicate entries
                    $data["packages"] = [];

                        
                    $sessions = SessionPackages::with(['package', 'slot'])
                    ->where('cart_id', $card_id)
                    ->orderBy('date')
                    ->get()
                    ->map(function ($sessionPackage) {
                        // Fetch staff details with the status from staff_sessions
                        $addedStaff = \DB::table('staff_sessions')
                            ->join('staff', 'staff.id', '=', 'staff_sessions.user_id')
                            ->where('staff_sessions.session_id', $sessionPackage->id)
                            ->select(
                                'staff.id',
                                'staff.user_id',
                                'staff.first_name',
                                'staff.last_name',
                                'staff.phone',
                                'staff.dial_code',
                                'staff_sessions.status as staff_session_status'
                            )
                            ->get();

                            $status = $sessionPackage->status;

                            // if (!is_null($sessionPackage->date)) {
                            //     $sessionDate = Carbon::parse($sessionPackage->date);

                            //     if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                            //         // If the session date is in the past and not today, mark as Expired
                            //         $status = 'Expired';
                            //     } elseif ($sessionDate->isToday()) {
                            //         // If the session date is today, check the session time
                            //         $slot = Slot::find($sessionPackage->time);
                            //         if ($slot && Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $slot->check_in))) {
                            //             $status = 'Expired';
                            //         }
                            //     } else {
                            //         $status = $sessionPackage->status;
                            //     } 
                            // }

                        return [
                            'session_id' => (string) $sessionPackage->id,
                            'package_id' => $sessionPackage->package_id,
                            'package' => convert_all_elements_to_string($sessionPackage->package->toArray()), 
                            'slot' => $sessionPackage->slot, 
                            'date' => $sessionPackage->date,
                            'time' => $sessionPackage->time,
                            'status' => $status,
                            'added_staff' => $addedStaff,
                        ];
                    });

                    $sessions = $sessions->sortBy(function ($session) {
                        return [$session['date'], (int) $session['time']];
                    })->values();
                    
                 
                    $allSessionsExpired = collect($sessions)->every(function ($session) {
                        if (!is_null($session['date'])) {
                            $sessionDate = Carbon::parse($session['date']);
                            if ($sessionDate->isPast() && !$sessionDate->isToday()) {
                                // If the date is in the past and not today, the session is expired
                                return true;
                            } elseif ($sessionDate->isToday() && isset($session['slot']['check_in'])) {
                                // If the date is today, check the session time
                                return Carbon::now()->greaterThanOrEqualTo(Carbon::createFromFormat('H:i:s', $session['slot']['check_in']));
                            }
                        }
                        return false;
                    });
                    
                    // Check if all sessions have the same status
                    $allSameStatus = collect($sessions)->pluck('status')->unique()->count() == 1;
                    $sameStatus = $allSameStatus ? $sessions[0]['status'] : null;
                    
                    if($sameStatus == 'Canceled'){
                        if ($allSameStatus && $sameStatus) {
                            $data['status'] = $sameStatus;
                        } else {
                            $data['status'] = $items->status;
                        }   
                    } else {
                        if ($allSameStatus && $sameStatus) {
                            $data['status'] = $sameStatus;
                        } else {
                            $data['status'] = $items->status;
                        }  
                    }           

                
                    foreach ($sessions as $session) {
                        // Check if package exists
                        if ($session['package']) {
                            $total_sessions = $session['package']['total_sessions'] ?? 0;
                            $free_sessions = $session['package']['free_sessions'] ?? 0;
                            $per_week = $session['package']['per_week'] ?? 0;
                        }
                    }

                    $data['session_history'] = (object) [
                        'total_sessions' => (string)$total_sessions,
                        'free_sessions' => $free_sessions,
                        'per_week' => $per_week,
                        'sessions' => $sessions,
                        'completed_session' => (string) $completed_session,
                    ];

                    $packages = Packages::whereIn('id', $selectedPackageIds)->get();

                    foreach ($packages as $package) {
                        $is_package = 1;
                        // Add only unique entries
                        $data["packages"][] = [
                            "name" => $package->name, 
                            "base_amount" => (string) $package->amount,
                            "price" => (string) ((int) $package->amount * (int) $total_count),
                            "save_amount" => (string) ((int) $package->save_amount * (int) $total_count),
                        ];
                    }

                    $data['is_package'] = $is_package;
                }

                
                return $this->sendResponse($data, 'Card Info');
            } else {
                return $this->sendError('Data not found.');
            }

        } else {
            return $this->sendError('Booking id is required.');
        }
    }

    public function remove_vendor($booking_id)
    {
        if($booking_id){

            $data = Card::find($booking_id);

            if($data){

                if($data->status=='Canceled'){

                    return $this->sendError('This booking is cancelled.');
                    
                } else {

                    if($data->accept_user_id){

                        $params['accept_user_id'] = null;
                        
                        $params['accept_user_company_id'] = null;

                        $params['status'] = 'Pending';
                        
                        $datas['status'] = Card::find($booking_id)->value('status');
                        
                        // Tahir Change 25/01
                        // if($data && $data->user && $data->user->email){

                        //     $user = $data->user?$data->user->name:'';
                        //     $service = $data->service?$data->service->name:'';

                        //     $array['view']      = 'emails.cencal_booking';
                        //     $array['subject']   = 'Booking Cancelled with '.$user.' for '.$service;
                        //     $array['data']      = $data;
                        //     \Mail::to($data->user->email)->send(new \App\Mail\Mail($array));
                        // }

                        if($data && $data->vendor && $data->vendor->email){

                            $user = $data->user?$data->user->name:'';
                            $service = $data->service?$data->service->name:'';

                            $array['view']      = 'emails.cencal_booking';
                            $array['subject']   = 'Booking Cancelled with '.$user.' for '.$service;
                            $array['data']      = $data;
                            \Mail::to($data->vendor->email)->send(new \App\Mail\Mail($array));
                        }

                        $user = $data->user?$data->user->name:'';
                        $service = $data->service?$data->service->name:'';

                        $vendor = User::find($data->accept_user_id);

                        $array['view']      = 'emails.cencal_booking';
                        $array['subject']   = 'Booking Cancelled with '.$user.' for '.$service;
                        $array['data']      = $data;
                        \Mail::to('urban.uae@gmail.com')->send(new \App\Mail\Mail($array));

                        $data->update($params);
                       
                        return $this->sendResponse($datas, 'Vendor removed');

                    } else {

                        return $this->sendError('Vendor not assign.');

                    }

                }

            } else {

                return $this->sendError('Data not found.');

            }

        } else {

            return $this->sendError('Booking id is required.');
            
        }
    }

    public function get_vendor_payment(Request $request)
    {
        $payment = Payment::where('vendor_id',$request->vendor_id)->get();
        return $this->sendResponse($payment, 'Vendor Payment History');

    }

    public function get_coupon_use_count(Request $request)
    {        
        if($request->user_id && $request->coupon_id){
            $count = UserCoupon::where('user_id',$request->user_id)->where('coupon_id',$request->coupon_id)->count();
            return $this->sendResponse($count, 'Coupon Usage Count');
        } else {
             return $this->sendError('Required field is empty.');
        }
    }

    function review(Request $request)
    {
        if($request->booking_id && $request->service_id && $request->rating && $request->opinion){
            $params['booking_id'] = $request->booking_id;
            $params['service_id'] = $request->service_id;
            $params['vendor_id'] = $request->vendor_id ?? null;
            $params['customer_id'] = auth()->user()->id;
            $params['rating'] = $request->rating;
            $params['opinion'] = $request->opinion;

            $res = Review::create($params);
            return $this->sendResponse($res, 'Review Successfully submitted');
        } else {
             return $this->sendError('Required field is empty.');
        }
    }
}
