<?php



namespace App\Console;



use Illuminate\Console\Scheduling\Schedule;

use Illuminate\Foundation\Console\Kernel as ConsoleKernel;



class Kernel extends ConsoleKernel

{

    /**

     * The Artisan commands provided by your application.

     *

     * @var array

     */

    protected $commands = [

        Commands\DailyOrder::class,
        Commands\NotifyExpiredJobs::class,
        Commands\UpdateSessionStatusCommand::class,

    ];



    /**

     * Define the application's command schedule.

     *

     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule

     * @return void

     */

    protected function schedule(Schedule $schedule)

    {

        $schedule->command('sessions:update-status')->everyMinute();
        $schedule->command('notify:expired-jobs')->everyMinute();

        $schedule->command('order:daily')

        //->everyMinute();

        ->daily();

        //->dailyAt('06:00');

        //->everyThirtyMinutes();

        //->hourly();

        //->everyFiveMinutes();



    }



    /**

     * Register the commands for the application.

     *

     * @return void

     */

    protected function commands()

    {

        $this->load(__DIR__.'/Commands');



        require base_path('routes/console.php');

    }

}

