<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\User;
use App\Card;
use App\Services\FirebasePushNotificationService;
use Kreait\Firebase\Database;
use Kreait\Firebase\Factory;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SendBookingAcceptNotification extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'accept_booking:notification {card_id}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(FirebasePushNotificationService $firebaseService, Database $database)
    {
        parent::__construct();
        $this->firebaseService = $firebaseService;
        $this->database = $database;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $card_id = $this->argument("card_id");
        $card = Card::with(['user','vendor'])->find($card_id);
        $cards = Card::with(['user','vendor'])->where('id',$card_id)->get();

        if($card->user && $card->user->email){
        $array['view']      = 'emails.booking_completed';
        $array['subject']   = 'Your booking has been accepted!';
        $array['data']      = $cards;
        $array['user']      = $card->user;
        \Mail::to($card->user?$card->user->email:'')->cc('sooraj.a2solution@gmail.com')->send(new \App\Mail\Mail($array));
    
        $user = User::find($card->user_id);

        if ($user) {
            $device_tokens = $user->user_device_token;
            $firebase_user_key = $user->firebase_user_key;
        
            if (!empty($device_tokens) && $device_tokens != '0') {
                if (strlen($device_tokens) > 70) {
                    // Logic when token length exceeds 70
                    $title  = $card->tran_id??"UM-" . $card->id;
                    $body   = "Your booking has been accepted!";
                    $text   = "Your booking has been accepted!";

                    if (!empty($firebase_user_key)) {
                        $user_firebase_key = $firebase_user_key; 
                            
                        $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
                            "title" => $title,
                            "description" => $body,
                            "notificationType" => 'accept_booking',
                            "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
                            "cardId" => (string)$card->id,
                            "status" => "1",
                            "url" => "",
                            "imageURL" => '',
                            "read" => "0",
                            "seen" => "0",
                        ];
                            
                        $this->database->getReference()->update($notification_data);

                        send_single_notification(
                            $device_tokens,
                            [
                                "title" => $title,
                                "body" => $body,
                                "icon" => 'myicon',
                                "sound" => 'default',
                                "click_action" => "EcomNotification",
                            ],
                            [
                                "type" => 'accept_booking',
                                "notificationID" => time(),
                                "status" => "1",
                                "imageURL" => "",
                                "cardId" => (string)$card->id,
                            ]
                        );
                    }
                }
            }
        }

    }
    print_r($card->toArray());
    if($card->vendor && $card->vendor->email){
    
        $user = User::find($card->accept_user_id);

        if ($user) {
            $device_tokens = $user->user_device_token;
            $firebase_user_key = $user->firebase_user_key;
        
            if (!empty($device_tokens) && $device_tokens != '0') {
                if (strlen($device_tokens) > 70) {
                    // Logic when token length exceeds 70
                    $title  = $card->tran_id??"UM-" . $card->id;
                    $body   = "Your booking has been accepted!";
                    $text   = "Your booking has been accepted!";

                    if (!empty($firebase_user_key)) {
                        $user_firebase_key = $firebase_user_key; 
                            
                        $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
                            "title" => $title,
                            "description" => $body,
                            "notificationType" => 'accept_booking',
                            "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
                            "cardId" => (string)$card->id,
                            "status" => "1",
                            "url" => "",
                            "imageURL" => '',
                            "read" => "0",
                            "seen" => "0",
                        ];
                        $this->database->getReference()->update($notification_data);

                        send_single_notification(
                            $device_tokens,
                            [
                                "title" => $title,
                                "body" => $body,
                                "icon" => 'myicon',
                                "sound" => 'default',
                                "click_action" => "EcomNotification",
                            ],
                            [
                                "type" => 'accept_booking',
                                "notificationID" => time(),
                                "status" => "1",
                                "imageURL" => "",
                                "cardId" => (string)$card->id,
                            ]
                        );
                    }
                }
            }
        }

    }

    if($card->vendor && $card->vendor->email){
        if($card && $card->user){
            $customer = $card->user?$card->user->name:'';
        } else {
            $customer = 'No Name';
        }

        if($card && $card->service){
            $service = $card->service?$card->service->name:'';
        } else {
            $service = 'No Service';
        }
        
        $array['view']      = 'emails.booking_completed_vendor';
        $array['subject']   = 'Booking Confirmation with '.$customer.' for '.$service;
        $array['data']      = $cards;
        $array['user']      = $card->user;
        \Mail::to($card->vendor?$card->vendor->email:'')->cc('sooraj.a2solution@gmail.com')->send(new \App\Mail\Mail($array));
    }
        return 0;
    }
}
