<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\User;
use App\Card;
use App\Services\FirebasePushNotificationService;
use Kreait\Firebase\Database;
use Kreait\Firebase\Factory;
use App\SellerService;
use Carbon\Carbon;
use App\Seller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SendAllSellerBookingNotification extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send_all_selle_booking_notification:init {card_id}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    
    public function __construct(FirebasePushNotificationService $firebaseService, Database $database)
    {
        parent::__construct();
        $this->firebaseService = $firebaseService;
        $this->database = $database;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $card_id = $this->argument("card_id");
        $card = Card::find($card_id);
        $cards = Card::with(['user','vendor'])->where('id',$card_id)->get();
        $users = User::where(['role' => 'vendor'])->get();
        foreach($users as $user){
            $seller = Seller::where('user_id',$user->id)->first();
            $device_tokens = $user->user_device_token;
            $firebase_user_key = $user->firebase_user_key;
            if (!empty($seller) && SellerService::where(['service_id' => $card->service_id, 'seller_id' => $seller->id])->exists()) {
            
                    if (strlen($device_tokens) > 70) {
                        // Logic when token length exceeds 70
                        $title  = $card->tran_id??"UM-" . $card->id;
                        $body   = "Heads up! You have a new booking on Urbanmop Partner App for {$card->service_name}. Don't miss out on extra earnings!";
                        $text   = "A new booking just came in for {$card->service_name} via Urbanmop Partner App. Take action quickly!";

                        if (!empty($firebase_user_key)) {
                            $user_firebase_key = $firebase_user_key; 
                                
                            $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
                                "title" => $title,
                                "description" => $body,
                                "notificationType" => 'card_payment_update',
                                "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
                                "cardId" => (string)$card->id,
                                "status" => "1",
                                "url" => "",
                                "imageURL" => '',
                                "read" => "0",
                                "seen" => "0",
                            ];
                            $this->database->getReference()->update($notification_data);

                            send_single_notification(
                                $device_tokens,
                                [
                                    "title" => $title,
                                    "body" => $body,
                                    "icon" => 'myicon',
                                    "sound" => 'default',
                                    "click_action" => "EcomNotification",
                                ],
                                [
                                    "type" => 'card_payment_update',
                                    "notificationID" => time(),
                                    "status" => "1",
                                    "imageURL" => "",
                                    "cardId" => (string)$card->id,
                                ]
                            );
                        }
                    }
                }

                if (!empty($card->vendor) && !empty($card->vendor->email)) {
                    $array['view']      = 'emails.booking_completed_vendor';
                    $array['subject']   = "A new booking just came in for {$card->service_name} via Urbanmop Partner App. Take action quickly!";
                    $array['data']      = $cards;
                    $array['user']      = $card->user;
                    
                    \Mail::to($card->vendor->email)
                        ->cc('sooraj.a2solution@gmail.com')
                        ->send(new \App\Mail\Mail($array));
                }
                
        }
        return 0;
    }
}
