<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\User;
use App\Card;
use App\Services\FirebasePushNotificationService;
use Kreait\Firebase\Database;
use Kreait\Firebase\Factory;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class BookingStartedNotification extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'booking_started_notification:push {card_id} {staff_id}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(FirebasePushNotificationService $firebaseService, Database $database)
    {
        parent::__construct();
        $this->firebaseService = $firebaseService;
        $this->database = $database;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $card_id = $this->argument("card_id");
        $staff_id = $this->argument("staff_id");
        $card = Card::find($card_id);
        $cards = Card::with(['user','vendor'])->where('id',$card_id)->get();

        $user = User::find($card->user_id);

            if ($user) {

                $array['view']      = 'emails.booking_completed';
                $array['subject']   = 'Your booking has been started!';
                $array['data']      = $cards;
                $array['user']      = $card->user;
                \Mail::to($card->user?$card->user->email:'')->cc('sooraj.a2solution@gmail.com')->send(new \App\Mail\Mail($array));
            
                $device_tokens = $user->user_device_token;
                $firebase_user_key = $user->firebase_user_key;
            
                if (!empty($device_tokens) && $device_tokens != '0') {
                    if (strlen($device_tokens) > 70) {
                        // Logic when token length exceeds 70
                        $title  = $card->tran_id??"UM-" . $card->id;
                        $body   = "Your booking has been started!";
                        $text   = "Your booking has been started!";

                        if (!empty($firebase_user_key)) {
                            $user_firebase_key = $firebase_user_key; 
                                
                            $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
                                "title" => $title,
                                "description" => $body,
                                "notificationType" => 'booking_started',
                                "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
                                "cardId" => (string)$card->id,
                                "status" => "1",
                                "url" => "",
                                "imageURL" => '',
                                "read" => "0",
                                "seen" => "0",
                            ];
                            $this->database->getReference()->update($notification_data);

                            send_single_notification(
                                $device_tokens,
                                [
                                    "title" => $title,
                                    "body" => $body,
                                    "icon" => 'myicon',
                                    "sound" => 'default',
                                    "click_action" => "EcomNotification",
                                ],
                                [
                                    "type" => 'booking_started',
                                    "notificationID" => time(),
                                    "status" => "1",
                                    "imageURL" => "",
                                    "cardId" => (string)$card->id,
                                ]
                            );
                        }
                    }
                }
            }

            if($staff_id > 0){
                
                $user = User::find($staff_id);

                if ($user) {
                    $device_tokens = $user->user_device_token;
                    $firebase_user_key = $user->firebase_user_key;
                
                    if (!empty($device_tokens) && $device_tokens != '0') {
                        if (strlen($device_tokens) > 70) {
                            // Logic when token length exceeds 70
                            $title  = $card->tran_id??"UM-" . $card->id;
                            $body   = "Your booking has been started!";
                            $text   = "Your booking has been started!";

                            if (!empty($firebase_user_key)) {
                                $user_firebase_key = $firebase_user_key; 
                                    
                                $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
                                    "title" => $title,
                                    "description" => $body,
                                    "notificationType" => 'booking_started',
                                    "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
                                    "cardId" => (string)$card->id,
                                    "status" => "1",
                                    "url" => "",
                                    "imageURL" => '',
                                    "read" => "0",
                                    "seen" => "0",
                                ];
                                $this->database->getReference()->update($notification_data);

                                send_single_notification(
                                    $device_tokens,
                                    [
                                        "title" => $title,
                                        "body" => $body,
                                        "icon" => 'myicon',
                                        "sound" => 'default',
                                        "click_action" => "EcomNotification",
                                    ],
                                    [
                                        "type" => 'booking_started',
                                        "notificationID" => time(),
                                        "status" => "1",
                                        "imageURL" => "",
                                        "cardId" => (string)$card->id,
                                    ]
                                );
                            }
                        }
                    }

                    $array['view']      = 'emails.booking_completed_vendor';
                    $array['subject']   = 'Your booking has been started!';
                    $array['data']      = $cards;
                    $array['user']      = $card->user;
                    \Mail::to($user->email?$user->email:'')->cc('sooraj.a2solution@gmail.com')->send(new \App\Mail\Mail($array));
                }
                
            }

            $user = User::find($card->accept_user_id);

            if ($user) {
                $device_tokens = $user->user_device_token;
                $firebase_user_key = $user->firebase_user_key;
            
                if (!empty($device_tokens) && $device_tokens != '0') {
                    if (strlen($device_tokens) > 70) {
                        // Logic when token length exceeds 70
                        $title  = $card->tran_id??"UM-" . $card->id;
                        $body   = "Your booking has been started!";
                        $text   = "Your booking has been started!";

                        if (!empty($firebase_user_key)) {
                            $user_firebase_key = $firebase_user_key; 
                                
                            $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
                                "title" => $title,
                                "description" => $body,
                                "notificationType" => 'booking_started',
                                "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
                                "cardId" => (string)$card->id,
                                "status" => "1",
                                "url" => "",
                                "imageURL" => '',
                                "read" => "0",
                                "seen" => "0",
                            ];
                            $this->database->getReference()->update($notification_data);

                            send_single_notification(
                                $device_tokens,
                                [
                                    "title" => $title,
                                    "body" => $body,
                                    "icon" => 'myicon',
                                    "sound" => 'default',
                                    "click_action" => "EcomNotification",
                                ],
                                [
                                    "type" => 'booking_started',
                                    "notificationID" => time(),
                                    "status" => "1",
                                    "imageURL" => "",
                                    "cardId" => (string)$card->id,
                                ]
                            );
                        }

                        
                    $array['view']      = 'emails.booking_completed_vendor';
                    $array['subject']   = 'Your booking has been started!';
                    $array['data']      = $cards;
                    $array['user']      = $card->user;
                    \Mail::to($user->email?$user->email:'')->cc('sooraj.a2solution@gmail.com')->send(new \App\Mail\Mail($array));
                
                    }
                }
            }

        return 0;
    }
}
