<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Staff;
use App\User;
use App\Card;
use App\Services\FirebasePushNotificationService;
use Kreait\Firebase\Database;
use Kreait\Firebase\Factory;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class AssignJobNotification extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'assign_job_notification:push {card_id} {staff_id} {staff_replaced}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(FirebasePushNotificationService $firebaseService, Database $database)
    {
        parent::__construct();
        $this->firebaseService = $firebaseService;
        $this->database = $database;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $card_id = $this->argument("card_id");
        $staff_id = $this->argument("staff_id");
        $staff_replace_by = $this->argument("staff_replaced");
        $card = Card::with(['user','vendor'])->find($card_id);

        $user_id = Staff::find($staff_id)->user_id;
            $user = User::find($user_id);
    
            if ($user) {
                $device_tokens = $user->user_device_token;
                $firebase_user_key = $user->firebase_user_key;
            
                if (!empty($device_tokens) && $device_tokens != '0') {
                    if (strlen($device_tokens) > 70) {
                        // Logic when token length exceeds 70
                        $title  = $card->tran_id??"UM-" . $card->id;
                        $body   = "Job is Assigned!";
                        $text   = "A new booking just came in for {$card->service_name} via Urbanmop Partner App. Take action quickly!";
    
                        if (!empty($firebase_user_key)) {
                            $user_firebase_key = $firebase_user_key; 
                                
                            $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
                                "title" => $title,
                                "description" => $body,
                                "notificationType" => 'card_payment_update',
                                "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
                                "cardId" => (string)$card->id,
                                "status" => "1",
                                "url" => "",
                                "imageURL" => '',
                                "read" => "0",
                                "seen" => "0",
                            ];
                            $this->database->getReference()->update($notification_data);
    
                            send_single_notification(
                                $device_tokens,
                                [
                                    "title" => $title,
                                    "body" => $body,
                                    "icon" => 'myicon',
                                    "sound" => 'default',
                                    "click_action" => "EcomNotification",
                                ],
                                [
                                    "type" => 'card_payment_update',
                                    "notificationID" => time(),
                                    "status" => "1",
                                    "imageURL" => "",
                                    "cardId" => (string)$card->id,
                                ]
                            );
                        }
                    }
                }
    
            }
    
           
            

            if($staff_replace_by != null){
                $user_id = Staff::find($staff_replace_by)->user_id;
                $user = User::find($user_id);
        
                if ($user) {
                    $device_tokens = $user->user_device_token;
                    $firebase_user_key = $user->firebase_user_key;
                
                    if (!empty($device_tokens) && $device_tokens != '0') {
                        if (strlen($device_tokens) > 70) {
                            // Logic when token length exceeds 70
                            $title  = $card->tran_id??"UM-" . $card->id;
                            $body   = "Job is Assigned!";
                            $text   = "A new booking just came in for {$card->service_name} via Urbanmop Partner App. Take action quickly!";
        
                            if (!empty($firebase_user_key)) {
                                $user_firebase_key = $firebase_user_key; 
                                    
                                $notification_data["Notifications/" . $firebase_user_key . "/" . time()] = [
                                    "title" => $title,
                                    "description" => $body,
                                    "notificationType" => 'card_payment_update',
                                    "createdAt" => Carbon::now()->setTimezone('GMT')->format('Y-m-d h:i:s'),
                                    "cardId" => (string)$card->id,
                                    "status" => "1",
                                    "url" => "",
                                    "imageURL" => '',
                                    "read" => "0",
                                    "seen" => "0",
                                ];
                                $this->database->getReference()->update($notification_data);
        
                                send_single_notification(
                                    $device_tokens,
                                    [
                                        "title" => $title,
                                        "body" => $body,
                                        "icon" => 'myicon',
                                        "sound" => 'default',
                                        "click_action" => "EcomNotification",
                                    ],
                                    [
                                        "type" => 'card_payment_update',
                                        "notificationID" => time(),
                                        "status" => "1",
                                        "imageURL" => "",
                                        "cardId" => (string)$card->id,
                                    ]
                                );
                            }
                        }
                    }
        
                }
        
            }

        return 0;
    }
}
